/* rygel-lms-all-images.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-lms-all-images.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-lms.h"
#include <sqlite3.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define RYGEL_LMS_ALL_IMAGES_SQL_ALL "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime " "FROM images, files " "WHERE dtime = 0 AND images.id = files.id " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALL_IMAGES_SQL_COUNT "SELECT count(images.id) " "FROM images, files " "WHERE dtime = 0 AND images.id = files.id;"
#define RYGEL_LMS_ALL_IMAGES_SQL_FIND_OBJECT "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime " "FROM images, files " "WHERE dtime = 0 AND files.id = ? AND images.id = files.id;"
#define RYGEL_LMS_ALL_IMAGES_SQL_ADDED "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime " "FROM images, files " "WHERE dtime = 0 AND images.id = files.id " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_ALL_IMAGES_SQL_REMOVED "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime " "FROM images, files " "WHERE dtime <> 0 AND images.id = files.id " "AND update_id > ? AND update_id <= ?;"

enum  {
	RYGEL_LMS_ALL_IMAGES_0_PROPERTY,
	RYGEL_LMS_ALL_IMAGES_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_all_images_properties[RYGEL_LMS_ALL_IMAGES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

static gpointer rygel_lms_all_images_parent_class = NULL;

static RygelMediaObject* rygel_lms_all_images_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                                   sqlite3_stmt* statement);
static GType rygel_lms_all_images_get_type_once (void);

static RygelMediaObject*
rygel_lms_all_images_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                 sqlite3_stmt* statement)
{
	RygelLMSAllImages * self;
	gint id = 0;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* mime_type = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* title = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	RygelImageItem* image = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RygelImageItem* _tmp14_;
	RygelImageItem* _tmp15_;
	const gchar* _tmp16_;
	GDateTime* dt = NULL;
	GDateTime* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GFile* file = NULL;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	RygelMediaObject* result;
	self = (RygelLMSAllImages*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	id = sqlite3_column_int (statement, 0);
	_tmp0_ = (const gchar*) sqlite3_column_text (statement, 6);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp2_ = (const gchar*) sqlite3_column_text (statement, 9);
	_tmp3_ = g_strdup (_tmp2_);
	mime_type = _tmp3_;
	_tmp5_ = mime_type;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = mime_type;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == 0;
	}
	if (_tmp4_) {
		const gchar* _tmp9_;
		_tmp9_ = path;
		g_debug ("rygel-lms-all-images.vala:67: Image item %d (%s) has no MIME type", id, _tmp9_);
	}
	_tmp10_ = (const gchar*) sqlite3_column_text (statement, 1);
	_tmp11_ = g_strdup (_tmp10_);
	title = _tmp11_;
	_tmp12_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, id);
	_tmp13_ = _tmp12_;
	_tmp14_ = rygel_image_item_new (_tmp13_, (RygelMediaContainer*) self, title, RYGEL_IMAGE_ITEM_UPNP_CLASS);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	image = _tmp15_;
	_tmp16_ = (const gchar*) sqlite3_column_text (statement, 2);
	rygel_media_object_set_creator ((RygelMediaObject*) image, _tmp16_);
	_tmp17_ = g_date_time_new_from_unix_utc ((gint64) ((glong) sqlite3_column_int (statement, 3)));
	dt = _tmp17_;
	_tmp18_ = g_date_time_format (dt, "%Y-%m-%dT%H:%M:%S");
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%sZ", _tmp19_);
	_tmp21_ = _tmp20_;
	rygel_media_object_set_date ((RygelMediaObject*) image, _tmp21_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	rygel_visual_item_set_width ((RygelVisualItem*) image, sqlite3_column_int (statement, 4));
	rygel_visual_item_set_height ((RygelVisualItem*) image, sqlite3_column_int (statement, 5));
	rygel_media_file_item_set_size ((RygelMediaFileItem*) image, (gint64) sqlite3_column_int (statement, 7));
	_tmp22_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) image, _tmp22_);
	_tmp23_ = (const gchar*) sqlite3_column_text (statement, 8);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) image, _tmp23_);
	_tmp24_ = path;
	_tmp25_ = g_file_new_for_path (_tmp24_);
	file = _tmp25_;
	_tmp26_ = g_file_get_uri (file);
	_tmp27_ = _tmp26_;
	rygel_media_object_add_uri ((RygelMediaObject*) image, _tmp27_);
	_g_free0 (_tmp27_);
	result = (RygelMediaObject*) image;
	_g_object_unref0 (file);
	_g_date_time_unref0 (dt);
	_g_free0 (title);
	_g_free0 (mime_type);
	_g_free0 (path);
	return result;
}

RygelLMSAllImages*
rygel_lms_all_images_construct (GType object_type,
                                RygelMediaContainer* parent,
                                RygelLMSDatabase* lms_db)
{
	RygelLMSAllImages * self = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	self = (RygelLMSAllImages*) rygel_lms_category_container_construct (object_type, "all", parent, _ ("All"), lms_db, RYGEL_LMS_ALL_IMAGES_SQL_ALL, RYGEL_LMS_ALL_IMAGES_SQL_FIND_OBJECT, RYGEL_LMS_ALL_IMAGES_SQL_COUNT, RYGEL_LMS_ALL_IMAGES_SQL_ADDED, RYGEL_LMS_ALL_IMAGES_SQL_REMOVED);
	return self;
}

RygelLMSAllImages*
rygel_lms_all_images_new (RygelMediaContainer* parent,
                          RygelLMSDatabase* lms_db)
{
	return rygel_lms_all_images_construct (RYGEL_LMS_TYPE_ALL_IMAGES, parent, lms_db);
}

static void
rygel_lms_all_images_class_init (RygelLMSAllImagesClass * klass,
                                 gpointer klass_data)
{
	rygel_lms_all_images_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_all_images_real_object_from_statement;
}

static void
rygel_lms_all_images_instance_init (RygelLMSAllImages * self,
                                    gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
rygel_lms_all_images_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLMSAllImagesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_all_images_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSAllImages), 0, (GInstanceInitFunc) rygel_lms_all_images_instance_init, NULL };
	GType rygel_lms_all_images_type_id;
	rygel_lms_all_images_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSAllImages", &g_define_type_info, 0);
	return rygel_lms_all_images_type_id;
}

GType
rygel_lms_all_images_get_type (void)
{
	static volatile gsize rygel_lms_all_images_type_id__once = 0;
	if (g_once_init_enter (&rygel_lms_all_images_type_id__once)) {
		GType rygel_lms_all_images_type_id;
		rygel_lms_all_images_type_id = rygel_lms_all_images_get_type_once ();
		g_once_init_leave (&rygel_lms_all_images_type_id__once, rygel_lms_all_images_type_id);
	}
	return rygel_lms_all_images_type_id__once;
}

