'''OpenGL extension OES.draw_texture

This module customises the behaviour of the 
OpenGL.raw.GLES1.OES.draw_texture to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines a mechanism for writing pixel
	rectangles from one or more textures to a rectangular
	region of the screen.  This capability is useful for
	fast rendering of background paintings, bitmapped font
	glyphs, and 2D framing elements in games.  This
	extension is primarily intended for use with OpenGL ES.
	
	The extension relies on a new piece of texture state
	called the texture crop rectangle, which defines a
	rectangular subregion of a texture object.  These
	subregions are used as sources of pixels for the texture
	drawing function.
	
	Applications use this extension by configuring the
	texture crop rectangle for one or more textures via
	ActiveTexture() and TexParameteriv() with pname equal to
	TEXTURE_CROP_RECT_OES.  They then request a drawing
	operation using DrawTex{sifx}[v]OES().  The effect of
	the latter function is to generate a screen-aligned
	target rectangle, with texture coordinates chosen to map
	the texture crop rectangle(s) linearly to fragments in
	the target rectangle.  The fragments are then processed
	in accordance with the fragment pipeline state.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/draw_texture.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES1 import _types, _glgets
from OpenGL.raw.GLES1.OES.draw_texture import *
from OpenGL.raw.GLES1.OES.draw_texture import _EXTENSION_NAME

def glInitDrawTextureOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glDrawTexsvOES=wrapper.wrapper(glDrawTexsvOES).setInputArraySize(
    'coords', 5
)
glDrawTexivOES=wrapper.wrapper(glDrawTexivOES).setInputArraySize(
    'coords', 5
)
glDrawTexxvOES=wrapper.wrapper(glDrawTexxvOES).setInputArraySize(
    'coords', 5
)
glDrawTexfvOES=wrapper.wrapper(glDrawTexfvOES).setInputArraySize(
    'coords', 5
)
### END AUTOGENERATED SECTION