
/* GENERATED CODE... DO NOT EDIT */

/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2013 - 2018 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <string.h>

#include "mbim-ms-voice-extensions.h"
#include "mbim-message-private.h"
#include "mbim-tlv-private.h"
#include "mbim-enum-types.h"
#include "mbim-error-types.h"
#include "mbim-device.h"
#include "mbim-utils.h"

/*****************************************************************************/
/* Message (Query): MBIM Message MS Voice Extensions NITZ */

MbimMessage *
mbim_message_ms_voice_extensions_nitz_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_VOICE_EXTENSIONS,
                                                 MBIM_CID_MS_VOICE_EXTENSIONS_NITZ,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_voice_extensions_nitz_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message MS Voice Extensions NITZ */

gboolean
mbim_message_ms_voice_extensions_nitz_response_parse (
    const MbimMessage *message,
    guint32 *out_year,
    guint32 *out_month,
    guint32 *out_day,
    guint32 *out_hour,
    guint32 *out_minute,
    guint32 *out_second,
    guint32 *out_time_zone_offset_minutes,
    guint32 *out_daylight_saving_time_offset_minutes,
    MbimDataClass *out_data_class,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'Year' variable */
    {
        if ((out_year != NULL) && !_mbim_message_read_guint32 (message, offset, out_year, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Month' variable */
    {
        if ((out_month != NULL) && !_mbim_message_read_guint32 (message, offset, out_month, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Day' variable */
    {
        if ((out_day != NULL) && !_mbim_message_read_guint32 (message, offset, out_day, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Hour' variable */
    {
        if ((out_hour != NULL) && !_mbim_message_read_guint32 (message, offset, out_hour, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Minute' variable */
    {
        if ((out_minute != NULL) && !_mbim_message_read_guint32 (message, offset, out_minute, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Second' variable */
    {
        if ((out_second != NULL) && !_mbim_message_read_guint32 (message, offset, out_second, error))
            goto out;
        offset += 4;
    }

    /* Read the 'TimeZoneOffsetMinutes' variable */
    {
        if ((out_time_zone_offset_minutes != NULL) && !_mbim_message_read_guint32 (message, offset, out_time_zone_offset_minutes, error))
            goto out;
        offset += 4;
    }

    /* Read the 'DaylightSavingTimeOffsetMinutes' variable */
    {
        if ((out_daylight_saving_time_offset_minutes != NULL) && !_mbim_message_read_guint32 (message, offset, out_daylight_saving_time_offset_minutes, error))
            goto out;
        offset += 4;
    }

    /* Read the 'DataClass' variable */
    {
        if (out_data_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_data_class = (MbimDataClass)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_voice_extensions_nitz_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_response_get_result (message, MBIM_MESSAGE_TYPE_COMMAND_DONE, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Year = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Month = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Day = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Hour = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Minute = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Second = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TimeZoneOffsetMinutes = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DaylightSavingTimeOffsetMinutes = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DataClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DATA_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_data_class_get_string ((MbimDataClass)tmp));
#elif defined __MBIM_DATA_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_data_class_build_string_from_mask ((MbimDataClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message MS Voice Extensions NITZ */

gboolean
mbim_message_ms_voice_extensions_nitz_notification_parse (
    const MbimMessage *message,
    guint32 *out_year,
    guint32 *out_month,
    guint32 *out_day,
    guint32 *out_hour,
    guint32 *out_minute,
    guint32 *out_second,
    guint32 *out_time_zone_offset_minutes,
    guint32 *out_daylight_saving_time_offset_minutes,
    MbimDataClass *out_data_class,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'Year' variable */
    {
        if ((out_year != NULL) && !_mbim_message_read_guint32 (message, offset, out_year, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Month' variable */
    {
        if ((out_month != NULL) && !_mbim_message_read_guint32 (message, offset, out_month, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Day' variable */
    {
        if ((out_day != NULL) && !_mbim_message_read_guint32 (message, offset, out_day, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Hour' variable */
    {
        if ((out_hour != NULL) && !_mbim_message_read_guint32 (message, offset, out_hour, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Minute' variable */
    {
        if ((out_minute != NULL) && !_mbim_message_read_guint32 (message, offset, out_minute, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Second' variable */
    {
        if ((out_second != NULL) && !_mbim_message_read_guint32 (message, offset, out_second, error))
            goto out;
        offset += 4;
    }

    /* Read the 'TimeZoneOffsetMinutes' variable */
    {
        if ((out_time_zone_offset_minutes != NULL) && !_mbim_message_read_guint32 (message, offset, out_time_zone_offset_minutes, error))
            goto out;
        offset += 4;
    }

    /* Read the 'DaylightSavingTimeOffsetMinutes' variable */
    {
        if ((out_daylight_saving_time_offset_minutes != NULL) && !_mbim_message_read_guint32 (message, offset, out_daylight_saving_time_offset_minutes, error))
            goto out;
        offset += 4;
    }

    /* Read the 'DataClass' variable */
    {
        if (out_data_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_data_class = (MbimDataClass)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_voice_extensions_nitz_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Year = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Month = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Day = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Hour = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Minute = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Second = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TimeZoneOffsetMinutes = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DaylightSavingTimeOffsetMinutes = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DataClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DATA_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_data_class_get_string ((MbimDataClass)tmp));
#elif defined __MBIM_DATA_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_data_class_build_string_from_mask ((MbimDataClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

typedef struct {
  gchar * (* query_cb)        (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* set_cb)          (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* response_cb)     (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* notification_cb) (const MbimMessage *message, const gchar *line_prefix, GError **error);
} GetPrintableCallbacks;

static const GetPrintableCallbacks ms_voice_extensions_get_printable_callbacks[] = {
    [MBIM_CID_MS_VOICE_EXTENSIONS_NITZ] = {
        .query_cb = mbim_message_ms_voice_extensions_nitz_query_get_printable,
        .response_cb = mbim_message_ms_voice_extensions_nitz_response_get_printable,
        .notification_cb = mbim_message_ms_voice_extensions_nitz_notification_get_printable,
    },
};

gchar *
__mbim_message_ms_voice_extensions_get_printable_fields (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    guint32 cid;

    switch (mbim_message_get_message_type (message)) {
        case MBIM_MESSAGE_TYPE_COMMAND: {
            cid = mbim_message_command_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_voice_extensions_get_printable_callbacks)) {
                switch (mbim_message_command_get_command_type (message)) {
                    case MBIM_MESSAGE_COMMAND_TYPE_QUERY:
                        if (ms_voice_extensions_get_printable_callbacks[cid].query_cb)
                            return ms_voice_extensions_get_printable_callbacks[cid].query_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_SET:
                        if (ms_voice_extensions_get_printable_callbacks[cid].set_cb)
                            return ms_voice_extensions_get_printable_callbacks[cid].set_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_UNKNOWN:
                    default:
                        g_set_error (error,
                                     MBIM_CORE_ERROR,
                                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                                     "Invalid command type");
                        return NULL;
                }
            }
            break;
        }

        case MBIM_MESSAGE_TYPE_COMMAND_DONE:
            cid = mbim_message_command_done_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_voice_extensions_get_printable_callbacks)) {
                if (ms_voice_extensions_get_printable_callbacks[cid].response_cb)
                    return ms_voice_extensions_get_printable_callbacks[cid].response_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_INDICATE_STATUS:
            cid = mbim_message_indicate_status_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_voice_extensions_get_printable_callbacks)) {
                if (ms_voice_extensions_get_printable_callbacks[cid].notification_cb)
                    return ms_voice_extensions_get_printable_callbacks[cid].notification_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_OPEN: 
        case MBIM_MESSAGE_TYPE_CLOSE: 
        case MBIM_MESSAGE_TYPE_INVALID: 
        case MBIM_MESSAGE_TYPE_HOST_ERROR: 
        case MBIM_MESSAGE_TYPE_OPEN_DONE: 
        case MBIM_MESSAGE_TYPE_CLOSE_DONE: 
        case MBIM_MESSAGE_TYPE_FUNCTION_ERROR: 
        default:
            g_set_error (error,
                         MBIM_CORE_ERROR,
                         MBIM_CORE_ERROR_INVALID_MESSAGE,
                         "No contents expected in this message type");
            return NULL;
    }

    g_set_error (error,
                 MBIM_CORE_ERROR,
                 MBIM_CORE_ERROR_UNSUPPORTED,
                 "Unsupported message");
    return NULL;
}
