/* rygel-meta-config.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-meta-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Krzesimir Nowak <krnowak@openismus.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-core.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

enum  {
	RYGEL_META_CONFIG_0_PROPERTY,
	RYGEL_META_CONFIG_NUM_PROPERTIES
};
static GParamSpec* rygel_meta_config_properties[RYGEL_META_CONFIG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

static gpointer rygel_meta_config_parent_class = NULL;
static RygelMetaConfig* rygel_meta_config_meta_config;
static RygelMetaConfig* rygel_meta_config_meta_config = NULL;
static GeeArrayList* rygel_meta_config_configs;
static GeeArrayList* rygel_meta_config_configs = NULL;
static RygelConfigurationIface * rygel_meta_config_rygel_configuration_parent_iface = NULL;

static void rygel_meta_config_connect_signals (RygelMetaConfig* self,
                                        RygelConfiguration* config);
static void rygel_meta_config_on_configuration_changed (RygelMetaConfig* self,
                                                 RygelConfiguration* affected_config,
                                                 RygelConfigurationEntry entry);
static void _rygel_meta_config_on_configuration_changed_rygel_configuration_configuration_changed (RygelConfiguration* _sender,
                                                                                            RygelConfigurationEntry entry,
                                                                                            gpointer self);
static void rygel_meta_config_on_section_changed (RygelMetaConfig* self,
                                           RygelConfiguration* affected_config,
                                           const gchar* section,
                                           RygelSectionEntry entry);
static void _rygel_meta_config_on_section_changed_rygel_configuration_section_changed (RygelConfiguration* _sender,
                                                                                const gchar* section,
                                                                                RygelSectionEntry entry,
                                                                                gpointer self);
static void rygel_meta_config_on_setting_changed (RygelMetaConfig* self,
                                           RygelConfiguration* affected_config,
                                           const gchar* section,
                                           const gchar* key);
static void _rygel_meta_config_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                                const gchar* section,
                                                                                const gchar* key,
                                                                                gpointer self);
static gchar* rygel_meta_config_real_get_interface (RygelConfiguration* base,
                                             GError** error);
static gchar** rygel_meta_config_real_get_interfaces (RygelConfiguration* base,
                                               GError** error);
static gint rygel_meta_config_real_get_port (RygelConfiguration* base,
                                      GError** error);
static gboolean rygel_meta_config_real_get_transcoding (RygelConfiguration* base,
                                                 GError** error);
static gboolean rygel_meta_config_real_get_allow_upload (RygelConfiguration* base,
                                                  GError** error);
static gboolean rygel_meta_config_real_get_allow_deletion (RygelConfiguration* base,
                                                    GError** error);
static gchar* rygel_meta_config_real_get_log_levels (RygelConfiguration* base,
                                              GError** error);
static gchar* rygel_meta_config_real_get_plugin_path (RygelConfiguration* base,
                                               GError** error);
static gchar* rygel_meta_config_real_get_media_engine (RygelConfiguration* base,
                                                GError** error);
static gchar* rygel_meta_config_real_get_engine_path (RygelConfiguration* base,
                                               GError** error);
static gchar* rygel_meta_config_real_get_video_upload_folder (RygelConfiguration* base,
                                                       GError** error);
static gchar* rygel_meta_config_real_get_music_upload_folder (RygelConfiguration* base,
                                                       GError** error);
static gchar* rygel_meta_config_real_get_picture_upload_folder (RygelConfiguration* base,
                                                         GError** error);
static gboolean rygel_meta_config_real_get_enabled (RygelConfiguration* base,
                                             const gchar* section,
                                             GError** error);
static gchar* rygel_meta_config_real_get_title (RygelConfiguration* base,
                                         const gchar* section,
                                         GError** error);
static gchar* rygel_meta_config_real_get_string (RygelConfiguration* base,
                                          const gchar* section,
                                          const gchar* key,
                                          GError** error);
static GeeArrayList* rygel_meta_config_real_get_string_list (RygelConfiguration* base,
                                                      const gchar* section,
                                                      const gchar* key,
                                                      GError** error);
static gint rygel_meta_config_real_get_int (RygelConfiguration* base,
                                     const gchar* section,
                                     const gchar* key,
                                     gint min,
                                     gint max,
                                     GError** error);
static GeeArrayList* rygel_meta_config_real_get_int_list (RygelConfiguration* base,
                                                   const gchar* section,
                                                   const gchar* key,
                                                   GError** error);
static gboolean rygel_meta_config_real_get_bool (RygelConfiguration* base,
                                          const gchar* section,
                                          const gchar* key,
                                          GError** error);
static gboolean rygel_meta_config_configuration_value_available (RygelMetaConfig* self,
                                                          RygelConfiguration* config,
                                                          RygelConfigurationEntry entry);
static gboolean rygel_meta_config_setting_value_available (RygelMetaConfig* self,
                                                    RygelConfiguration* config,
                                                    const gchar* section,
                                                    RygelSectionEntry entry);
static void rygel_meta_config_finalize (GObject * obj);
static GType rygel_meta_config_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_rygel_meta_config_on_configuration_changed_rygel_configuration_configuration_changed (RygelConfiguration* _sender,
                                                                                       RygelConfigurationEntry entry,
                                                                                       gpointer self)
{
	rygel_meta_config_on_configuration_changed ((RygelMetaConfig*) self, _sender, entry);
}

static void
_rygel_meta_config_on_section_changed_rygel_configuration_section_changed (RygelConfiguration* _sender,
                                                                           const gchar* section,
                                                                           RygelSectionEntry entry,
                                                                           gpointer self)
{
	rygel_meta_config_on_section_changed ((RygelMetaConfig*) self, _sender, section, entry);
}

static void
_rygel_meta_config_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                           const gchar* section,
                                                                           const gchar* key,
                                                                           gpointer self)
{
	rygel_meta_config_on_setting_changed ((RygelMetaConfig*) self, _sender, section, key);
}

static void
rygel_meta_config_connect_signals (RygelMetaConfig* self,
                                   RygelConfiguration* config)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_signal_connect_object (config, "configuration-changed", (GCallback) _rygel_meta_config_on_configuration_changed_rygel_configuration_configuration_changed, self, 0);
	g_signal_connect_object (config, "section-changed", (GCallback) _rygel_meta_config_on_section_changed_rygel_configuration_section_changed, self, 0);
	g_signal_connect_object (config, "setting-changed", (GCallback) _rygel_meta_config_on_setting_changed_rygel_configuration_setting_changed, self, 0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelMetaConfig*
rygel_meta_config_get_default (void)
{
	GeeArrayList* _tmp0_;
	RygelMetaConfig* _tmp2_;
	RygelMetaConfig* _tmp14_;
	RygelMetaConfig* _tmp15_;
	RygelMetaConfig* result;
	_tmp0_ = rygel_meta_config_configs;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		_tmp1_ = gee_array_list_new (RYGEL_TYPE_CONFIGURATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (rygel_meta_config_configs);
		rygel_meta_config_configs = _tmp1_;
	}
	_tmp2_ = rygel_meta_config_meta_config;
	if (_tmp2_ == NULL) {
		RygelMetaConfig* _tmp3_;
		_tmp3_ = rygel_meta_config_new ();
		_g_object_unref0 (rygel_meta_config_meta_config);
		rygel_meta_config_meta_config = _tmp3_;
		{
			GeeArrayList* _config_list = NULL;
			GeeArrayList* _tmp4_;
			gint _config_size = 0;
			GeeArrayList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _config_index = 0;
			_tmp4_ = rygel_meta_config_configs;
			_config_list = _tmp4_;
			_tmp5_ = _config_list;
			_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_config_size = _tmp7_;
			_config_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				RygelConfiguration* config = NULL;
				GeeArrayList* _tmp10_;
				gpointer _tmp11_;
				RygelMetaConfig* _tmp12_;
				RygelConfiguration* _tmp13_;
				_config_index = _config_index + 1;
				_tmp8_ = _config_index;
				_tmp9_ = _config_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _config_list;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _config_index);
				config = (RygelConfiguration*) _tmp11_;
				_tmp12_ = rygel_meta_config_meta_config;
				_tmp13_ = config;
				rygel_meta_config_connect_signals (_tmp12_, _tmp13_);
				_g_object_unref0 (config);
			}
		}
	}
	_tmp14_ = rygel_meta_config_meta_config;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	result = _tmp15_;
	return result;
}

/**
     * Register another configuration provider to the meta configuration
     * First configuration to provide a value wins. If you want to assign
     * priority to configuration providers, they have to be added with descending
     * priority
     */
void
rygel_meta_config_register_configuration (RygelConfiguration* config)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp2_;
	RygelMetaConfig* _tmp3_;
	g_return_if_fail (config != NULL);
	_tmp0_ = rygel_meta_config_configs;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		_tmp1_ = gee_array_list_new (RYGEL_TYPE_CONFIGURATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (rygel_meta_config_configs);
		rygel_meta_config_configs = _tmp1_;
	}
	_tmp2_ = rygel_meta_config_configs;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, config);
	_tmp3_ = rygel_meta_config_meta_config;
	if (_tmp3_ != NULL) {
		RygelMetaConfig* _tmp4_;
		_tmp4_ = rygel_meta_config_meta_config;
		rygel_meta_config_connect_signals (_tmp4_, config);
	}
}

/**
     * Convenoience method for cleaning up the singleton. This
     * Should usually not be used; only if you care for your
     * valgrind report or in tests
     */
void
rygel_meta_config_cleanup (void)
{
	_g_object_unref0 (rygel_meta_config_meta_config);
	rygel_meta_config_meta_config = NULL;
	_g_object_unref0 (rygel_meta_config_configs);
	rygel_meta_config_configs = NULL;
}

static gchar*
rygel_meta_config_real_get_interface (RygelConfiguration* base,
                                      GError** error)
{
	RygelMetaConfig * self;
	gchar* val = NULL;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	val = NULL;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = config;
				_tmp10_ = rygel_configuration_get_interface (_tmp9_, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (val);
				val = _tmp11_;
				unavailable = FALSE;
				_g_free0 (_tmp8_);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp12_;
		_tmp12_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static gchar**
rygel_meta_config_real_get_interfaces (RygelConfiguration* base,
                                       GError** error)
{
	RygelMetaConfig * self;
	gchar** val = NULL;
	gint val_length1;
	gint _val_size_;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gchar** result;
	self = (RygelMetaConfig*) base;
	val = NULL;
	val_length1 = 0;
	_val_size_ = val_length1;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gchar** _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				gchar** _tmp10_;
				gchar** _tmp11_;
				gint _tmp8__length1;
				gint __tmp8__size_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				_tmp9_ = config;
				_tmp11_ = _tmp10_ = rygel_configuration_get_interfaces (_tmp9_, &_inner_error0_);
				_tmp8_ = _tmp11_;
				_tmp8__length1 = _vala_array_length (_tmp10_);
				__tmp8__size_ = _tmp8__length1;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp12_ = _tmp8_;
				_tmp12__length1 = _tmp8__length1;
				_tmp8_ = NULL;
				_tmp8__length1 = 0;
				val = (_vala_array_free (val, val_length1, (GDestroyNotify) g_free), NULL);
				val = _tmp12_;
				val_length1 = _tmp12__length1;
				_val_size_ = val_length1;
				unavailable = FALSE;
				_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				val = (_vala_array_free (val, val_length1, (GDestroyNotify) g_free), NULL);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		val = (_vala_array_free (val, val_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = val;
	return result;
}

static gint
rygel_meta_config_real_get_port (RygelConfiguration* base,
                                 GError** error)
{
	RygelMetaConfig * self;
	gint val = 0;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (RygelMetaConfig*) base;
	val = 0;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gint _tmp8_ = 0;
				RygelConfiguration* _tmp9_;
				_tmp9_ = config;
				_tmp8_ = rygel_configuration_get_port (_tmp9_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				val = _tmp8_;
				unavailable = FALSE;
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp10_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				return _tmp10_;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp11_;
		gint _tmp12_ = -1;
		_tmp11_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		return _tmp12_;
	}
	result = val;
	return result;
}

static gboolean
rygel_meta_config_real_get_transcoding (RygelConfiguration* base,
                                        GError** error)
{
	RygelMetaConfig * self;
	gboolean val = FALSE;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				RygelConfiguration* _tmp9_;
				_tmp9_ = config;
				_tmp8_ = rygel_configuration_get_transcoding (_tmp9_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				val = _tmp8_;
				unavailable = FALSE;
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp10_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				return _tmp10_;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		return _tmp12_;
	}
	result = val;
	return result;
}

static gboolean
rygel_meta_config_real_get_allow_upload (RygelConfiguration* base,
                                         GError** error)
{
	RygelMetaConfig * self;
	gboolean val = FALSE;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				RygelConfiguration* _tmp9_;
				_tmp9_ = config;
				_tmp8_ = rygel_configuration_get_allow_upload (_tmp9_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				val = _tmp8_;
				unavailable = FALSE;
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp10_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				return _tmp10_;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		return _tmp12_;
	}
	result = val;
	return result;
}

static gboolean
rygel_meta_config_real_get_allow_deletion (RygelConfiguration* base,
                                           GError** error)
{
	RygelMetaConfig * self;
	gboolean val = FALSE;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				RygelConfiguration* _tmp9_;
				_tmp9_ = config;
				_tmp8_ = rygel_configuration_get_allow_deletion (_tmp9_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				val = _tmp8_;
				unavailable = FALSE;
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp10_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				return _tmp10_;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		return _tmp12_;
	}
	result = val;
	return result;
}

static gchar*
rygel_meta_config_real_get_log_levels (RygelConfiguration* base,
                                       GError** error)
{
	RygelMetaConfig * self;
	gchar* val = NULL;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	val = NULL;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = config;
				_tmp10_ = rygel_configuration_get_log_levels (_tmp9_, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (val);
				val = _tmp11_;
				unavailable = FALSE;
				_g_free0 (_tmp8_);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp12_;
		_tmp12_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static gchar*
rygel_meta_config_real_get_plugin_path (RygelConfiguration* base,
                                        GError** error)
{
	RygelMetaConfig * self;
	gchar* val = NULL;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	val = NULL;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = config;
				_tmp10_ = rygel_configuration_get_plugin_path (_tmp9_, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (val);
				val = _tmp11_;
				unavailable = FALSE;
				_g_free0 (_tmp8_);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp12_;
		_tmp12_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static gchar*
rygel_meta_config_real_get_media_engine (RygelConfiguration* base,
                                         GError** error)
{
	RygelMetaConfig * self;
	gchar* val = NULL;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	val = NULL;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = config;
				_tmp10_ = rygel_configuration_get_media_engine (_tmp9_, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (val);
				val = _tmp11_;
				unavailable = FALSE;
				_g_free0 (_tmp8_);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp12_;
		_tmp12_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static gchar*
rygel_meta_config_real_get_engine_path (RygelConfiguration* base,
                                        GError** error)
{
	RygelMetaConfig * self;
	gchar* val = NULL;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	val = NULL;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = config;
				_tmp10_ = rygel_configuration_get_engine_path (_tmp9_, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (val);
				val = _tmp11_;
				unavailable = FALSE;
				_g_free0 (_tmp8_);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp12_;
		_tmp12_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
rygel_meta_config_real_get_video_upload_folder (RygelConfiguration* base,
                                                GError** error)
{
	RygelMetaConfig * self;
	const gchar* _default_ = NULL;
	const gchar* _tmp0_;
	gchar* value = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	_default_ = _tmp0_;
	_tmp1_ = _default_;
	_tmp2_ = g_strdup (_tmp1_);
	value = _tmp2_;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp3_;
		gint _config_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _config_index = 0;
		_tmp3_ = rygel_meta_config_configs;
		_config_list = _tmp3_;
		_tmp4_ = _config_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_config_size = _tmp6_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			_config_index = _config_index + 1;
			_tmp7_ = _config_index;
			_tmp8_ = _config_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _config_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _config_index);
			config = (RygelConfiguration*) _tmp10_;
			{
				gchar* _tmp11_ = NULL;
				RygelConfiguration* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = config;
				_tmp13_ = rygel_configuration_get_video_upload_folder (_tmp12_, &_inner_error0_);
				_tmp11_ = _tmp13_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp14_ = _tmp11_;
				_tmp11_ = NULL;
				_g_free0 (value);
				value = _tmp14_;
				_g_free0 (_tmp11_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (value);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	_tmp16_ = value;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		_tmp17_ = _default_;
		_tmp15_ = _tmp17_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = value;
		_tmp19_ = _default_;
		_tmp20_ = string_replace (_tmp18_, "@VIDEOS@", _tmp19_);
		result = _tmp20_;
		_g_free0 (value);
		return result;
	}
	result = NULL;
	_g_free0 (value);
	return result;
}

static gchar*
rygel_meta_config_real_get_music_upload_folder (RygelConfiguration* base,
                                                GError** error)
{
	RygelMetaConfig * self;
	const gchar* _default_ = NULL;
	const gchar* _tmp0_;
	gchar* value = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	_default_ = _tmp0_;
	_tmp1_ = _default_;
	_tmp2_ = g_strdup (_tmp1_);
	value = _tmp2_;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp3_;
		gint _config_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _config_index = 0;
		_tmp3_ = rygel_meta_config_configs;
		_config_list = _tmp3_;
		_tmp4_ = _config_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_config_size = _tmp6_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			_config_index = _config_index + 1;
			_tmp7_ = _config_index;
			_tmp8_ = _config_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _config_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _config_index);
			config = (RygelConfiguration*) _tmp10_;
			{
				gchar* _tmp11_ = NULL;
				RygelConfiguration* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = config;
				_tmp13_ = rygel_configuration_get_music_upload_folder (_tmp12_, &_inner_error0_);
				_tmp11_ = _tmp13_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp14_ = _tmp11_;
				_tmp11_ = NULL;
				_g_free0 (value);
				value = _tmp14_;
				_g_free0 (_tmp11_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (value);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	_tmp16_ = value;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		_tmp17_ = _default_;
		_tmp15_ = _tmp17_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = value;
		_tmp19_ = _default_;
		_tmp20_ = string_replace (_tmp18_, "@MUSIC@", _tmp19_);
		result = _tmp20_;
		_g_free0 (value);
		return result;
	}
	result = NULL;
	_g_free0 (value);
	return result;
}

static gchar*
rygel_meta_config_real_get_picture_upload_folder (RygelConfiguration* base,
                                                  GError** error)
{
	RygelMetaConfig * self;
	const gchar* _default_ = NULL;
	const gchar* _tmp0_;
	gchar* value = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_default_ = _tmp0_;
	_tmp1_ = _default_;
	_tmp2_ = g_strdup (_tmp1_);
	value = _tmp2_;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp3_;
		gint _config_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _config_index = 0;
		_tmp3_ = rygel_meta_config_configs;
		_config_list = _tmp3_;
		_tmp4_ = _config_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_config_size = _tmp6_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			_config_index = _config_index + 1;
			_tmp7_ = _config_index;
			_tmp8_ = _config_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _config_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _config_index);
			config = (RygelConfiguration*) _tmp10_;
			{
				gchar* _tmp11_ = NULL;
				RygelConfiguration* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = config;
				_tmp13_ = rygel_configuration_get_picture_upload_folder (_tmp12_, &_inner_error0_);
				_tmp11_ = _tmp13_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp14_ = _tmp11_;
				_tmp11_ = NULL;
				_g_free0 (value);
				value = _tmp14_;
				_g_free0 (_tmp11_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (value);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	_tmp16_ = value;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		_tmp17_ = _default_;
		_tmp15_ = _tmp17_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = value;
		_tmp19_ = _default_;
		_tmp20_ = string_replace (_tmp18_, "@PICTURES@", _tmp19_);
		result = _tmp20_;
		_g_free0 (value);
		return result;
	}
	result = NULL;
	_g_free0 (value);
	return result;
}

static gboolean
rygel_meta_config_real_get_enabled (RygelConfiguration* base,
                                    const gchar* section,
                                    GError** error)
{
	RygelMetaConfig * self;
	gboolean val = FALSE;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				RygelConfiguration* _tmp9_;
				_tmp9_ = config;
				_tmp8_ = rygel_configuration_get_enabled (_tmp9_, section, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				val = _tmp8_;
				unavailable = FALSE;
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp10_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				return _tmp10_;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		gchar* msg = NULL;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = g_strdup (_ ("No value set for “%s/enabled”"));
		msg = _tmp11_;
		_tmp12_ = msg;
		_tmp13_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp12_, section);
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		return _tmp14_;
	}
	result = val;
	return result;
}

static gchar*
rygel_meta_config_real_get_title (RygelConfiguration* base,
                                  const gchar* section,
                                  GError** error)
{
	RygelMetaConfig * self;
	gchar* val = NULL;
	const gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	val = NULL;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = config;
				_tmp10_ = rygel_configuration_get_title (_tmp9_, section, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (val);
				val = _tmp11_;
				_g_free0 (_tmp8_);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	_tmp12_ = val;
	if (_tmp12_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		_tmp13_ = g_strdup (_ ("No value set for “%s/title”"));
		msg = _tmp13_;
		_tmp14_ = msg;
		_tmp15_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp14_, section);
		_inner_error0_ = _tmp15_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static gchar*
rygel_meta_config_real_get_string (RygelConfiguration* base,
                                   const gchar* section,
                                   const gchar* key,
                                   GError** error)
{
	RygelMetaConfig * self;
	gchar* val = NULL;
	const gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	val = NULL;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = config;
				_tmp10_ = rygel_configuration_get_string (_tmp9_, section, key, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (val);
				val = _tmp11_;
				_g_free0 (_tmp8_);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	_tmp12_ = val;
	if (_tmp12_ == NULL) {
		GError* _tmp13_;
		_tmp13_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available for “%s/%s”"), section, key);
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static GeeArrayList*
rygel_meta_config_real_get_string_list (RygelConfiguration* base,
                                        const gchar* section,
                                        const gchar* key,
                                        GError** error)
{
	RygelMetaConfig * self;
	GeeArrayList* val = NULL;
	GeeArrayList* _tmp12_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	val = NULL;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				GeeArrayList* _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				_tmp9_ = config;
				_tmp10_ = rygel_configuration_get_string_list (_tmp9_, section, key, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_object_unref0 (val);
				val = _tmp11_;
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_object_unref0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	_tmp12_ = val;
	if (_tmp12_ == NULL) {
		GError* _tmp13_;
		_tmp13_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available for “%s/%s”"), section, key);
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static gint
rygel_meta_config_real_get_int (RygelConfiguration* base,
                                const gchar* section,
                                const gchar* key,
                                gint min,
                                gint max,
                                GError** error)
{
	RygelMetaConfig * self;
	gint val = 0;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	val = 0;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gint _tmp8_ = 0;
				RygelConfiguration* _tmp9_;
				_tmp9_ = config;
				_tmp8_ = rygel_configuration_get_int (_tmp9_, section, key, min, max, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				val = _tmp8_;
				unavailable = FALSE;
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp10_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				return _tmp10_;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp11_;
		gint _tmp12_ = -1;
		_tmp11_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available for “%s/%s”"), section, key);
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		return _tmp12_;
	}
	result = val;
	return result;
}

static GeeArrayList*
rygel_meta_config_real_get_int_list (RygelConfiguration* base,
                                     const gchar* section,
                                     const gchar* key,
                                     GError** error)
{
	RygelMetaConfig * self;
	GeeArrayList* val = NULL;
	GeeArrayList* _tmp12_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	val = NULL;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				GeeArrayList* _tmp8_ = NULL;
				RygelConfiguration* _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				_tmp9_ = config;
				_tmp10_ = rygel_configuration_get_int_list (_tmp9_, section, key, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_object_unref0 (val);
				val = _tmp11_;
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				_g_object_unref0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
	}
	_tmp12_ = val;
	if (_tmp12_ == NULL) {
		GError* _tmp13_;
		_tmp13_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available for “%s/%s”"), section, key);
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static gboolean
rygel_meta_config_real_get_bool (RygelConfiguration* base,
                                 const gchar* section,
                                 const gchar* key,
                                 GError** error)
{
	RygelMetaConfig * self;
	gboolean val = FALSE;
	gboolean unavailable = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	val = FALSE;
	unavailable = TRUE;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				RygelConfiguration* _tmp9_;
				_tmp9_ = config;
				_tmp8_ = rygel_configuration_get_bool (_tmp9_, section, key, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				val = _tmp8_;
				unavailable = FALSE;
				_g_object_unref0 (config);
				break;
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp10_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (config);
				return _tmp10_;
			}
			_g_object_unref0 (config);
		}
	}
	if (unavailable) {
		GError* _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available for “%s/%s”"), section, key);
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		return _tmp12_;
	}
	result = val;
	return result;
}

static gboolean
rygel_meta_config_configuration_value_available (RygelMetaConfig* self,
                                                 RygelConfiguration* config,
                                                 RygelConfigurationEntry entry)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (config != NULL, FALSE);
	{
		switch (entry) {
			case RYGEL_CONFIGURATION_ENTRY_INTERFACE:
			{
				gchar** _tmp0_;
				gchar** _tmp1_;
				gchar** _tmp2_;
				gint _tmp2__length1;
				_tmp1_ = _tmp0_ = rygel_configuration_get_interfaces (config, &_inner_error0_);
				_tmp2_ = _tmp1_;
				_tmp2__length1 = _vala_array_length (_tmp0_);
				_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_CONFIGURATION_ENTRY_PORT:
			{
				rygel_configuration_get_port (config, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_CONFIGURATION_ENTRY_TRANSCODING:
			{
				rygel_configuration_get_transcoding (config, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_CONFIGURATION_ENTRY_ALLOW_UPLOAD:
			{
				rygel_configuration_get_allow_upload (config, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_CONFIGURATION_ENTRY_ALLOW_DELETION:
			{
				rygel_configuration_get_allow_deletion (config, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_CONFIGURATION_ENTRY_LOG_LEVELS:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = rygel_configuration_get_log_levels (config, &_inner_error0_);
				_tmp4_ = _tmp3_;
				_g_free0 (_tmp4_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_CONFIGURATION_ENTRY_PLUGIN_PATH:
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = rygel_configuration_get_plugin_path (config, &_inner_error0_);
				_tmp6_ = _tmp5_;
				_g_free0 (_tmp6_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_CONFIGURATION_ENTRY_VIDEO_UPLOAD_FOLDER:
			{
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = rygel_configuration_get_video_upload_folder (config, &_inner_error0_);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp8_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_CONFIGURATION_ENTRY_MUSIC_UPLOAD_FOLDER:
			{
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = rygel_configuration_get_music_upload_folder (config, &_inner_error0_);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp10_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_CONFIGURATION_ENTRY_PICTURE_UPLOAD_FOLDER:
			{
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = rygel_configuration_get_picture_upload_folder (config, &_inner_error0_);
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp12_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	result = TRUE;
	return result;
}

static void
rygel_meta_config_on_configuration_changed (RygelMetaConfig* self,
                                            RygelConfiguration* affected_config,
                                            RygelConfigurationEntry entry)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (affected_config != NULL);
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			RygelConfiguration* _tmp8_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			_tmp8_ = config;
			if (_tmp8_ == affected_config) {
				g_signal_emit_by_name ((RygelConfiguration*) self, "configuration-changed", entry);
			} else {
				RygelConfiguration* _tmp9_;
				_tmp9_ = config;
				if (rygel_meta_config_configuration_value_available (self, _tmp9_, entry)) {
					_g_object_unref0 (config);
					return;
				}
			}
			_g_object_unref0 (config);
		}
	}
}

static gboolean
rygel_meta_config_setting_value_available (RygelMetaConfig* self,
                                           RygelConfiguration* config,
                                           const gchar* section,
                                           RygelSectionEntry entry)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (config != NULL, FALSE);
	g_return_val_if_fail (section != NULL, FALSE);
	{
		switch (entry) {
			case RYGEL_SECTION_ENTRY_TITLE:
			{
				gchar* _tmp0_;
				gchar* _tmp1_;
				_tmp0_ = rygel_configuration_get_title (config, section, &_inner_error0_);
				_tmp1_ = _tmp0_;
				_g_free0 (_tmp1_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case RYGEL_SECTION_ENTRY_ENABLED:
			{
				rygel_configuration_get_enabled (config, section, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = TRUE;
	return result;
}

static void
rygel_meta_config_on_section_changed (RygelMetaConfig* self,
                                      RygelConfiguration* affected_config,
                                      const gchar* section,
                                      RygelSectionEntry entry)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (affected_config != NULL);
	g_return_if_fail (section != NULL);
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp0_;
		gint _config_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _config_index = 0;
		_tmp0_ = rygel_meta_config_configs;
		_config_list = _tmp0_;
		_tmp1_ = _config_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_config_size = _tmp3_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelConfiguration* config = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			RygelConfiguration* _tmp8_;
			_config_index = _config_index + 1;
			_tmp4_ = _config_index;
			_tmp5_ = _config_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _config_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _config_index);
			config = (RygelConfiguration*) _tmp7_;
			_tmp8_ = config;
			if (_tmp8_ == affected_config) {
				g_signal_emit_by_name ((RygelConfiguration*) self, "section-changed", section, entry);
			} else {
				RygelConfiguration* _tmp9_;
				_tmp9_ = config;
				if (rygel_meta_config_setting_value_available (self, _tmp9_, section, entry)) {
					_g_object_unref0 (config);
					return;
				}
			}
			_g_object_unref0 (config);
		}
	}
}

static void
rygel_meta_config_on_setting_changed (RygelMetaConfig* self,
                                      RygelConfiguration* affected_config,
                                      const gchar* section,
                                      const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (affected_config != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_signal_emit_by_name ((RygelConfiguration*) self, "setting-changed", section, key);
}

RygelMetaConfig*
rygel_meta_config_construct (GType object_type)
{
	RygelMetaConfig * self = NULL;
	self = (RygelMetaConfig*) g_object_new (object_type, NULL);
	return self;
}

RygelMetaConfig*
rygel_meta_config_new (void)
{
	return rygel_meta_config_construct (RYGEL_TYPE_META_CONFIG);
}

static void
rygel_meta_config_class_init (RygelMetaConfigClass * klass,
                              gpointer klass_data)
{
	rygel_meta_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_meta_config_finalize;
}

static void
rygel_meta_config_rygel_configuration_interface_init (RygelConfigurationIface * iface,
                                                      gpointer iface_data)
{
	rygel_meta_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_interface = (gchar* (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_interface;
	iface->get_interfaces = (gchar** (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_interfaces;
	iface->get_port = (gint (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_port;
	iface->get_transcoding = (gboolean (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_transcoding;
	iface->get_allow_upload = (gboolean (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_allow_deletion;
	iface->get_log_levels = (gchar* (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_log_levels;
	iface->get_plugin_path = (gchar* (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_plugin_path;
	iface->get_media_engine = (gchar* (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_media_engine;
	iface->get_engine_path = (gchar* (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_engine_path;
	iface->get_video_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_video_upload_folder;
	iface->get_music_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_music_upload_folder;
	iface->get_picture_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_meta_config_real_get_picture_upload_folder;
	iface->get_enabled = (gboolean (*) (RygelConfiguration*, const gchar*, GError**)) rygel_meta_config_real_get_enabled;
	iface->get_title = (gchar* (*) (RygelConfiguration*, const gchar*, GError**)) rygel_meta_config_real_get_title;
	iface->get_string = (gchar* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_meta_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_meta_config_real_get_string_list;
	iface->get_int = (gint (*) (RygelConfiguration*, const gchar*, const gchar*, gint, gint, GError**)) rygel_meta_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_meta_config_real_get_int_list;
	iface->get_bool = (gboolean (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_meta_config_real_get_bool;
}

static void
rygel_meta_config_instance_init (RygelMetaConfig * self,
                                 gpointer klass)
{
}

static void
rygel_meta_config_finalize (GObject * obj)
{
	RygelMetaConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_META_CONFIG, RygelMetaConfig);
	G_OBJECT_CLASS (rygel_meta_config_parent_class)->finalize (obj);
}

/**
 * Manages all the configuration sources for Rygel.
 *
 * Abstracts Rygel and its plugins from Configuration implementations. It keeps
 * all real configuration sources in a list and returns the value provided by
 * the first one. If none of them provides the value, it emits an error.
 */
 G_GNUC_NO_INLINE static GType
rygel_meta_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMetaConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_meta_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMetaConfig), 0, (GInstanceInitFunc) rygel_meta_config_instance_init, NULL };
	static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_meta_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_meta_config_type_id;
	rygel_meta_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMetaConfig", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_meta_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
	return rygel_meta_config_type_id;
}

GType
rygel_meta_config_get_type (void)
{
	static volatile gsize rygel_meta_config_type_id__once = 0;
	if (g_once_init_enter (&rygel_meta_config_type_id__once)) {
		GType rygel_meta_config_type_id;
		rygel_meta_config_type_id = rygel_meta_config_get_type_once ();
		g_once_init_leave (&rygel_meta_config_type_id__once, rygel_meta_config_type_id);
	}
	return rygel_meta_config_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

