/* rygel-media-renderer.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-media-renderer.vala, do not modify */

/*
 * Copyright (C) 2012 Openismus GmbH.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-renderer.h"
#include <glib-object.h>
#include "rygel-core.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define TYPE_PLUGIN (plugin_get_type ())
#define PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN, Plugin))
#define PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN, PluginClass))
#define IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN))
#define IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN))
#define PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN, PluginClass))

typedef struct _Plugin Plugin;
typedef struct _PluginClass PluginClass;
typedef struct _PluginPrivate PluginPrivate;
enum  {
	PLUGIN_0_PROPERTY,
	PLUGIN_NUM_PROPERTIES
};
static GParamSpec* plugin_properties[PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	RYGEL_MEDIA_RENDERER_0_PROPERTY,
	RYGEL_MEDIA_RENDERER_PLAYER_PROPERTY,
	RYGEL_MEDIA_RENDERER_NUM_PROPERTIES
};
static GParamSpec* rygel_media_renderer_properties[RYGEL_MEDIA_RENDERER_NUM_PROPERTIES];

struct _Plugin {
	RygelMediaRendererPlugin parent_instance;
	PluginPrivate * priv;
};

struct _PluginClass {
	RygelMediaRendererPluginClass parent_class;
};

struct _PluginPrivate {
	RygelMediaPlayer* player;
};

struct _RygelMediaRendererPrivate {
	RygelMediaPlayer* _player;
};

static gint Plugin_private_offset;
static gpointer plugin_parent_class = NULL;
static gint RygelMediaRenderer_private_offset;
static gpointer rygel_media_renderer_parent_class = NULL;

VALA_EXTERN GType plugin_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Plugin* plugin_new (RygelMediaPlayer* player,
                    RygelPluginCapabilities capabilities);
VALA_EXTERN Plugin* plugin_construct (GType object_type,
                          RygelMediaPlayer* player,
                          RygelPluginCapabilities capabilities);
static RygelMediaPlayer* plugin_real_get_player (RygelMediaRendererPlugin* base);
static void plugin_finalize (GObject * obj);
static GType plugin_get_type_once (void);
static void rygel_media_renderer_real_constructed (GObject* base);
static RygelMediaPlayer* rygel_media_renderer_get_player (RygelMediaRenderer* self);
static void rygel_media_renderer_finalize (GObject * obj);
static GType rygel_media_renderer_get_type_once (void);
static void _vala_rygel_media_renderer_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_rygel_media_renderer_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
plugin_get_instance_private (Plugin* self)
{
	return G_STRUCT_MEMBER_P (self, Plugin_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Plugin*
plugin_construct (GType object_type,
                  RygelMediaPlayer* player,
                  RygelPluginCapabilities capabilities)
{
	Plugin * self = NULL;
	RygelMediaPlayer* _tmp0_;
	g_return_val_if_fail (player != NULL, NULL);
	self = (Plugin*) rygel_media_renderer_plugin_construct (object_type, "LibRygelRenderer", "LibRygelRenderer", NULL, capabilities);
	_tmp0_ = _g_object_ref0 (player);
	_g_object_unref0 (self->priv->player);
	self->priv->player = _tmp0_;
	return self;
}

Plugin*
plugin_new (RygelMediaPlayer* player,
            RygelPluginCapabilities capabilities)
{
	return plugin_construct (TYPE_PLUGIN, player, capabilities);
}

static RygelMediaPlayer*
plugin_real_get_player (RygelMediaRendererPlugin* base)
{
	Plugin * self;
	RygelMediaPlayer* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	RygelMediaPlayer* result;
	self = (Plugin*) base;
	_tmp0_ = self->priv->player;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
plugin_class_init (PluginClass * klass,
                   gpointer klass_data)
{
	plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Plugin_private_offset);
	((RygelMediaRendererPluginClass *) klass)->get_player = (RygelMediaPlayer* (*) (RygelMediaRendererPlugin*)) plugin_real_get_player;
	G_OBJECT_CLASS (klass)->finalize = plugin_finalize;
}

static void
plugin_instance_init (Plugin * self,
                      gpointer klass)
{
	self->priv = plugin_get_instance_private (self);
}

static void
plugin_finalize (GObject * obj)
{
	Plugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLUGIN, Plugin);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (plugin_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Plugin), 0, (GInstanceInitFunc) plugin_instance_init, NULL };
	GType plugin_type_id;
	plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, "Plugin", &g_define_type_info, 0);
	Plugin_private_offset = g_type_add_instance_private (plugin_type_id, sizeof (PluginPrivate));
	return plugin_type_id;
}

GType
plugin_get_type (void)
{
	static volatile gsize plugin_type_id__once = 0;
	if (g_once_init_enter (&plugin_type_id__once)) {
		GType plugin_type_id;
		plugin_type_id = plugin_get_type_once ();
		g_once_init_leave (&plugin_type_id__once, plugin_type_id);
	}
	return plugin_type_id__once;
}

static inline gpointer
rygel_media_renderer_get_instance_private (RygelMediaRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaRenderer_private_offset);
}

/**
     * Create a RygelMediaRenderer to render content via a RygelMediaPlayer.
     */
RygelMediaRenderer*
rygel_media_renderer_construct (GType object_type,
                                const gchar* title,
                                RygelMediaPlayer* player,
                                RygelPluginCapabilities capabilities)
{
	RygelMediaRenderer * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (player != NULL, NULL);
	self = (RygelMediaRenderer*) g_object_new (object_type, "title", title, "player", player, "capabilities", capabilities, NULL);
	return self;
}

RygelMediaRenderer*
rygel_media_renderer_new (const gchar* title,
                          RygelMediaPlayer* player,
                          RygelPluginCapabilities capabilities)
{
	return rygel_media_renderer_construct (RYGEL_TYPE_MEDIA_RENDERER, title, player, capabilities);
}

static void
rygel_media_renderer_real_constructed (GObject* base)
{
	RygelMediaRenderer * self;
	RygelPlugin* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelPlugin* _tmp7_;
	RygelPlugin* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	self = (RygelMediaRenderer*) base;
	G_OBJECT_CLASS (rygel_media_renderer_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice));
	_tmp0_ = rygel_media_device_get_plugin ((RygelMediaDevice*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		RygelMediaPlayer* _tmp2_;
		RygelPluginCapabilities _tmp3_;
		RygelPluginCapabilities _tmp4_;
		Plugin* _tmp5_;
		Plugin* _tmp6_;
		_tmp2_ = self->priv->_player;
		_tmp3_ = rygel_media_device_get_capabilities ((RygelMediaDevice*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = plugin_new (_tmp2_, _tmp4_);
		_tmp6_ = _tmp5_;
		rygel_media_device_set_plugin ((RygelMediaDevice*) self, (RygelPlugin*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp7_ = rygel_media_device_get_plugin ((RygelMediaDevice*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = rygel_media_device_get_title ((RygelMediaDevice*) self);
	_tmp10_ = _tmp9_;
	rygel_plugin_set_title (_tmp8_, _tmp10_);
}

static RygelMediaPlayer*
rygel_media_renderer_get_player (RygelMediaRenderer* self)
{
	RygelMediaPlayer* result;
	RygelMediaPlayer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_player;
	result = _tmp0_;
	return result;
}

static void
rygel_media_renderer_set_player (RygelMediaRenderer* self,
                                 RygelMediaPlayer* value)
{
	RygelMediaPlayer* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_renderer_get_player (self);
	if (old_value != value) {
		self->priv->_player = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_renderer_properties[RYGEL_MEDIA_RENDERER_PLAYER_PROPERTY]);
	}
}

static void
rygel_media_renderer_class_init (RygelMediaRendererClass * klass,
                                 gpointer klass_data)
{
	rygel_media_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaRenderer_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_media_renderer_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RENDERER_PLAYER_PROPERTY, rygel_media_renderer_properties[RYGEL_MEDIA_RENDERER_PLAYER_PROPERTY] = g_param_spec_object ("player", "player", "player", RYGEL_TYPE_MEDIA_PLAYER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
rygel_media_renderer_instance_init (RygelMediaRenderer * self,
                                    gpointer klass)
{
	self->priv = rygel_media_renderer_get_instance_private (self);
}

static void
rygel_media_renderer_finalize (GObject * obj)
{
	RygelMediaRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_RENDERER, RygelMediaRenderer);
	G_OBJECT_CLASS (rygel_media_renderer_parent_class)->finalize (obj);
}

/**
 * This class may be used to implement in-process UPnP-AV media renderers.
 *
 * Call rygel_media_device_add_interface() on the RygelMediaRenderer to allow it
 * to render media from that network interface.
 *
 * See the
 * <link linkend="implementing-renderers">Implementing Renderers</link> section.
 */
 G_GNUC_NO_INLINE static GType
rygel_media_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaRenderer), 0, (GInstanceInitFunc) rygel_media_renderer_instance_init, NULL };
	GType rygel_media_renderer_type_id;
	rygel_media_renderer_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_DEVICE, "RygelMediaRenderer", &g_define_type_info, 0);
	RygelMediaRenderer_private_offset = g_type_add_instance_private (rygel_media_renderer_type_id, sizeof (RygelMediaRendererPrivate));
	return rygel_media_renderer_type_id;
}

GType
rygel_media_renderer_get_type (void)
{
	static volatile gsize rygel_media_renderer_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_renderer_type_id__once)) {
		GType rygel_media_renderer_type_id;
		rygel_media_renderer_type_id = rygel_media_renderer_get_type_once ();
		g_once_init_leave (&rygel_media_renderer_type_id__once, rygel_media_renderer_type_id);
	}
	return rygel_media_renderer_type_id__once;
}

static void
_vala_rygel_media_renderer_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	RygelMediaRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RENDERER, RygelMediaRenderer);
	switch (property_id) {
		case RYGEL_MEDIA_RENDERER_PLAYER_PROPERTY:
		g_value_set_object (value, rygel_media_renderer_get_player (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_renderer_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	RygelMediaRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RENDERER, RygelMediaRenderer);
	switch (property_id) {
		case RYGEL_MEDIA_RENDERER_PLAYER_PROPERTY:
		rygel_media_renderer_set_player (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

