/* rygel-relational-expression.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-relational-expression.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>

#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,@refID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_relational_expression_parent_class = NULL;

static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base,
                                                        RygelMediaObject* media_object);
static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self,
                                                           RygelWritableContainer* container);
static gchar* rygel_relational_expression_real_to_string (RygelSearchExpression* base);
static GType rygel_relational_expression_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base,
                                               RygelMediaObject* media_object)
{
	RygelRelationalExpression * self;
	gconstpointer _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	gboolean result;
	self = (RygelRelationalExpression*) base;
	g_return_val_if_fail (media_object != NULL, FALSE);
	_tmp0_ = ((RygelSearchExpression*) self)->operand1;
	_tmp1_ = (const gchar*) _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = rygel_media_object_get_id (media_object);
				_tmp5_ = _tmp4_;
				result = rygel_relational_expression_compare_string (self, _tmp5_);
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@refID")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = rygel_media_object_get_ref_id (media_object);
				_tmp7_ = _tmp6_;
				result = rygel_relational_expression_compare_string (self, _tmp7_);
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				RygelMediaContainer* _tmp8_;
				RygelMediaContainer* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp8_ = rygel_media_object_get_parent (media_object);
				_tmp9_ = _tmp8_;
				_tmp10_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp9_);
				_tmp11_ = _tmp10_;
				result = rygel_relational_expression_compare_string (self, _tmp11_);
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = rygel_media_object_get_upnp_class (media_object);
				_tmp13_ = _tmp12_;
				result = rygel_relational_expression_compare_string (self, _tmp13_);
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = rygel_media_object_get_title (media_object);
				_tmp15_ = _tmp14_;
				result = rygel_relational_expression_compare_string (self, _tmp15_);
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:objectUpdateID")))) {
		switch (0) {
			default:
			{
				gconstpointer _tmp16_;
				_tmp16_ = ((RygelSearchExpression*) self)->op;
				if (((GUPnPSearchCriteriaOp) ((gintptr) _tmp16_)) == GUPNP_SEARCH_CRITERIA_OP_EXISTS) {
					gconstpointer _tmp17_;
					_tmp17_ = ((RygelSearchExpression*) self)->operand2;
					if (g_strcmp0 ((const gchar*) _tmp17_, "true") == 0) {
						gboolean _tmp18_ = FALSE;
						if (RYGEL_IS_TRACKABLE_CONTAINER (media_object)) {
							_tmp18_ = TRUE;
						} else {
							_tmp18_ = RYGEL_IS_TRACKABLE_ITEM (media_object);
						}
						result = _tmp18_;
						return result;
					} else {
						gboolean _tmp19_ = FALSE;
						if (RYGEL_IS_TRACKABLE_CONTAINER (media_object)) {
							_tmp19_ = TRUE;
						} else {
							_tmp19_ = RYGEL_IS_TRACKABLE_ITEM (media_object);
						}
						result = !_tmp19_;
						return result;
					}
				} else {
					guint _tmp20_;
					guint _tmp21_;
					_tmp20_ = rygel_media_object_get_object_update_id (media_object);
					_tmp21_ = _tmp20_;
					result = rygel_relational_expression_compare_uint (self, _tmp21_);
					return result;
				}
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("upnp:containerUpdateID")))) {
		switch (0) {
			default:
			{
				gconstpointer _tmp22_;
				if (!RYGEL_IS_MEDIA_CONTAINER (media_object)) {
					result = FALSE;
					return result;
				}
				_tmp22_ = ((RygelSearchExpression*) self)->op;
				if (((GUPnPSearchCriteriaOp) ((gintptr) _tmp22_)) == GUPNP_SEARCH_CRITERIA_OP_EXISTS) {
					gconstpointer _tmp23_;
					_tmp23_ = ((RygelSearchExpression*) self)->operand2;
					if (g_strcmp0 ((const gchar*) _tmp23_, "true") == 0) {
						result = RYGEL_IS_TRACKABLE_CONTAINER (media_object);
						return result;
					} else {
						result = !RYGEL_IS_TRACKABLE_CONTAINER (media_object);
						return result;
					}
				} else {
					RygelMediaContainer* container = NULL;
					RygelMediaContainer* _tmp24_;
					RygelMediaContainer* _tmp25_;
					_tmp24_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (media_object) ? ((RygelMediaContainer*) media_object) : NULL);
					container = _tmp24_;
					_tmp25_ = container;
					result = rygel_relational_expression_compare_uint (self, (guint) _tmp25_->update_id);
					_g_object_unref0 (container);
					return result;
				}
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:createClass")))) {
		switch (0) {
			default:
			{
				if (!RYGEL_IS_WRITABLE_CONTAINER (media_object)) {
					result = FALSE;
					return result;
				}
				result = rygel_relational_expression_compare_create_class (self, RYGEL_IS_WRITABLE_CONTAINER (media_object) ? ((RygelWritableContainer*) media_object) : NULL);
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				{
					RygelPhotoItem* item = NULL;
					RygelPhotoItem* _tmp26_;
					gboolean _tmp27_ = FALSE;
					RygelPhotoItem* _tmp28_;
					_tmp26_ = _g_object_ref0 (RYGEL_IS_PHOTO_ITEM (media_object) ? ((RygelPhotoItem*) media_object) : NULL);
					item = _tmp26_;
					_tmp28_ = item;
					if (_tmp28_ != NULL) {
						RygelPhotoItem* _tmp29_;
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						_tmp29_ = item;
						_tmp30_ = rygel_media_object_get_creator ((RygelMediaObject*) _tmp29_);
						_tmp31_ = _tmp30_;
						_tmp27_ = rygel_relational_expression_compare_string (self, _tmp31_);
					} else {
						_tmp27_ = FALSE;
					}
					result = _tmp27_;
					_g_object_unref0 (item);
					return result;
				}
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("upnp:artist")))) {
		switch (0) {
			default:
			{
				{
					RygelMusicItem* item = NULL;
					RygelMusicItem* _tmp32_;
					gboolean _tmp33_ = FALSE;
					RygelMusicItem* _tmp34_;
					_tmp32_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (media_object) ? ((RygelMusicItem*) media_object) : NULL);
					item = _tmp32_;
					_tmp34_ = item;
					if (_tmp34_ != NULL) {
						RygelMusicItem* _tmp35_;
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						_tmp35_ = item;
						_tmp36_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp35_);
						_tmp37_ = _tmp36_;
						_tmp33_ = rygel_relational_expression_compare_string (self, _tmp37_);
					} else {
						_tmp33_ = FALSE;
					}
					result = _tmp33_;
					_g_object_unref0 (item);
					return result;
				}
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				RygelMusicItem* item = NULL;
				RygelMusicItem* _tmp38_;
				gboolean _tmp39_ = FALSE;
				RygelMusicItem* _tmp40_;
				_tmp38_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (media_object) ? ((RygelMusicItem*) media_object) : NULL);
				item = _tmp38_;
				_tmp40_ = item;
				if (_tmp40_ != NULL) {
					RygelMusicItem* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					_tmp41_ = item;
					_tmp42_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp39_ = rygel_relational_expression_compare_string (self, _tmp43_);
				} else {
					_tmp39_ = FALSE;
				}
				result = _tmp39_;
				_g_object_unref0 (item);
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("@childCount")))) {
		switch (0) {
			default:
			{
				RygelMediaContainer* container = NULL;
				RygelMediaContainer* _tmp44_;
				gboolean _tmp45_ = FALSE;
				RygelMediaContainer* _tmp46_;
				_tmp44_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (media_object) ? ((RygelMediaContainer*) media_object) : NULL);
				container = _tmp44_;
				_tmp46_ = container;
				if (_tmp46_ != NULL) {
					RygelMediaContainer* _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
					_tmp47_ = container;
					_tmp48_ = rygel_media_container_get_child_count (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp45_ = rygel_relational_expression_compare_int (self, _tmp49_);
				} else {
					_tmp45_ = FALSE;
				}
				result = _tmp45_;
				_g_object_unref0 (container);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
}

static gchar*
rygel_relational_expression_real_to_string (RygelSearchExpression* base)
{
	RygelRelationalExpression * self;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = (RygelRelationalExpression*) base;
	_tmp0_ = ((RygelSearchExpression*) self)->operand1;
	_tmp1_ = ((RygelSearchExpression*) self)->op;
	_tmp2_ = ((RygelSearchExpression*) self)->operand2;
	_tmp3_ = g_strdup_printf ("%s %d %s", (const gchar*) _tmp0_, (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp1_)), (const gchar*) _tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
rygel_relational_expression_compare_create_class (RygelRelationalExpression* self,
                                                  RygelWritableContainer* container)
{
	gboolean ret = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (container != NULL, FALSE);
	ret = FALSE;
	{
		GeeArrayList* _create_class_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _create_class_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _create_class_index = 0;
		_tmp0_ = rygel_writable_container_get_create_classes (container);
		_tmp1_ = _tmp0_;
		_create_class_list = _tmp1_;
		_tmp2_ = _create_class_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_create_class_size = _tmp4_;
		_create_class_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* create_class = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			_create_class_index = _create_class_index + 1;
			_tmp5_ = _create_class_index;
			_tmp6_ = _create_class_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _create_class_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _create_class_index);
			create_class = (gchar*) _tmp8_;
			_tmp9_ = create_class;
			if (rygel_relational_expression_compare_string (self, _tmp9_)) {
				ret = TRUE;
				_g_free0 (create_class);
				break;
			}
			_g_free0 (create_class);
		}
	}
	result = ret;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
rygel_relational_expression_compare_string (RygelRelationalExpression* self,
                                            const gchar* str)
{
	gchar* up_operand2 = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_;
	gchar* up_str = NULL;
	gconstpointer _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
	_tmp1_ = g_utf8_strup ((const gchar*) _tmp0_, (gssize) -1);
	up_operand2 = _tmp1_;
	if (str != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_utf8_strup (str, (gssize) -1);
		_g_free0 (up_str);
		up_str = _tmp2_;
	} else {
		_g_free0 (up_str);
		up_str = NULL;
	}
	_tmp3_ = ((RygelSearchExpression*) self)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp3_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			gconstpointer _tmp4_;
			_tmp4_ = ((RygelSearchExpression*) self)->operand2;
			if (g_strcmp0 ((const gchar*) _tmp4_, "true") == 0) {
				const gchar* _tmp5_;
				_tmp5_ = up_str;
				result = _tmp5_ != NULL;
				_g_free0 (up_str);
				_g_free0 (up_operand2);
				return result;
			} else {
				const gchar* _tmp6_;
				_tmp6_ = up_str;
				result = _tmp6_ == NULL;
				_g_free0 (up_str);
				_g_free0 (up_operand2);
				return result;
			}
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = up_operand2;
			_tmp8_ = up_str;
			result = g_strcmp0 (_tmp7_, _tmp8_) == 0;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = up_operand2;
			_tmp10_ = up_str;
			result = g_strcmp0 (_tmp9_, _tmp10_) != 0;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = up_str;
			_tmp12_ = up_operand2;
			result = string_contains (_tmp11_, _tmp12_);
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp13_ = up_str;
			_tmp14_ = up_operand2;
			result = g_str_has_prefix (_tmp13_, _tmp14_);
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		default:
		{
			result = FALSE;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
	}
}

gboolean
rygel_relational_expression_compare_int (RygelRelationalExpression* self,
                                         gint integer)
{
	gint operand2 = 0;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
	operand2 = atoi ((const gchar*) _tmp0_);
	_tmp1_ = ((RygelSearchExpression*) self)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp1_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			result = integer == operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			result = integer != operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		{
			result = integer < operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		{
			result = integer <= operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		{
			result = integer > operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			result = integer >= operand2;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

gboolean
rygel_relational_expression_compare_uint (RygelRelationalExpression* self,
                                          guint integer)
{
	guint64 operand2 = 0ULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
	operand2 = uint64_parse ((const gchar*) _tmp0_, (guint) 0);
	_tmp1_ = ((RygelSearchExpression*) self)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp1_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			result = ((guint64) integer) == operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			result = ((guint64) integer) != operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		{
			result = ((guint64) integer) < operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		{
			result = ((guint64) integer) <= operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		{
			result = ((guint64) integer) > operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			result = ((guint64) integer) >= operand2;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

RygelRelationalExpression*
rygel_relational_expression_construct (GType object_type)
{
	RygelRelationalExpression* self = NULL;
	self = (RygelRelationalExpression*) rygel_search_expression_construct (object_type, gupnp_search_criteria_op_get_type (), NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free);
	return self;
}

RygelRelationalExpression*
rygel_relational_expression_new (void)
{
	return rygel_relational_expression_construct (RYGEL_TYPE_RELATIONAL_EXPRESSION);
}

static void
rygel_relational_expression_class_init (RygelRelationalExpressionClass * klass,
                                        gpointer klass_data)
{
	rygel_relational_expression_parent_class = g_type_class_peek_parent (klass);
	((RygelSearchExpressionClass *) klass)->satisfied_by = (gboolean (*) (RygelSearchExpression*, RygelMediaObject*)) rygel_relational_expression_real_satisfied_by;
	((RygelSearchExpressionClass *) klass)->to_string = (gchar* (*) (RygelSearchExpression*)) rygel_relational_expression_real_to_string;
}

static void
rygel_relational_expression_instance_init (RygelRelationalExpression * self,
                                           gpointer klass)
{
}

/**
 * This is a parsed UPnP search expression consisting of two strings joined by a
 * relational operator such as such <, <=, ==, !=, >, >=, derivedFrom or exists.
 */
 G_GNUC_NO_INLINE static GType
rygel_relational_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelRelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRelationalExpression), 0, (GInstanceInitFunc) rygel_relational_expression_instance_init, NULL };
	GType rygel_relational_expression_type_id;
	rygel_relational_expression_type_id = g_type_register_static (RYGEL_TYPE_SEARCH_EXPRESSION, "RygelRelationalExpression", &g_define_type_info, 0);
	return rygel_relational_expression_type_id;
}

GType
rygel_relational_expression_get_type (void)
{
	static volatile gsize rygel_relational_expression_type_id__once = 0;
	if (g_once_init_enter (&rygel_relational_expression_type_id__once)) {
		GType rygel_relational_expression_type_id;
		rygel_relational_expression_type_id = rygel_relational_expression_get_type_once ();
		g_once_init_leave (&rygel_relational_expression_type_id__once, rygel_relational_expression_type_id);
	}
	return rygel_relational_expression_type_id__once;
}

