/* rygel-lms-albums.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-lms-albums.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-lms.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "rygel-server.h"
#include <sqlite3.h>
#include "rygel-db.h"
#include <gee.h>
#include <glib/gi18n-lib.h>

#define RYGEL_LMS_ALBUMS_SQL_ALL "SELECT audio_albums.id, audio_albums.name as title, " "audio_artists.name as artist " "FROM audio_albums " "LEFT JOIN audio_artists " "ON audio_albums.artist_id = audio_artists.id " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALBUMS_SQL_ALL_WITH_FILTER_TEMPLATE "SELECT audio_albums.id, audio_albums.name as title, " "audio_artists.name as artist " "FROM audio_albums " "LEFT JOIN audio_artists " "ON audio_albums.artist_id = audio_artists.id " "WHERE %s " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALBUMS_SQL_COUNT "SELECT COUNT(audio_albums.id) " "FROM audio_albums;"
#define RYGEL_LMS_ALBUMS_SQL_COUNT_WITH_FILTER_TEMPLATE "SELECT COUNT(audio_albums.id), audio_albums.name as title, " "audio_artists.name as artist " "FROM audio_albums " "LEFT JOIN audio_artists " "ON audio_albums.artist_id = audio_artists.id " "WHERE %s;"
#define RYGEL_LMS_ALBUMS_SQL_CHILD_COUNT_WITH_FILTER_TEMPLATE "SELECT COUNT(audios.id), audios.title as title, " "audio_artists.name as artist " "FROM audios, files, audio_albums " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = audio_a" \
"lbums.id %s;"
#define RYGEL_LMS_ALBUMS_SQL_CHILD_ALL_WITH_FILTER_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, audios.channels," \
" audios.sampling_rate, audios.bitrate, audios.dlna_profile, audios.dln" \
"a_mime, " "audio_artists.name as artist, " "audio_albums.name, audio_albums.id " "FROM audios, files, audio_albums " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = audio_a" \
"lbums.id %s " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALBUMS_SQL_FIND_OBJECT "SELECT audio_albums.id, audio_albums.name " "FROM audio_albums " "WHERE audio_albums.id = ?;"

enum  {
	RYGEL_LMS_ALBUMS_0_PROPERTY,
	RYGEL_LMS_ALBUMS_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_albums_properties[RYGEL_LMS_ALBUMS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_database_cursor_iterator_unref (var), NULL)))

static gpointer rygel_lms_albums_parent_class = NULL;

static gchar* rygel_lms_albums_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base,
                                                      const gchar* filter);
static gchar* rygel_lms_albums_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base,
                                                        const gchar* filter);
static guint rygel_lms_albums_real_get_child_count_with_filter (RygelLMSCategoryContainer* base,
                                                         const gchar* where_filter,
                                                         GArray* args);
static RygelMediaObjects* rygel_lms_albums_real_get_children_with_filter (RygelLMSCategoryContainer* base,
                                                                   const gchar* where_filter,
                                                                   GArray* args,
                                                                   const gchar* sort_criteria,
                                                                   guint offset,
                                                                   guint max_count);
static RygelMediaObject* rygel_lms_albums_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                               sqlite3_stmt* statement);
static GType rygel_lms_albums_get_type_once (void);

static gchar*
rygel_lms_albums_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base,
                                               const gchar* filter)
{
	RygelLMSAlbums * self;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp3_;
	gchar* result;
	self = (RygelLMSAlbums*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = strlen (filter);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (RYGEL_LMS_ALBUMS_SQL_ALL);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup_printf (RYGEL_LMS_ALBUMS_SQL_ALL_WITH_FILTER_TEMPLATE, filter);
	result = _tmp3_;
	return result;
}

static gchar*
rygel_lms_albums_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base,
                                                 const gchar* filter)
{
	RygelLMSAlbums * self;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp3_;
	gchar* result;
	self = (RygelLMSAlbums*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = strlen (filter);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (RYGEL_LMS_ALBUMS_SQL_COUNT);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup_printf (RYGEL_LMS_ALBUMS_SQL_COUNT_WITH_FILTER_TEMPLATE, filter);
	result = _tmp3_;
	return result;
}

static guint
rygel_lms_albums_real_get_child_count_with_filter (RygelLMSCategoryContainer* base,
                                                   const gchar* where_filter,
                                                   GArray* args)
{
	RygelLMSAlbums * self;
	guint count = 0U;
	gchar* filter = NULL;
	gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* query = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	guint result;
	self = (RygelLMSAlbums*) base;
	g_return_val_if_fail (where_filter != NULL, 0U);
	g_return_val_if_fail (args != NULL, 0U);
	count = RYGEL_LMS_CATEGORY_CONTAINER_CLASS (rygel_lms_albums_parent_class)->get_child_count_with_filter (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer), where_filter, args);
	_tmp0_ = g_strdup ("");
	filter = _tmp0_;
	_tmp1_ = strlen (where_filter);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup_printf ("AND %s", where_filter);
		_g_free0 (filter);
		filter = _tmp3_;
	}
	_tmp4_ = filter;
	_tmp5_ = g_strdup_printf (RYGEL_LMS_ALBUMS_SQL_CHILD_COUNT_WITH_FILTER_TEMPLATE, _tmp4_);
	query = _tmp5_;
	{
		gint _tmp6_ = 0;
		RygelLMSDatabase* _tmp7_;
		RygelLMSDatabase* _tmp8_;
		gpointer* _tmp9_;
		gint _tmp9__length1;
		_tmp7_ = rygel_lms_category_container_get_lms_db ((RygelLMSCategoryContainer*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = args->data;
		_tmp9__length1 = args->len;
		_tmp6_ = rygel_database_database_query_value ((RygelDatabaseDatabase*) _tmp8_, query, _tmp9_, (gint) _tmp9__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint _tmp10_ = 0U;
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			_g_free0 (query);
			_g_free0 (filter);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
		count += (guint) _tmp6_;
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("rygel-lms-albums.vala:113: Query failed: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint _tmp13_ = 0U;
		_g_free0 (query);
		_g_free0 (filter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	result = count;
	_g_free0 (query);
	_g_free0 (filter);
	return result;
}

static RygelMediaObjects*
rygel_lms_albums_real_get_children_with_filter (RygelLMSCategoryContainer* base,
                                                const gchar* where_filter,
                                                GArray* args,
                                                const gchar* sort_criteria,
                                                guint offset,
                                                guint max_count)
{
	RygelLMSAlbums * self;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_;
	gchar* filter = NULL;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* query = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	RygelMediaObjects* result;
	self = (RygelLMSAlbums*) base;
	g_return_val_if_fail (where_filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = RYGEL_LMS_CATEGORY_CONTAINER_CLASS (rygel_lms_albums_parent_class)->get_children_with_filter (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer), where_filter, args, sort_criteria, offset, max_count);
	children = _tmp0_;
	_tmp1_ = g_strdup ("");
	filter = _tmp1_;
	_tmp2_ = strlen (where_filter);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf ("AND %s", where_filter);
		_g_free0 (filter);
		filter = _tmp4_;
	}
	_tmp5_ = filter;
	_tmp6_ = g_strdup_printf (RYGEL_LMS_ALBUMS_SQL_CHILD_ALL_WITH_FILTER_TEMPLATE, _tmp5_);
	query = _tmp6_;
	{
		RygelDatabaseCursor* cursor = NULL;
		RygelLMSDatabase* _tmp7_;
		RygelLMSDatabase* _tmp8_;
		const gchar* _tmp9_;
		gpointer* _tmp10_;
		gint _tmp10__length1;
		RygelDatabaseCursor* _tmp11_;
		_tmp7_ = rygel_lms_category_container_get_lms_db ((RygelLMSCategoryContainer*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = query;
		_tmp10_ = args->data;
		_tmp10__length1 = args->len;
		_tmp11_ = rygel_database_database_exec_cursor ((RygelDatabaseDatabase*) _tmp8_, _tmp9_, _tmp10_, (gint) _tmp10__length1, &_inner_error0_);
		cursor = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			_g_free0 (query);
			_g_free0 (filter);
			_g_object_unref0 (children);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			RygelDatabaseCursorIterator* _stmt_it = NULL;
			RygelDatabaseCursor* _tmp12_;
			RygelDatabaseCursorIterator* _tmp13_;
			_tmp12_ = cursor;
			_tmp13_ = rygel_database_cursor_iterator (_tmp12_);
			_stmt_it = _tmp13_;
			while (TRUE) {
				gboolean _tmp14_ = FALSE;
				RygelDatabaseCursorIterator* _tmp15_;
				sqlite3_stmt* stmt = NULL;
				RygelDatabaseCursorIterator* _tmp16_;
				sqlite3_stmt* _tmp17_;
				gchar* album_id = NULL;
				sqlite3_stmt* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				RygelLMSAlbum* album = NULL;
				const gchar* _tmp21_;
				RygelLMSDatabase* _tmp22_;
				RygelLMSDatabase* _tmp23_;
				RygelLMSAlbum* _tmp24_;
				RygelMediaObject* song = NULL;
				RygelLMSAlbum* _tmp25_;
				sqlite3_stmt* _tmp26_;
				RygelMediaObject* _tmp27_;
				RygelMediaObject* _tmp28_;
				RygelMediaObject* _tmp29_;
				RygelMediaContainer* _tmp30_;
				RygelMediaContainer* _tmp31_;
				RygelMediaObjects* _tmp32_;
				RygelMediaObject* _tmp33_;
				_tmp15_ = _stmt_it;
				_tmp14_ = rygel_database_cursor_iterator_next (_tmp15_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch0_rygel_database_database_error;
					}
					_g_free0 (query);
					_g_free0 (filter);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				if (!_tmp14_) {
					break;
				}
				_tmp16_ = _stmt_it;
				_tmp17_ = rygel_database_cursor_iterator_get (_tmp16_, &_inner_error0_);
				stmt = _tmp17_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch0_rygel_database_database_error;
					}
					_g_free0 (query);
					_g_free0 (filter);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp18_ = stmt;
				_tmp19_ = (const gchar*) sqlite3_column_text (_tmp18_, 13);
				_tmp20_ = g_strdup (_tmp19_);
				album_id = _tmp20_;
				_tmp21_ = album_id;
				_tmp22_ = rygel_lms_category_container_get_lms_db ((RygelLMSCategoryContainer*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = rygel_lms_album_new (_tmp21_, (RygelMediaContainer*) self, "", _tmp23_);
				album = _tmp24_;
				_tmp25_ = album;
				_tmp26_ = stmt;
				_tmp27_ = rygel_lms_category_container_object_from_statement ((RygelLMSCategoryContainer*) _tmp25_, _tmp26_);
				song = _tmp27_;
				_tmp28_ = song;
				_tmp29_ = song;
				_tmp30_ = rygel_media_object_get_parent (_tmp29_);
				_tmp31_ = _tmp30_;
				rygel_media_object_set_parent_ref (_tmp28_, _tmp31_);
				_tmp32_ = children;
				_tmp33_ = song;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
				_g_object_unref0 (song);
				_g_object_unref0 (album);
				_g_free0 (album_id);
			}
			_rygel_database_cursor_iterator_unref0 (_stmt_it);
		}
		_g_object_unref0 (cursor);
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		g_warning ("rygel-lms-albums.vala:147: Query failed: %s", _tmp35_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (query);
		_g_free0 (filter);
		_g_object_unref0 (children);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = children;
	_g_free0 (query);
	_g_free0 (filter);
	return result;
}

static RygelMediaObject*
rygel_lms_albums_real_object_from_statement (RygelLMSCategoryContainer* base,
                                             sqlite3_stmt* statement)
{
	RygelLMSAlbums * self;
	gchar* id = NULL;
	gchar* _tmp0_;
	RygelLMSAlbum* album = NULL;
	const gchar* _tmp1_;
	RygelLMSDatabase* _tmp2_;
	RygelLMSDatabase* _tmp3_;
	RygelLMSAlbum* _tmp4_;
	RygelMediaObject* result;
	self = (RygelLMSAlbums*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%d", sqlite3_column_int (statement, 0));
	id = _tmp0_;
	_tmp1_ = (const gchar*) sqlite3_column_text (statement, 1);
	_tmp2_ = rygel_lms_category_container_get_lms_db ((RygelLMSCategoryContainer*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_lms_album_new (id, (RygelMediaContainer*) self, _tmp1_, _tmp3_);
	album = _tmp4_;
	result = (RygelMediaObject*) album;
	_g_free0 (id);
	return result;
}

RygelLMSAlbums*
rygel_lms_albums_construct (GType object_type,
                            RygelMediaContainer* parent,
                            RygelLMSDatabase* lms_db)
{
	RygelLMSAlbums * self = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	self = (RygelLMSAlbums*) rygel_lms_category_container_construct (object_type, "albums", parent, _ ("Albums"), lms_db, RYGEL_LMS_ALBUMS_SQL_ALL, RYGEL_LMS_ALBUMS_SQL_FIND_OBJECT, RYGEL_LMS_ALBUMS_SQL_COUNT, NULL, NULL);
	return self;
}

RygelLMSAlbums*
rygel_lms_albums_new (RygelMediaContainer* parent,
                      RygelLMSDatabase* lms_db)
{
	return rygel_lms_albums_construct (RYGEL_LMS_TYPE_ALBUMS, parent, lms_db);
}

static void
rygel_lms_albums_class_init (RygelLMSAlbumsClass * klass,
                             gpointer klass_data)
{
	rygel_lms_albums_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->get_sql_all_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_albums_real_get_sql_all_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_count_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_albums_real_get_sql_count_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_child_count_with_filter = (guint (*) (RygelLMSCategoryContainer*, const gchar*, GArray*)) rygel_lms_albums_real_get_child_count_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_children_with_filter = (RygelMediaObjects* (*) (RygelLMSCategoryContainer*, const gchar*, GArray*, const gchar*, guint, guint)) rygel_lms_albums_real_get_children_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_albums_real_object_from_statement;
}

static void
rygel_lms_albums_instance_init (RygelLMSAlbums * self,
                                gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
rygel_lms_albums_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLMSAlbumsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_albums_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSAlbums), 0, (GInstanceInitFunc) rygel_lms_albums_instance_init, NULL };
	GType rygel_lms_albums_type_id;
	rygel_lms_albums_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSAlbums", &g_define_type_info, 0);
	return rygel_lms_albums_type_id;
}

GType
rygel_lms_albums_get_type (void)
{
	static volatile gsize rygel_lms_albums_type_id__once = 0;
	if (g_once_init_enter (&rygel_lms_albums_type_id__once)) {
		GType rygel_lms_albums_type_id;
		rygel_lms_albums_type_id = rygel_lms_albums_get_type_once ();
		g_once_init_leave (&rygel_lms_albums_type_id__once, rygel_lms_albums_type_id);
	}
	return rygel_lms_albums_type_id__once;
}

