/* rygel-mpris-plugin.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-mpris-plugin.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-mpris.h"
#include "rygel-renderer.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-core.h"

#define RYGEL_MPRIS_PLUGIN_MEDIA_PLAYER_PATH "/org/mpris/MediaPlayer2"

enum  {
	RYGEL_MPRIS_PLUGIN_0_PROPERTY,
	RYGEL_MPRIS_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* rygel_mpris_plugin_properties[RYGEL_MPRIS_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_mpris_plugin_parent_class = NULL;

static gchar** rygel_mpris_plugin_schemes_to_protocols (RygelMPRISPlugin* self,
                                                 gchar** schemes,
                                                 gint schemes_length1,
                                                 gint* result_length1);
static RygelMediaPlayer* rygel_mpris_plugin_real_get_player (RygelMediaRendererPlugin* base);
static gchar* rygel_mpris_plugin_scheme_to_protocol (RygelMPRISPlugin* self,
                                              const gchar* scheme);
static void rygel_mpris_plugin_finalize (GObject * obj);
static GType rygel_mpris_plugin_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelMPRISPlugin*
rygel_mpris_plugin_construct (GType object_type,
                              const gchar* service_name,
                              RygelMPRISMediaPlayerPlayerProxy* actual_player)
{
	RygelMPRISPlugin * self = NULL;
	gchar* title = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	RygelMPRISMediaPlayerPlayerProxy* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_ = 0;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_ = 0;
	gchar** _tmp14_;
	g_return_val_if_fail (service_name != NULL, NULL);
	g_return_val_if_fail (actual_player != NULL, NULL);
	_tmp0_ = rygel_mpris_media_player_proxy_get_identity ((RygelMPRISMediaPlayerProxy*) actual_player);
	_tmp1_ = _tmp0_;
	title = _tmp1_;
	_tmp2_ = title;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (service_name);
		_g_free0 (title);
		title = _tmp3_;
	}
	_tmp4_ = title;
	self = (RygelMPRISPlugin*) rygel_media_renderer_plugin_construct (object_type, service_name, _tmp4_, NULL, RYGEL_PLUGIN_CAPABILITIES_NONE);
	_tmp5_ = _g_object_ref0 (actual_player);
	_g_object_unref0 (self->actual_player);
	self->actual_player = _tmp5_;
	_tmp6_ = rygel_mpris_media_player_proxy_get_supported_mime_types ((RygelMPRISMediaPlayerProxy*) actual_player, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->mime_types = _tmp8_;
	self->mime_types_length1 = _tmp8__length1;
	_tmp9_ = rygel_mpris_media_player_proxy_get_supported_uri_schemes ((RygelMPRISMediaPlayerProxy*) actual_player, &_tmp10_);
	_tmp9__length1 = _tmp10_;
	_tmp11_ = _tmp9_;
	_tmp11__length1 = _tmp9__length1;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _tmp11__length1;
	_tmp14_ = rygel_mpris_plugin_schemes_to_protocols (self, _tmp12_, (gint) _tmp11__length1, &_tmp13_);
	self->protocols = (_vala_array_free (self->protocols, self->protocols_length1, (GDestroyNotify) g_free), NULL);
	self->protocols = _tmp14_;
	self->protocols_length1 = _tmp13_;
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (title);
	return self;
}

RygelMPRISPlugin*
rygel_mpris_plugin_new (const gchar* service_name,
                        RygelMPRISMediaPlayerPlayerProxy* actual_player)
{
	return rygel_mpris_plugin_construct (RYGEL_MPRIS_TYPE_PLUGIN, service_name, actual_player);
}

static RygelMediaPlayer*
rygel_mpris_plugin_real_get_player (RygelMediaRendererPlugin* base)
{
	RygelMPRISPlugin * self;
	RygelMPRISPlayer* _tmp0_;
	RygelMediaPlayer* result;
	self = (RygelMPRISPlugin*) base;
	_tmp0_ = rygel_mpris_player_new (self);
	result = (RygelMediaPlayer*) _tmp0_;
	return result;
}

static gchar**
rygel_mpris_plugin_schemes_to_protocols (RygelMPRISPlugin* self,
                                         gchar** schemes,
                                         gint schemes_length1,
                                         gint* result_length1)
{
	gchar** protocols = NULL;
	gchar** _tmp1_;
	gint protocols_length1;
	gint _protocols_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	if (schemes == NULL) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp0__length1;
		}
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_new0 (gchar*, schemes_length1 + 1);
	protocols = _tmp1_;
	protocols_length1 = schemes_length1;
	_protocols_size_ = protocols_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar** _tmp4_;
				gint _tmp4__length1;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < schemes_length1)) {
					break;
				}
				_tmp4_ = protocols;
				_tmp4__length1 = protocols_length1;
				_tmp5_ = schemes[i];
				_tmp6_ = rygel_mpris_plugin_scheme_to_protocol (self, _tmp5_);
				_g_free0 (_tmp4_[i]);
				_tmp4_[i] = _tmp6_;
			}
		}
	}
	_tmp7_ = protocols;
	_tmp7__length1 = protocols_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static gchar*
rygel_mpris_plugin_scheme_to_protocol (RygelMPRISPlugin* self,
                                       const gchar* scheme)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scheme != NULL, NULL);
	_tmp0_ = scheme;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("http")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("http-get");
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("file")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("internal");
				result = _tmp4_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (scheme);
				result = _tmp5_;
				return result;
			}
		}
	}
}

static void
rygel_mpris_plugin_class_init (RygelMPRISPluginClass * klass,
                               gpointer klass_data)
{
	rygel_mpris_plugin_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaRendererPluginClass *) klass)->get_player = (RygelMediaPlayer* (*) (RygelMediaRendererPlugin*)) rygel_mpris_plugin_real_get_player;
	G_OBJECT_CLASS (klass)->finalize = rygel_mpris_plugin_finalize;
}

static void
rygel_mpris_plugin_instance_init (RygelMPRISPlugin * self,
                                  gpointer klass)
{
}

static void
rygel_mpris_plugin_finalize (GObject * obj)
{
	RygelMPRISPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPlugin);
	_g_object_unref0 (self->actual_player);
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->protocols = (_vala_array_free (self->protocols, self->protocols_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_mpris_plugin_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_mpris_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mpris_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMPRISPlugin), 0, (GInstanceInitFunc) rygel_mpris_plugin_instance_init, NULL };
	GType rygel_mpris_plugin_type_id;
	rygel_mpris_plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, "RygelMPRISPlugin", &g_define_type_info, 0);
	return rygel_mpris_plugin_type_id;
}

GType
rygel_mpris_plugin_get_type (void)
{
	static volatile gsize rygel_mpris_plugin_type_id__once = 0;
	if (g_once_init_enter (&rygel_mpris_plugin_type_id__once)) {
		GType rygel_mpris_plugin_type_id;
		rygel_mpris_plugin_type_id = rygel_mpris_plugin_get_type_once ();
		g_once_init_leave (&rygel_mpris_plugin_type_id__once, rygel_mpris_plugin_type_id);
	}
	return rygel_mpris_plugin_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

