/* application.c generated by valac 0.56.3, the Vala compiler
 * generated from application.vala, do not modify */

/* SPDX-License-Identifier: LGPL-2.1-or-later*/
/**/

#include <gio/gio.h>
#include <glib-object.h>
#include "rygel-core.h"
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-unix.h>
#include <signal.h>
#include "config.h"
#include <glib/gi18n-lib.h>
#include <libgssdp/gssdp.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <locale.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define RYGEL_TYPE_APPLICATION (rygel_application_get_type ())
#define RYGEL_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_APPLICATION, RygelApplication))
#define RYGEL_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_APPLICATION, RygelApplicationClass))
#define RYGEL_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_APPLICATION))
#define RYGEL_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_APPLICATION))
#define RYGEL_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_APPLICATION, RygelApplicationClass))

typedef struct _RygelApplication RygelApplication;
typedef struct _RygelApplicationClass RygelApplicationClass;
typedef struct _RygelApplicationPrivate RygelApplicationPrivate;

#define RYGEL_TYPE_ACL (rygel_acl_get_type ())
#define RYGEL_ACL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ACL, RygelAcl))
#define RYGEL_ACL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ACL, RygelAclClass))
#define RYGEL_IS_ACL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ACL))
#define RYGEL_IS_ACL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ACL))
#define RYGEL_ACL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ACL, RygelAclClass))

typedef struct _RygelAcl RygelAcl;
typedef struct _RygelAclClass RygelAclClass;

#define RYGEL_TYPE_DBUS_SERVICE (rygel_dbus_service_get_type ())
#define RYGEL_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusService))
#define RYGEL_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))
#define RYGEL_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))

typedef struct _RygelDBusService RygelDBusService;
typedef struct _RygelDBusServiceClass RygelDBusServiceClass;
enum  {
	RYGEL_APPLICATION_0_PROPERTY,
	RYGEL_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* rygel_application_properties[RYGEL_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelApplicationCreateDeviceData RygelApplicationCreateDeviceData;

struct _RygelApplication {
	GApplication parent_instance;
	RygelApplicationPrivate * priv;
};

struct _RygelApplicationClass {
	GApplicationClass parent_class;
};

struct _RygelApplicationPrivate {
	RygelPluginLoader* plugin_loader;
	GUPnPContextManager* context_manager;
	GeeArrayList* factories;
	GeeArrayList* root_devices;
	RygelConfiguration* config;
	RygelLogHandler* log_handler;
	RygelAcl* acl;
	RygelDBusService* service;
	gboolean activation_pending;
};

struct _RygelApplicationCreateDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelApplication* self;
	RygelPlugin* plugin;
	RygelRootDeviceFactory* factory;
	RygelRootDevice* device;
	RygelRootDevice* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GError* _error_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_;
};

static gint RygelApplication_private_offset;
static gpointer rygel_application_parent_class = NULL;
static gint rygel_application_PLUGIN_TIMEOUT;
static gint rygel_application_PLUGIN_TIMEOUT = 5;

VALA_EXTERN GType rygel_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelApplication, g_object_unref)
VALA_EXTERN GType rygel_acl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelAcl, g_object_unref)
VALA_EXTERN GType rygel_dbus_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelDBusService, g_object_unref)
VALA_EXTERN guint rygel_dbus_service_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN RygelApplication* rygel_application_new (void);
VALA_EXTERN RygelApplication* rygel_application_construct (GType object_type);
static gboolean __lambda6_ (RygelApplication* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static gboolean __lambda7_ (RygelApplication* self);
static gboolean ___lambda7__gsource_func (gpointer self);
static gboolean __lambda8_ (RygelApplication* self);
static gboolean ___lambda8__gsource_func (gpointer self);
static gboolean rygel_application_real_dbus_register (GApplication* base,
                                               GDBusConnection* connection,
                                               const gchar* object_path,
                                               GError** error);
VALA_EXTERN RygelDBusService* rygel_dbus_service_new (RygelApplication* main);
VALA_EXTERN RygelDBusService* rygel_dbus_service_construct (GType object_type,
                                                RygelApplication* main);
VALA_EXTERN void rygel_dbus_service_publish (RygelDBusService* self,
                                 GDBusConnection* connection);
static gint rygel_application_real_handle_local_options (GApplication* base,
                                                  GVariantDict* options);
static gint rygel_application_real_command_line (GApplication* base,
                                          GApplicationCommandLine* command_line);
static void rygel_application_register_default_configurations (RygelApplication* self);
static void rygel_application_run_everything (RygelApplication* self);
VALA_EXTERN RygelAcl* rygel_acl_new (void);
VALA_EXTERN RygelAcl* rygel_acl_construct (GType object_type);
static void rygel_application_on_plugin_loaded (RygelApplication* self,
                                         RygelPluginLoader* plugin_loader,
                                         RygelPlugin* plugin);
static void _rygel_application_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender,
                                                                               RygelPlugin* plugin,
                                                                               gpointer self);
static GUPnPContextManager* rygel_application_create_context_manager (RygelApplication* self);
static gboolean __lambda10_ (RygelApplication* self);
static gboolean ___lambda10__gsource_func (gpointer self);
static void rygel_application_real_activate (GApplication* base);
static gboolean ____lambda9_ (RygelApplication* self);
static gboolean _____lambda9__gsource_func (gpointer self);
static void rygel_application_real_startup (GApplication* base);
static void rygel_application_real_shutdown (GApplication* base);
static gboolean rygel_application_real_name_lost (GApplication* base);
static void rygel_application_create_device (RygelApplication* self,
                                      RygelPlugin* plugin,
                                      RygelRootDeviceFactory* factory,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void rygel_application_create_device_finish (RygelApplication* self,
                                             GAsyncResult* _res_);
static void rygel_application_create_device_data_free (gpointer _data);
static gboolean rygel_application_create_device_co (RygelApplicationCreateDeviceData* _data_);
static gboolean _rygel_application_create_device_co_gsource_func (gpointer self);
static void rygel_application_on_plugin_active_notify (RygelApplication* self,
                                                GObject* obj,
                                                GParamSpec* spec);
static void _rygel_application_on_plugin_active_notify_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void rygel_application_on_context_available (RygelApplication* self,
                                             GUPnPContextManager* manager,
                                             GUPnPContext* context);
static void _rygel_application_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender,
                                                                                      GUPnPContext* context,
                                                                                      gpointer self);
static void rygel_application_on_context_unavailable (RygelApplication* self,
                                               GUPnPContextManager* manager,
                                               GUPnPContext* context);
static void _rygel_application_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender,
                                                                                          GUPnPContext* context,
                                                                                          gpointer self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gint rygel_application_main (gchar** args,
                             gint args_length1);
static void rygel_application_finalize (GObject * obj);
static GType rygel_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
rygel_application_get_instance_private (RygelApplication* self)
{
	return G_STRUCT_MEMBER_P (self, RygelApplication_private_offset);
}

static gboolean
__lambda6_ (RygelApplication* self)
{
	gboolean result;
	g_application_release ((GApplication*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((RygelApplication*) self);
	return result;
}

static gboolean
__lambda7_ (RygelApplication* self)
{
	gboolean result;
	g_application_release ((GApplication*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((RygelApplication*) self);
	return result;
}

static gboolean
__lambda8_ (RygelApplication* self)
{
	gboolean result;
	g_application_release ((GApplication*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((RygelApplication*) self);
	return result;
}

RygelApplication*
rygel_application_construct (GType object_type)
{
	RygelApplication * self = NULL;
	self = (RygelApplication*) g_object_new (object_type, "application-id", "org.gnome.Rygel", "flags", G_APPLICATION_HANDLES_COMMAND_LINE | G_APPLICATION_ALLOW_REPLACEMENT, NULL);
	g_application_add_main_option_entries ((GApplication*) self, RYGEL_CMDLINE_CONFIG_OPTIONS);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGINT, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGTERM, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGHUP, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
	return self;
}

RygelApplication*
rygel_application_new (void)
{
	return rygel_application_construct (RYGEL_TYPE_APPLICATION);
}

static gboolean
rygel_application_real_dbus_register (GApplication* base,
                                      GDBusConnection* connection,
                                      const gchar* object_path,
                                      GError** error)
{
	RygelApplication * self;
	gboolean _tmp0_ = FALSE;
	RygelDBusService* _tmp2_;
	RygelDBusService* _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelApplication*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	_tmp0_ = G_APPLICATION_CLASS (rygel_application_parent_class)->dbus_register (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication), connection, object_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = rygel_dbus_service_new (self);
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp2_;
	_tmp3_ = self->priv->service;
	rygel_dbus_service_publish (_tmp3_, connection);
	result = TRUE;
	return result;
}

static gint
rygel_application_real_handle_local_options (GApplication* base,
                                             GVariantDict* options)
{
	RygelApplication * self;
	gint count = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	gint result;
	self = (RygelApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp1_ = g_variant_dict_lookup (options, "version", "b", &_tmp0_, NULL);
	count = _tmp0_;
	if (_tmp1_) {
		g_print ("%s\n", PACKAGE_STRING);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static gint
rygel_application_real_command_line (GApplication* base,
                                     GApplicationCommandLine* command_line)
{
	RygelApplication * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	GVariantDict* _tmp2_;
	RygelCmdlineConfig* _tmp3_;
	RygelCmdlineConfig* _tmp4_;
	GVariantDict* _tmp5_;
	gint result;
	self = (RygelApplication*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (command_line);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	options = _tmp1_;
	_tmp2_ = options;
	if (g_variant_dict_contains (_tmp2_, "shutdown")) {
		g_application_release ((GApplication*) self);
		result = 0;
		_g_variant_dict_unref0 (options);
		return result;
	}
	_tmp3_ = rygel_cmdline_config_get_default ();
	_tmp4_ = _tmp3_;
	_tmp5_ = options;
	rygel_cmdline_config_set_options (_tmp4_, _tmp5_);
	_g_object_unref0 (_tmp4_);
	g_application_activate ((GApplication*) self);
	result = -1;
	_g_variant_dict_unref0 (options);
	return result;
}

static void
rygel_application_register_default_configurations (RygelApplication* self)
{
	RygelCmdlineConfig* cmdline_config = NULL;
	RygelCmdlineConfig* _tmp0_;
	RygelCmdlineConfig* _tmp1_;
	RygelEnvironmentConfig* _tmp2_;
	RygelEnvironmentConfig* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_cmdline_config_get_default ();
	cmdline_config = _tmp0_;
	_tmp1_ = cmdline_config;
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp1_);
	_tmp2_ = rygel_environment_config_get_default ();
	_tmp3_ = _tmp2_;
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		gchar* config_file = NULL;
		RygelCmdlineConfig* _tmp4_;
		gchar* _tmp5_;
		RygelUserConfig* user_config = NULL;
		const gchar* _tmp6_;
		RygelUserConfig* _tmp7_;
		RygelUserConfig* _tmp8_;
		_tmp4_ = cmdline_config;
		_tmp5_ = rygel_cmdline_config_get_config_file (_tmp4_, &_inner_error0_);
		config_file = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = config_file;
		_tmp7_ = rygel_user_config_new (_tmp6_, &_inner_error0_);
		user_config = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (config_file);
			goto __catch0_g_error;
		}
		_tmp8_ = user_config;
		rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp8_);
		_g_object_unref0 (user_config);
		_g_free0 (config_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		{
			RygelUserConfig* user_config = NULL;
			RygelUserConfig* _tmp9_;
			RygelUserConfig* _tmp10_;
			_tmp9_ = rygel_user_config_get_default (&_inner_error0_);
			user_config = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp10_ = user_config;
			rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp10_);
			_g_object_unref0 (user_config);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = err;
			_tmp12_ = _tmp11_->message;
			g_warning (_ ("Failed to load user configuration: %s"), _tmp12_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (cmdline_config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cmdline_config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (cmdline_config);
}

static void
_rygel_application_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender,
                                                                          RygelPlugin* plugin,
                                                                          gpointer self)
{
	rygel_application_on_plugin_loaded ((RygelApplication*) self, _sender, plugin);
}

static gboolean
__lambda10_ (RygelApplication* self)
{
	RygelPluginLoader* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	_tmp0_ = self->priv->plugin_loader;
	_tmp1_ = rygel_plugin_loader_list_plugins (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		g_warning (ngettext ("No plugins found in %d second; giving up…", "No plugins found in %d seconds; giving up…", (gulong) rygel_application_PLUGIN_TIMEOUT), rygel_application_PLUGIN_TIMEOUT);
		g_application_release ((GApplication*) self);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda10_ ((RygelApplication*) self);
	return result;
}

static void
rygel_application_run_everything (RygelApplication* self)
{
	RygelLogHandler* _tmp0_;
	RygelMetaConfig* _tmp1_;
	RygelPluginLoader* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	RygelAcl* _tmp5_;
	RygelPluginLoader* _tmp6_;
	GUPnPContextManager* _tmp7_;
	RygelPluginLoader* _tmp8_;
	gint timeout = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_application_register_default_configurations (self);
	_tmp0_ = rygel_log_handler_get_default ();
	_g_object_unref0 (self->priv->log_handler);
	self->priv->log_handler = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp1_;
	_tmp2_ = rygel_plugin_loader_new ();
	_g_object_unref0 (self->priv->plugin_loader);
	self->priv->plugin_loader = _tmp2_;
	_tmp3_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = _tmp3_;
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE_FACTORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->factories);
	self->priv->factories = _tmp4_;
	_tmp5_ = rygel_acl_new ();
	_g_object_unref0 (self->priv->acl);
	self->priv->acl = _tmp5_;
	_tmp6_ = self->priv->plugin_loader;
	g_signal_connect_object (_tmp6_, "plugin-available", (GCallback) _rygel_application_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
	_tmp7_ = rygel_application_create_context_manager (self);
	_g_object_unref0 (self->priv->context_manager);
	self->priv->context_manager = _tmp7_;
	_tmp8_ = self->priv->plugin_loader;
	rygel_recursive_module_loader_load_modules ((RygelRecursiveModuleLoader*) _tmp8_);
	self->priv->activation_pending = FALSE;
	timeout = rygel_application_PLUGIN_TIMEOUT;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp9_;
		gint _tmp10_ = 0;
		_tmp9_ = rygel_meta_config_get_default ();
		config = _tmp9_;
		_tmp10_ = rygel_configuration_get_int ((RygelConfiguration*) config, "plugin", "TIMEOUT", 0, G_MAXINT, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		timeout = _tmp10_;
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (timeout == 0) {
		g_debug ("application.vala:118: Plugin timeout disabled...");
		return;
	}
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) timeout, ___lambda10__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
____lambda9_ (RygelApplication* self)
{
	gboolean result;
	rygel_application_run_everything (self);
	result = FALSE;
	return result;
}

static gboolean
_____lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda9_ ((RygelApplication*) self);
	return result;
}

static void
rygel_application_real_activate (GApplication* base)
{
	RygelApplication * self;
	gboolean _tmp0_ = FALSE;
	GUPnPContextManager* _tmp1_;
	self = (RygelApplication*) base;
	G_APPLICATION_CLASS (rygel_application_parent_class)->activate (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
	_tmp1_ = self->priv->context_manager;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->activation_pending;
	}
	if (_tmp0_) {
		GApplicationFlags _tmp2_;
		GApplicationFlags _tmp3_;
		g_application_hold ((GApplication*) self);
		_tmp2_ = g_application_get_flags ((GApplication*) self);
		_tmp3_ = _tmp2_;
		if ((_tmp3_ & G_APPLICATION_REPLACE) == G_APPLICATION_REPLACE) {
			self->priv->activation_pending = TRUE;
			g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _____lambda9__gsource_func, g_object_ref (self), g_object_unref);
		} else {
			rygel_application_run_everything (self);
		}
	}
}

static void
rygel_application_real_startup (GApplication* base)
{
	RygelApplication * self;
	self = (RygelApplication*) base;
	G_APPLICATION_CLASS (rygel_application_parent_class)->startup (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
	g_message (_ ("Rygel v%s starting…"), PACKAGE_VERSION);
}

static void
rygel_application_real_shutdown (GApplication* base)
{
	RygelApplication * self;
	self = (RygelApplication*) base;
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = NULL;
	G_APPLICATION_CLASS (rygel_application_parent_class)->shutdown (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
}

static gboolean
rygel_application_real_name_lost (GApplication* base)
{
	RygelApplication * self;
	gboolean result;
	self = (RygelApplication*) base;
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = NULL;
	g_application_release ((GApplication*) self);
	result = TRUE;
	return result;
}

static void
rygel_application_on_plugin_loaded (RygelApplication* self,
                                    RygelPluginLoader* plugin_loader,
                                    RygelPlugin* plugin)
{
	GeeIterator* iterator = NULL;
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_loader != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = self->priv->factories;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iterator = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		gpointer _tmp4_;
		RygelRootDeviceFactory* _tmp5_;
		_tmp2_ = iterator;
		if (!gee_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iterator;
		_tmp4_ = gee_iterator_get (_tmp3_);
		_tmp5_ = (RygelRootDeviceFactory*) _tmp4_;
		rygel_application_create_device (self, plugin, _tmp5_, NULL, NULL);
		_g_object_unref0 (_tmp5_);
	}
	_g_object_unref0 (iterator);
}

static void
rygel_application_create_device_data_free (gpointer _data)
{
	RygelApplicationCreateDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->plugin);
	_g_object_unref0 (_data_->factory);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelApplicationCreateDeviceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_application_create_device (RygelApplication* self,
                                 RygelPlugin* plugin,
                                 RygelRootDeviceFactory* factory,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelApplicationCreateDeviceData* _data_;
	RygelApplication* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelRootDeviceFactory* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	g_return_if_fail (factory != NULL);
	_data_ = g_slice_new0 (RygelApplicationCreateDeviceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_application_create_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (plugin);
	_g_object_unref0 (_data_->plugin);
	_data_->plugin = _tmp1_;
	_tmp2_ = _g_object_ref0 (factory);
	_g_object_unref0 (_data_->factory);
	_data_->factory = _tmp2_;
	rygel_application_create_device_co (_data_);
}

static void
rygel_application_create_device_finish (RygelApplication* self,
                                        GAsyncResult* _res_)
{
	RygelApplicationCreateDeviceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_rygel_application_create_device_co_gsource_func (gpointer self)
{
	gboolean result;
	result = rygel_application_create_device_co (self);
	return result;
}

static void
_rygel_application_on_plugin_active_notify_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	rygel_application_on_plugin_active_notify ((RygelApplication*) self, _sender, pspec);
}

static gboolean
rygel_application_create_device_co (RygelApplicationCreateDeviceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_application_create_device_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	{
		_data_->_tmp0_ = rygel_root_device_factory_create (_data_->factory, _data_->plugin, &_data_->_inner_error0_);
		_data_->device = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = rygel_plugin_get_active (_data_->plugin);
		_data_->_tmp2_ = _data_->_tmp1_;
		gupnp_root_device_set_available ((GUPnPRootDevice*) _data_->device, _data_->_tmp2_);
		_data_->_tmp3_ = _data_->self->priv->root_devices;
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = _data_->self->priv->root_devices;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp4_, _data_->device);
			g_signal_connect_object ((GObject*) _data_->plugin, "notify::active", (GCallback) _rygel_application_on_plugin_active_notify_g_object_notify, _data_->self, 0);
		}
		_g_object_unref0 (_data_->device);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = rygel_plugin_get_name (_data_->plugin);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->_error_;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_warning (_ ("Failed to create RootDevice for %s. Reason: %s"), _data_->_tmp6_, _data_->_tmp8_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_application_on_plugin_active_notify (RygelApplication* self,
                                           GObject* obj,
                                           GParamSpec* spec)
{
	GeeArrayList* _tmp0_;
	RygelPlugin* plugin = NULL;
	RygelPlugin* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = self->priv->root_devices;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		return;
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (obj, RYGEL_TYPE_PLUGIN) ? ((RygelPlugin*) obj) : NULL);
	plugin = _tmp1_;
	{
		GeeArrayList* _device_list = NULL;
		GeeArrayList* _tmp2_;
		gint _device_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _device_index = 0;
		_tmp2_ = self->priv->root_devices;
		_device_list = _tmp2_;
		_tmp3_ = _device_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_device_size = _tmp5_;
		_device_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			RygelRootDevice* device = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			RygelRootDevice* _tmp10_;
			GUPnPResourceFactory* _tmp11_;
			GUPnPResourceFactory* _tmp12_;
			RygelPlugin* _tmp13_;
			_device_index = _device_index + 1;
			_tmp6_ = _device_index;
			_tmp7_ = _device_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _device_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _device_index);
			device = (RygelRootDevice*) _tmp9_;
			_tmp10_ = device;
			_tmp11_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = plugin;
			if (_tmp12_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gupnp_resource_factory_get_type (), GUPnPResourceFactory)) {
				RygelRootDevice* _tmp14_;
				RygelPlugin* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp14_ = device;
				_tmp15_ = plugin;
				_tmp16_ = rygel_plugin_get_active (_tmp15_);
				_tmp17_ = _tmp16_;
				gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp14_, _tmp17_);
			}
			_g_object_unref0 (device);
		}
	}
	_g_object_unref0 (plugin);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
_rygel_application_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender,
                                                                                 GUPnPContext* context,
                                                                                 gpointer self)
{
	rygel_application_on_context_available ((RygelApplication*) self, _sender, context);
}

static void
_rygel_application_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender,
                                                                                     GUPnPContext* context,
                                                                                     gpointer self)
{
	rygel_application_on_context_unavailable ((RygelApplication*) self, _sender, context);
}

static GUPnPContextManager*
rygel_application_create_context_manager (RygelApplication* self)
{
	gint port = 0;
	gboolean ipv6 = FALSE;
	GSocketFamily family = 0;
	GUPnPContextManager* manager = NULL;
	GUPnPContextManager* _tmp6_;
	GError* _inner_error0_ = NULL;
	GUPnPContextManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	port = 0;
	ipv6 = FALSE;
	{
		gint _tmp0_ = 0;
		RygelConfiguration* _tmp1_;
		_tmp1_ = self->priv->config;
		_tmp0_ = rygel_configuration_get_port (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		port = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gboolean _tmp2_ = FALSE;
		RygelConfiguration* _tmp3_;
		_tmp3_ = self->priv->config;
		_tmp2_ = rygel_configuration_get_bool (_tmp3_, "general", "ipv6", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		ipv6 = _tmp2_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		g_clear_error (&_inner_error0_);
		_tmp4_ = bool_to_string (ipv6);
		_tmp5_ = _tmp4_;
		g_debug ("application.vala:235: No ipv6 config key found, using default %s", _tmp5_);
		_g_free0 (_tmp5_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	family = G_SOCKET_FAMILY_INVALID;
	if (!ipv6) {
		family = G_SOCKET_FAMILY_IPV4;
	}
	_tmp6_ = gupnp_context_manager_create_full (GSSDP_UDA_VERSION_1_0, family, (guint) port);
	manager = _tmp6_;
	g_signal_connect_object (manager, "context-available", (GCallback) _rygel_application_on_context_available_gupnp_context_manager_context_available, self, 0);
	g_signal_connect_object (manager, "context-unavailable", (GCallback) _rygel_application_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
	result = manager;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
rygel_application_on_context_available (RygelApplication* self,
                                        GUPnPContextManager* manager,
                                        GUPnPContext* context)
{
	gchar** ifaces = NULL;
	gint ifaces_length1;
	gint _ifaces_size_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	RygelAcl* _tmp6_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	ifaces = NULL;
	ifaces_length1 = 0;
	_ifaces_size_ = ifaces_length1;
	_tmp0_ = gssdp_client_get_network ((GSSDPClient*) context);
	_tmp1_ = _tmp0_;
	_tmp2_ = gssdp_client_get_interface ((GSSDPClient*) context);
	_tmp3_ = _tmp2_;
	_tmp4_ = gssdp_client_get_host_ip ((GSSDPClient*) context);
	_tmp5_ = _tmp4_;
	g_debug ("application.vala:258: New network %s (%s) context available. IP: %s", _tmp1_, _tmp3_, _tmp5_);
	_tmp6_ = self->priv->acl;
	gupnp_context_set_acl (context, (GUPnPAcl*) _tmp6_);
	{
		gchar** _tmp7_ = NULL;
		RygelConfiguration* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp7__length1;
		gint __tmp7__size_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp8_ = self->priv->config;
		_tmp10_ = _tmp9_ = rygel_configuration_get_interfaces (_tmp8_, &_inner_error0_);
		_tmp7_ = _tmp10_;
		_tmp7__length1 = _vala_array_length (_tmp9_);
		__tmp7__size_ = _tmp7__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp7_;
		_tmp11__length1 = _tmp7__length1;
		_tmp7_ = NULL;
		_tmp7__length1 = 0;
		ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
		ifaces = _tmp11_;
		ifaces_length1 = _tmp11__length1;
		_ifaces_size_ = ifaces_length1;
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp15_ = ifaces;
	_tmp15__length1 = ifaces_length1;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		_tmp16_ = gssdp_client_get_interface ((GSSDPClient*) context);
		_tmp17_ = _tmp16_;
		_tmp18_ = ifaces;
		_tmp18__length1 = ifaces_length1;
		_tmp14_ = _vala_string_array_contains (_tmp18_, _tmp18__length1, _tmp17_);
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		_tmp19_ = gssdp_client_get_network ((GSSDPClient*) context);
		_tmp20_ = _tmp19_;
		_tmp21_ = ifaces;
		_tmp21__length1 = ifaces_length1;
		_tmp13_ = _vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_);
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		_tmp22_ = gssdp_client_get_host_ip ((GSSDPClient*) context);
		_tmp23_ = _tmp22_;
		_tmp24_ = ifaces;
		_tmp24__length1 = ifaces_length1;
		_tmp12_ = _vala_string_array_contains (_tmp24_, _tmp24__length1, _tmp23_);
	}
	if (_tmp12_) {
		{
			RygelRootDeviceFactory* factory = NULL;
			RygelRootDeviceFactory* _tmp25_;
			GeeArrayList* _tmp26_;
			RygelRootDeviceFactory* _tmp27_;
			GeeIterator* iterator = NULL;
			RygelPluginLoader* _tmp28_;
			GeeCollection* _tmp29_;
			GeeCollection* _tmp30_;
			GeeIterator* _tmp31_;
			GeeIterator* _tmp32_;
			_tmp25_ = rygel_root_device_factory_new (context, &_inner_error0_);
			factory = _tmp25_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp26_ = self->priv->factories;
			_tmp27_ = factory;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp27_);
			_tmp28_ = self->priv->plugin_loader;
			_tmp29_ = rygel_plugin_loader_list_plugins (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = gee_iterable_iterator ((GeeIterable*) _tmp30_);
			_tmp32_ = _tmp31_;
			_g_object_unref0 (_tmp30_);
			iterator = _tmp32_;
			while (TRUE) {
				GeeIterator* _tmp33_;
				GeeIterator* _tmp34_;
				gpointer _tmp35_;
				RygelPlugin* _tmp36_;
				RygelRootDeviceFactory* _tmp37_;
				_tmp33_ = iterator;
				if (!gee_iterator_next (_tmp33_)) {
					break;
				}
				_tmp34_ = iterator;
				_tmp35_ = gee_iterator_get (_tmp34_);
				_tmp36_ = (RygelPlugin*) _tmp35_;
				_tmp37_ = factory;
				rygel_application_create_device (self, _tmp36_, _tmp37_, NULL, NULL);
				_g_object_unref0 (_tmp36_);
			}
			_g_object_unref0 (iterator);
			_g_object_unref0 (factory);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp38_;
			const gchar* _tmp39_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp38_ = err;
			_tmp39_ = _tmp38_->message;
			g_warning (_ ("Failed to create root device factory: %s"), _tmp39_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		_tmp40_ = gssdp_client_get_network ((GSSDPClient*) context);
		_tmp41_ = _tmp40_;
		_tmp42_ = gssdp_client_get_interface ((GSSDPClient*) context);
		_tmp43_ = _tmp42_;
		g_debug ("application.vala:287: Ignoring network %s (%s) context.", _tmp41_, _tmp43_);
		g_object_set ((GSSDPClient*) context, "active", FALSE, NULL);
	}
	ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
}

static void
rygel_application_on_context_unavailable (RygelApplication* self,
                                          GUPnPContextManager* manager,
                                          GUPnPContext* context)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GeeIterator* factory_iter = NULL;
	GeeArrayList* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* device_iter = NULL;
	GeeArrayList* _tmp16_;
	GeeIterator* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = gssdp_client_get_network ((GSSDPClient*) context);
	_tmp1_ = _tmp0_;
	_tmp2_ = gssdp_client_get_interface ((GSSDPClient*) context);
	_tmp3_ = _tmp2_;
	_tmp4_ = gssdp_client_get_host_ip ((GSSDPClient*) context);
	_tmp5_ = _tmp4_;
	g_debug ("application.vala:296: Network %s (%s) context now unavailable. IP: %s", _tmp1_, _tmp3_, _tmp5_);
	_tmp6_ = self->priv->factories;
	_tmp7_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp6_);
	factory_iter = _tmp7_;
	while (TRUE) {
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		gpointer _tmp10_;
		RygelRootDeviceFactory* _tmp11_;
		GUPnPContext* _tmp12_;
		GUPnPContext* _tmp13_;
		gboolean _tmp14_;
		_tmp8_ = factory_iter;
		if (!gee_iterator_next (_tmp8_)) {
			break;
		}
		_tmp9_ = factory_iter;
		_tmp10_ = gee_iterator_get (_tmp9_);
		_tmp11_ = (RygelRootDeviceFactory*) _tmp10_;
		_tmp12_ = rygel_root_device_factory_get_context (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = context == _tmp13_;
		_g_object_unref0 (_tmp11_);
		if (_tmp14_) {
			GeeIterator* _tmp15_;
			_tmp15_ = factory_iter;
			gee_iterator_remove (_tmp15_);
		}
	}
	_tmp16_ = self->priv->root_devices;
	_tmp17_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp16_);
	device_iter = _tmp17_;
	while (TRUE) {
		GeeIterator* _tmp18_;
		GeeIterator* _tmp19_;
		gpointer _tmp20_;
		RygelRootDevice* _tmp21_;
		GUPnPContext* _tmp22_;
		GUPnPContext* _tmp23_;
		gboolean _tmp24_;
		_tmp18_ = device_iter;
		if (!gee_iterator_next (_tmp18_)) {
			break;
		}
		_tmp19_ = device_iter;
		_tmp20_ = gee_iterator_get (_tmp19_);
		_tmp21_ = (RygelRootDevice*) _tmp20_;
		_tmp22_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = context == _tmp23_;
		_g_object_unref0 (_tmp21_);
		if (_tmp24_) {
			GeeIterator* _tmp25_;
			_tmp25_ = device_iter;
			gee_iterator_remove (_tmp25_);
		}
	}
	_g_object_unref0 (device_iter);
	_g_object_unref0 (factory_iter);
}

static gint
rygel_application_main (gchar** args,
                        gint args_length1)
{
	RygelApplication* app = NULL;
	RygelApplication* _tmp0_;
	gint result;
	g_set_application_name (_ (PACKAGE_NAME));
	XInitThreads ();
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = rygel_application_new ();
	app = _tmp0_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return rygel_application_main (argv, argc);
}

static void
rygel_application_class_init (RygelApplicationClass * klass,
                              gpointer klass_data)
{
	rygel_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelApplication_private_offset);
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) rygel_application_real_dbus_register;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) rygel_application_real_handle_local_options;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) rygel_application_real_command_line;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) rygel_application_real_activate;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) rygel_application_real_startup;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) rygel_application_real_shutdown;
	((GApplicationClass *) klass)->name_lost = (gboolean (*) (GApplication*)) rygel_application_real_name_lost;
	G_OBJECT_CLASS (klass)->finalize = rygel_application_finalize;
}

static void
rygel_application_instance_init (RygelApplication * self,
                                 gpointer klass)
{
	self->priv = rygel_application_get_instance_private (self);
	self->priv->activation_pending = FALSE;
}

static void
rygel_application_finalize (GObject * obj)
{
	RygelApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_APPLICATION, RygelApplication);
	_g_object_unref0 (self->priv->plugin_loader);
	_g_object_unref0 (self->priv->context_manager);
	_g_object_unref0 (self->priv->factories);
	_g_object_unref0 (self->priv->root_devices);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->log_handler);
	_g_object_unref0 (self->priv->acl);
	_g_object_unref0 (self->priv->service);
	G_OBJECT_CLASS (rygel_application_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelApplication), 0, (GInstanceInitFunc) rygel_application_instance_init, NULL };
	GType rygel_application_type_id;
	rygel_application_type_id = g_type_register_static (g_application_get_type (), "RygelApplication", &g_define_type_info, 0);
	RygelApplication_private_offset = g_type_add_instance_private (rygel_application_type_id, sizeof (RygelApplicationPrivate));
	return rygel_application_type_id;
}

GType
rygel_application_get_type (void)
{
	static volatile gsize rygel_application_type_id__once = 0;
	if (g_once_init_enter (&rygel_application_type_id__once)) {
		GType rygel_application_type_id;
		rygel_application_type_id = rygel_application_get_type_once ();
		g_once_init_leave (&rygel_application_type_id__once, rygel_application_type_id);
	}
	return rygel_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

