/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;

public class Map
extends FreeColGameObject
implements Location {
    private static final Logger logger = Logger.getLogger(Map.class.getName());
    public static final String TAG = "map";
    public static final int POLAR_HEIGHT = 2;
    private int width = -1;
    private int height = -1;
    private Tile[][] tileArray;
    private List<Tile> tileList = new ArrayList<Tile>();
    private Layer layer;
    private int minimumLatitude = -90;
    private int maximumLatitude = 90;
    private float latitudePerRow;
    private final List<Region> regions = new ArrayList<Region>();
    private boolean traceSearch = false;
    private SearchHeuristic trivialSearchHeuristic = t -> 0;
    private static final String HEIGHT_TAG = "height";
    private static final String LAYER_TAG = "layer";
    private static final String MAXIMUM_LATITUDE_TAG = "maximumLatitude";
    private static final String MINIMUM_LATITUDE_TAG = "minimumLatitude";
    private static final String WIDTH_TAG = "width";

    public Map(Game game, int width, int height) {
        super(game);
        this.setTiles(width, height);
        this.setLayer(Layer.RESOURCES);
        this.calculateLatitudePerRow();
        this.initializeTraceSearch();
    }

    public Map(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this(game, xr.getAttribute(WIDTH_TAG, -1), xr.getAttribute(HEIGHT_TAG, -1));
        this.readFromXML(xr);
    }

    public Map(Game game, String id) {
        super(game, id);
        this.initializeTraceSearch();
    }

    private void initializeTraceSearch() {
        this.traceSearch = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.PATHS);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static boolean inBox(int x, int y, int width, int height) {
        return x >= 0 && x < width && y >= 0 && y < height;
    }

    public boolean isValid(int x, int y) {
        return Map.inBox(x, y, this.getWidth(), this.getHeight());
    }

    public boolean isValid(Position position) {
        return this.isValid(position.getX(), position.getY());
    }

    private String setTiles(int width, int height) {
        if (width <= 0 || height <= 0) {
            return "Bad map tile array size: (" + width + "," + height + ")";
        }
        this.width = width;
        this.height = height;
        this.tileArray = new Tile[width][height];
        this.tileList.clear();
        return null;
    }

    private String updateTiles(int width, int height) {
        if (this.width < 0 && this.height < 0) {
            return this.setTiles(width, height);
        }
        if (this.width != width || this.height != height) {
            return "Attempted map resize (" + this.width + "," + this.height + " -> " + width + "," + height + ")";
        }
        return null;
    }

    public Tile getTile(int x, int y) {
        if (!this.isValid(x, y)) {
            return null;
        }
        return this.tileArray[x][y];
    }

    public Tile getTile(Position p) {
        return this.getTile(p.getX(), p.getY());
    }

    private boolean setTile(Tile tile, int x, int y) {
        if (tile == null) {
            return false;
        }
        this.tileArray[x][y] = tile;
        this.tileList.add(tile);
        return true;
    }

    private boolean updateTile(Tile tile) {
        int y;
        if (tile == null) {
            return false;
        }
        int x = tile.getX();
        if (!this.isValid(x, y = tile.getY())) {
            return false;
        }
        Tile old = this.tileArray[x][y];
        if (old == null) {
            return this.setTile(tile, x, y);
        }
        old.copyIn(tile);
        return true;
    }

    public final Layer getLayer() {
        return this.layer;
    }

    public final void setLayer(Layer newLayer) {
        this.layer = newLayer;
    }

    public final int getMinimumLatitude() {
        return this.minimumLatitude;
    }

    public final void setMinimumLatitude(int newMinimumLatitude) {
        this.minimumLatitude = newMinimumLatitude;
        this.calculateLatitudePerRow();
    }

    public final int getMaximumLatitude() {
        return this.maximumLatitude;
    }

    public final void setMaximumLatitude(int newMaximumLatitude) {
        this.maximumLatitude = newMaximumLatitude;
        this.calculateLatitudePerRow();
    }

    public final float getLatitudePerRow() {
        return this.latitudePerRow;
    }

    private final void calculateLatitudePerRow() {
        this.latitudePerRow = 1.0f * (float)(this.maximumLatitude - this.minimumLatitude) / (float)(this.getHeight() - 1);
    }

    public int getLatitude(int row) {
        return this.minimumLatitude + (int)((float)row * this.latitudePerRow);
    }

    public int getRow(int latitude) {
        return (int)((float)(latitude - this.minimumLatitude) / this.latitudePerRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Region> getRegions() {
        List<Region> list = this.regions;
        synchronized (list) {
            return new ArrayList<Region>(this.regions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegion(Region region) {
        List<Region> list = this.regions;
        synchronized (list) {
            this.regions.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegions() {
        List<Region> list = this.regions;
        synchronized (list) {
            this.regions.clear();
        }
    }

    public java.util.Map<String, Region> getFixedRegions() {
        HashMap<String, Region> result = new HashMap<String, Region>();
        for (Region r : this.getRegions()) {
            String n = r.getKey();
            if (n == null) continue;
            result.put(n, r);
        }
        return result;
    }

    public Region getRegionByKey(String key) {
        return key == null ? null : CollectionUtils.find(this.getRegions(), CollectionUtils.matchKeyEquals(key, Region::getKey));
    }

    public Region getRegionByName(String name) {
        return name == null ? null : CollectionUtils.find(this.getRegions(), CollectionUtils.matchKeyEquals(name, Region::getName));
    }

    public static final boolean isSameLocation(Location l1, Location l2) {
        return l1 == null || l2 == null ? false : (l1 == l2 ? true : (l1.getTile() == null ? false : l1.getTile() == l2.getTile()));
    }

    public static final boolean isSameContiguity(Location l1, Location l2) {
        return l1 == null || l2 == null ? false : (l1 == l2 ? true : (l1.getTile() == null || l2.getTile() == null ? false : l1.getTile().isConnectedTo(l2.getTile())));
    }

    public boolean isPolar(Tile tile) {
        return tile.getY() <= 2 || tile.getY() >= this.getHeight() - 2 - 1;
    }

    public Direction getDirection(Tile t1, Tile t2) {
        return t1 == null || t2 == null ? null : new Position(t1).getDirection(new Position(t2));
    }

    public static Direction getRoughDirection(Tile src, Tile dst) {
        int x = dst.getX() - src.getX();
        int y = dst.getY() - src.getY();
        if (x == 0 && y == 0) {
            return null;
        }
        double theta = Math.atan2(y, x) + 1.5707963267948966 + 0.39269908169872414;
        if (theta < 0.0) {
            theta += Math.PI * 2;
        }
        return Direction.angleToDirection(theta);
    }

    public Tile getAdjacentTile(int x, int y, Direction direction) {
        return this.getTile(direction.step(x, y));
    }

    public Tile getAdjacentTile(Tile tile, Direction direction) {
        return this.getAdjacentTile(tile.getX(), tile.getY(), direction);
    }

    public int getDistance(Tile t1, Tile t2) {
        return Position.getXYDistance(t1.getX(), t1.getY(), t2.getX(), t2.getY());
    }

    public Tile getClosestTile(Tile tile, Collection<Tile> tiles) {
        return CollectionUtils.minimize(tiles, CollectionUtils.cachingIntComparator(t -> this.getDistance((Tile)t, tile)));
    }

    public Tile getRandomLandTile(Random random) {
        int SLOSH = 10;
        int x = 0;
        int y = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width >= 10) {
            width -= 10;
            x += 5;
        }
        if (height >= 10) {
            height -= 10;
            y += 5;
        }
        for (Tile t : this.getCircleTiles(this.getTile(x += RandomUtils.randomInt(logger, "W", random, width), y += RandomUtils.randomInt(logger, "H", random, height)), true, Integer.MAX_VALUE)) {
            if (!t.isLand()) continue;
            return t;
        }
        return null;
    }

    public Set<Tile> getTileSet(Predicate<Tile> predicate) {
        HashSet<Tile> ret = new HashSet<Tile>();
        for (Tile t : this.tileList) {
            if (!predicate.test(t)) continue;
            ret.add(t);
        }
        return ret;
    }

    public List<Tile> getTileList(Predicate<Tile> predicate) {
        ArrayList<Tile> ret = new ArrayList<Tile>();
        for (Tile t : this.tileList) {
            if (!predicate.test(t)) continue;
            ret.add(t);
        }
        return ret;
    }

    public void forEachTile(Consumer<Tile> consumer) {
        for (Tile t : this.tileList) {
            consumer.accept(t);
        }
    }

    public void forEachTile(Predicate<Tile> predicate, Consumer<Tile> consumer) {
        for (Tile t : this.tileList) {
            if (!predicate.test(t)) continue;
            consumer.accept(t);
        }
    }

    public boolean populateTiles(BiFunction<Integer, Integer, Tile> func) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.setTile(func.apply(x, y), x, y)) continue;
                return false;
            }
        }
        return true;
    }

    public void forSubMap(int x, int y, int w, int h, Consumer<Tile> consumer) {
        for (Tile t : this.subMap(x, y, w, h)) {
            consumer.accept(t);
        }
    }

    public List<Tile> subMap(int x, int y, int w, int h) {
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (y < 0) {
            h += y;
            y = 0;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (w <= 0 || h <= 0 || x > width || y > height) {
            return Collections.emptyList();
        }
        if (x + w > width) {
            w = width - x;
        }
        if (y + h > height) {
            h = height - y;
        }
        ArrayList<Tile> ret = new ArrayList<Tile>();
        for (int yi = y; yi < y + h; ++yi) {
            for (int xi = x; xi < x + w; ++xi) {
                ret.add(this.getTile(xi, yi));
            }
        }
        return ret;
    }

    public List<Tile> getShuffledTiles(Random random) {
        ArrayList<Tile> ret = new ArrayList<Tile>(this.tileList);
        RandomUtils.randomShuffle(logger, "All tile shuffle", ret, random);
        return ret;
    }

    public Iterator<Tile> getCircleIterator(Tile center, boolean isFilled, int radius) {
        return new CircleIterator(center, isFilled, radius);
    }

    public Iterable<Tile> getCircleTiles(final Tile center, final boolean isFilled, final int radius) {
        return new Iterable<Tile>(){

            @Override
            public Iterator<Tile> iterator() {
                return Map.this.getCircleIterator(center, isFilled, radius);
            }
        };
    }

    private SearchHeuristic getManhattenHeuristic(Tile endTile) {
        return tile -> tile.getDistanceTo(endTile);
    }

    private Location findRealEnd(Unit unit, Location end) {
        while (true) {
            if (end == null) {
                throw new RuntimeException("Null end for: " + unit);
            }
            if (end instanceof Europe) {
                return end;
            }
            if (!(end instanceof Map)) break;
            end = unit.getFullEntryLocation();
        }
        if (end.getTile() != null) {
            return end.getTile();
        }
        if (unit != null) {
            return unit.resolveDestination();
        }
        throw new RuntimeException("Invalid end: " + end);
    }

    private PathNode getBestEntryPath(Unit unit, Tile tile, Unit carrier, CostDecider costDecider) {
        if (costDecider == null) {
            costDecider = CostDeciders.avoidSettlementsAndBlockingUnits();
        }
        return this.searchMap(unit, tile, GoalDeciders.getHighSeasGoalDecider(), costDecider, Integer.MAX_VALUE, carrier, null, null);
    }

    public Tile getBestEntryTile(Unit unit, Tile tile, Unit carrier, CostDecider costDecider) {
        PathNode path = this.getBestEntryPath(unit, tile, carrier, costDecider);
        return path == null ? null : path.getLastNode().getTile();
    }

    private PathNode findMapPath(Unit unit, Tile start, Tile end, Unit carrier, CostDecider costDecider, LogBuilder lb) {
        Unit embarkTo;
        Unit endUnit;
        PathNode path;
        Unit offMapUnit = carrier != null ? carrier : (unit != null && unit.isNaval() ? unit : null);
        GoalDecider gd = GoalDeciders.getLocationGoalDecider(end);
        SearchHeuristic sh = this.getManhattenHeuristic(end);
        if (start.getContiguity() == end.getContiguity()) {
            PathNode carrierPath;
            path = this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, null, sh, lb);
            PathNode pathNode = carrierPath = carrier == null ? null : this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, carrier, sh, lb);
            if (carrierPath != null && (path == null || path.getLastNode().getCost() > carrierPath.getLastNode().getCost())) {
                path = carrierPath;
            }
        } else if (offMapUnit != null) {
            path = this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, carrier, sh, lb);
        } else if (unit != null && unit.isOnCarrier() && !start.isLand() && end.isLand() && !start.getContiguityAdjacent(end.getContiguity()).isEmpty()) {
            path = this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, carrier, sh, lb);
        } else if (start.isLand() && !end.isLand() && (endUnit = end.getFirstUnit()) != null && unit != null && unit.getOwner().owns(endUnit) && !end.getContiguityAdjacent(start.getContiguity()).isEmpty() && (embarkTo = end.getCarrierForUnit(unit)) != null) {
            path = this.searchMap(unit, start, GoalDeciders.getAdjacentLocationGoalDecider(end), costDecider, Integer.MAX_VALUE, null, null, lb);
            if (path != null) {
                PathNode last = path.getLastNode();
                last.next = new PathNode(embarkTo, 0, last.getTurns() + 1, true, last, null);
            }
        } else {
            path = null;
        }
        return path;
    }

    private void finishPath(PathNode path, Unit unit, LogBuilder lb) {
        if (path != null) {
            int initialTurns;
            int n = !unit.isAtSea() ? 0 : (initialTurns = (unit.isOnCarrier() ? unit.getCarrier() : unit).getWorkLeft());
            if (initialTurns != 0) {
                path.addTurns(initialTurns);
            }
            if (lb != null) {
                lb.add("\nSuccess\n", path.fullPathToString());
            }
        }
        if (lb != null) {
            lb.log(logger, Level.INFO);
        }
    }

    public PathNode findPath(Unit unit, Location start, Location end, Unit carrier, CostDecider costDecider, LogBuilder lb) {
        PathNode path;
        Unit offMapUnit;
        Location realEnd;
        if (this.traceSearch) {
            lb = new LogBuilder(1024);
        }
        try {
            realEnd = this.findRealEnd(unit, end);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Path fail: " + unit + " from " + start + " to " + end + " with " + carrier, iae);
        }
        Unit unit2 = offMapUnit = carrier != null ? carrier : unit;
        if (realEnd instanceof Tile && !((Tile)realEnd).isExplored()) {
            Tile closest = start instanceof Tile ? this.getClosestTile((Tile)start, CollectionUtils.transform(((Tile)realEnd).getSurroundingTiles(1, 1), t -> t.isExplored() && Map.isSameContiguity(t, start))) : null;
            PathNode pathNode = path = closest == null ? null : this.findPath(unit, start, closest, carrier, costDecider, lb);
            if (path != null) {
                PathNode last = path.getLastNode();
                last.next = new PathNode((Tile)realEnd, 0, last.getTurns() + 1, last.isOnCarrier(), last, null);
            }
        } else if (start instanceof Europe && realEnd instanceof Europe) {
            path = new PathNode(start, unit.getMovesLeft(), 0, false, null, null);
        } else if (start instanceof Europe && realEnd instanceof Tile) {
            if (offMapUnit == null || !offMapUnit.getType().canMoveToHighSeas()) {
                path = null;
            } else {
                PathNode p = this.getBestEntryPath(unit, (Tile)realEnd, carrier, costDecider);
                if (p == null) {
                    path = null;
                } else {
                    Tile tile = p.getLastNode().getTile();
                    path = this.findMapPath(unit, tile, (Tile)realEnd, carrier, costDecider, lb);
                    if (path == null) {
                        if (!((Tile)realEnd).isOnRiver()) {
                            LogBuilder l2 = new LogBuilder(512);
                            l2.add("Fail in findPath(", unit, ", ", tile, ", ", realEnd, ", ", carrier, ")\n");
                            l2.addStackTrace();
                            l2.add(p.fullPathToString());
                            this.findMapPath(unit, tile, (Tile)realEnd, carrier, costDecider, l2);
                            l2.log(logger, Level.WARNING);
                        }
                        path = null;
                    } else {
                        path.addTurns(offMapUnit.getSailTurns());
                        path = path.previous = new PathNode(start, unit.getMovesLeft(), 0, carrier != null, null, path);
                        if (carrier != null && unit.getLocation() != carrier) {
                            path = path.previous = new PathNode(start, unit.getMovesLeft(), 0, false, null, path);
                        }
                    }
                }
            }
        } else if (start instanceof Tile && realEnd instanceof Europe) {
            if (offMapUnit == null || !offMapUnit.getType().canMoveToHighSeas()) {
                path = null;
            } else {
                PathNode p = this.searchMap(unit, (Tile)start, GoalDeciders.getHighSeasGoalDecider(), costDecider, Integer.MAX_VALUE, carrier, null, lb);
                if (p == null) {
                    path = null;
                } else {
                    PathNode last = p.getLastNode();
                    last.next = new PathNode(realEnd, unit.getInitialMovesLeft(), last.getTurns() + offMapUnit.getSailTurns(), last.isOnCarrier(), last, null);
                    path = p;
                }
            }
        } else if (start instanceof Tile && realEnd instanceof Tile) {
            Unit.MoveType mt;
            Direction d;
            if (unit != null && (d = ((Tile)start).getDirection((Tile)realEnd)) != null && (mt = unit.getMoveType(d)).isLegal() && !mt.isProgress()) {
                path = new PathNode(start, unit.getMovesLeft(), 0, carrier != null, null, null);
                int cost = unit.getMoveCost((Tile)start, (Tile)realEnd, unit.getMovesLeft());
                path.next = new PathNode(realEnd, unit.getMovesLeft() - cost, 0, false, path, null);
            } else {
                path = this.findMapPath(unit, (Tile)start, (Tile)realEnd, carrier, costDecider, lb);
            }
        } else {
            throw new IllegalStateException("Can not happen: " + start + ", " + realEnd);
        }
        this.finishPath(path, unit, lb);
        return path;
    }

    public PathNode search(Unit unit, Location start, GoalDecider goalDecider, CostDecider costDecider, int maxTurns, Unit carrier, LogBuilder lb) {
        PathNode p;
        Unit offMapUnit;
        if (this.traceSearch) {
            lb = new LogBuilder(1024);
        }
        Unit unit2 = offMapUnit = carrier != null ? carrier : unit;
        Object path = start instanceof Europe ? (offMapUnit == null || !offMapUnit.getType().canMoveToHighSeas() ? null : ((p = this.searchMap(unit, offMapUnit.getFullEntryLocation(), goalDecider, costDecider, maxTurns, carrier, null, lb)) == null ? null : this.findPath(unit, start, p.getLastNode().getTile(), carrier, costDecider, lb))) : this.searchMap(unit, start.getTile(), goalDecider, costDecider, maxTurns, carrier, null, lb);
        this.finishPath((PathNode)path, unit, lb);
        return path;
    }

    public boolean getSearchTrace() {
        return this.traceSearch;
    }

    public boolean setSearchTrace(boolean trace) {
        boolean ret = this.traceSearch;
        this.traceSearch = trace;
        return ret;
    }

    private boolean usedCarrier(PathNode path) {
        while (path != null) {
            if (path.isOnCarrier()) {
                return true;
            }
            path = path.previous;
        }
        return false;
    }

    private PathNode searchMap(Unit unit, Tile start, GoalDecider goalDecider, CostDecider costDecider, int maxTurns, Unit carrier, SearchHeuristic searchHeuristic, LogBuilder lb) {
        Unit currentUnit;
        Unit offMapUnit;
        HashMap<String, PathNode> openMap = new HashMap<String, PathNode>();
        HashMap<String, PathNode> closedMap = new HashMap<String, PathNode>();
        HashMap<String, Integer> f = new HashMap<String, Integer>();
        PriorityQueue<PathNode> openMapQueue = new PriorityQueue<PathNode>(1024, Comparator.comparingInt(p -> (Integer)f.get(p.getLocation().getId())));
        SearchHeuristic sh = searchHeuristic == null ? this.trivialSearchHeuristic : searchHeuristic;
        Unit unit2 = offMapUnit = carrier != null ? carrier : unit;
        Unit unit3 = start.isLand() ? (unit != null && unit.getLocation() == carrier && start.hasSettlement() && start.getSettlement().isConnectedPort() ? carrier : unit) : (currentUnit = offMapUnit);
        if (lb != null) {
            lb.add("Search trace(unit=", unit, ", from=", start, ", max=", maxTurns == Integer.MAX_VALUE ? "-" : Integer.toString(maxTurns), ", carrier=", carrier, ")", "\n", FreeColDebugger.stackTraceToString());
        }
        PathNode firstNode = new PathNode(start, currentUnit != null ? currentUnit.getMovesLeft() : -1, 0, carrier != null && currentUnit == carrier, null, null);
        f.put(start.getId(), sh.getValue(start));
        openMap.put(start.getId(), firstNode);
        openMapQueue.offer(firstNode);
        PathNode best = null;
        int bestScore = Integer.MAX_VALUE;
        block11: while (!openMap.isEmpty()) {
            PathNode currentNode = openMapQueue.poll();
            Location currentLocation = currentNode.getLocation();
            openMap.remove(currentLocation.getId());
            if (lb != null) {
                lb.add("\n  ", currentNode);
            }
            Unit unit4 = currentUnit = currentNode.isOnCarrier() ? carrier : unit;
            if (goalDecider.check(currentUnit, currentNode)) {
                if (lb != null) {
                    lb.add(" ***goal(", currentNode.getCost(), ")***");
                }
                if ((best = goalDecider.getGoal()) == null || !goalDecider.hasSubGoals()) break;
                bestScore = best.getCost();
                continue;
            }
            closedMap.put(currentLocation.getId(), currentNode);
            if (lb != null) {
                lb.add(" closing");
            }
            if (bestScore < currentNode.getCost()) {
                if (lb == null) continue;
                lb.add("...goal cost wins(", bestScore, " < ", currentNode.getCost(), ")...");
                continue;
            }
            if (currentNode.getTurns() > maxTurns) {
                if (lb == null) continue;
                lb.add("...out-of-range");
                continue;
            }
            int currentMovesLeft = currentNode.getMovesLeft();
            int currentTurns = currentNode.getTurns();
            boolean currentOnCarrier = currentNode.isOnCarrier();
            Tile currentTile = currentNode.getTile();
            if (currentTile == null) {
                if (lb == null) continue;
                lb.add("...skip Europe");
                continue;
            }
            block12: for (Tile moveTile : currentTile.getSurroundingTiles(1)) {
                Object stepLog;
                MoveCandidate move;
                boolean isGoal;
                boolean carrierMove;
                int cc;
                if (lb != null) {
                    lb.add("\n    ", moveTile);
                }
                if (currentNode.previous != null && currentNode.previous.getTile() == moveTile) {
                    if (lb == null) continue;
                    lb.add(" !prev");
                    continue;
                }
                PathNode closed = (PathNode)closedMap.get(moveTile.getId());
                if (closed != null && (cc = closed.getCost()) <= currentNode.getCost()) {
                    if (lb == null) continue;
                    lb.add(" !worse ", cc);
                    continue;
                }
                Unit.MoveType umt = unit.getSimpleMoveType(currentTile, moveTile);
                boolean unitMove = umt.isProgress();
                boolean bl = carrierMove = carrier != null && carrier.getSimpleMoveType(carrier.getTile(), moveTile).isProgress();
                if (lb != null) {
                    lb.add(" ", unitMove ? "U" : (carrierMove ? "C" : ""));
                }
                if (isGoal = goalDecider.check(unit, new PathNode(moveTile, 0, 0x3FFFFFFF, false, currentNode, null))) {
                    if (lb != null) {
                        lb.add(new Object[]{" *goal*", umt});
                    }
                    if (unitMove) {
                        if (moveTile.hasSettlement() && currentOnCarrier && carrierMove) {
                            move = new MoveCandidate(carrier, currentNode, moveTile, currentMovesLeft, currentTurns, true, CostDeciders.tileCost());
                        } else {
                            int left = currentOnCarrier ? (currentNode.embarkedThisTurn(currentTurns) ? 0 : unit.getInitialMovesLeft()) : currentMovesLeft;
                            move = new MoveCandidate(unit, currentNode, moveTile, left, currentTurns, false, CostDeciders.tileCost());
                        }
                    } else {
                        switch (umt) {
                            case ATTACK_UNIT: 
                            case ATTACK_SETTLEMENT: 
                            case ENTER_FOREIGN_COLONY_WITH_SCOUT: 
                            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: 
                            case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: 
                            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: 
                            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                                move = new MoveCandidate(unit, currentNode, moveTile, currentMovesLeft, currentTurns, false, CostDeciders.tileCost());
                                unitMove = true;
                                break;
                            }
                            case EMBARK: {
                                move = new MoveCandidate(unit, currentNode, moveTile, currentMovesLeft, currentTurns, true, CostDeciders.tileCost());
                                unitMove = true;
                                break;
                            }
                            case MOVE_NO_ATTACK_CIVILIAN: {
                                if (moveTile.hasSettlement()) {
                                    if (lb != null) {
                                        lb.add(" !FAIL-SETTLEMENT");
                                    }
                                    if (goalDecider.hasSubGoals()) continue block12;
                                    break block11;
                                }
                                if (currentNode.getTurns() <= 0 || moveTile.getAvailableAdjacentCount() < 3) {
                                    if (lb != null) {
                                        lb.add(" !FAIL-ATTACK");
                                    }
                                    if (goalDecider.hasSubGoals()) continue block12;
                                    break block11;
                                }
                                if (lb != null) {
                                    lb.add(" blocked");
                                }
                                unitMove = true;
                                move = new MoveCandidate(unit, currentNode, moveTile, currentMovesLeft, currentTurns, false, CostDeciders.tileCost());
                                break;
                            }
                            default: {
                                if (lb == null) continue block12;
                                lb.add(new Object[]{" !FAIL-", umt});
                                continue block12;
                            }
                        }
                    }
                    assert (move != null);
                    stepLog = "@";
                } else {
                    MoveStep step = currentOnCarrier ? (carrierMove ? MoveStep.BYWATER : (unitMove ? MoveStep.DISEMBARK : MoveStep.FAIL)) : (carrierMove && !this.usedCarrier(currentNode) ? MoveStep.EMBARK : (unitMove ? (unit.isNaval() ? MoveStep.BYWATER : MoveStep.BYLAND) : MoveStep.FAIL));
                    switch (step) {
                        case BYLAND: {
                            move = new MoveCandidate(unit, currentNode, moveTile, currentMovesLeft, currentTurns, false, costDecider);
                            break;
                        }
                        case BYWATER: {
                            move = new MoveCandidate(offMapUnit, currentNode, moveTile, currentMovesLeft, currentTurns, currentOnCarrier, costDecider);
                            break;
                        }
                        case EMBARK: {
                            move = new MoveCandidate(offMapUnit, currentNode, moveTile, currentMovesLeft, currentTurns, true, costDecider);
                            move.embarkUnit(carrier);
                            break;
                        }
                        case DISEMBARK: {
                            move = new MoveCandidate(unit, currentNode, moveTile, 0, currentTurns, false, costDecider);
                            break;
                        }
                        default: {
                            if (lb == null) continue block12;
                            lb.add("!");
                            continue block12;
                        }
                    }
                    stepLog = " " + step + "_";
                }
                assert (move.getCost() >= 0);
                if (closed != null) {
                    if (move.canImprove(closed)) {
                        closedMap.remove(moveTile.getId());
                        move.improve(openMap, openMapQueue, f, sh);
                        stepLog = (String)stepLog + "^" + Integer.toString(move.getCost());
                    } else {
                        stepLog = (String)stepLog + "v";
                    }
                } else if (move.canImprove((PathNode)openMap.get(moveTile.getId()))) {
                    move.improve(openMap, openMapQueue, f, sh);
                    stepLog = (String)stepLog + "+" + Integer.toString(move.getCost());
                } else {
                    stepLog = (String)stepLog + "-";
                }
                if (lb == null) continue;
                lb.add(stepLog);
            }
        }
        if ((best = goalDecider.getGoal()) != null) {
            while (best.previous != null) {
                best.previous.next = best;
                best = best.previous;
            }
        }
        return best;
    }

    public Tile searchCircle(Tile start, GoalDecider goalDecider, int radius) {
        Tile t;
        PathNode path;
        if (start == null || goalDecider == null || radius <= 0) {
            return null;
        }
        Iterator<Tile> iterator = this.getCircleTiles(start, true, radius).iterator();
        while (iterator.hasNext() && (!goalDecider.check(null, path = new PathNode(t = iterator.next(), 0, start.getDistanceTo(t), false, null, null)) || goalDecider.hasSubGoals())) {
        }
        PathNode best = goalDecider.getGoal();
        return best == null ? null : best.getTile();
    }

    public Tile getLandWithinDistance(int x, int y, int distance) {
        for (Tile t : this.getCircleTiles(this.getTile(x, y), true, distance)) {
            if (!t.isLand()) continue;
            return t;
        }
        return null;
    }

    public static boolean[][] floodFillBool(boolean[][] boolmap, int x, int y) {
        return Map.floodFillBool(boolmap, x, y, Integer.MAX_VALUE);
    }

    public static boolean[][] floodFillBool(boolean[][] boolmap, int x, int y, int limit) {
        int xmax = boolmap.length;
        int ymax = boolmap[0].length;
        boolean[][] visited = new boolean[xmax][ymax];
        LinkedList<Position> q = new LinkedList<Position>();
        visited[x][y] = true;
        Position p = new Position(x, y);
        while (p != null && --limit > 0) {
            for (Direction d : Direction.values()) {
                int ny;
                int nx;
                Position np = new Position(p, d);
                if (!np.isValid(xmax, ymax) || !boolmap[nx = np.getX()][ny = np.getY()] || visited[nx][ny]) continue;
                visited[nx][ny] = true;
                q.add(np);
            }
            p = (Position)q.poll();
        }
        return visited;
    }

    public void resetContiguity() {
        int xmax = this.getWidth();
        int ymax = this.getHeight();
        boolean[][] waterMap = new boolean[xmax][ymax];
        for (int y = 0; y < ymax; ++y) {
            for (int x = 0; x < xmax; ++x) {
                if (!this.isValid(x, y)) continue;
                waterMap[x][y] = !this.getTile(x, y).isLand();
                Tile tile = this.getTile(x, y);
                tile.setContiguity(-1);
            }
        }
        int contig = 0;
        this.floodFill(contig, ymax, xmax, waterMap);
        for (int y = 0; y < ymax; ++y) {
            for (int x = 0; x < xmax; ++x) {
                if (!this.isValid(x, y)) continue;
                waterMap[x][y] = !waterMap[x][y];
            }
        }
        this.floodFill(contig, ymax, xmax, waterMap);
    }

    private void floodFill(int contig, int ymax, int xmax, boolean[][] waterMap) {
        for (int y = 0; y < ymax; ++y) {
            for (int x = 0; x < xmax; ++x) {
                Tile tile;
                if (!waterMap[x][y] || (tile = this.getTile(x, y)).getContiguity() >= 0) continue;
                boolean[][] found = Map.floodFillBool(waterMap, x, y);
                for (int yy = 0; yy < ymax; ++yy) {
                    for (int xx = 0; xx < xmax; ++xx) {
                        Tile t;
                        if (!found[xx][yy] || (t = this.getTile(xx, yy)).getContiguity() >= 0) continue;
                        t.setContiguity(contig);
                    }
                }
                ++contig;
            }
        }
    }

    public void collectStartingTiles(List<Tile> eastTiles, List<Tile> westTiles) {
        boolean west = false;
        int east = this.getWidth() - 1;
        eastTiles.clear();
        westTiles.clear();
        for (int y = 0; y < this.getHeight(); ++y) {
            Tile t;
            int x;
            Tile ok = this.getTile(east, y);
            if (ok.isDirectlyHighSeasConnected()) {
                for (x = east; x > 0 && (t = this.getTile(x, y)).isDirectlyHighSeasConnected(); --x) {
                    ok = t;
                }
                if (ok != null) {
                    eastTiles.add(ok);
                }
            }
            if (!(ok = this.getTile(0, y)).isDirectlyHighSeasConnected()) continue;
            for (x = 0; x < east && (t = this.getTile(x, y)).isDirectlyHighSeasConnected(); ++x) {
                ok = t;
            }
            if (ok == null) continue;
            westTiles.add(ok);
        }
    }

    public void resetHighSeas(int distToLandFromHighSeas, int maxDistanceToEdge) {
        Specification spec = this.getSpecification();
        TileType ocean = spec.getTileType("model.tile.ocean");
        TileType highSeas = spec.getTileType("model.tile.highSeas");
        if (highSeas == null) {
            throw new RuntimeException("HighSeas TileType must exist: " + spec);
        }
        if (ocean == null) {
            throw new RuntimeException("Ocean TileType must exist: " + spec);
        }
        if (distToLandFromHighSeas < 0) {
            throw new RuntimeException("Land<->HighSeas distance can not be negative: " + distToLandFromHighSeas);
        }
        if (maxDistanceToEdge < 0) {
            throw new RuntimeException("Distance to edge can not be negative: " + maxDistanceToEdge);
        }
        this.forEachTile(t -> t.getType() == highSeas, t -> t.setType(ocean));
        int width = this.getWidth();
        int height = this.getHeight();
        Tile seaL = null;
        Tile seaR = null;
        int totalL = 0;
        int totalR = 0;
        int distanceL = -1;
        int distanceR = -1;
        for (int y = 0; y < height; ++y) {
            int distance;
            Tile other;
            Tile t2;
            int x;
            for (x = 0; x < maxDistanceToEdge && x < width && this.isValid(x, y) && (t2 = this.getTile(x, y)).getType() == ocean; ++x) {
                other = this.getLandWithinDistance(x, y, distToLandFromHighSeas);
                if (other == null) {
                    t2.setType(highSeas);
                    ++totalL;
                    continue;
                }
                distance = t2.getDistanceTo(other);
                if (distanceL >= distance) continue;
                distanceL = distance;
                seaL = t2;
            }
            for (x = 0; x < maxDistanceToEdge && x < width && this.isValid(width - 1 - x, y) && (t2 = this.getTile(width - 1 - x, y)).getType() == ocean; ++x) {
                other = this.getLandWithinDistance(width - 1 - x, y, distToLandFromHighSeas);
                if (other == null) {
                    t2.setType(highSeas);
                    ++totalR;
                    continue;
                }
                distance = t2.getDistanceTo(other);
                if (distanceR >= distance) continue;
                distanceR = distance;
                seaR = t2;
            }
        }
        if (totalL <= 0 && seaL != null) {
            seaL.setType(highSeas);
            ++totalL;
        }
        if (totalR <= 0 && seaR != null) {
            seaR.setType(highSeas);
            ++totalR;
        }
        if (totalL <= 0 || totalR <= 0) {
            logger.warning("No high seas on " + (totalL <= 0 && totalR <= 0 ? "either" : (totalL <= 0 ? "left" : (totalR <= 0 ? "right" : "BOGUS"))) + " side of the map.  This can cause failures on small test maps.");
        }
    }

    public void resetHighSeasCount() {
        ArrayList curr = new ArrayList();
        ArrayList<Tile> next = new ArrayList<Tile>();
        int hsc = 0;
        for (Tile t : this.tileList) {
            t.setHighSeasCount(-1);
            if (t.isLand()) continue;
            if ((t.getX() == 0 || t.getX() == this.getWidth() - 1) && t.getType() != null && t.getType().isHighSeasConnected() && !t.getType().isDirectlyHighSeasConnected() && t.getMoveToEurope() == null) {
                t.setMoveToEurope(Boolean.TRUE);
            }
            if (!t.isDirectlyHighSeasConnected()) continue;
            t.setHighSeasCount(0);
            next.add(t);
        }
        while (!next.isEmpty()) {
            ++hsc;
            curr.addAll(next);
            next.clear();
            while (!curr.isEmpty()) {
                Tile tile = (Tile)curr.remove(0);
                Position position = new Position(tile.getX(), tile.getY());
                for (Position p : CollectionUtils.transform(Direction.values(), CollectionUtils.alwaysTrue(), d -> new Position(position, (Direction)d))) {
                    Tile t;
                    if (!this.isValid(p) || (t = this.getTile(p)).getHighSeasCount() >= 0) continue;
                    t.setHighSeasCount(hsc);
                    if (t.isLand()) continue;
                    next.add(t);
                }
            }
        }
    }

    public void resetLayers() {
        boolean regions = false;
        boolean rivers = false;
        boolean lostCityRumours = false;
        boolean resources = false;
        boolean nativeSettlements = false;
        int hgt = this.getHeight();
        int wid = this.getWidth();
        for (int y = 0; y < hgt; ++y) {
            for (int x = 0; x < wid; ++x) {
                Tile t = this.getTile(x, y);
                regions |= t.getRegion() != null;
                rivers |= t.hasRiver();
                lostCityRumours |= t.hasLostCityRumour();
                resources |= t.hasResource();
                nativeSettlements |= t.getSettlement() instanceof IndianSettlement;
            }
        }
        this.setLayer(rivers && lostCityRumours && resources && nativeSettlements ? Layer.ALL : (nativeSettlements ? Layer.NATIVES : (lostCityRumours ? Layer.RUMOURS : (resources ? Layer.RESOURCES : (rivers ? Layer.RIVERS : (regions ? Layer.REGIONS : Layer.TERRAIN))))));
    }

    public void fixupRegions() {
        for (Region r2 : CollectionUtils.transform(this.getRegions(), r -> !r.isPacific())) {
            Region p = r2.getParent();
            if (p != null && p.getDiscoverable() && r2.getDiscoverable()) {
                p = p.getParent();
                r2.setParent(p);
            }
            if (p == null || p.getChildren().contains(r2)) continue;
            p.addChild(r2);
        }
    }

    public Tile importTile(Tile other, int x, int y, Layer layer) {
        Game game = this.getGame();
        Tile t = new Tile(game, other.getType(), x, y);
        if (other.getMoveToEurope() != null) {
            t.setMoveToEurope(other.getMoveToEurope());
        }
        if (other.getTileItemContainer() != null) {
            TileItemContainer container = new TileItemContainer(game, t);
            container.copyFrom(other.getTileItemContainer(), layer);
            t.setTileItemContainer(container);
        }
        return t;
    }

    public Map scale(int width, int height) {
        Game game = this.getGame();
        Map ret = new Map(game, width, height);
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        ret.populateTiles((x, y) -> {
            int oldX = x * oldWidth / width;
            int oldY = y * oldHeight / height;
            return this.importTile(this.getTile(oldX, oldY), (int)x, (int)y, Layer.ALL);
        });
        ret.resetContiguity();
        ret.resetHighSeasCount();
        return ret;
    }

    @Override
    public Tile getTile() {
        return null;
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.key("newWorld");
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        String name = player.getNewLandName();
        return name == null ? this.getLocationLabel() : StringTemplate.name(name);
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            throw new RuntimeException("Disabled Map.add(Unit): " + locatable);
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        Tile tile;
        if (locatable instanceof Unit && (tile = locatable.getTile()) != null) {
            return tile.remove(locatable);
        }
        return false;
    }

    @Override
    public boolean contains(Locatable locatable) {
        return locatable instanceof Unit && locatable.getLocation() != null && locatable.getLocation().getTile() != null;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return locatable instanceof Unit;
    }

    @Override
    public int getUnitCount() {
        return -1;
    }

    @Override
    public Stream<Unit> getUnits() {
        return Stream.empty();
    }

    @Override
    public List<Unit> getUnitList() {
        return Collections.emptyList();
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    public Settlement getSettlement() {
        return null;
    }

    @Override
    public Colony getColony() {
        return null;
    }

    @Override
    public IndianSettlement getIndianSettlement() {
        return null;
    }

    @Override
    public Location up() {
        return this;
    }

    @Override
    public int getRank() {
        return -3;
    }

    @Override
    public String toShortString() {
        return "Map";
    }

    @Override
    public String getLocationImageKey() {
        return "image.tileitem.lostCityRumour";
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        int hgt = this.getHeight();
        int wid = this.getWidth();
        for (int y = 0; y < hgt; ++y) {
            for (int x = 0; x < wid; ++x) {
                Tile t = this.getTile(x, y);
                result = result.combine(t.checkIntegrity(fix, lb));
            }
        }
        return result;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Map o = this.copyInCast(other, Map.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        String err = this.updateTiles(o.getWidth(), o.getHeight());
        if (err != null) {
            throw new RuntimeException("copyIn failure, " + err);
        }
        this.clearRegions();
        for (Region r : o.getRegions()) {
            this.addRegion(game.update(r, true));
        }
        o.forEachTile(t -> this.updateTile(game.update(t, true)));
        this.layer = o.getLayer();
        this.minimumLatitude = o.getMinimumLatitude();
        this.maximumLatitude = o.getMaximumLatitude();
        this.latitudePerRow = o.getLatitudePerRow();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(WIDTH_TAG, this.getWidth());
        xw.writeAttribute(HEIGHT_TAG, this.getHeight());
        xw.writeAttribute(LAYER_TAG, this.layer);
        xw.writeAttribute(MINIMUM_LATITUDE_TAG, this.minimumLatitude);
        xw.writeAttribute(MAXIMUM_LATITUDE_TAG, this.maximumLatitude);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Region region : CollectionUtils.sort(this.getRegions())) {
            region.toXML(xw);
        }
        int hgt = this.getHeight();
        int wid = this.getWidth();
        for (int y = 0; y < hgt; ++y) {
            for (int x = 0; x < wid; ++x) {
                this.getTile(x, y).toXML(xw);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        String err = this.updateTiles(xr.getAttribute(WIDTH_TAG, -1), xr.getAttribute(HEIGHT_TAG, -1));
        if (err != null) {
            throw new XMLStreamException("Map.readAttributes failure, " + err);
        }
        this.setLayer(xr.getAttribute(LAYER_TAG, Layer.class, Layer.ALL));
        this.minimumLatitude = xr.getAttribute(MINIMUM_LATITUDE_TAG, -90);
        this.maximumLatitude = xr.getAttribute(MAXIMUM_LATITUDE_TAG, 90);
        this.calculateLatitudePerRow();
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        this.forEachTile(t -> {
            Settlement s = t.getOwningSettlement();
            if (s != null) {
                s.addTile((Tile)t);
            }
        });
        this.fixupRegions();
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if ("region".equals(tag)) {
            this.addRegion(xr.readFreeColObject(game, Region.class));
        } else if ("tile".equals(tag)) {
            Tile t = xr.readFreeColObject(game, Tile.class);
            if (!this.updateTile(t)) {
                logger.warning("Tile update failure for: " + t);
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    private static class MoveCandidate {
        private Unit unit;
        private final PathNode current;
        private final Location dst;
        private int movesLeft;
        private int turns;
        private final boolean onCarrier;
        private int cost;

        public MoveCandidate(Unit unit, PathNode current, Location dst, int movesLeft, int turns, boolean onCarrier, CostDecider decider) {
            this.unit = unit;
            this.current = current;
            this.dst = dst;
            this.movesLeft = movesLeft;
            this.turns = turns;
            this.onCarrier = onCarrier;
            CostDecider cd = decider != null ? decider : CostDeciders.defaultCostDeciderFor(unit);
            this.cost = cd.getCost(unit, current.getLocation(), dst, movesLeft);
            if (this.cost == -1) {
                if (dst.getTile() != null && !dst.getTile().isExplored()) {
                    this.turns += 2;
                    this.movesLeft = 0;
                } else {
                    throw new RuntimeException("Invalid move candidate: for " + unit + " to " + dst);
                }
            }
            this.turns += cd.getNewTurns();
            this.movesLeft = cd.getMovesLeft();
            this.cost = PathNode.getNodeCost(this.turns, this.movesLeft);
        }

        public int getCost() {
            return this.cost;
        }

        public void embarkUnit(Unit unit) {
            this.unit = unit;
            this.movesLeft = unit.getInitialMovesLeft();
            ++this.turns;
            this.cost = PathNode.getNodeCost(this.turns, this.movesLeft);
        }

        public boolean canImprove(PathNode best) {
            return best == null || this.cost < best.getCost();
        }

        public void improve(HashMap<String, PathNode> openMap, PriorityQueue<PathNode> openMapQueue, HashMap<String, Integer> f, SearchHeuristic sh) {
            PathNode best = openMap.get(this.dst.getId());
            if (best != null) {
                openMap.remove(this.dst.getId());
                openMapQueue.remove(best);
            }
            this.add(openMap, openMapQueue, f, sh);
        }

        public void add(HashMap<String, PathNode> openMap, PriorityQueue<PathNode> openMapQueue, HashMap<String, Integer> f, SearchHeuristic sh) {
            int fcost = this.cost;
            if (this.dst.getTile() != null) {
                fcost += sh.getValue(this.dst.getTile());
            }
            f.put(this.dst.getId(), fcost);
            PathNode path = new PathNode(this.dst, this.movesLeft, this.turns, this.onCarrier, this.current, null);
            openMap.put(this.dst.getId(), path);
            openMapQueue.offer(path);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("[candidate unit=").append(this.unit).append(" dst=").append(this.dst).append(" movesLeft=").append(this.movesLeft).append(" turns=").append(this.turns).append(" onCarrier=").append(this.onCarrier).append(" cost=").append(this.cost).append(']');
            return sb.toString();
        }
    }

    private static interface SearchHeuristic {
        public int getValue(Tile var1);
    }

    private final class CircleIterator
    implements Iterator<Tile> {
        private final int radius;
        private int currentRadius;
        private int n;
        private int x;
        private int y;

        public CircleIterator(Tile center, boolean isFilled, int radius) {
            if (center == null) {
                throw new RuntimeException("center must not be null: " + this);
            }
            this.radius = radius;
            this.n = 0;
            if (isFilled || radius == 1) {
                Position step = Direction.NE.step(center.getX(), center.getY());
                this.x = step.x;
                this.y = step.y;
                this.currentRadius = 1;
            } else {
                Position step;
                this.currentRadius = radius;
                this.x = center.getX();
                this.y = center.getY();
                for (int i = 1; i < radius; ++i) {
                    step = Direction.N.step(this.x, this.y);
                    this.x = step.x;
                    this.y = step.y;
                }
                step = Direction.NE.step(this.x, this.y);
                this.x = step.x;
                this.y = step.y;
            }
            if (!Map.this.isValid(this.x, this.y)) {
                this.nextTile();
            }
        }

        public int getCurrentRadius() {
            return this.currentRadius;
        }

        private void nextTile() {
            boolean started = this.n != 0;
            do {
                Direction direction;
                ++this.n;
                int width = this.currentRadius * 2;
                if (this.n >= width * 4) {
                    ++this.currentRadius;
                    if (this.currentRadius > this.radius) {
                        this.y = Integer.MIN_VALUE;
                        this.x = Integer.MIN_VALUE;
                        break;
                    }
                    if (!started) {
                        this.y = Integer.MIN_VALUE;
                        this.x = Integer.MIN_VALUE;
                        break;
                    }
                    this.n = 0;
                    started = false;
                    Position step = Direction.NE.step(this.x, this.y);
                    this.x = step.x;
                    this.y = step.y;
                    continue;
                }
                int i = this.n / width;
                switch (i) {
                    case 0: {
                        direction = Direction.SE;
                        break;
                    }
                    case 1: {
                        direction = Direction.SW;
                        break;
                    }
                    case 2: {
                        direction = Direction.NW;
                        break;
                    }
                    case 3: {
                        direction = Direction.NE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("i=" + i + ", n=" + this.n + ", width=" + width);
                    }
                }
                Position step = direction.step(this.x, this.y);
                this.x = step.x;
                this.y = step.y;
            } while (!Map.this.isValid(this.x, this.y));
        }

        @Override
        public boolean hasNext() {
            return this.x != Integer.MIN_VALUE && this.y != Integer.MIN_VALUE;
        }

        @Override
        public Tile next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("CircleIterator exhausted: " + this.n);
            }
            Tile result = Map.this.getTile(this.x, this.y);
            this.nextTile();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Position {
        public final int x;
        public final int y;

        public Position(int posX, int posY) {
            this.x = posX;
            this.y = posY;
        }

        public Position(Tile tile) {
            this(tile.getX(), tile.getY());
        }

        public Position(Position start, Direction direction) {
            Position step = direction == null ? start : direction.step(start.x, start.y);
            this.x = step.x;
            this.y = step.y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean isValid(int width, int height) {
            return Map.inBox(this.x, this.y, width, height);
        }

        public static int getXYDistance(int ax, int ay, int bx, int by) {
            int r = bx - ax - (ay - by) / 2;
            if (by > ay && ay % 2 == 0 && by % 2 != 0) {
                ++r;
            } else if (by < ay && ay % 2 != 0 && by % 2 == 0) {
                --r;
            }
            return Math.max(Math.abs(ay - by + r), Math.abs(r));
        }

        public int getDistance(Position position) {
            return Position.getXYDistance(this.getX(), this.getY(), position.getX(), position.getY());
        }

        public Direction getDirection(Position other) {
            return CollectionUtils.find(Direction.values(), CollectionUtils.matchKeyEquals(other, d -> new Position(this, (Direction)d)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Position) {
                Position other = (Position)o;
                return this.x == other.x && this.y == other.y;
            }
            return false;
        }

        public int hashCode() {
            return this.x | this.y << 16;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }

    public static enum Layer {
        NONE,
        LAND,
        TERRAIN,
        REGIONS,
        RIVERS,
        RESOURCES,
        RUMOURS,
        NATIVES,
        ALL;

    }

    private static enum MoveStep {
        FAIL,
        BYLAND,
        BYWATER,
        EMBARK,
        DISEMBARK;

    }
}

