/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObject;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class NationOptions
extends FreeColSpecObject {
    private static final Logger logger = Logger.getLogger(NationOptions.class.getName());
    public static final String TAG = "nationOptions";
    private Advantages nationalAdvantages;
    private final Map<Nation, NationState> nations = new HashMap<Nation, NationState>();
    private static final String NATIONAL_ADVANTAGES_TAG = "nationalAdvantages";
    private static final String NATION_OPTION_TAG = "nationOption";
    private static final String STATE_TAG = "state";
    private static final String OLD_NATION_TAG = "Nation";
    private static final String OLD_NATIONS_TAG = "Nations";

    public NationOptions(Specification specification) {
        super(specification);
        this.nationalAdvantages = FreeCol.getAdvantages();
        if (specification != null) {
            int counter = 0;
            int maxEuropeans = FreeCol.getEuropeanCount();
            for (Nation nation : CollectionUtils.transform(specification.getNations(), n -> !n.isUnknownEnemy() && !n.getType().isREF())) {
                if (nation.getType().isEuropean() && nation.isSelectable()) {
                    if (counter < maxEuropeans) {
                        this.nations.put(nation, NationState.AVAILABLE);
                        ++counter;
                        continue;
                    }
                    this.nations.put(nation, NationState.NOT_AVAILABLE);
                    continue;
                }
                this.nations.put(nation, NationState.AI_ONLY);
            }
        }
    }

    public NationOptions(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this(specification);
        this.readFromXML(xr);
    }

    public final Advantages getNationalAdvantages() {
        return this.nationalAdvantages;
    }

    public final Map<Nation, NationState> getNations() {
        return this.nations;
    }

    protected void setNations(Map<Nation, NationState> nations) {
        this.nations.clear();
        this.nations.putAll(nations);
    }

    public final NationState getNationState(Nation nation) {
        return this.nations.get(nation);
    }

    public final void setNationState(Nation nation, NationState state) {
        this.nations.put(nation, state);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        NationOptions o = this.copyInCast(other, NationOptions.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.nationalAdvantages = o.getNationalAdvantages();
        this.setNations(o.getNations());
        return true;
    }

    @Override
    public void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeAttribute(NATIONAL_ADVANTAGES_TAG, this.nationalAdvantages);
    }

    @Override
    public void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Nation nation : CollectionUtils.sort(this.nations.keySet())) {
            xw.writeStartElement(NATION_OPTION_TAG);
            xw.writeAttribute("id", nation);
            xw.writeAttribute(STATE_TAG, this.nations.get(nation));
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.nationalAdvantages = xr.getAttribute(NATIONAL_ADVANTAGES_TAG, Advantages.class, Advantages.SELECTABLE);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.nations.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (NATION_OPTION_TAG.equals(tag)) {
            Nation nation = xr.getType(spec, "id", Nation.class, null);
            NationState state = xr.getAttribute(STATE_TAG, NationState.class, null);
            if (nation != null && state != null) {
                this.nations.put(nation, state);
            }
            xr.closeTag(NATION_OPTION_TAG);
        } else if (OLD_NATIONS_TAG.equals(tag)) {
            while (xr.moreTags()) {
                tag = xr.getLocalName();
                if (OLD_NATION_TAG.equals(tag)) {
                    Nation nation = xr.getType(spec, "id", Nation.class, null);
                    NationState state = xr.getAttribute(STATE_TAG, NationState.class, null);
                    if (nation != null && state != null) {
                        this.nations.put(nation, state);
                    }
                    xr.closeTag(OLD_NATION_TAG);
                    continue;
                }
                throw new XMLStreamException("Bogus Nation tag: " + tag);
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(NATIONAL_ADVANTAGES_TAG).append(": ").append(this.nationalAdvantages).append('\n');
        CollectionUtils.forEachMapEntry(this.nations, e -> sb.append(' ').append(((Nation)e.getKey()).getId()).append(' ').append(e.getValue()).append('\n'));
        return sb.toString();
    }

    public static enum NationState implements Named
    {
        AVAILABLE,
        AI_ONLY,
        NOT_AVAILABLE;


        private String getKey() {
            return "nationState." + StringUtils.getEnumKey(this);
        }

        public final String getShortDescriptionKey() {
            return Messages.shortDescriptionKey("model." + this.getKey());
        }

        @Override
        public final String getNameKey() {
            return Messages.nameKey("model." + this.getKey());
        }
    }

    public static enum Advantages implements Named
    {
        NONE,
        FIXED,
        SELECTABLE;


        private String getKey() {
            return "advantages." + StringUtils.getEnumKey(this);
        }

        public final String getShortDescriptionKey() {
            return Messages.shortDescriptionKey("model." + this.getKey());
        }

        @Override
        public final String getNameKey() {
            return Messages.nameKey("model." + this.getKey());
        }
    }
}

