/* WindowClone.c generated by valac 0.56.3, the Vala compiler
 * generated from WindowClone.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2022 elementary, Inc. (https://elementary.io)
 *                         2014 Tom Beckmann
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <meta/window.h>
#include <meta/boxes.h>
#include <glib.h>
#include "gala.h"
#include <meta/meta-window-actor.h>
#include <meta/workspace.h>
#include <meta/display.h>
#include <meta/meta-workspace-manager.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <meta/prefs.h>
#include <meta/meta-background-group.h>
#include <meta/common.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <granite.h>

#define GALA_WINDOW_CLONE_CLOSE_WINDOW_ICON_SIZE 36
#define GALA_WINDOW_CLONE_WINDOW_ICON_SIZE 64
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE 12
#define GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION 200
#define GALA_WINDOW_CLONE_TITLE_MAX_WIDTH_MARGIN 60
#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_COLOR_OPACITY 0.8
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
typedef struct _GalaWindowClonePrivate GalaWindowClonePrivate;

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;

#define GALA_TYPE_SHADOW_EFFECT (gala_shadow_effect_get_type ())
#define GALA_SHADOW_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect))
#define GALA_SHADOW_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHADOW_EFFECT, GalaShadowEffectClass))
#define GALA_IS_SHADOW_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHADOW_EFFECT))
#define GALA_IS_SHADOW_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHADOW_EFFECT))
#define GALA_SHADOW_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHADOW_EFFECT, GalaShadowEffectClass))

typedef struct _GalaShadowEffect GalaShadowEffect;
typedef struct _GalaShadowEffectClass GalaShadowEffectClass;

#define GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE (gala_window_clone_active_shape_get_type ())
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape))
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShapeClass))
#define GALA_WINDOW_CLONE_IS_ACTIVE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE))
#define GALA_WINDOW_CLONE_IS_ACTIVE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE))
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShapeClass))

typedef struct _GalaWindowCloneActiveShape GalaWindowCloneActiveShape;
typedef struct _GalaWindowCloneActiveShapeClass GalaWindowCloneActiveShapeClass;

#define GALA_TYPE_TOOLTIP (gala_tooltip_get_type ())
#define GALA_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOOLTIP, GalaTooltip))
#define GALA_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOOLTIP, GalaTooltipClass))
#define GALA_IS_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOOLTIP))
#define GALA_IS_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOOLTIP))
#define GALA_TOOLTIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOOLTIP, GalaTooltipClass))

typedef struct _GalaTooltip GalaTooltip;
typedef struct _GalaTooltipClass GalaTooltipClass;
enum  {
	GALA_WINDOW_CLONE_0_PROPERTY,
	GALA_WINDOW_CLONE_WINDOW_PROPERTY,
	GALA_WINDOW_CLONE_SLOT_PROPERTY,
	GALA_WINDOW_CLONE_DRAGGING_PROPERTY,
	GALA_WINDOW_CLONE_ACTIVE_PROPERTY,
	GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY,
	GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY,
	GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY,
	GALA_WINDOW_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_properties[GALA_WINDOW_CLONE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_MetaRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_MetaRectangle_free (var), NULL)))

#define GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT (gala_window_clone_window_shadow_effect_get_type ())
#define GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT, GalaWindowCloneWindowShadowEffect))
#define GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT, GalaWindowCloneWindowShadowEffectClass))
#define GALA_WINDOW_CLONE_IS_WINDOW_SHADOW_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT))
#define GALA_WINDOW_CLONE_IS_WINDOW_SHADOW_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT))
#define GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT, GalaWindowCloneWindowShadowEffectClass))

typedef struct _GalaWindowCloneWindowShadowEffect GalaWindowCloneWindowShadowEffect;
typedef struct _GalaWindowCloneWindowShadowEffectClass GalaWindowCloneWindowShadowEffectClass;
typedef struct _Block66Data Block66Data;
typedef void (*GalaGestureTrackerOnBegin) (gdouble percentage, gpointer user_data);
typedef void (*GalaGestureTrackerOnUpdate) (gdouble percentage, gpointer user_data);
typedef void (*GalaGestureTrackerOnEnd) (gdouble percentage, gboolean cancel_action, gint calculated_duration, gpointer user_data);
typedef struct _Block67Data Block67Data;

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;

#define GALA_TYPE_WORKSPACE_INSERT_THUMB (gala_workspace_insert_thumb_get_type ())
#define GALA_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb))
#define GALA_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))
#define GALA_IS_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_IS_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_WORKSPACE_INSERT_THUMB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))

typedef struct _GalaWorkspaceInsertThumb GalaWorkspaceInsertThumb;
typedef struct _GalaWorkspaceInsertThumbClass GalaWorkspaceInsertThumbClass;

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;

#define GALA_TYPE_FRAMED_BACKGROUND (gala_framed_background_get_type ())
#define GALA_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground))
#define GALA_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))
#define GALA_IS_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_IS_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_FRAMED_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))

typedef struct _GalaFramedBackground GalaFramedBackground;
typedef struct _GalaFramedBackgroundClass GalaFramedBackgroundClass;

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;

#define GALA_TYPE_MONITOR_CLONE (gala_monitor_clone_get_type ())
#define GALA_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorClone))
#define GALA_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))
#define GALA_IS_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONITOR_CLONE))
#define GALA_IS_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONITOR_CLONE))
#define GALA_MONITOR_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))

typedef struct _GalaMonitorClone GalaMonitorClone;
typedef struct _GalaMonitorCloneClass GalaMonitorCloneClass;
typedef struct _GalaShadowEffectPrivate GalaShadowEffectPrivate;
typedef struct _GalaWindowCloneWindowShadowEffectPrivate GalaWindowCloneWindowShadowEffectPrivate;
enum  {
	GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_0_PROPERTY,
	GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_WINDOW_PROPERTY,
	GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_window_shadow_effect_properties[GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_NUM_PROPERTIES];
typedef struct _GalaWindowCloneActiveShapePrivate GalaWindowCloneActiveShapePrivate;
enum  {
	GALA_WINDOW_CLONE_ACTIVE_SHAPE_0_PROPERTY,
	GALA_WINDOW_CLONE_ACTIVE_SHAPE_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_active_shape_properties[GALA_WINDOW_CLONE_ACTIVE_SHAPE_NUM_PROPERTIES];
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
typedef struct _Block68Data Block68Data;
enum  {
	GALA_WINDOW_CLONE_SELECTED_SIGNAL,
	GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL,
	GALA_WINDOW_CLONE_NUM_SIGNALS
};
static guint gala_window_clone_signals[GALA_WINDOW_CLONE_NUM_SIGNALS] = {0};

struct _GalaWindowClone {
	ClutterActor parent_instance;
	GalaWindowClonePrivate * priv;
};

struct _GalaWindowCloneClass {
	ClutterActorClass parent_class;
};

struct _GalaWindowClonePrivate {
	MetaWindow* _window;
	MetaRectangle* _slot;
	gboolean _dragging;
	gboolean _active;
	gboolean _overview_mode;
	GalaGestureTracker* _gesture_tracker;
	GalaDragDropAction* drag_action;
	ClutterClone* clone;
	GalaShadowEffect* shadow_effect;
	ClutterActor* prev_parent;
	gint prev_index;
	gulong check_confirm_dialog_cb;
	guint shadow_update_timeout;
	gboolean in_slot_animation;
	ClutterActor* close_button;
	GalaWindowCloneActiveShape* active_shape;
	ClutterActor* window_icon;
	GalaTooltip* window_title;
};

struct _Block66Data {
	int _ref_count_;
	GalaWindowClone* self;
	MetaRectangle outer_rect;
	gfloat initial_x;
	gfloat initial_y;
	gfloat initial_width;
	gfloat initial_height;
	gint target_x;
	gint target_y;
	gboolean animate;
};

struct _Block67Data {
	int _ref_count_;
	GalaWindowClone* self;
	gfloat initial_x;
	gfloat initial_y;
	gfloat initial_width;
	gfloat initial_height;
	MetaRectangle rect;
};

struct _GalaShadowEffect {
	ClutterEffect parent_instance;
	GalaShadowEffectPrivate * priv;
};

struct _GalaShadowEffectClass {
	ClutterEffectClass parent_class;
	void (*get_bounding_box) (GalaShadowEffect* self, ClutterActorBox* result);
};

struct _GalaWindowCloneWindowShadowEffect {
	GalaShadowEffect parent_instance;
	GalaWindowCloneWindowShadowEffectPrivate * priv;
};

struct _GalaWindowCloneWindowShadowEffectClass {
	GalaShadowEffectClass parent_class;
};

struct _GalaWindowCloneWindowShadowEffectPrivate {
	MetaWindow* _window;
};

struct _GalaWindowCloneActiveShape {
	ClutterActor parent_instance;
	GalaWindowCloneActiveShapePrivate * priv;
};

struct _GalaWindowCloneActiveShapeClass {
	ClutterActorClass parent_class;
};

struct _GalaWindowCloneActiveShapePrivate {
	ClutterCanvas* background_canvas;
};

struct _Block68Data {
	int _ref_count_;
	GalaWindowClone* self;
	ClutterClickAction* click_action;
};

static gint GalaWindowClone_private_offset;
static gpointer gala_window_clone_parent_class = NULL;
static gint GalaWindowCloneWindowShadowEffect_private_offset;
static gpointer gala_window_clone_window_shadow_effect_parent_class = NULL;
static gint GalaWindowCloneActiveShape_private_offset;
static gpointer gala_window_clone_active_shape_parent_class = NULL;
static gint gala_window_clone_active_shape_border_radius;
static gint gala_window_clone_active_shape_border_radius = 0;
static GdkRGBA gala_window_clone_active_shape_color;
static GdkRGBA gala_window_clone_active_shape_color = {0};

VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
VALA_EXTERN GType gala_shadow_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShadowEffect, g_object_unref)
static GType gala_window_clone_active_shape_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneActiveShape, g_object_unref)
VALA_EXTERN GType gala_tooltip_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaTooltip, g_object_unref)
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
static void gala_window_clone_unmanaged (GalaWindowClone* self);
static void _gala_window_clone_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                         gpointer self);
static void gala_window_clone_on_all_workspaces_changed (GalaWindowClone* self);
static void _gala_window_clone_on_all_workspaces_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void gala_window_clone_check_shadow_requirements (GalaWindowClone* self);
static void _gala_window_clone_check_shadow_requirements_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _vala_MetaRectangle_free (MetaRectangle* self);
VALA_EXTERN GalaWindowClone* gala_window_clone_new (MetaWindow* window,
                                        GalaGestureTracker* gesture_tracker,
                                        gboolean overview_mode);
VALA_EXTERN GalaWindowClone* gala_window_clone_construct (GType object_type,
                                              MetaWindow* window,
                                              GalaGestureTracker* gesture_tracker,
                                              gboolean overview_mode);
static void gala_window_clone_load_clone (GalaWindowClone* self,
                                   gboolean was_waiting);
static gboolean ___lambda78_ (GalaWindowClone* self);
static gboolean ____lambda78__gsource_func (gpointer self);
VALA_EXTERN gboolean gala_window_clone_get_overview_mode (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_transition_to_original_state (GalaWindowClone* self,
                                                     gboolean animate,
                                                     gboolean with_gesture,
                                                     gboolean is_cancel_animation);
static gboolean gala_window_clone_should_fade (GalaWindowClone* self);
VALA_EXTERN MetaRectangle* gala_window_clone_get_slot (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_take_slot (GalaWindowClone* self,
                                  MetaRectangle* rect,
                                  gboolean with_gesture,
                                  gboolean is_cancel_animation);
static GalaWindowCloneWindowShadowEffect* gala_window_clone_window_shadow_effect_new (MetaWindow* window,
                                                                               gint shadow_size,
                                                                               gint shadow_spread);
static GalaWindowCloneWindowShadowEffect* gala_window_clone_window_shadow_effect_construct (GType object_type,
                                                                                     MetaWindow* window,
                                                                                     gint shadow_size,
                                                                                     gint shadow_spread);
static GType gala_window_clone_window_shadow_effect_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneWindowShadowEffect, g_object_unref)
static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
VALA_EXTERN void gala_window_clone_place_widgets (GalaWindowClone* self,
                                      gint dest_width,
                                      gint dest_height);
static void __lambda79_ (GalaWindowClone* self);
static void ___lambda79__gala_gesture_tracker_on_begin (gdouble percentage,
                                                 gpointer self);
static void __lambda80_ (Block66Data* _data66_,
                  gdouble percentage);
VALA_EXTERN gfloat gala_gesture_tracker_animation_value (gfloat initial_value,
                                             gfloat target_value,
                                             gdouble percentage,
                                             gboolean rounded);
static void gala_window_clone_set_window_icon_position (GalaWindowClone* self,
                                                 gfloat window_width,
                                                 gfloat window_height,
                                                 gboolean aligned);
static void ___lambda80__gala_gesture_tracker_on_update (gdouble percentage,
                                                  gpointer self);
static void __lambda81_ (Block66Data* _data66_,
                  gdouble percentage,
                  gboolean cancel_action);
static void gala_window_clone_toggle_shadow (GalaWindowClone* self,
                                      gboolean show);
static void ___lambda82_ (Block66Data* _data66_);
static void ____lambda82__clutter_timeline_completed (ClutterTimeline* _sender,
                                               gpointer self);
static void ___lambda81__gala_gesture_tracker_on_end (gdouble percentage,
                                               gboolean cancel_action,
                                               gint calculated_duration,
                                               gpointer self);
VALA_EXTERN GalaGestureTracker* gala_window_clone_get_gesture_tracker (GalaWindowClone* self);
VALA_EXTERN void gala_gesture_tracker_connect_handlers (GalaGestureTracker* self,
                                            GalaGestureTrackerOnBegin on_begin_handler,
                                            gpointer on_begin_handler_target,
                                            GDestroyNotify on_begin_handler_target_destroy_notify,
                                            GalaGestureTrackerOnUpdate on_update_handler,
                                            gpointer on_update_handler_target,
                                            GDestroyNotify on_update_handler_target_destroy_notify,
                                            GalaGestureTrackerOnEnd on_end_handler,
                                            gpointer on_end_handler_target,
                                            GDestroyNotify on_end_handler_target_destroy_notify);
static Block67Data* block67_data_ref (Block67Data* _data67_);
static void block67_data_unref (void * _userdata_);
static void gala_window_clone_set_slot (GalaWindowClone* self,
                                 MetaRectangle* value);
static void __lambda83_ (Block67Data* _data67_,
                  gdouble percentage);
static void ___lambda83__gala_gesture_tracker_on_update (gdouble percentage,
                                                  gpointer self);
static void __lambda84_ (Block67Data* _data67_,
                  gdouble percentage,
                  gboolean cancel_action);
static void __lambda85_ (Block67Data* _data67_);
static void ___lambda85__clutter_timeline_completed (ClutterTimeline* _sender,
                                              gpointer self);
static void ___lambda84__gala_gesture_tracker_on_end (gdouble percentage,
                                               gboolean cancel_action,
                                               gint calculated_duration,
                                               gpointer self);
static void gala_window_clone_real_allocate (ClutterActor* base,
                                      ClutterActorBox* box);
VALA_EXTERN gboolean gala_window_clone_get_dragging (GalaWindowClone* self);
static gboolean gala_window_clone_real_button_press_event (ClutterActor* base,
                                                    ClutterButtonEvent* event);
static gboolean gala_window_clone_real_enter_event (ClutterActor* base,
                                             ClutterCrossingEvent* event);
static gboolean gala_window_clone_real_leave_event (ClutterActor* base,
                                             ClutterCrossingEvent* event);
VALA_EXTERN gint gala_internal_utils_get_ui_scaling_factor (void);
static gboolean gala_window_clone_is_close_button_on_left (void);
VALA_EXTERN void gala_tooltip_set_text (GalaTooltip* self,
                            const gchar* new_text,
                            gboolean redraw);
VALA_EXTERN void gala_tooltip_set_max_width (GalaTooltip* self,
                                 gfloat new_max_width,
                                 gboolean redraw);
static void gala_window_clone_set_window_title_position (GalaWindowClone* self,
                                                  gfloat window_width,
                                                  gfloat window_height);
VALA_EXTERN guint8 gala_window_clone_get_shadow_opacity (GalaWindowClone* self);
static void gala_window_clone_close_window (GalaWindowClone* self);
static void gala_window_clone_check_confirm_dialog (GalaWindowClone* self,
                                             gint monitor,
                                             MetaWindow* new_window);
static void _gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                  gint object,
                                                                                  MetaWindow* p0,
                                                                                  gpointer self);
static gboolean ___lambda86_ (GalaWindowClone* self);
static gboolean ____lambda86__gsource_func (gpointer self);
static void gala_window_clone_actor_clicked (GalaWindowClone* self,
                                      guint32 button);
static ClutterActor* gala_window_clone_drag_begin (GalaWindowClone* self,
                                            gfloat click_x,
                                            gfloat click_y);
static void gala_window_clone_set_dragging (GalaWindowClone* self,
                                     gboolean value);
static void gala_window_clone_drag_destination_crossed (GalaWindowClone* self,
                                                 ClutterActor* destination,
                                                 gboolean hovered);
VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN GType gala_workspace_insert_thumb_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceInsertThumb, g_object_unref)
VALA_EXTERN MetaWorkspace* gala_icon_group_get_workspace (GalaIconGroup* self);
VALA_EXTERN gint gala_workspace_insert_thumb_get_delay (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_workspace_insert_thumb_set_window_thumb (GalaWorkspaceInsertThumb* self,
                                                   MetaWindow* window);
VALA_EXTERN void gala_icon_group_add_window (GalaIconGroup* self,
                                 MetaWindow* window,
                                 gboolean no_redraw,
                                 gboolean temporary);
VALA_EXTERN void gala_icon_group_remove_window (GalaIconGroup* self,
                                    MetaWindow* window,
                                    gboolean animate);
static void gala_window_clone_drag_end (GalaWindowClone* self,
                                 ClutterActor* destination);
VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
 G_GNUC_INTERNAL GType gala_framed_background_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFramedBackground, g_object_unref)
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
static void gala_window_clone_drag_canceled (GalaWindowClone* self);
VALA_EXTERN gint gala_workspace_insert_thumb_get_workspace_index (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_internal_utils_insert_workspace_with_window (gint index,
                                                       MetaWindow* new_window);
VALA_EXTERN GType gala_monitor_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonitorClone, g_object_unref)
VALA_EXTERN gint gala_monitor_clone_get_monitor (GalaMonitorClone* self);
VALA_EXTERN gint gala_internal_utils_pixel_align (gfloat value);
static void gala_window_clone_set_window (GalaWindowClone* self,
                                   MetaWindow* value);
static gboolean _meta_rectangle_equal (const MetaRectangle * s1,
                                const MetaRectangle * s2);
static MetaRectangle* _vala_MetaRectangle_copy (MetaRectangle* self);
VALA_EXTERN gboolean gala_window_clone_get_active (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_set_active (GalaWindowClone* self,
                                   gboolean value);
static void gala_window_clone_set_overview_mode (GalaWindowClone* self,
                                          gboolean value);
static void gala_window_clone_set_gesture_tracker (GalaWindowClone* self,
                                            GalaGestureTracker* value);
VALA_EXTERN guint8 gala_shadow_effect_get_shadow_opacity (GalaShadowEffect* self);
VALA_EXTERN void gala_window_clone_set_shadow_opacity (GalaWindowClone* self,
                                           guint8 value);
VALA_EXTERN void gala_shadow_effect_set_shadow_opacity (GalaShadowEffect* self,
                                            guint8 value);
VALA_EXTERN void gala_shadow_effect_get_bounding_box (GalaShadowEffect* self,
                                          ClutterActorBox* result);
static void gala_window_clone_window_shadow_effect_real_get_bounding_box (GalaShadowEffect* base,
                                                                   ClutterActorBox* result);
VALA_EXTERN gint gala_shadow_effect_get_shadow_size (GalaShadowEffect* self);
VALA_EXTERN gint gala_shadow_effect_get_shadow_spread (GalaShadowEffect* self);
static MetaWindow* gala_window_clone_window_shadow_effect_get_window (GalaWindowCloneWindowShadowEffect* self);
static void gala_window_clone_window_shadow_effect_set_window (GalaWindowCloneWindowShadowEffect* self,
                                                        MetaWindow* value);
static void gala_window_clone_window_shadow_effect_finalize (GObject * obj);
static GType gala_window_clone_window_shadow_effect_get_type_once (void);
static void _vala_gala_window_clone_window_shadow_effect_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_gala_window_clone_window_shadow_effect_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static gboolean gala_window_clone_active_shape_draw_background (cairo_t* cr,
                                                         gint width,
                                                         gint height);
static void gala_window_clone_active_shape_real_allocate (ClutterActor* base,
                                                   ClutterActorBox* box);
VALA_EXTERN void gala_internal_utils_get_theme_accent_color (GdkRGBA* result);
static GalaWindowCloneActiveShape* gala_window_clone_active_shape_new (void);
static GalaWindowCloneActiveShape* gala_window_clone_active_shape_construct (GType object_type);
static GObject * gala_window_clone_active_shape_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static gboolean _gala_window_clone_active_shape_draw_background_clutter_canvas_draw (ClutterCanvas* _sender,
                                                                              cairo_t* cr,
                                                                              gint width,
                                                                              gint height,
                                                                              gpointer self);
static void gala_window_clone_active_shape_finalize (GObject * obj);
static GType gala_window_clone_active_shape_get_type_once (void);
static GObject * gala_window_clone_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
static void _gala_window_clone___lambda107_ (Block68Data* _data68_);
static void __gala_window_clone___lambda107__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                    ClutterActor* actor,
                                                                    gpointer self);
static ClutterActor* _gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                              gfloat x,
                                                                              gfloat y,
                                                                              gpointer self);
static void _gala_window_clone_drag_destination_crossed_gala_drag_drop_action_destination_crossed (GalaDragDropAction* _sender,
                                                                                            ClutterActor* destination,
                                                                                            gboolean hovered,
                                                                                            gpointer self);
static void _gala_window_clone_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                                 ClutterActor* actor,
                                                                 gpointer self);
static void _gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                           gpointer self);
static void _gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                           guint32 button,
                                                                           gpointer self);
static gboolean _gala_window_clone___lambda108_ (GalaWindowClone* self);
static gboolean __gala_window_clone___lambda108__clutter_actor_button_press_event (ClutterActor* _sender,
                                                                            ClutterButtonEvent* event,
                                                                            gpointer self);
VALA_EXTERN GalaTooltip* gala_tooltip_new (void);
VALA_EXTERN GalaTooltip* gala_tooltip_construct (GType object_type);
static void gala_window_clone_finalize (GObject * obj);
static GType gala_window_clone_get_type_once (void);
static void _vala_gala_window_clone_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_window_clone_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_window_clone_get_instance_private (GalaWindowClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowClone_private_offset);
}

static void
_gala_window_clone_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                    gpointer self)
{
	gala_window_clone_unmanaged ((GalaWindowClone*) self);
}

static void
_gala_window_clone_on_all_workspaces_changed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	gala_window_clone_on_all_workspaces_changed ((GalaWindowClone*) self);
}

static void
_gala_window_clone_check_shadow_requirements_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	gala_window_clone_check_shadow_requirements ((GalaWindowClone*) self);
}

static void
_vala_MetaRectangle_free (MetaRectangle* self)
{
	g_boxed_free (meta_rectangle_get_type (), self);
}

GalaWindowClone*
gala_window_clone_construct (GType object_type,
                             MetaWindow* window,
                             GalaGestureTracker* gesture_tracker,
                             gboolean overview_mode)
{
	GalaWindowClone * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaWindowClone*) g_object_new (object_type, "window", window, "gesture-tracker", gesture_tracker, "overview-mode", overview_mode, NULL);
	return self;
}

GalaWindowClone*
gala_window_clone_new (MetaWindow* window,
                       GalaGestureTracker* gesture_tracker,
                       gboolean overview_mode)
{
	return gala_window_clone_construct (GALA_TYPE_WINDOW_CLONE, window, gesture_tracker, overview_mode);
}

/**
     * Waits for the texture of a new Meta.WindowActor to be available
     * and makes a close of it. If it was already was assigned a slot
     * at this point it will animate to it. Otherwise it will just place
     * itself at the location of the original window. Also adds the shadow
     * effect and makes sure the shadow is updated on size changes.
     *
     * @param was_waiting Internal argument used to indicate that we had to
     *                    wait before the window's texture became available.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
___lambda78_ (GalaWindowClone* self)
{
	MetaWindow* _tmp0_;
	GObject* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_compositor_private (_tmp0_);
	if (_tmp1_ != NULL) {
		gala_window_clone_load_clone (self, TRUE);
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda78__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda78_ ((GalaWindowClone*) self);
	return result;
}

static void
gala_window_clone_load_clone (GalaWindowClone* self,
                              gboolean was_waiting)
{
	MetaWindowActor* actor = NULL;
	MetaWindow* _tmp0_;
	GObject* _tmp1_;
	MetaWindowActor* _tmp2_;
	MetaWindowActor* _tmp3_;
	gboolean _tmp4_;
	MetaWindowActor* _tmp6_;
	ClutterClone* _tmp7_;
	ClutterClone* _tmp8_;
	GalaWindowCloneActiveShape* _tmp9_;
	ClutterClone* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterClone* _tmp12_;
	ClutterActor* _tmp13_;
	ClutterClone* _tmp14_;
	GalaTooltip* _tmp15_;
	ClutterClone* _tmp16_;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_compositor_private (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, meta_window_actor_get_type ()) ? ((MetaWindowActor*) _tmp1_) : NULL);
	actor = _tmp2_;
	_tmp3_ = actor;
	if (_tmp3_ == NULL) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda78__gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (actor);
		return;
	}
	_tmp4_ = self->priv->_overview_mode;
	if (_tmp4_) {
		MetaWindowActor* _tmp5_;
		_tmp5_ = actor;
		clutter_actor_hide ((ClutterActor*) _tmp5_);
	}
	_tmp6_ = actor;
	_tmp7_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->clone);
	self->priv->clone = _tmp7_;
	_tmp8_ = self->priv->clone;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp8_);
	_tmp9_ = self->priv->active_shape;
	_tmp10_ = self->priv->clone;
	clutter_actor_set_child_below_sibling ((ClutterActor*) self, (ClutterActor*) _tmp9_, (ClutterActor*) _tmp10_);
	_tmp11_ = self->priv->close_button;
	_tmp12_ = self->priv->clone;
	clutter_actor_set_child_above_sibling ((ClutterActor*) self, _tmp11_, (ClutterActor*) _tmp12_);
	_tmp13_ = self->priv->window_icon;
	_tmp14_ = self->priv->clone;
	clutter_actor_set_child_above_sibling ((ClutterActor*) self, _tmp13_, (ClutterActor*) _tmp14_);
	_tmp15_ = self->priv->window_title;
	_tmp16_ = self->priv->clone;
	clutter_actor_set_child_above_sibling ((ClutterActor*) self, (ClutterActor*) _tmp15_, (ClutterActor*) _tmp16_);
	gala_window_clone_transition_to_original_state (self, FALSE, FALSE, FALSE);
	gala_window_clone_check_shadow_requirements (self);
	if (gala_window_clone_should_fade (self)) {
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	}
	if (was_waiting) {
		MetaRectangle* _tmp18_;
		_tmp18_ = self->priv->_slot;
		_tmp17_ = _tmp18_ != NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		MetaRectangle* _tmp19_;
		MetaRectangle _tmp20_;
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
		_tmp19_ = self->priv->_slot;
		_tmp20_ = *_tmp19_;
		gala_window_clone_take_slot (self, &_tmp20_, FALSE, FALSE);
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
		g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
	}
	_g_object_unref0 (actor);
}

static void
gala_window_clone_check_shadow_requirements (GalaWindowClone* self)
{
	ClutterClone* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MetaWindow* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->_window;
	g_object_get (_tmp2_, "fullscreen", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		MetaWindow* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->_window;
		g_object_get (_tmp6_, "maximized-horizontally", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			MetaWindow* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp9_ = self->priv->_window;
			g_object_get (_tmp9_, "maximized-vertically", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		GalaShadowEffect* _tmp12_;
		_tmp12_ = self->priv->shadow_effect;
		if (_tmp12_ == NULL) {
			MetaWindow* _tmp13_;
			GalaWindowCloneWindowShadowEffect* _tmp14_;
			ClutterClone* _tmp15_;
			GalaShadowEffect* _tmp16_;
			_tmp13_ = self->priv->_window;
			_tmp14_ = gala_window_clone_window_shadow_effect_new (_tmp13_, 40, 5);
			g_object_ref_sink (_tmp14_);
			_g_object_unref0 (self->priv->shadow_effect);
			self->priv->shadow_effect = (GalaShadowEffect*) _tmp14_;
			_tmp15_ = self->priv->clone;
			_tmp16_ = self->priv->shadow_effect;
			clutter_actor_add_effect_with_name ((ClutterActor*) _tmp15_, "shadow", (ClutterEffect*) _tmp16_);
		}
	} else {
		GalaShadowEffect* _tmp17_;
		_tmp17_ = self->priv->shadow_effect;
		if (_tmp17_ != NULL) {
			ClutterClone* _tmp18_;
			GalaShadowEffect* _tmp19_;
			_tmp18_ = self->priv->clone;
			_tmp19_ = self->priv->shadow_effect;
			clutter_actor_remove_effect ((ClutterActor*) _tmp18_, (ClutterEffect*) _tmp19_);
			_g_object_unref0 (self->priv->shadow_effect);
			self->priv->shadow_effect = NULL;
		}
	}
}

/**
     * If we are in overview mode, we may display windows from workspaces other than
     * the current one. To ease their appearance we have to fade them in.
     */
static gboolean
gala_window_clone_should_fade (GalaWindowClone* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->priv->_overview_mode;
	if (_tmp2_) {
		MetaWindow* _tmp3_;
		MetaWorkspace* _tmp4_;
		MetaWindow* _tmp5_;
		MetaDisplay* _tmp6_;
		MetaWorkspaceManager* _tmp7_;
		MetaWorkspace* _tmp8_;
		_tmp3_ = self->priv->_window;
		_tmp4_ = meta_window_get_workspace (_tmp3_);
		_tmp5_ = self->priv->_window;
		_tmp6_ = meta_window_get_display (_tmp5_);
		_tmp7_ = meta_display_get_workspace_manager (_tmp6_);
		_tmp8_ = meta_workspace_manager_get_active_workspace (_tmp7_);
		_tmp1_ = _tmp4_ != _tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		MetaWindow* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->_window;
		g_object_get (_tmp9_, "minimized", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_;
	}
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_on_all_workspaces_changed (GalaWindowClone* self)
{
	MetaWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	g_object_get (_tmp0_, "on-all-workspaces", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gala_window_clone_unmanaged (self);
	}
}

/**
     * Place the window at the location of the original MetaWindow
     *
     * @param animate Animate the transformation of the placement
     */
static Block66Data*
block66_data_ref (Block66Data* _data66_)
{
	g_atomic_int_inc (&_data66_->_ref_count_);
	return _data66_;
}

static void
block66_data_unref (void * _userdata_)
{
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data66_->self;
		_g_object_unref0 (self);
		g_slice_free (Block66Data, _data66_);
	}
}

static void
__lambda79_ (GalaWindowClone* self)
{
	ClutterActor* _tmp0_;
	_tmp0_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp0_, (guint) 0);
}

static void
___lambda79__gala_gesture_tracker_on_begin (gdouble percentage,
                                            gpointer self)
{
	__lambda79_ ((GalaWindowClone*) self);
}

static void
__lambda80_ (Block66Data* _data66_,
             gdouble percentage)
{
	GalaWindowClone* self;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat width = 0.0F;
	MetaRectangle _tmp0_;
	gfloat height = 0.0F;
	MetaRectangle _tmp1_;
	gfloat opacity = 0.0F;
	ClutterActor* _tmp2_;
	self = _data66_->self;
	x = gala_gesture_tracker_animation_value (_data66_->initial_x, (gfloat) _data66_->target_x, percentage, FALSE);
	y = gala_gesture_tracker_animation_value (_data66_->initial_y, (gfloat) _data66_->target_y, percentage, FALSE);
	_tmp0_ = _data66_->outer_rect;
	width = gala_gesture_tracker_animation_value (_data66_->initial_width, (gfloat) _tmp0_.width, percentage, FALSE);
	_tmp1_ = _data66_->outer_rect;
	height = gala_gesture_tracker_animation_value (_data66_->initial_height, (gfloat) _tmp1_.height, percentage, FALSE);
	opacity = gala_gesture_tracker_animation_value (255.f, 0.f, percentage, FALSE);
	clutter_actor_set_size ((ClutterActor*) self, width, height);
	clutter_actor_set_position ((ClutterActor*) self, x, y);
	_tmp2_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp2_, (guint) opacity);
	gala_window_clone_set_window_icon_position (self, width, height, FALSE);
}

static void
___lambda80__gala_gesture_tracker_on_update (gdouble percentage,
                                             gpointer self)
{
	__lambda80_ (self, percentage);
}

static void
___lambda82_ (Block66Data* _data66_)
{
	GalaWindowClone* self;
	MetaRectangle _tmp0_;
	MetaRectangle _tmp1_;
	self = _data66_->self;
	self->priv->in_slot_animation = FALSE;
	_tmp0_ = _data66_->outer_rect;
	_tmp1_ = _data66_->outer_rect;
	gala_window_clone_place_widgets (self, _tmp0_.width, _tmp1_.height);
}

static void
____lambda82__clutter_timeline_completed (ClutterTimeline* _sender,
                                          gpointer self)
{
	___lambda82_ (self);
}

static void
__lambda81_ (Block66Data* _data66_,
             gdouble percentage,
             gboolean cancel_action)
{
	GalaWindowClone* self;
	ClutterActor* _tmp0_;
	gint _tmp1_ = 0;
	MetaRectangle _tmp2_;
	MetaRectangle _tmp3_;
	ClutterActor* _tmp4_;
	MetaRectangle _tmp5_;
	MetaRectangle _tmp6_;
	ClutterTransition* transition = NULL;
	ClutterActor* _tmp7_;
	ClutterTransition* _tmp8_;
	ClutterTransition* _tmp9_;
	ClutterTransition* _tmp10_;
	self = _data66_->self;
	_tmp0_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp0_, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	if (cancel_action) {
		return;
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	if (_data66_->animate) {
		_tmp1_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp1_ = 0;
	}
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) _tmp1_);
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _data66_->target_x, (gfloat) _data66_->target_y);
	_tmp2_ = _data66_->outer_rect;
	_tmp3_ = _data66_->outer_rect;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp2_.width, (gfloat) _tmp3_.height);
	if (gala_window_clone_should_fade (self)) {
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	}
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	if (_data66_->animate) {
		gala_window_clone_toggle_shadow (self, FALSE);
	}
	_tmp4_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp4_, (guint) 0);
	_tmp5_ = _data66_->outer_rect;
	_tmp6_ = _data66_->outer_rect;
	gala_window_clone_set_window_icon_position (self, (gfloat) _tmp5_.width, (gfloat) _tmp6_.height, TRUE);
	_tmp7_ = self->priv->window_icon;
	_tmp8_ = clutter_actor_get_transition (_tmp7_, "opacity");
	_tmp9_ = _g_object_ref0 (_tmp8_);
	transition = _tmp9_;
	_tmp10_ = transition;
	if (_tmp10_ != NULL) {
		ClutterTransition* _tmp11_;
		_tmp11_ = transition;
		g_signal_connect_data ((ClutterTimeline*) _tmp11_, "completed", (GCallback) ____lambda82__clutter_timeline_completed, block66_data_ref (_data66_), (GClosureNotify) block66_data_unref, 0);
	} else {
		MetaRectangle _tmp12_;
		MetaRectangle _tmp13_;
		self->priv->in_slot_animation = FALSE;
		_tmp12_ = _data66_->outer_rect;
		_tmp13_ = _data66_->outer_rect;
		gala_window_clone_place_widgets (self, _tmp12_.width, _tmp13_.height);
	}
	_g_object_unref0 (transition);
}

static void
___lambda81__gala_gesture_tracker_on_end (gdouble percentage,
                                          gboolean cancel_action,
                                          gint calculated_duration,
                                          gpointer self)
{
	__lambda81_ (self, percentage, cancel_action);
}

void
gala_window_clone_transition_to_original_state (GalaWindowClone* self,
                                                gboolean animate,
                                                gboolean with_gesture,
                                                gboolean is_cancel_animation)
{
	Block66Data* _data66_;
	MetaWindow* _tmp0_;
	MetaRectangle _tmp1_ = {0};
	MetaRectangle monitor_geom = {0};
	MetaWindow* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWindow* _tmp4_;
	MetaRectangle _tmp5_ = {0};
	gint offset_x = 0;
	MetaRectangle _tmp6_;
	gint offset_y = 0;
	MetaRectangle _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	MetaRectangle _tmp16_;
	MetaRectangle _tmp17_;
	MetaRectangle _tmp18_;
	MetaRectangle _tmp19_;
	GalaGestureTrackerOnBegin on_animation_begin = NULL;
	gpointer on_animation_begin_target;
	GDestroyNotify on_animation_begin_target_destroy_notify;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	_data66_ = g_slice_new0 (Block66Data);
	_data66_->_ref_count_ = 1;
	_data66_->self = g_object_ref (self);
	_data66_->animate = animate;
	_tmp0_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp0_, &_tmp1_);
	_data66_->outer_rect = _tmp1_;
	_tmp2_ = self->priv->_window;
	_tmp3_ = meta_window_get_display (_tmp2_);
	_tmp4_ = self->priv->_window;
	meta_display_get_monitor_geometry (_tmp3_, meta_window_get_monitor (_tmp4_), &_tmp5_);
	monitor_geom = _tmp5_;
	_tmp6_ = monitor_geom;
	offset_x = _tmp6_.x;
	_tmp7_ = monitor_geom;
	offset_y = _tmp7_.y;
	_tmp8_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp9_ = _tmp8_;
	_data66_->initial_x = _tmp9_;
	_tmp10_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp11_ = _tmp10_;
	_data66_->initial_y = _tmp11_;
	_tmp12_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp13_ = _tmp12_;
	_data66_->initial_width = _tmp13_;
	_tmp14_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp15_ = _tmp14_;
	_data66_->initial_height = _tmp15_;
	_tmp16_ = _data66_->outer_rect;
	_data66_->target_x = _tmp16_.x - offset_x;
	_tmp17_ = _data66_->outer_rect;
	_data66_->target_y = _tmp17_.y - offset_y;
	self->priv->in_slot_animation = TRUE;
	_tmp18_ = _data66_->outer_rect;
	_tmp19_ = _data66_->outer_rect;
	gala_window_clone_place_widgets (self, _tmp18_.width, _tmp19_.height);
	on_animation_begin = ___lambda79__gala_gesture_tracker_on_begin;
	on_animation_begin_target = g_object_ref (self);
	on_animation_begin_target_destroy_notify = g_object_unref;
	on_animation_update = ___lambda80__gala_gesture_tracker_on_update;
	on_animation_update_target = block66_data_ref (_data66_);
	on_animation_update_target_destroy_notify = block66_data_unref;
	on_animation_end = ___lambda81__gala_gesture_tracker_on_end;
	on_animation_end_target = block66_data_ref (_data66_);
	on_animation_end_target_destroy_notify = block66_data_unref;
	if (!_data66_->animate) {
		_tmp21_ = TRUE;
	} else {
		GalaGestureTracker* _tmp22_;
		_tmp22_ = self->priv->_gesture_tracker;
		_tmp21_ = _tmp22_ == NULL;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = !with_gesture;
	}
	if (_tmp20_) {
		GalaGestureTrackerOnBegin _tmp23_;
		gpointer _tmp23__target;
		GalaGestureTrackerOnEnd _tmp24_;
		gpointer _tmp24__target;
		_tmp23_ = on_animation_begin;
		_tmp23__target = on_animation_begin_target;
		_tmp23_ ((gdouble) 0, _tmp23__target);
		_tmp24_ = on_animation_end;
		_tmp24__target = on_animation_end_target;
		_tmp24_ ((gdouble) 1, FALSE, 0, _tmp24__target);
	} else {
		GalaGestureTracker* _tmp25_;
		GalaGestureTrackerOnBegin _tmp26_;
		gpointer _tmp26__target;
		GDestroyNotify _tmp26__target_destroy_notify;
		GalaGestureTrackerOnUpdate _tmp27_;
		gpointer _tmp27__target;
		GDestroyNotify _tmp27__target_destroy_notify;
		GalaGestureTrackerOnEnd _tmp28_;
		gpointer _tmp28__target;
		GDestroyNotify _tmp28__target_destroy_notify;
		_tmp25_ = self->priv->_gesture_tracker;
		_tmp26_ = on_animation_begin;
		_tmp26__target = on_animation_begin_target;
		_tmp26__target_destroy_notify = on_animation_begin_target_destroy_notify;
		on_animation_begin = NULL;
		on_animation_begin_target = NULL;
		on_animation_begin_target_destroy_notify = NULL;
		_tmp27_ = on_animation_update;
		_tmp27__target = on_animation_update_target;
		_tmp27__target_destroy_notify = on_animation_update_target_destroy_notify;
		on_animation_update = NULL;
		on_animation_update_target = NULL;
		on_animation_update_target_destroy_notify = NULL;
		_tmp28_ = on_animation_end;
		_tmp28__target = on_animation_end_target;
		_tmp28__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp25_, _tmp26_, _tmp26__target, _tmp26__target_destroy_notify, _tmp27_, _tmp27__target, _tmp27__target_destroy_notify, _tmp28_, _tmp28__target, _tmp28__target_destroy_notify);
	}
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	(on_animation_begin_target_destroy_notify == NULL) ? NULL : (on_animation_begin_target_destroy_notify (on_animation_begin_target), NULL);
	on_animation_begin = NULL;
	on_animation_begin_target = NULL;
	on_animation_begin_target_destroy_notify = NULL;
	block66_data_unref (_data66_);
	_data66_ = NULL;
}

/**
     * Animate the window to the given slot
     */
static Block67Data*
block67_data_ref (Block67Data* _data67_)
{
	g_atomic_int_inc (&_data67_->_ref_count_);
	return _data67_;
}

static void
block67_data_unref (void * _userdata_)
{
	Block67Data* _data67_;
	_data67_ = (Block67Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data67_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data67_->self;
		_g_object_unref0 (self);
		g_slice_free (Block67Data, _data67_);
	}
}

static void
__lambda83_ (Block67Data* _data67_,
             gdouble percentage)
{
	GalaWindowClone* self;
	gfloat x = 0.0F;
	MetaRectangle _tmp0_;
	gfloat y = 0.0F;
	MetaRectangle _tmp1_;
	gfloat width = 0.0F;
	MetaRectangle _tmp2_;
	gfloat height = 0.0F;
	MetaRectangle _tmp3_;
	gfloat opacity = 0.0F;
	ClutterActor* _tmp4_;
	self = _data67_->self;
	_tmp0_ = _data67_->rect;
	x = gala_gesture_tracker_animation_value (_data67_->initial_x, (gfloat) _tmp0_.x, percentage, FALSE);
	_tmp1_ = _data67_->rect;
	y = gala_gesture_tracker_animation_value (_data67_->initial_y, (gfloat) _tmp1_.y, percentage, FALSE);
	_tmp2_ = _data67_->rect;
	width = gala_gesture_tracker_animation_value (_data67_->initial_width, (gfloat) _tmp2_.width, percentage, FALSE);
	_tmp3_ = _data67_->rect;
	height = gala_gesture_tracker_animation_value (_data67_->initial_height, (gfloat) _tmp3_.height, percentage, FALSE);
	opacity = gala_gesture_tracker_animation_value (0.f, 255.f, percentage, FALSE);
	clutter_actor_set_size ((ClutterActor*) self, width, height);
	clutter_actor_set_position ((ClutterActor*) self, x, y);
	_tmp4_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp4_, (guint) opacity);
	gala_window_clone_set_window_icon_position (self, width, height, FALSE);
}

static void
___lambda83__gala_gesture_tracker_on_update (gdouble percentage,
                                             gpointer self)
{
	__lambda83_ (self, percentage);
}

static void
__lambda85_ (Block67Data* _data67_)
{
	GalaWindowClone* self;
	MetaRectangle _tmp0_;
	MetaRectangle _tmp1_;
	self = _data67_->self;
	self->priv->in_slot_animation = FALSE;
	_tmp0_ = _data67_->rect;
	_tmp1_ = _data67_->rect;
	gala_window_clone_place_widgets (self, _tmp0_.width, _tmp1_.height);
}

static void
___lambda85__clutter_timeline_completed (ClutterTimeline* _sender,
                                         gpointer self)
{
	__lambda85_ (self);
}

static void
__lambda84_ (Block67Data* _data67_,
             gdouble percentage,
             gboolean cancel_action)
{
	GalaWindowClone* self;
	ClutterActor* _tmp0_;
	MetaRectangle _tmp1_;
	MetaRectangle _tmp2_;
	MetaRectangle _tmp3_;
	MetaRectangle _tmp4_;
	ClutterActor* _tmp5_;
	MetaRectangle _tmp6_;
	MetaRectangle _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	ClutterActor* _tmp10_;
	ClutterTransition* _tmp11_;
	self = _data67_->self;
	_tmp0_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp0_, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	if (cancel_action) {
		return;
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	_tmp1_ = _data67_->rect;
	_tmp2_ = _data67_->rect;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp1_.width, (gfloat) _tmp2_.height);
	_tmp3_ = _data67_->rect;
	_tmp4_ = _data67_->rect;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp3_.x, (gfloat) _tmp4_.y);
	_tmp5_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp5_, (guint) 255);
	_tmp6_ = _data67_->rect;
	_tmp7_ = _data67_->rect;
	gala_window_clone_set_window_icon_position (self, (gfloat) _tmp6_.width, (gfloat) _tmp7_.height, TRUE);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	gala_window_clone_toggle_shadow (self, TRUE);
	_tmp8_ = clutter_actor_get_opacity ((ClutterActor*) self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ < ((guint) 255)) {
		clutter_actor_save_easing_state ((ClutterActor*) self);
		clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
		clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 300);
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
		clutter_actor_restore_easing_state ((ClutterActor*) self);
	}
	_tmp10_ = self->priv->window_icon;
	_tmp11_ = clutter_actor_get_transition (_tmp10_, "opacity");
	g_signal_connect_data ((ClutterTimeline*) _tmp11_, "completed", (GCallback) ___lambda85__clutter_timeline_completed, block67_data_ref (_data67_), (GClosureNotify) block67_data_unref, 0);
}

static void
___lambda84__gala_gesture_tracker_on_end (gdouble percentage,
                                          gboolean cancel_action,
                                          gint calculated_duration,
                                          gpointer self)
{
	__lambda84_ (self, percentage, cancel_action);
}

void
gala_window_clone_take_slot (GalaWindowClone* self,
                             MetaRectangle* rect,
                             gboolean with_gesture,
                             gboolean is_cancel_animation)
{
	Block67Data* _data67_;
	MetaRectangle _tmp0_;
	MetaRectangle _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	MetaRectangle _tmp12_;
	MetaRectangle _tmp13_;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	gboolean _tmp14_ = FALSE;
	GalaGestureTracker* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rect != NULL);
	_data67_ = g_slice_new0 (Block67Data);
	_data67_->_ref_count_ = 1;
	_data67_->self = g_object_ref (self);
	_tmp0_ = *rect;
	_data67_->rect = _tmp0_;
	_tmp1_ = _data67_->rect;
	gala_window_clone_set_slot (self, &_tmp1_);
	_tmp2_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp3_ = _tmp2_;
	_data67_->initial_x = _tmp3_;
	_tmp4_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp5_ = _tmp4_;
	_data67_->initial_y = _tmp5_;
	_tmp6_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp7_ = _tmp6_;
	_data67_->initial_width = _tmp7_;
	_tmp8_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp9_ = _tmp8_;
	_data67_->initial_height = _tmp9_;
	_tmp10_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp10_, (guint) 0);
	_tmp11_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp11_, (guint) 0);
	self->priv->in_slot_animation = TRUE;
	_tmp12_ = _data67_->rect;
	_tmp13_ = _data67_->rect;
	gala_window_clone_place_widgets (self, _tmp12_.width, _tmp13_.height);
	on_animation_update = ___lambda83__gala_gesture_tracker_on_update;
	on_animation_update_target = block67_data_ref (_data67_);
	on_animation_update_target_destroy_notify = block67_data_unref;
	on_animation_end = ___lambda84__gala_gesture_tracker_on_end;
	on_animation_end_target = block67_data_ref (_data67_);
	on_animation_end_target_destroy_notify = block67_data_unref;
	_tmp15_ = self->priv->_gesture_tracker;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = !with_gesture;
	}
	if (_tmp14_) {
		GalaGestureTrackerOnEnd _tmp16_;
		gpointer _tmp16__target;
		_tmp16_ = on_animation_end;
		_tmp16__target = on_animation_end_target;
		_tmp16_ ((gdouble) 1, FALSE, 0, _tmp16__target);
	} else {
		GalaGestureTracker* _tmp17_;
		GalaGestureTrackerOnUpdate _tmp18_;
		gpointer _tmp18__target;
		GDestroyNotify _tmp18__target_destroy_notify;
		GalaGestureTrackerOnEnd _tmp19_;
		gpointer _tmp19__target;
		GDestroyNotify _tmp19__target_destroy_notify;
		_tmp17_ = self->priv->_gesture_tracker;
		_tmp18_ = on_animation_update;
		_tmp18__target = on_animation_update_target;
		_tmp18__target_destroy_notify = on_animation_update_target_destroy_notify;
		on_animation_update = NULL;
		on_animation_update_target = NULL;
		on_animation_update_target_destroy_notify = NULL;
		_tmp19_ = on_animation_end;
		_tmp19__target = on_animation_end_target;
		_tmp19__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp17_, NULL, NULL, NULL, _tmp18_, _tmp18__target, _tmp18__target_destroy_notify, _tmp19_, _tmp19__target, _tmp19__target_destroy_notify);
	}
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	block67_data_unref (_data67_);
	_data67_ = NULL;
}

/**
     * Except for the texture clone and the highlight all children are placed
     * according to their given allocations. The first two are placed in a way
     * that compensates for invisible borders of the texture.
     */
static void
gala_window_clone_real_allocate (ClutterActor* base,
                                 ClutterActorBox* box)
{
	GalaWindowClone * self;
	ClutterActorBox _tmp0_;
	GList* _tmp1_;
	ClutterActorBox shape_alloc = {0};
	ClutterActorBox _tmp14_ = {0};
	GalaWindowCloneActiveShape* _tmp15_;
	ClutterActorBox _tmp16_;
	gboolean _tmp17_ = FALSE;
	ClutterClone* _tmp18_;
	MetaWindowActor* actor = NULL;
	MetaWindow* _tmp20_;
	GObject* _tmp21_;
	MetaWindowActor* _tmp22_;
	MetaRectangle input_rect = {0};
	MetaWindow* _tmp23_;
	MetaRectangle _tmp24_ = {0};
	MetaRectangle outer_rect = {0};
	MetaWindow* _tmp25_;
	MetaRectangle _tmp26_ = {0};
	gfloat scale_factor = 0.0F;
	gfloat _tmp27_;
	gfloat _tmp28_;
	MetaRectangle _tmp29_;
	ClutterActorBox alloc = {0};
	ClutterActorBox _tmp30_ = {0};
	MetaRectangle _tmp31_;
	MetaRectangle _tmp32_;
	MetaRectangle _tmp33_;
	MetaRectangle _tmp34_;
	MetaWindowActor* _tmp35_;
	gfloat _tmp36_;
	gfloat _tmp37_;
	MetaWindowActor* _tmp38_;
	gfloat _tmp39_;
	gfloat _tmp40_;
	ClutterClone* _tmp41_;
	ClutterActorBox _tmp42_;
	self = (GalaWindowClone*) base;
	g_return_if_fail (box != NULL);
	_tmp0_ = *box;
	CLUTTER_ACTOR_CLASS (gala_window_clone_parent_class)->allocate (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), &_tmp0_);
	_tmp1_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				gboolean _tmp2_ = FALSE;
				ClutterActor* _tmp3_;
				ClutterClone* _tmp4_;
				_tmp3_ = child;
				_tmp4_ = self->priv->clone;
				if (_tmp3_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, clutter_actor_get_type (), ClutterActor)) {
					ClutterActor* _tmp5_;
					GalaWindowCloneActiveShape* _tmp6_;
					_tmp5_ = child;
					_tmp6_ = self->priv->active_shape;
					_tmp2_ = _tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, clutter_actor_get_type (), ClutterActor);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					ClutterActor* _tmp7_;
					ClutterActor* _tmp8_;
					gfloat _tmp9_;
					gfloat _tmp10_;
					ClutterActor* _tmp11_;
					gfloat _tmp12_;
					gfloat _tmp13_;
					_tmp7_ = child;
					_tmp8_ = child;
					g_object_get (_tmp8_, "fixed-x", &_tmp9_, NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = child;
					g_object_get (_tmp11_, "fixed-y", &_tmp12_, NULL);
					_tmp13_ = _tmp12_;
					clutter_actor_allocate_preferred_size (_tmp7_, _tmp10_, _tmp13_);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp14_.x1 = (gfloat) (-GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE);
	_tmp14_.y1 = (gfloat) (-GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE);
	_tmp14_.x2 = clutter_actor_box_get_width (box) + GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE;
	_tmp14_.y2 = clutter_actor_box_get_height (box) + GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE;
	shape_alloc = _tmp14_;
	_tmp15_ = self->priv->active_shape;
	_tmp16_ = shape_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp15_, &_tmp16_);
	_tmp18_ = self->priv->clone;
	if (_tmp18_ == NULL) {
		_tmp17_ = TRUE;
	} else {
		gboolean _tmp19_;
		_tmp19_ = self->priv->_dragging;
		_tmp17_ = _tmp19_;
	}
	if (_tmp17_) {
		return;
	}
	_tmp20_ = self->priv->_window;
	_tmp21_ = meta_window_get_compositor_private (_tmp20_);
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, meta_window_actor_get_type (), MetaWindowActor));
	actor = _tmp22_;
	_tmp23_ = self->priv->_window;
	meta_window_get_buffer_rect (_tmp23_, &_tmp24_);
	input_rect = _tmp24_;
	_tmp25_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp25_, &_tmp26_);
	outer_rect = _tmp26_;
	_tmp27_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp28_ = _tmp27_;
	_tmp29_ = outer_rect;
	scale_factor = ((gfloat) _tmp28_) / _tmp29_.width;
	alloc = _tmp30_;
	_tmp31_ = input_rect;
	_tmp32_ = outer_rect;
	_tmp33_ = input_rect;
	_tmp34_ = outer_rect;
	clutter_actor_box_set_origin (&alloc, (_tmp31_.x - _tmp32_.x) * scale_factor, (_tmp33_.y - _tmp34_.y) * scale_factor);
	_tmp35_ = actor;
	_tmp36_ = clutter_actor_get_width ((ClutterActor*) _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = actor;
	_tmp39_ = clutter_actor_get_height ((ClutterActor*) _tmp38_);
	_tmp40_ = _tmp39_;
	clutter_actor_box_set_size (&alloc, _tmp37_ * scale_factor, _tmp40_ * scale_factor);
	_tmp41_ = self->priv->clone;
	_tmp42_ = alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp41_, &_tmp42_);
	_g_object_unref0 (actor);
}

static gboolean
gala_window_clone_real_button_press_event (ClutterActor* base,
                                           ClutterButtonEvent* event)
{
	GalaWindowClone * self;
	gboolean result;
	self = (GalaWindowClone*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	result = TRUE;
	return result;
}

static gboolean
gala_window_clone_real_enter_event (ClutterActor* base,
                                    ClutterCrossingEvent* event)
{
	GalaWindowClone * self;
	GalaDragDropAction* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_ = 0;
	ClutterActor* _tmp4_;
	gint _tmp5_ = 0;
	GalaTooltip* _tmp6_;
	gboolean result;
	self = (GalaWindowClone*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->drag_action;
	_tmp1_ = gala_drag_drop_action_get_dragging (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	if (self->priv->in_slot_animation) {
		_tmp3_ = 0;
	} else {
		_tmp3_ = 255;
	}
	_tmp4_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp4_, (guint) _tmp3_);
	if (self->priv->in_slot_animation) {
		_tmp5_ = 0;
	} else {
		_tmp5_ = 255;
	}
	_tmp6_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp6_, (guint) _tmp5_);
	result = FALSE;
	return result;
}

static gboolean
gala_window_clone_real_leave_event (ClutterActor* base,
                                    ClutterCrossingEvent* event)
{
	GalaWindowClone * self;
	ClutterActor* _tmp0_;
	GalaTooltip* _tmp1_;
	gboolean result;
	self = (GalaWindowClone*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp0_, (guint) 0);
	_tmp1_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp1_, (guint) 0);
	result = FALSE;
	return result;
}

/**
     * Place the widgets, that is the close button and the WindowIcon of the window,
     * at their positions inside the actor for a given width and height.
     */
void
gala_window_clone_place_widgets (GalaWindowClone* self,
                                 gint dest_width,
                                 gint dest_height)
{
	gint scale_factor = 0;
	ClutterActor* _tmp0_;
	GalaTooltip* _tmp1_;
	ClutterActor* _tmp2_;
	GalaTooltip* _tmp3_;
	gint close_button_size = 0;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_ = 0.0F;
	ClutterActor* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean show = FALSE;
	gint _tmp20_ = 0;
	ClutterActor* _tmp21_;
	GalaTooltip* _tmp22_;
	ClutterActor* _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	const gchar* _tmp26_ = NULL;
	MetaWindow* _tmp27_;
	const gchar* _tmp28_;
	GalaTooltip* _tmp29_;
	GalaTooltip* _tmp30_;
	ClutterActor* _tmp31_;
	GalaTooltip* _tmp32_;
	g_return_if_fail (self != NULL);
	scale_factor = gala_internal_utils_get_ui_scaling_factor ();
	_tmp0_ = self->priv->close_button;
	clutter_actor_save_easing_state (_tmp0_);
	_tmp1_ = self->priv->window_title;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp1_);
	_tmp2_ = self->priv->close_button;
	clutter_actor_set_easing_duration (_tmp2_, (guint) 0);
	_tmp3_ = self->priv->window_title;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp3_, (guint) 0);
	close_button_size = GALA_WINDOW_CLONE_CLOSE_WINDOW_ICON_SIZE * scale_factor;
	_tmp4_ = self->priv->close_button;
	clutter_actor_set_size (_tmp4_, (gfloat) close_button_size, (gfloat) close_button_size);
	_tmp5_ = self->priv->close_button;
	_tmp6_ = self->priv->close_button;
	_tmp7_ = clutter_actor_get_height (_tmp6_);
	_tmp8_ = _tmp7_;
	clutter_actor_set_y (_tmp5_, (-_tmp8_) * 0.33f);
	if (gala_window_clone_is_close_button_on_left ()) {
		ClutterActor* _tmp10_;
		gfloat _tmp11_;
		gfloat _tmp12_;
		_tmp10_ = self->priv->close_button;
		_tmp11_ = clutter_actor_get_width (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp9_ = (-_tmp12_) * 0.5f;
	} else {
		ClutterActor* _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		_tmp13_ = self->priv->close_button;
		_tmp14_ = clutter_actor_get_width (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp9_ = dest_width - (_tmp15_ * 0.5f);
	}
	_tmp16_ = self->priv->close_button;
	clutter_actor_set_x (_tmp16_, _tmp9_);
	g_object_get ((ClutterActor*) self, "has-pointer", &_tmp18_, NULL);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		_tmp17_ = !self->priv->in_slot_animation;
	} else {
		_tmp17_ = FALSE;
	}
	show = _tmp17_;
	if (show) {
		_tmp20_ = 255;
	} else {
		_tmp20_ = 0;
	}
	_tmp21_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp21_, (guint) _tmp20_);
	_tmp22_ = self->priv->window_title;
	_tmp23_ = self->priv->close_button;
	_tmp24_ = clutter_actor_get_opacity (_tmp23_);
	_tmp25_ = _tmp24_;
	clutter_actor_set_opacity ((ClutterActor*) _tmp22_, _tmp25_);
	_tmp27_ = self->priv->_window;
	_tmp28_ = meta_window_get_title (_tmp27_);
	_tmp26_ = _tmp28_;
	if (_tmp26_ == NULL) {
		_tmp26_ = "";
	}
	_tmp29_ = self->priv->window_title;
	gala_tooltip_set_text (_tmp29_, _tmp26_, FALSE);
	_tmp30_ = self->priv->window_title;
	gala_tooltip_set_max_width (_tmp30_, (gfloat) (dest_width - (GALA_WINDOW_CLONE_TITLE_MAX_WIDTH_MARGIN * scale_factor)), TRUE);
	gala_window_clone_set_window_title_position (self, (gfloat) dest_width, (gfloat) dest_height);
	_tmp31_ = self->priv->close_button;
	clutter_actor_restore_easing_state (_tmp31_);
	_tmp32_ = self->priv->window_title;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp32_);
}

static void
gala_window_clone_toggle_shadow (GalaWindowClone* self,
                                 gboolean show)
{
	ClutterTransition* _tmp0_;
	ClutterPropertyTransition* shadow_transition = NULL;
	ClutterPropertyTransition* _tmp1_ = NULL;
	ClutterPropertyTransition* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_transition ((ClutterActor*) self, "shadow-opacity");
	if (_tmp0_ != NULL) {
		clutter_actor_remove_transition ((ClutterActor*) self, "shadow-opacity");
	}
	_tmp1_ = (ClutterPropertyTransition*) clutter_property_transition_new ("shadow-opacity");
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp1_, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp1_, TRUE);
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp1_, CLUTTER_EASE_OUT_QUAD);
	shadow_transition = _tmp1_;
	if (show) {
		ClutterPropertyTransition* _tmp2_;
		guint8 _tmp3_;
		guint8 _tmp4_;
		ClutterInterval* _tmp5_;
		ClutterInterval* _tmp6_;
		_tmp2_ = shadow_transition;
		_tmp3_ = gala_window_clone_get_shadow_opacity (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = clutter_interval_new (G_TYPE_UCHAR, _tmp4_, 255, NULL);
		g_object_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		clutter_transition_set_interval ((ClutterTransition*) _tmp2_, _tmp6_);
		_g_object_unref0 (_tmp6_);
	} else {
		ClutterPropertyTransition* _tmp7_;
		guint8 _tmp8_;
		guint8 _tmp9_;
		ClutterInterval* _tmp10_;
		ClutterInterval* _tmp11_;
		_tmp7_ = shadow_transition;
		_tmp8_ = gala_window_clone_get_shadow_opacity (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = clutter_interval_new (G_TYPE_UCHAR, _tmp9_, 0, NULL);
		g_object_ref_sink (_tmp10_);
		_tmp11_ = _tmp10_;
		clutter_transition_set_interval ((ClutterTransition*) _tmp7_, _tmp11_);
		_g_object_unref0 (_tmp11_);
	}
	_tmp12_ = shadow_transition;
	clutter_actor_add_transition ((ClutterActor*) self, "shadow-opacity", (ClutterTransition*) _tmp12_);
	_g_object_unref0 (shadow_transition);
}

/**
     * Send the window the delete signal and listen for new windows to be added
     * to the window's workspace, in which case we check if the new window is a
     * dialog of the window we were going to delete. If that's the case, we request
     * to select our window.
     */
static void
_gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                             gint object,
                                                                             MetaWindow* p0,
                                                                             gpointer self)
{
	gala_window_clone_check_confirm_dialog ((GalaWindowClone*) self, object, p0);
}

static void
gala_window_clone_close_window (GalaWindowClone* self)
{
	MetaDisplay* display = NULL;
	MetaWindow* _tmp0_;
	MetaDisplay* _tmp1_;
	gulong _tmp2_;
	MetaWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = g_signal_connect_object (display, "window-entered-monitor", (GCallback) _gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor, self, 0);
	self->priv->check_confirm_dialog_cb = _tmp2_;
	_tmp3_ = self->priv->_window;
	meta_window_delete (_tmp3_, meta_display_get_current_time (display));
}

static gboolean
___lambda86_ (GalaWindowClone* self)
{
	gboolean result;
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
____lambda86__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda86_ ((GalaWindowClone*) self);
	return result;
}

static void
gala_window_clone_check_confirm_dialog (GalaWindowClone* self,
                                        gint monitor,
                                        MetaWindow* new_window)
{
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_window != NULL);
	_tmp0_ = meta_window_get_transient_for (new_window);
	_tmp1_ = self->priv->_window;
	if (_tmp0_ == _tmp1_) {
		MetaWindow* _tmp2_;
		MetaDisplay* _tmp3_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda86__gsource_func, g_object_ref (self), g_object_unref);
		_tmp2_ = self->priv->_window;
		_tmp3_ = meta_window_get_display (_tmp2_);
		g_signal_handler_disconnect (_tmp3_, self->priv->check_confirm_dialog_cb);
		self->priv->check_confirm_dialog_cb = (gulong) 0;
	}
}

/**
     * The window unmanaged by the compositor, so we need to destroy ourselves too.
     */
static void
gala_window_clone_unmanaged (GalaWindowClone* self)
{
	gboolean _tmp0_ = FALSE;
	GalaDragDropAction* _tmp1_;
	ClutterClone* _tmp6_;
	g_return_if_fail (self != NULL);
	clutter_actor_remove_all_transitions ((ClutterActor*) self);
	_tmp1_ = self->priv->drag_action;
	if (_tmp1_ != NULL) {
		GalaDragDropAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->drag_action;
		_tmp3_ = gala_drag_drop_action_get_dragging (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GalaDragDropAction* _tmp5_;
		_tmp5_ = self->priv->drag_action;
		gala_drag_drop_action_cancel (_tmp5_);
	}
	_tmp6_ = self->priv->clone;
	if (_tmp6_ != NULL) {
		ClutterClone* _tmp7_;
		_tmp7_ = self->priv->clone;
		clutter_actor_destroy ((ClutterActor*) _tmp7_);
	}
	if (self->priv->check_confirm_dialog_cb != ((gulong) 0)) {
		MetaWindow* _tmp8_;
		MetaDisplay* _tmp9_;
		_tmp8_ = self->priv->_window;
		_tmp9_ = meta_window_get_display (_tmp8_);
		g_signal_handler_disconnect (_tmp9_, self->priv->check_confirm_dialog_cb);
		self->priv->check_confirm_dialog_cb = (gulong) 0;
	}
	if (self->priv->shadow_update_timeout != ((guint) 0)) {
		g_source_remove (self->priv->shadow_update_timeout);
		self->priv->shadow_update_timeout = (guint) 0;
	}
	clutter_actor_destroy ((ClutterActor*) self);
}

static void
gala_window_clone_actor_clicked (GalaWindowClone* self,
                                 guint32 button)
{
	g_return_if_fail (self != NULL);
	switch (button) {
		case 1:
		{
			g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL], 0);
			break;
		}
		case 2:
		{
			gala_window_clone_close_window (self);
			break;
		}
		default:
		break;
	}
}

/**
     * A drag action has been initiated on us, we reparent ourselves to the stage so
     * we can move freely, scale ourselves to a smaller scale and request that the
     * position we just freed is immediately filled by the WindowCloneContainer.
     */
static ClutterActor*
gala_window_clone_drag_begin (GalaWindowClone* self,
                              gfloat click_x,
                              gfloat click_y)
{
	gfloat abs_x = 0.0F;
	gfloat abs_y = 0.0F;
	gfloat prev_parent_x = 0.0F;
	gfloat prev_parent_y = 0.0F;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	ClutterActor* _tmp5_;
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	ClutterStage* stage = NULL;
	ClutterStage* _tmp8_;
	ClutterStage* _tmp9_;
	ClutterActor* _tmp10_;
	GalaWindowCloneActiveShape* _tmp11_;
	gfloat scale = 0.0F;
	ClutterActor* _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	ClutterClone* _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	ClutterClone* _tmp18_;
	gfloat _tmp19_ = 0.0F;
	gfloat _tmp20_ = 0.0F;
	ClutterClone* _tmp21_;
	ClutterClone* _tmp22_;
	ClutterClone* _tmp23_;
	ClutterClone* _tmp24_;
	ClutterClone* _tmp25_;
	ClutterClone* _tmp26_;
	ClutterClone* _tmp27_;
	gfloat _tmp28_;
	gfloat _tmp29_;
	ClutterClone* _tmp30_;
	gfloat _tmp31_;
	gfloat _tmp32_;
	ClutterClone* _tmp33_;
	gfloat _tmp34_ = 0.0F;
	gfloat _tmp35_ = 0.0F;
	ClutterActor* _tmp36_;
	ClutterActor* _tmp37_;
	ClutterActor* _tmp38_;
	ClutterActor* _tmp39_;
	ClutterActor* _tmp40_;
	gfloat _tmp41_;
	gfloat _tmp42_;
	ClutterActor* _tmp43_;
	gfloat _tmp44_;
	gfloat _tmp45_;
	ClutterActor* _tmp46_;
	ClutterActor* _tmp47_;
	GalaTooltip* _tmp48_;
	ClutterActor* _tmp49_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->prev_parent);
	self->priv->prev_parent = _tmp1_;
	_tmp2_ = self->priv->prev_parent;
	_tmp3_ = clutter_actor_get_children (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->prev_index = g_list_index (_tmp4_, (ClutterActor*) self);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
	_tmp5_ = self->priv->prev_parent;
	clutter_actor_get_transformed_position (_tmp5_, &_tmp6_, &_tmp7_);
	prev_parent_x = _tmp6_;
	prev_parent_y = _tmp7_;
	_tmp8_ = clutter_actor_get_stage ((ClutterActor*) self);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	stage = _tmp9_;
	_tmp10_ = self->priv->prev_parent;
	clutter_actor_remove_child (_tmp10_, (ClutterActor*) self);
	clutter_actor_add_child ((ClutterActor*) stage, (ClutterActor*) self);
	_tmp11_ = self->priv->active_shape;
	clutter_actor_hide ((ClutterActor*) _tmp11_);
	_tmp12_ = self->priv->window_icon;
	_tmp13_ = clutter_actor_get_width (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->clone;
	_tmp16_ = clutter_actor_get_width ((ClutterActor*) _tmp15_);
	_tmp17_ = _tmp16_;
	scale = _tmp14_ / _tmp17_;
	_tmp18_ = self->priv->clone;
	clutter_actor_get_transformed_position ((ClutterActor*) _tmp18_, &_tmp19_, &_tmp20_);
	abs_x = _tmp19_;
	abs_y = _tmp20_;
	_tmp21_ = self->priv->clone;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp21_);
	_tmp22_ = self->priv->clone;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp22_, (guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION);
	_tmp23_ = self->priv->clone;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp23_, CLUTTER_EASE_IN_CUBIC);
	_tmp24_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp24_, (gdouble) scale, (gdouble) scale);
	_tmp25_ = self->priv->clone;
	clutter_actor_set_opacity ((ClutterActor*) _tmp25_, (guint) 0);
	_tmp26_ = self->priv->clone;
	_tmp27_ = self->priv->clone;
	_tmp28_ = clutter_actor_get_width ((ClutterActor*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->clone;
	_tmp31_ = clutter_actor_get_height ((ClutterActor*) _tmp30_);
	_tmp32_ = _tmp31_;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp26_, (click_x - abs_x) / _tmp29_, (click_y - abs_y) / _tmp32_);
	_tmp33_ = self->priv->clone;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp33_);
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
	clutter_actor_get_transformed_position ((ClutterActor*) self, &_tmp34_, &_tmp35_);
	abs_x = _tmp34_;
	abs_y = _tmp35_;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 0);
	clutter_actor_set_position ((ClutterActor*) self, abs_x + prev_parent_x, abs_y + prev_parent_y);
	_tmp36_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp36_);
	_tmp37_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp37_, (guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION);
	_tmp38_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp38_, CLUTTER_EASE_IN_OUT_CUBIC);
	_tmp39_ = self->priv->window_icon;
	_tmp40_ = self->priv->window_icon;
	_tmp41_ = clutter_actor_get_width (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = self->priv->window_icon;
	_tmp44_ = clutter_actor_get_height (_tmp43_);
	_tmp45_ = _tmp44_;
	clutter_actor_set_position (_tmp39_, (click_x - (abs_x + prev_parent_x)) - (_tmp42_ / 2), (click_y - (abs_y + prev_parent_y)) - (_tmp45_ / 2));
	_tmp46_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp46_);
	_tmp47_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp47_, (guint) 0);
	_tmp48_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp48_, (guint) 0);
	gala_window_clone_set_dragging (self, TRUE);
	_tmp49_ = _g_object_ref0 ((ClutterActor*) self);
	result = _tmp49_;
	_g_object_unref0 (stage);
	return result;
}

/**
     * When we cross an IconGroup, we animate to an even smaller size and slightly
     * less opacity and add ourselves as temporary window to the group. When left,
     * we reverse those steps.
     */
static void
gala_window_clone_drag_destination_crossed (GalaWindowClone* self,
                                            ClutterActor* destination,
                                            gboolean hovered)
{
	GalaIconGroup* icon_group = NULL;
	GalaIconGroup* _tmp0_;
	GalaWorkspaceInsertThumb* insert_thumb = NULL;
	GalaWorkspaceInsertThumb* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GalaIconGroup* _tmp4_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GalaIconGroup* _tmp10_;
	gdouble _tmp19_ = 0.0;
	gdouble scale = 0.0;
	gint _tmp20_ = 0;
	gint opacity = 0;
	gint _tmp21_ = 0;
	gboolean _tmp22_ = FALSE;
	gint duration = 0;
	ClutterActor* _tmp27_;
	ClutterActor* _tmp28_;
	ClutterActor* _tmp29_;
	ClutterActor* _tmp30_;
	ClutterActor* _tmp31_;
	ClutterActor* _tmp32_;
	GalaWorkspaceInsertThumb* _tmp33_;
	GalaIconGroup* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	_tmp0_ = _g_object_ref0 (GALA_IS_ICON_GROUP (destination) ? ((GalaIconGroup*) destination) : NULL);
	icon_group = _tmp0_;
	_tmp1_ = _g_object_ref0 (GALA_IS_WORKSPACE_INSERT_THUMB (destination) ? ((GalaWorkspaceInsertThumb*) destination) : NULL);
	insert_thumb = _tmp1_;
	_tmp4_ = icon_group;
	if (_tmp4_ == NULL) {
		GalaWorkspaceInsertThumb* _tmp5_;
		_tmp5_ = insert_thumb;
		_tmp3_ = _tmp5_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		GalaWorkspaceInsertThumb* _tmp7_;
		_tmp7_ = insert_thumb;
		if (_tmp7_ != NULL) {
			_tmp6_ = !meta_prefs_get_dynamic_workspaces ();
		} else {
			_tmp6_ = FALSE;
		}
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		_g_object_unref0 (insert_thumb);
		_g_object_unref0 (icon_group);
		return;
	}
	_tmp10_ = icon_group;
	if (_tmp10_ != NULL) {
		GalaIconGroup* _tmp11_;
		MetaWorkspace* _tmp12_;
		MetaWorkspace* _tmp13_;
		MetaWindow* _tmp14_;
		MetaWorkspace* _tmp15_;
		_tmp11_ = icon_group;
		_tmp12_ = gala_icon_group_get_workspace (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->_window;
		_tmp15_ = meta_window_get_workspace (_tmp14_);
		_tmp9_ = _tmp13_ == _tmp15_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		MetaWindow* _tmp16_;
		MetaWindow* _tmp17_;
		MetaDisplay* _tmp18_;
		_tmp16_ = self->priv->_window;
		_tmp17_ = self->priv->_window;
		_tmp18_ = meta_window_get_display (_tmp17_);
		_tmp8_ = meta_window_get_monitor (_tmp16_) == meta_display_get_primary_monitor (_tmp18_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_g_object_unref0 (insert_thumb);
		_g_object_unref0 (icon_group);
		return;
	}
	if (hovered) {
		_tmp19_ = 0.4;
	} else {
		_tmp19_ = 1.0;
	}
	scale = _tmp19_;
	if (hovered) {
		_tmp20_ = 0;
	} else {
		_tmp20_ = 255;
	}
	opacity = _tmp20_;
	if (hovered) {
		GalaWorkspaceInsertThumb* _tmp23_;
		_tmp23_ = insert_thumb;
		_tmp22_ = _tmp23_ != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		GalaWorkspaceInsertThumb* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp24_ = insert_thumb;
		_tmp25_ = gala_workspace_insert_thumb_get_delay (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp21_ = _tmp26_;
	} else {
		_tmp21_ = 100;
	}
	duration = _tmp21_;
	_tmp27_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp27_);
	_tmp28_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp28_, CLUTTER_LINEAR);
	_tmp29_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp29_, (guint) duration);
	_tmp30_ = self->priv->window_icon;
	clutter_actor_set_scale (_tmp30_, scale, scale);
	_tmp31_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp31_, (guint8) opacity);
	_tmp32_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp32_);
	_tmp33_ = insert_thumb;
	if (_tmp33_ != NULL) {
		GalaWorkspaceInsertThumb* _tmp34_;
		MetaWindow* _tmp35_;
		_tmp34_ = insert_thumb;
		_tmp35_ = self->priv->_window;
		gala_workspace_insert_thumb_set_window_thumb (_tmp34_, _tmp35_);
	}
	_tmp36_ = icon_group;
	if (_tmp36_ != NULL) {
		if (hovered) {
			GalaIconGroup* _tmp37_;
			MetaWindow* _tmp38_;
			_tmp37_ = icon_group;
			_tmp38_ = self->priv->_window;
			gala_icon_group_add_window (_tmp37_, _tmp38_, FALSE, TRUE);
		} else {
			GalaIconGroup* _tmp39_;
			MetaWindow* _tmp40_;
			_tmp39_ = icon_group;
			_tmp40_ = self->priv->_window;
			gala_icon_group_remove_window (_tmp39_, _tmp40_, TRUE);
		}
	}
	_g_object_unref0 (insert_thumb);
	_g_object_unref0 (icon_group);
}

/**
     * Depending on the destination we have different ways to find the correct destination.
     * After we found one we destroy ourselves so the dragged clone immediately disappears,
     * otherwise we cancel the drag and animate back to our old place.
     */
static void
gala_window_clone_drag_end (GalaWindowClone* self,
                            ClutterActor* destination)
{
	MetaWorkspace* workspace = NULL;
	gint primary = 0;
	MetaWindow* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowCloneActiveShape* _tmp2_;
	gboolean did_move = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp29_ = FALSE;
	MetaWorkspace* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	workspace = NULL;
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_display (_tmp0_);
	primary = meta_display_get_primary_monitor (_tmp1_);
	_tmp2_ = self->priv->active_shape;
	clutter_actor_show ((ClutterActor*) _tmp2_);
	if (GALA_IS_ICON_GROUP (destination)) {
		MetaWorkspace* _tmp3_;
		MetaWorkspace* _tmp4_;
		MetaWorkspace* _tmp5_;
		_tmp3_ = gala_icon_group_get_workspace (G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_ICON_GROUP, GalaIconGroup));
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (workspace);
		workspace = _tmp5_;
	} else {
		if (GALA_IS_FRAMED_BACKGROUND (destination)) {
			ClutterActor* _tmp6_;
			MetaWorkspace* _tmp7_;
			MetaWorkspace* _tmp8_;
			MetaWorkspace* _tmp9_;
			_tmp6_ = clutter_actor_get_parent (destination);
			_tmp7_ = gala_workspace_clone_get_workspace (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone));
			_tmp8_ = _tmp7_;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (workspace);
			workspace = _tmp9_;
		} else {
			if (GALA_IS_WORKSPACE_INSERT_THUMB (destination)) {
				GalaWorkspaceInsertThumb* inserter = NULL;
				gboolean will_move = FALSE;
				MetaWindow* _tmp10_;
				MetaWorkspace* _tmp11_;
				GalaWorkspaceInsertThumb* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gboolean _tmp15_ = FALSE;
				GalaWorkspaceInsertThumb* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				MetaWindow* _tmp21_;
				if (!meta_prefs_get_dynamic_workspaces ()) {
					gala_window_clone_drag_canceled (self);
					_g_object_unref0 (workspace);
					return;
				}
				inserter = G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb);
				_tmp10_ = self->priv->_window;
				_tmp11_ = meta_window_get_workspace (_tmp10_);
				_tmp12_ = inserter;
				_tmp13_ = gala_workspace_insert_thumb_get_workspace_index (_tmp12_);
				_tmp14_ = _tmp13_;
				will_move = meta_workspace_index (_tmp11_) != _tmp14_;
				if (meta_prefs_get_workspaces_only_on_primary ()) {
					MetaWindow* _tmp16_;
					_tmp16_ = self->priv->_window;
					_tmp15_ = meta_window_get_monitor (_tmp16_) != primary;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					MetaWindow* _tmp17_;
					_tmp17_ = self->priv->_window;
					meta_window_move_to_monitor (_tmp17_, primary);
					will_move = TRUE;
				}
				_tmp18_ = inserter;
				_tmp19_ = gala_workspace_insert_thumb_get_workspace_index (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = self->priv->_window;
				gala_internal_utils_insert_workspace_with_window (_tmp20_, _tmp21_);
				if (!will_move) {
					gala_window_clone_drag_canceled (self);
				} else {
					gala_window_clone_unmanaged (self);
				}
				_g_object_unref0 (workspace);
				return;
			} else {
				if (GALA_IS_MONITOR_CLONE (destination)) {
					gint monitor = 0;
					gint _tmp22_;
					gint _tmp23_;
					MetaWindow* _tmp24_;
					_tmp22_ = gala_monitor_clone_get_monitor (G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone));
					_tmp23_ = _tmp22_;
					monitor = _tmp23_;
					_tmp24_ = self->priv->_window;
					if (meta_window_get_monitor (_tmp24_) != monitor) {
						MetaWindow* _tmp25_;
						_tmp25_ = self->priv->_window;
						meta_window_move_to_monitor (_tmp25_, monitor);
						gala_window_clone_unmanaged (self);
					} else {
						gala_window_clone_drag_canceled (self);
					}
					_g_object_unref0 (workspace);
					return;
				}
			}
		}
	}
	did_move = FALSE;
	if (meta_prefs_get_workspaces_only_on_primary ()) {
		MetaWindow* _tmp27_;
		_tmp27_ = self->priv->_window;
		_tmp26_ = meta_window_get_monitor (_tmp27_) != primary;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		MetaWindow* _tmp28_;
		_tmp28_ = self->priv->_window;
		meta_window_move_to_monitor (_tmp28_, primary);
		did_move = TRUE;
	}
	_tmp30_ = workspace;
	if (_tmp30_ != NULL) {
		MetaWorkspace* _tmp31_;
		MetaWindow* _tmp32_;
		MetaWorkspace* _tmp33_;
		_tmp31_ = workspace;
		_tmp32_ = self->priv->_window;
		_tmp33_ = meta_window_get_workspace (_tmp32_);
		_tmp29_ = _tmp31_ != _tmp33_;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		MetaWindow* _tmp34_;
		MetaWorkspace* _tmp35_;
		_tmp34_ = self->priv->_window;
		_tmp35_ = workspace;
		meta_window_change_workspace (_tmp34_, _tmp35_);
		did_move = TRUE;
	}
	if (did_move) {
		gala_window_clone_unmanaged (self);
	} else {
		gala_window_clone_drag_canceled (self);
	}
	_g_object_unref0 (workspace);
}

/**
     * Animate back to our previous position with a bouncing animation.
     */
static void
gala_window_clone_drag_canceled (GalaWindowClone* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterClone* _tmp2_;
	ClutterClone* _tmp3_;
	ClutterClone* _tmp4_;
	ClutterClone* _tmp5_;
	ClutterClone* _tmp6_;
	ClutterClone* _tmp7_;
	ClutterClone* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	MetaRectangle* _tmp12_;
	MetaRectangle* _tmp13_;
	ClutterActor* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
	clutter_actor_remove_child (_tmp0_, (ClutterActor*) self);
	_tmp1_ = self->priv->prev_parent;
	clutter_actor_insert_child_at_index (_tmp1_, (ClutterActor*) self, self->priv->prev_index);
	_tmp2_ = self->priv->clone;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp2_);
	_tmp3_ = self->priv->clone;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp3_, 0.5f, 0.5f);
	_tmp4_ = self->priv->clone;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp4_, (guint) 250);
	_tmp5_ = self->priv->clone;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp5_, CLUTTER_EASE_OUT_QUAD);
	_tmp6_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp6_, (gdouble) 1, (gdouble) 1);
	_tmp7_ = self->priv->clone;
	clutter_actor_set_opacity ((ClutterActor*) _tmp7_, (guint) 255);
	_tmp8_ = self->priv->clone;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp8_);
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_tmp9_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp9_);
	_tmp10_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp10_, (guint) 250);
	_tmp11_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp11_, CLUTTER_EASE_OUT_QUAD);
	_tmp12_ = self->priv->_slot;
	_tmp13_ = self->priv->_slot;
	gala_window_clone_set_window_icon_position (self, (gfloat) (*_tmp12_).width, (gfloat) (*_tmp13_).height, TRUE);
	_tmp14_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp14_);
	gala_window_clone_set_dragging (self, FALSE);
}

static void
gala_window_clone_set_window_icon_position (GalaWindowClone* self,
                                            gfloat window_width,
                                            gfloat window_height,
                                            gboolean aligned)
{
	gint scale_factor = 0;
	gint size = 0;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	g_return_if_fail (self != NULL);
	scale_factor = gala_internal_utils_get_ui_scaling_factor ();
	size = GALA_WINDOW_CLONE_WINDOW_ICON_SIZE * scale_factor;
	x = (window_width - size) / 2;
	y = window_height - (size * 0.75f);
	if (aligned) {
		x = (gfloat) gala_internal_utils_pixel_align (x);
		y = (gfloat) gala_internal_utils_pixel_align (y);
	}
	_tmp0_ = self->priv->window_icon;
	clutter_actor_set_size (_tmp0_, (gfloat) size, (gfloat) size);
	_tmp1_ = self->priv->window_icon;
	clutter_actor_set_position (_tmp1_, x, y);
}

static void
gala_window_clone_set_window_title_position (GalaWindowClone* self,
                                             gfloat window_width,
                                             gfloat window_height)
{
	gint scale_factor = 0;
	gint x = 0;
	GalaTooltip* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gint y = 0;
	GalaTooltip* _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	GalaTooltip* _tmp6_;
	g_return_if_fail (self != NULL);
	scale_factor = gala_internal_utils_get_ui_scaling_factor ();
	_tmp0_ = self->priv->window_title;
	_tmp1_ = clutter_actor_get_width ((ClutterActor*) _tmp0_);
	_tmp2_ = _tmp1_;
	x = gala_internal_utils_pixel_align ((window_width - _tmp2_) / 2);
	_tmp3_ = self->priv->window_title;
	_tmp4_ = clutter_actor_get_height ((ClutterActor*) _tmp3_);
	_tmp5_ = _tmp4_;
	y = gala_internal_utils_pixel_align (((window_height - ((GALA_WINDOW_CLONE_WINDOW_ICON_SIZE * scale_factor) * 0.75f)) - (_tmp5_ / 2)) - (18 * scale_factor));
	_tmp6_ = self->priv->window_title;
	clutter_actor_set_position ((ClutterActor*) _tmp6_, (gfloat) x, (gfloat) y);
}

static gboolean
gala_window_clone_is_close_button_on_left (void)
{
	MetaButtonLayout layout = {0};
	MetaButtonLayout _tmp0_ = {0};
	MetaButtonLayout _tmp1_;
	gboolean result;
	meta_prefs_get_button_layout (&_tmp0_);
	layout = _tmp0_;
	_tmp1_ = layout;
	{
		MetaButtonFunction* button_function_collection = NULL;
		gint button_function_collection_length1 = 0;
		gint _button_function_collection_size_ = 0;
		gint button_function_it = 0;
		button_function_collection = _tmp1_.right_buttons;
		button_function_collection_length1 = 4;
		for (button_function_it = 0; button_function_it < button_function_collection_length1; button_function_it = button_function_it + 1) {
			MetaButtonFunction button_function = 0;
			button_function = button_function_collection[button_function_it];
			{
				if (button_function == META_BUTTON_FUNCTION_CLOSE) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

MetaWindow*
gala_window_clone_get_window (GalaWindowClone* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_set_window (GalaWindowClone* self,
                              MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_WINDOW_PROPERTY]);
	}
}

MetaRectangle*
gala_window_clone_get_slot (GalaWindowClone* self)
{
	MetaRectangle* result;
	MetaRectangle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_slot;
	result = _tmp0_;
	return result;
}

static gboolean
_meta_rectangle_equal (const MetaRectangle * s1,
                       const MetaRectangle * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static MetaRectangle*
_vala_MetaRectangle_copy (MetaRectangle* self)
{
	return g_boxed_copy (meta_rectangle_get_type (), self);
}

static gpointer
__vala_MetaRectangle_copy0 (gpointer self)
{
	return self ? _vala_MetaRectangle_copy (self) : NULL;
}

static void
gala_window_clone_set_slot (GalaWindowClone* self,
                            MetaRectangle* value)
{
	MetaRectangle* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_slot (self);
	if (_meta_rectangle_equal (value, old_value) != TRUE) {
		MetaRectangle* _tmp0_;
		_tmp0_ = __vala_MetaRectangle_copy0 (value);
		__vala_MetaRectangle_free0 (self->priv->_slot);
		self->priv->_slot = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_SLOT_PROPERTY]);
	}
}

gboolean
gala_window_clone_get_dragging (GalaWindowClone* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dragging;
	return result;
}

static void
gala_window_clone_set_dragging (GalaWindowClone* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_dragging (self);
	if (old_value != value) {
		self->priv->_dragging = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_DRAGGING_PROPERTY]);
	}
}

gboolean
gala_window_clone_get_active (GalaWindowClone* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
gala_window_clone_set_active (GalaWindowClone* self,
                              gboolean value)
{
	GalaWindowCloneActiveShape* _tmp0_;
	GalaWindowCloneActiveShape* _tmp1_;
	gint _tmp2_ = 0;
	GalaWindowCloneActiveShape* _tmp3_;
	GalaWindowCloneActiveShape* _tmp4_;
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	_tmp0_ = self->priv->active_shape;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->active_shape;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp1_, (guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION);
	if (self->priv->_active) {
		_tmp2_ = 255;
	} else {
		_tmp2_ = 0;
	}
	_tmp3_ = self->priv->active_shape;
	clutter_actor_set_opacity ((ClutterActor*) _tmp3_, (guint) _tmp2_);
	_tmp4_ = self->priv->active_shape;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp4_);
	g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_ACTIVE_PROPERTY]);
}

gboolean
gala_window_clone_get_overview_mode (GalaWindowClone* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overview_mode;
	return result;
}

static void
gala_window_clone_set_overview_mode (GalaWindowClone* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_overview_mode (self);
	if (old_value != value) {
		self->priv->_overview_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY]);
	}
}

GalaGestureTracker*
gala_window_clone_get_gesture_tracker (GalaWindowClone* self)
{
	GalaGestureTracker* result;
	GalaGestureTracker* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gesture_tracker;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_set_gesture_tracker (GalaWindowClone* self,
                                       GalaGestureTracker* value)
{
	GalaGestureTracker* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_gesture_tracker (self);
	if (old_value != value) {
		GalaGestureTracker* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gesture_tracker);
		self->priv->_gesture_tracker = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY]);
	}
}

guint8
gala_window_clone_get_shadow_opacity (GalaWindowClone* self)
{
	guint8 result;
	guint8 _tmp0_ = 0U;
	GalaShadowEffect* _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = self->priv->shadow_effect;
	if (_tmp1_ != NULL) {
		GalaShadowEffect* _tmp2_;
		guint8 _tmp3_;
		guint8 _tmp4_;
		_tmp2_ = self->priv->shadow_effect;
		_tmp3_ = gala_shadow_effect_get_shadow_opacity (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = (guint8) 255;
	}
	result = _tmp0_;
	return result;
}

void
gala_window_clone_set_shadow_opacity (GalaWindowClone* self,
                                      guint8 value)
{
	GalaShadowEffect* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shadow_effect;
	if (_tmp0_ != NULL) {
		GalaShadowEffect* _tmp1_;
		_tmp1_ = self->priv->shadow_effect;
		gala_shadow_effect_set_shadow_opacity (_tmp1_, value);
		clutter_actor_queue_redraw ((ClutterActor*) self);
	}
}

static inline gpointer
gala_window_clone_window_shadow_effect_get_instance_private (GalaWindowCloneWindowShadowEffect* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowCloneWindowShadowEffect_private_offset);
}

static GalaWindowCloneWindowShadowEffect*
gala_window_clone_window_shadow_effect_construct (GType object_type,
                                                  MetaWindow* window,
                                                  gint shadow_size,
                                                  gint shadow_spread)
{
	GalaWindowCloneWindowShadowEffect * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaWindowCloneWindowShadowEffect*) g_object_new (object_type, "window", window, "shadow-size", shadow_size, "shadow-spread", shadow_spread, "shadow-opacity", 255, NULL);
	return self;
}

static GalaWindowCloneWindowShadowEffect*
gala_window_clone_window_shadow_effect_new (MetaWindow* window,
                                            gint shadow_size,
                                            gint shadow_spread)
{
	return gala_window_clone_window_shadow_effect_construct (GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT, window, shadow_size, shadow_spread);
}

static void
gala_window_clone_window_shadow_effect_real_get_bounding_box (GalaShadowEffect* base,
                                                              ClutterActorBox* result)
{
	GalaWindowCloneWindowShadowEffect * self;
	gint scale_factor = 0;
	gint size = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	MetaRectangle input_rect = {0};
	MetaWindow* _tmp4_;
	MetaRectangle _tmp5_ = {0};
	MetaRectangle outer_rect = {0};
	MetaWindow* _tmp6_;
	MetaRectangle _tmp7_ = {0};
	ClutterActorBox bounding_box = {0};
	MetaRectangle _tmp8_;
	MetaRectangle _tmp9_;
	MetaRectangle _tmp10_;
	MetaRectangle _tmp11_;
	MetaRectangle _tmp12_;
	MetaRectangle _tmp13_;
	self = (GalaWindowCloneWindowShadowEffect*) base;
	scale_factor = gala_internal_utils_get_ui_scaling_factor ();
	_tmp0_ = gala_shadow_effect_get_shadow_size ((GalaShadowEffect*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gala_shadow_effect_get_shadow_spread ((GalaShadowEffect*) self);
	_tmp3_ = _tmp2_;
	size = (_tmp1_ + _tmp3_) * scale_factor;
	_tmp4_ = self->priv->_window;
	meta_window_get_buffer_rect (_tmp4_, &_tmp5_);
	input_rect = _tmp5_;
	_tmp6_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp6_, &_tmp7_);
	outer_rect = _tmp7_;
	memset (&bounding_box, 0, sizeof (ClutterActorBox));
	_tmp8_ = input_rect;
	_tmp9_ = outer_rect;
	_tmp10_ = input_rect;
	_tmp11_ = outer_rect;
	clutter_actor_box_set_origin (&bounding_box, (gfloat) ((-(_tmp8_.x - _tmp9_.x)) - size), (gfloat) ((-(_tmp10_.y - _tmp11_.y)) - size));
	_tmp12_ = outer_rect;
	_tmp13_ = outer_rect;
	clutter_actor_box_set_size (&bounding_box, (gfloat) (_tmp12_.width + (size * 2)), (gfloat) (_tmp13_.height + (size * 2)));
	*result = bounding_box;
	return;
}

static MetaWindow*
gala_window_clone_window_shadow_effect_get_window (GalaWindowCloneWindowShadowEffect* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_window_shadow_effect_set_window (GalaWindowCloneWindowShadowEffect* self,
                                                   MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_window_shadow_effect_get_window (self);
	if (old_value != value) {
		self->priv->_window = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_window_shadow_effect_properties[GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_WINDOW_PROPERTY]);
	}
}

static void
gala_window_clone_window_shadow_effect_class_init (GalaWindowCloneWindowShadowEffectClass * klass,
                                                   gpointer klass_data)
{
	gala_window_clone_window_shadow_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowCloneWindowShadowEffect_private_offset);
	((GalaShadowEffectClass *) klass)->get_bounding_box = (void (*) (GalaShadowEffect*, ClutterActorBox*)) gala_window_clone_window_shadow_effect_real_get_bounding_box;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_clone_window_shadow_effect_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_clone_window_shadow_effect_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_window_shadow_effect_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_WINDOW_PROPERTY, gala_window_clone_window_shadow_effect_properties[GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_window_clone_window_shadow_effect_instance_init (GalaWindowCloneWindowShadowEffect * self,
                                                      gpointer klass)
{
	self->priv = gala_window_clone_window_shadow_effect_get_instance_private (self);
}

static void
gala_window_clone_window_shadow_effect_finalize (GObject * obj)
{
	GalaWindowCloneWindowShadowEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT, GalaWindowCloneWindowShadowEffect);
	G_OBJECT_CLASS (gala_window_clone_window_shadow_effect_parent_class)->finalize (obj);
}

static GType
gala_window_clone_window_shadow_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneWindowShadowEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_window_shadow_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowCloneWindowShadowEffect), 0, (GInstanceInitFunc) gala_window_clone_window_shadow_effect_instance_init, NULL };
	GType gala_window_clone_window_shadow_effect_type_id;
	gala_window_clone_window_shadow_effect_type_id = g_type_register_static (GALA_TYPE_SHADOW_EFFECT, "GalaWindowCloneWindowShadowEffect", &g_define_type_info, 0);
	GalaWindowCloneWindowShadowEffect_private_offset = g_type_add_instance_private (gala_window_clone_window_shadow_effect_type_id, sizeof (GalaWindowCloneWindowShadowEffectPrivate));
	return gala_window_clone_window_shadow_effect_type_id;
}

static GType
gala_window_clone_window_shadow_effect_get_type (void)
{
	static volatile gsize gala_window_clone_window_shadow_effect_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_window_shadow_effect_type_id__once)) {
		GType gala_window_clone_window_shadow_effect_type_id;
		gala_window_clone_window_shadow_effect_type_id = gala_window_clone_window_shadow_effect_get_type_once ();
		g_once_init_leave (&gala_window_clone_window_shadow_effect_type_id__once, gala_window_clone_window_shadow_effect_type_id);
	}
	return gala_window_clone_window_shadow_effect_type_id__once;
}

static void
_vala_gala_window_clone_window_shadow_effect_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	GalaWindowCloneWindowShadowEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT, GalaWindowCloneWindowShadowEffect);
	switch (property_id) {
		case GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_WINDOW_PROPERTY:
		g_value_set_object (value, gala_window_clone_window_shadow_effect_get_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_clone_window_shadow_effect_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	GalaWindowCloneWindowShadowEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_WINDOW_CLONE_TYPE_WINDOW_SHADOW_EFFECT, GalaWindowCloneWindowShadowEffect);
	switch (property_id) {
		case GALA_WINDOW_CLONE_WINDOW_SHADOW_EFFECT_WINDOW_PROPERTY:
		gala_window_clone_window_shadow_effect_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
gala_window_clone_active_shape_get_instance_private (GalaWindowCloneActiveShape* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowCloneActiveShape_private_offset);
}

static gboolean
gala_window_clone_active_shape_draw_background (cairo_t* cr,
                                                gint width,
                                                gint height)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	gboolean result;
	g_return_val_if_fail (cr != NULL, FALSE);
	cairo_save (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_restore (cr);
	gala_drawing_utilities_cairo_rounded_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height, (gdouble) gala_window_clone_active_shape_border_radius);
	_tmp0_ = gala_window_clone_active_shape_color;
	_tmp1_ = gala_window_clone_active_shape_color;
	_tmp2_ = gala_window_clone_active_shape_color;
	cairo_set_source_rgba (cr, _tmp0_.red, _tmp1_.green, _tmp2_.blue, GALA_WINDOW_CLONE_ACTIVE_SHAPE_COLOR_OPACITY);
	cairo_fill (cr);
	result = FALSE;
	return result;
}

static void
gala_window_clone_active_shape_real_allocate (ClutterActor* base,
                                              ClutterActorBox* box)
{
	GalaWindowCloneActiveShape * self;
	ClutterActorBox _tmp0_;
	GdkRGBA _tmp1_ = {0};
	ClutterCanvas* _tmp2_;
	ClutterCanvas* _tmp3_;
	self = (GalaWindowCloneActiveShape*) base;
	g_return_if_fail (box != NULL);
	_tmp0_ = *box;
	CLUTTER_ACTOR_CLASS (gala_window_clone_active_shape_parent_class)->allocate (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), &_tmp0_);
	gala_internal_utils_get_theme_accent_color (&_tmp1_);
	gala_window_clone_active_shape_color = _tmp1_;
	_tmp2_ = self->priv->background_canvas;
	clutter_canvas_set_size (_tmp2_, (gint) clutter_actor_box_get_width (box), (gint) clutter_actor_box_get_height (box));
	_tmp3_ = self->priv->background_canvas;
	clutter_content_invalidate ((ClutterContent*) _tmp3_);
}

static GalaWindowCloneActiveShape*
gala_window_clone_active_shape_construct (GType object_type)
{
	GalaWindowCloneActiveShape * self = NULL;
	self = (GalaWindowCloneActiveShape*) g_object_new (object_type, NULL);
	return self;
}

static GalaWindowCloneActiveShape*
gala_window_clone_active_shape_new (void)
{
	return gala_window_clone_active_shape_construct (GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE);
}

static gboolean
_gala_window_clone_active_shape_draw_background_clutter_canvas_draw (ClutterCanvas* _sender,
                                                                     cairo_t* cr,
                                                                     gint width,
                                                                     gint height,
                                                                     gpointer self)
{
	gboolean result;
	result = gala_window_clone_active_shape_draw_background (cr, width, height);
	return result;
}

static GObject *
gala_window_clone_active_shape_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowCloneActiveShape * self;
	ClutterCanvas* _tmp0_;
	ClutterCanvas* _tmp1_;
	ClutterCanvas* _tmp2_;
	parent_class = G_OBJECT_CLASS (gala_window_clone_active_shape_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape);
	_tmp0_ = (ClutterCanvas*) clutter_canvas_new ();
	_g_object_unref0 (self->priv->background_canvas);
	self->priv->background_canvas = _tmp0_;
	_tmp1_ = self->priv->background_canvas;
	g_signal_connect (_tmp1_, "draw", (GCallback) _gala_window_clone_active_shape_draw_background_clutter_canvas_draw, NULL);
	_tmp2_ = self->priv->background_canvas;
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) _tmp2_);
	return obj;
}

static void
gala_window_clone_active_shape_class_init (GalaWindowCloneActiveShapeClass * klass,
                                           gpointer klass_data)
{
	GtkWidgetPath* label_widget_path = NULL;
	GtkWidgetPath* _tmp0_;
	GtkWidgetPath* _tmp1_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkWidgetPath* _tmp6_;
	GtkStyleContext* _tmp7_;
	GValue _tmp8_ = {0};
	GValue _tmp9_;
	GdkRGBA _tmp10_ = {0};
	gala_window_clone_active_shape_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowCloneActiveShape_private_offset);
	((ClutterActorClass *) klass)->allocate = (void (*) (ClutterActor*, ClutterActorBox*)) gala_window_clone_active_shape_real_allocate;
	G_OBJECT_CLASS (klass)->constructor = gala_window_clone_active_shape_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_active_shape_finalize;
	_tmp0_ = gtk_widget_path_new ();
	label_widget_path = _tmp0_;
	_tmp1_ = label_widget_path;
	gtk_widget_path_append_type (_tmp1_, gtk_label_get_type ());
	_tmp2_ = gtk_style_context_new ();
	style_context = _tmp2_;
	_tmp3_ = style_context;
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_CARD);
	_tmp4_ = style_context;
	gtk_style_context_add_class (_tmp4_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp5_ = style_context;
	_tmp6_ = label_widget_path;
	gtk_style_context_set_path (_tmp5_, _tmp6_);
	_tmp7_ = style_context;
	gtk_style_context_get_property (_tmp7_, GTK_STYLE_PROPERTY_BORDER_RADIUS, GTK_STATE_FLAG_NORMAL, &_tmp8_);
	_tmp9_ = _tmp8_;
	gala_window_clone_active_shape_border_radius = g_value_get_int (&_tmp9_) * 4;
	G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
	gala_internal_utils_get_theme_accent_color (&_tmp10_);
	gala_window_clone_active_shape_color = _tmp10_;
	_g_object_unref0 (style_context);
	_gtk_widget_path_unref0 (label_widget_path);
}

static void
gala_window_clone_active_shape_instance_init (GalaWindowCloneActiveShape * self,
                                              gpointer klass)
{
	self->priv = gala_window_clone_active_shape_get_instance_private (self);
}

static void
gala_window_clone_active_shape_finalize (GObject * obj)
{
	GalaWindowCloneActiveShape * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape);
	_g_object_unref0 (self->priv->background_canvas);
	G_OBJECT_CLASS (gala_window_clone_active_shape_parent_class)->finalize (obj);
}

/**
     * Border to show around the selected window when using keyboard navigation.
     */
static GType
gala_window_clone_active_shape_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneActiveShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_active_shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowCloneActiveShape), 0, (GInstanceInitFunc) gala_window_clone_active_shape_instance_init, NULL };
	GType gala_window_clone_active_shape_type_id;
	gala_window_clone_active_shape_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowCloneActiveShape", &g_define_type_info, 0);
	GalaWindowCloneActiveShape_private_offset = g_type_add_instance_private (gala_window_clone_active_shape_type_id, sizeof (GalaWindowCloneActiveShapePrivate));
	return gala_window_clone_active_shape_type_id;
}

static GType
gala_window_clone_active_shape_get_type (void)
{
	static volatile gsize gala_window_clone_active_shape_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_active_shape_type_id__once)) {
		GType gala_window_clone_active_shape_type_id;
		gala_window_clone_active_shape_type_id = gala_window_clone_active_shape_get_type_once ();
		g_once_init_leave (&gala_window_clone_active_shape_type_id__once, gala_window_clone_active_shape_type_id);
	}
	return gala_window_clone_active_shape_type_id__once;
}

static Block68Data*
block68_data_ref (Block68Data* _data68_)
{
	g_atomic_int_inc (&_data68_->_ref_count_);
	return _data68_;
}

static void
block68_data_unref (void * _userdata_)
{
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data68_->self;
		_g_object_unref0 (_data68_->click_action);
		_g_object_unref0 (self);
		g_slice_free (Block68Data, _data68_);
	}
}

static void
_gala_window_clone___lambda107_ (Block68Data* _data68_)
{
	GalaWindowClone* self;
	ClutterClickAction* _tmp0_;
	self = _data68_->self;
	_tmp0_ = _data68_->click_action;
	gala_window_clone_actor_clicked (self, (guint32) clutter_click_action_get_button (_tmp0_));
}

static void
__gala_window_clone___lambda107__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                               ClutterActor* actor,
                                                               gpointer self)
{
	_gala_window_clone___lambda107_ (self);
}

static ClutterActor*
_gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                gfloat x,
                                                                gfloat y,
                                                                gpointer self)
{
	ClutterActor* result;
	result = gala_window_clone_drag_begin ((GalaWindowClone*) self, x, y);
	return result;
}

static void
_gala_window_clone_drag_destination_crossed_gala_drag_drop_action_destination_crossed (GalaDragDropAction* _sender,
                                                                                       ClutterActor* destination,
                                                                                       gboolean hovered,
                                                                                       gpointer self)
{
	gala_window_clone_drag_destination_crossed ((GalaWindowClone*) self, destination, hovered);
}

static void
_gala_window_clone_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                            ClutterActor* actor,
                                                            gpointer self)
{
	gala_window_clone_drag_end ((GalaWindowClone*) self, actor);
}

static void
_gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                      gpointer self)
{
	gala_window_clone_drag_canceled ((GalaWindowClone*) self);
}

static void
_gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                      guint32 button,
                                                                      gpointer self)
{
	gala_window_clone_actor_clicked ((GalaWindowClone*) self, button);
}

static gboolean
_gala_window_clone___lambda108_ (GalaWindowClone* self)
{
	gboolean result;
	gala_window_clone_close_window (self);
	result = TRUE;
	return result;
}

static gboolean
__gala_window_clone___lambda108__clutter_actor_button_press_event (ClutterActor* _sender,
                                                                   ClutterButtonEvent* event,
                                                                   gpointer self)
{
	gboolean result;
	result = _gala_window_clone___lambda108_ ((GalaWindowClone*) self);
	return result;
}

static GObject *
gala_window_clone_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowClone * self;
	Block68Data* _data68_;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	ClutterClickAction* _tmp5_;
	ClutterClickAction* _tmp6_;
	ClutterClickAction* _tmp7_;
	gboolean _tmp8_;
	ClutterActor* _tmp16_;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	ClutterActor* _tmp19_;
	gint scale_factor = 0;
	MetaRectangle window_frame_rect = {0};
	MetaWindow* _tmp20_;
	MetaRectangle _tmp21_ = {0};
	MetaWindow* _tmp22_;
	GalaWindowIcon* _tmp23_;
	ClutterActor* _tmp24_;
	ClutterActor* _tmp25_;
	ClutterActor* _tmp26_;
	ClutterActor* _tmp27_;
	MetaRectangle _tmp28_;
	MetaRectangle _tmp29_;
	GalaTooltip* _tmp30_;
	GalaTooltip* _tmp31_;
	GalaTooltip* _tmp32_;
	GalaWindowCloneActiveShape* _tmp33_;
	GalaWindowCloneActiveShape* _tmp34_;
	GalaWindowCloneActiveShape* _tmp35_;
	ClutterActor* _tmp36_;
	GalaTooltip* _tmp37_;
	ClutterActor* _tmp38_;
	parent_class = G_OBJECT_CLASS (gala_window_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	_data68_ = g_slice_new0 (Block68Data);
	_data68_->_ref_count_ = 1;
	_data68_->self = g_object_ref (self);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = self->priv->_window;
	g_signal_connect_object (_tmp0_, "unmanaged", (GCallback) _gala_window_clone_unmanaged_meta_window_unmanaged, self, 0);
	_tmp1_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::on-all-workspaces", (GCallback) _gala_window_clone_on_all_workspaces_changed_g_object_notify, self, 0);
	_tmp2_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::fullscreen", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp3_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::maximized-horizontally", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp4_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::maximized-vertically", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp5_ = (ClutterClickAction*) clutter_click_action_new ();
	g_object_ref_sink (_tmp5_);
	_data68_->click_action = _tmp5_;
	_tmp6_ = _data68_->click_action;
	g_signal_connect_data (_tmp6_, "clicked", (GCallback) __gala_window_clone___lambda107__clutter_click_action_clicked, block68_data_ref (_data68_), (GClosureNotify) block68_data_unref, 0);
	_tmp7_ = _data68_->click_action;
	clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp7_);
	_tmp8_ = self->priv->_overview_mode;
	if (!_tmp8_) {
		GalaDragDropAction* _tmp9_;
		GalaDragDropAction* _tmp10_;
		GalaDragDropAction* _tmp11_;
		GalaDragDropAction* _tmp12_;
		GalaDragDropAction* _tmp13_;
		GalaDragDropAction* _tmp14_;
		GalaDragDropAction* _tmp15_;
		_tmp9_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE, "multitaskingview-window");
		g_object_ref_sink (_tmp9_);
		_g_object_unref0 (self->priv->drag_action);
		self->priv->drag_action = _tmp9_;
		_tmp10_ = self->priv->drag_action;
		g_signal_connect_object (_tmp10_, "drag-begin", (GCallback) _gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin, self, 0);
		_tmp11_ = self->priv->drag_action;
		g_signal_connect_object (_tmp11_, "destination-crossed", (GCallback) _gala_window_clone_drag_destination_crossed_gala_drag_drop_action_destination_crossed, self, 0);
		_tmp12_ = self->priv->drag_action;
		g_signal_connect_object (_tmp12_, "drag-end", (GCallback) _gala_window_clone_drag_end_gala_drag_drop_action_drag_end, self, 0);
		_tmp13_ = self->priv->drag_action;
		g_signal_connect_object (_tmp13_, "drag-canceled", (GCallback) _gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled, self, 0);
		_tmp14_ = self->priv->drag_action;
		g_signal_connect_object (_tmp14_, "actor-clicked", (GCallback) _gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked, self, 0);
		_tmp15_ = self->priv->drag_action;
		clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp15_);
	}
	_tmp16_ = gala_utils_create_close_button ();
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp16_;
	_tmp17_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp17_, (guint) 0);
	_tmp18_ = self->priv->close_button;
	clutter_actor_set_easing_duration (_tmp18_, (guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION);
	_tmp19_ = self->priv->close_button;
	g_signal_connect_object (_tmp19_, "button-press-event", (GCallback) __gala_window_clone___lambda108__clutter_actor_button_press_event, self, 0);
	scale_factor = gala_internal_utils_get_ui_scaling_factor ();
	_tmp20_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp20_, &_tmp21_);
	window_frame_rect = _tmp21_;
	_tmp22_ = self->priv->_window;
	_tmp23_ = gala_window_icon_new (_tmp22_, GALA_WINDOW_CLONE_WINDOW_ICON_SIZE, scale_factor, FALSE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->window_icon);
	self->priv->window_icon = (ClutterActor*) _tmp23_;
	_tmp24_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp24_, (guint) 0);
	_tmp25_ = self->priv->window_icon;
	clutter_actor_set_pivot_point (_tmp25_, 0.5f, 0.5f);
	_tmp26_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp26_, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	_tmp27_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp27_, CLUTTER_EASE_OUT_QUAD);
	_tmp28_ = window_frame_rect;
	_tmp29_ = window_frame_rect;
	gala_window_clone_set_window_icon_position (self, (gfloat) _tmp28_.width, (gfloat) _tmp29_.height, TRUE);
	_tmp30_ = gala_tooltip_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->window_title);
	self->priv->window_title = _tmp30_;
	_tmp31_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp31_, (guint) 0);
	_tmp32_ = self->priv->window_title;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp32_, (guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION);
	_tmp33_ = gala_window_clone_active_shape_new ();
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->active_shape);
	self->priv->active_shape = _tmp33_;
	_tmp34_ = self->priv->active_shape;
	clutter_actor_set_opacity ((ClutterActor*) _tmp34_, (guint) 0);
	_tmp35_ = self->priv->active_shape;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp35_);
	_tmp36_ = self->priv->window_icon;
	clutter_actor_add_child ((ClutterActor*) self, _tmp36_);
	_tmp37_ = self->priv->window_title;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp37_);
	_tmp38_ = self->priv->close_button;
	clutter_actor_add_child ((ClutterActor*) self, _tmp38_);
	gala_window_clone_load_clone (self, FALSE);
	block68_data_unref (_data68_);
	_data68_ = NULL;
	return obj;
}

static void
gala_window_clone_class_init (GalaWindowCloneClass * klass,
                              gpointer klass_data)
{
	gala_window_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowClone_private_offset);
	((ClutterActorClass *) klass)->allocate = (void (*) (ClutterActor*, ClutterActorBox*)) gala_window_clone_real_allocate;
	((ClutterActorClass *) klass)->button_press_event = (gboolean (*) (ClutterActor*, ClutterButtonEvent*)) gala_window_clone_real_button_press_event;
	((ClutterActorClass *) klass)->enter_event = (gboolean (*) (ClutterActor*, ClutterCrossingEvent*)) gala_window_clone_real_enter_event;
	((ClutterActorClass *) klass)->leave_event = (gboolean (*) (ClutterActor*, ClutterCrossingEvent*)) gala_window_clone_real_leave_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_WINDOW_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The currently assigned slot of the window in the tiling layout. May be null.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_SLOT_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_SLOT_PROPERTY] = g_param_spec_boxed ("slot", "slot", "slot", meta_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_DRAGGING_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_DRAGGING_PROPERTY] = g_param_spec_boolean ("dragging", "dragging", "dragging", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * When active fades a white border around the window in. Used for the visually
	     * indicating the WindowCloneContainer's current_window.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_ACTIVE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY] = g_param_spec_boolean ("overview-mode", "overview-mode", "overview-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY] = g_param_spec_object ("gesture-tracker", "gesture-tracker", "gesture-tracker", GALA_TYPE_GESTURE_TRACKER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY] = g_param_spec_uchar ("shadow-opacity", "shadow-opacity", "shadow-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	     * The window was selected. The MultitaskingView should consider activating
	     * the window and closing the view.
	     */
	gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL] = g_signal_new ("selected", GALA_TYPE_WINDOW_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * The window was moved or resized and a relayout of the tiling layout may
	     * be sensible right now.
	     */
	gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL] = g_signal_new ("request-reposition", GALA_TYPE_WINDOW_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_window_clone_instance_init (GalaWindowClone * self,
                                 gpointer klass)
{
	self->priv = gala_window_clone_get_instance_private (self);
	self->priv->_slot = NULL;
	self->priv->_dragging = FALSE;
	self->priv->_active = FALSE;
	self->priv->drag_action = NULL;
	self->priv->clone = NULL;
	self->priv->shadow_effect = NULL;
	self->priv->prev_parent = NULL;
	self->priv->prev_index = -1;
	self->priv->check_confirm_dialog_cb = (gulong) 0;
	self->priv->shadow_update_timeout = (guint) 0;
	self->priv->in_slot_animation = FALSE;
}

static void
gala_window_clone_finalize (GObject * obj)
{
	GalaWindowClone * self;
	MetaWindow* _tmp0_;
	guint _tmp1_;
	MetaWindow* _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	MetaWindow* _tmp5_;
	guint _tmp6_;
	GQuark _tmp7_;
	MetaWindow* _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	MetaWindow* _tmp11_;
	guint _tmp12_;
	GQuark _tmp13_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	_tmp0_ = self->priv->_window;
	g_signal_parse_name ("unmanaged", meta_window_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_window_clone_unmanaged_meta_window_unmanaged, self);
	_tmp2_ = self->priv->_window;
	g_signal_parse_name ("notify::on-all-workspaces", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _gala_window_clone_on_all_workspaces_changed_g_object_notify, self);
	_tmp5_ = self->priv->_window;
	g_signal_parse_name ("notify::fullscreen", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_tmp8_ = self->priv->_window;
	g_signal_parse_name ("notify::maximized-horizontally", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_tmp11_ = self->priv->_window;
	g_signal_parse_name ("notify::maximized-vertically", G_TYPE_OBJECT, &_tmp12_, &_tmp13_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, _tmp13_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	if (self->priv->shadow_update_timeout != ((guint) 0)) {
		g_source_remove (self->priv->shadow_update_timeout);
	}
	_g_object_unref0 (self->priv->_window);
	__vala_MetaRectangle_free0 (self->priv->_slot);
	_g_object_unref0 (self->priv->_gesture_tracker);
	_g_object_unref0 (self->priv->drag_action);
	_g_object_unref0 (self->priv->clone);
	_g_object_unref0 (self->priv->shadow_effect);
	_g_object_unref0 (self->priv->prev_parent);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->active_shape);
	_g_object_unref0 (self->priv->window_icon);
	_g_object_unref0 (self->priv->window_title);
	G_OBJECT_CLASS (gala_window_clone_parent_class)->finalize (obj);
}

/**
 * A container for a clone of the texture of a MetaWindow, a WindowIcon, a Tooltip with the title,
 * a close button and a shadow. Used together with the WindowCloneContainer.
 */
static GType
gala_window_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowClone), 0, (GInstanceInitFunc) gala_window_clone_instance_init, NULL };
	GType gala_window_clone_type_id;
	gala_window_clone_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowClone", &g_define_type_info, 0);
	GalaWindowClone_private_offset = g_type_add_instance_private (gala_window_clone_type_id, sizeof (GalaWindowClonePrivate));
	return gala_window_clone_type_id;
}

GType
gala_window_clone_get_type (void)
{
	static volatile gsize gala_window_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_type_id__once)) {
		GType gala_window_clone_type_id;
		gala_window_clone_type_id = gala_window_clone_get_type_once ();
		g_once_init_leave (&gala_window_clone_type_id__once, gala_window_clone_type_id);
	}
	return gala_window_clone_type_id__once;
}

static void
_vala_gala_window_clone_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	switch (property_id) {
		case GALA_WINDOW_CLONE_WINDOW_PROPERTY:
		g_value_set_object (value, gala_window_clone_get_window (self));
		break;
		case GALA_WINDOW_CLONE_SLOT_PROPERTY:
		{
			MetaRectangle* boxed;
			boxed = gala_window_clone_get_slot (self);
			g_value_set_boxed (value, boxed);
		}
		break;
		case GALA_WINDOW_CLONE_DRAGGING_PROPERTY:
		g_value_set_boolean (value, gala_window_clone_get_dragging (self));
		break;
		case GALA_WINDOW_CLONE_ACTIVE_PROPERTY:
		g_value_set_boolean (value, gala_window_clone_get_active (self));
		break;
		case GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY:
		g_value_set_boolean (value, gala_window_clone_get_overview_mode (self));
		break;
		case GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY:
		g_value_set_object (value, gala_window_clone_get_gesture_tracker (self));
		break;
		case GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY:
		g_value_set_uchar (value, gala_window_clone_get_shadow_opacity (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_clone_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	switch (property_id) {
		case GALA_WINDOW_CLONE_WINDOW_PROPERTY:
		gala_window_clone_set_window (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_SLOT_PROPERTY:
		gala_window_clone_set_slot (self, g_value_get_boxed (value));
		break;
		case GALA_WINDOW_CLONE_DRAGGING_PROPERTY:
		gala_window_clone_set_dragging (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_ACTIVE_PROPERTY:
		gala_window_clone_set_active (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY:
		gala_window_clone_set_overview_mode (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY:
		gala_window_clone_set_gesture_tracker (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY:
		gala_window_clone_set_shadow_opacity (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

