/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;

public class SrtmTile {
    private int _latitude = 0;
    private int _longitude = 0;

    public SrtmTile(DataPoint dataPoint) {
        Coordinate coordinate = dataPoint.getLatitude();
        this._latitude = (int)Math.floor(coordinate.getDouble());
        Coordinate coordinate2 = dataPoint.getLongitude();
        this._longitude = (int)Math.floor(coordinate2.getDouble());
    }

    public SrtmTile(int n, int n2) {
        this._latitude = n;
        this._longitude = n2;
    }

    public int hashCode() {
        return this._latitude * 1000 + this._longitude;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SrtmTile srtmTile = (SrtmTile)object;
        return this._latitude == srtmTile._latitude && this._longitude == srtmTile._longitude;
    }

    public boolean contains(DataPoint dataPoint) {
        int n = (int)Math.floor(dataPoint.getLatitude().getDouble());
        int n2 = (int)Math.floor(dataPoint.getLongitude().getDouble());
        return n == this._latitude && n2 == this._longitude;
    }

    public int getLatitude() {
        return this._latitude;
    }

    public int getLongitude() {
        return this._longitude;
    }

    public String getTileName() {
        return String.valueOf(this._latitude >= 0 ? "N" : "S") + (Math.abs(this._latitude) < 10 ? "0" : "") + Math.abs(this._latitude) + (this._longitude >= 0 ? "E" : "W") + (Math.abs(this._longitude) < 100 ? "0" : "") + (Math.abs(this._longitude) < 10 ? "0" : "") + Math.abs(this._longitude);
    }
}

