/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Image;

public class MemTileCacher {
    private Image[] _tiles = new Image[400];
    private int _zoom = -1;
    private int _tileX = -1;
    private int _tileY = -1;
    private int _gridCentreX = 0;
    private int _gridCentreY = 0;
    private static final int GRID_SIZE = 20;

    public void centreMap(int n, int n2, int n3) {
        int n4 = Math.max(Math.abs(n2 - this._tileX), Math.abs(n3 - this._tileY));
        if (n4 == 0) {
            return;
        }
        if (n != this._zoom || n4 > 10) {
            this._zoom = n;
            this.clearAll();
        }
        this._gridCentreX = MemTileCacher.getCacheCoordinate(this._gridCentreX + n2 - this._tileX);
        this._gridCentreY = MemTileCacher.getCacheCoordinate(this._gridCentreY + n3 - this._tileY);
        this._tileX = n2;
        this._tileY = n3;
        int n5 = 0;
        while (n5 < 20) {
            this._tiles[this.getArrayIndexNoWrap((int)(this._tileX + 10 + 1), (int)(this._tileY + n5 - 10))] = null;
            this._tiles[this.getArrayIndexNoWrap((int)(this._tileX + n5 - 10), (int)(this._tileY + 10 + 1))] = null;
            ++n5;
        }
    }

    private static int getCacheCoordinate(int n) {
        int n2 = n;
        while (n2 >= 20) {
            n2 -= 20;
        }
        while (n2 < 0) {
            n2 += 20;
        }
        return n2;
    }

    private int getArrayIndex(int n, int n2) {
        int n3 = 1 << this._zoom;
        int n4 = n - this._tileX;
        while (n4 > n3 / 2) {
            n4 -= n3;
        }
        while (n4 < -n3 / 2) {
            n4 += n3;
        }
        int n5 = MemTileCacher.getCacheCoordinate(n4 + this._gridCentreX);
        int n6 = MemTileCacher.getCacheCoordinate(n2 - this._tileY + this._gridCentreY);
        return n5 + n6 * 20;
    }

    private int getArrayIndexNoWrap(int n, int n2) {
        int n3 = MemTileCacher.getCacheCoordinate(n - this._tileX + this._gridCentreX);
        int n4 = MemTileCacher.getCacheCoordinate(n2 - this._tileY + this._gridCentreY);
        return n3 + n4 * 20;
    }

    public void clearAll() {
        int n = 0;
        while (n < this._tiles.length) {
            this._tiles[n] = null;
            ++n;
        }
    }

    public Image getTile(int n, int n2) {
        return this._tiles[this.getArrayIndex(n, n2)];
    }

    public void setTile(Image image, int n, int n2, int n3) {
        if (n3 == this._zoom) {
            this._tiles[this.getArrayIndex((int)n, (int)n2)] = image;
        }
    }
}

