/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import tim.prune.data.DataPoint;
import tim.prune.data.FileInfo;
import tim.prune.data.SourceInfo;
import tim.prune.save.xml.GpxCacher;

public class GpxCacherList {
    private GpxCacher[] _cacherList = null;

    public GpxCacherList(FileInfo fileInfo) {
        int n = fileInfo.getNumFiles();
        this._cacherList = new GpxCacher[n];
        int n2 = 0;
        while (n2 < n) {
            SourceInfo sourceInfo = fileInfo.getSource(n2);
            if (sourceInfo.getFileType() == SourceInfo.FILE_TYPE.GPX) {
                this._cacherList[n2] = new GpxCacher(sourceInfo);
            }
            ++n2;
        }
    }

    public String getSourceString(DataPoint dataPoint) {
        String string = null;
        int n = 0;
        while (n < this._cacherList.length && string == null) {
            GpxCacher gpxCacher = this._cacherList[n];
            if (gpxCacher != null) {
                string = gpxCacher.getSourceString(dataPoint);
            }
            ++n;
        }
        return string;
    }

    public String getFirstHeader() {
        String string = null;
        int n = 0;
        while (n < this._cacherList.length && (string == null || string.equals(""))) {
            GpxCacher gpxCacher = this._cacherList[n];
            if (gpxCacher != null) {
                string = gpxCacher.getHeaderString();
            }
            ++n;
        }
        return string;
    }
}

