/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.WriterMetrics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public class AdmissionControlMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    private static final Logger LOG = LogManager.getLogger(AdmissionControlMetricsCollector.class);
    private static final int sTimeInterval = 5000;
    private static final int KEYS_PATH_LENGTH = 0;
    private StringBuilder value = new StringBuilder();
    private static final String GLOBAL_JVMMP = "Global_JVMMP";
    private static final String REQUEST_SIZE = "Request_Size";
    private static final String ADMISSION_CONTROLLER = "com.sonian.opensearch.http.jetty.throttling.AdmissionController";
    private static final String ADMISSION_CONTROL_SERVICE = "com.sonian.opensearch.http.jetty.throttling.JettyAdmissionControlService";

    public AdmissionControlMetricsCollector() {
        super(5000, "AdmissionControlMetricsCollector");
    }

    public void collectMetrics(long startTime) {
        if (!this.isAdmissionControlFeatureAvailable()) {
            LOG.debug("AdmissionControl is not available for this domain");
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.ADMISSION_CONTROL_COLLECTOR_NOT_AVAILABLE, "", (Number)1);
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        try {
            Class<?> admissionController = Class.forName(ADMISSION_CONTROLLER);
            Class<?> jettyAdmissionControlService = Class.forName(ADMISSION_CONTROL_SERVICE);
            Method getAdmissionController = jettyAdmissionControlService.getDeclaredMethod("getAdmissionController", String.class);
            Object globalJVMMP = getAdmissionController.invoke(null, GLOBAL_JVMMP);
            Object requestSize = getAdmissionController.invoke(null, REQUEST_SIZE);
            if (Objects.isNull(globalJVMMP) && Objects.isNull(requestSize)) {
                return;
            }
            this.value.setLength(0);
            Method getUsedQuota = admissionController.getDeclaredMethod("getUsedQuota", new Class[0]);
            Method getTotalQuota = admissionController.getDeclaredMethod("getTotalQuota", new Class[0]);
            Method getRejectionCount = admissionController.getDeclaredMethod("getRejectionCount", new Class[0]);
            if (!Objects.isNull(globalJVMMP)) {
                this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(new AdmissionControlMetrics(GLOBAL_JVMMP, (Long)getUsedQuota.invoke(globalJVMMP, new Object[0]), (Long)getTotalQuota.invoke(globalJVMMP, new Object[0]), (Long)getRejectionCount.invoke(globalJVMMP, new Object[0])).serialize());
            }
            if (!Objects.isNull(requestSize)) {
                this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(new AdmissionControlMetrics(REQUEST_SIZE, (Long)getUsedQuota.invoke(requestSize, new Object[0]), (Long)getTotalQuota.invoke(requestSize, new Object[0]), (Long)getRejectionCount.invoke(requestSize, new Object[0])).serialize());
            }
            this.saveMetricValues(this.value.toString(), startTime, new String[0]);
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.ADMISSION_CONTROL_COLLECTOR_EXECUTION_TIME, "", (Number)(System.currentTimeMillis() - startTimeMillis));
        }
        catch (Exception ex) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat((MeasurementSet)ExceptionsAndErrors.ADMISSION_CONTROL_COLLECTOR_ERROR, this.getCollectorName(), (Number)(System.currentTimeMillis() - startTimeMillis));
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = ex::toString;
            supplierArray[1] = () -> startTime;
            LOG.debug("Exception in collecting AdmissionControl Metrics: {} for startTime {}", supplierArray);
        }
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"admission_control_metrics"});
    }

    private boolean isAdmissionControlFeatureAvailable() {
        try {
            Class.forName(ADMISSION_CONTROLLER);
            Class.forName(ADMISSION_CONTROL_SERVICE);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    static class AdmissionControlMetrics
    extends MetricStatus {
        private String controllerName;
        private long current;
        private long threshold;
        private long rejectionCount;

        public AdmissionControlMetrics() {
        }

        public AdmissionControlMetrics(String controllerName, long current, long threshold, long rejectionCount) {
            this.controllerName = controllerName;
            this.current = current;
            this.threshold = threshold;
            this.rejectionCount = rejectionCount;
        }

        @JsonProperty(value="ControllerName")
        public String getControllerName() {
            return this.controllerName;
        }

        @JsonProperty(value="AdmissionControl_CurrentValue")
        public long getCurrent() {
            return this.current;
        }

        @JsonProperty(value="AdmissionControl_ThresholdValue")
        public long getThreshold() {
            return this.threshold;
        }

        @JsonProperty(value="AdmissionControl_RejectionCount")
        public long getRejectionCount() {
            return this.rejectionCount;
        }
    }
}

