/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.store.collector.NodeConfigCache;
import org.opensearch.performanceanalyzer.reader.ClusterDetailsEventProcessor;

public class AppContext {
    private volatile ClusterDetailsEventProcessor clusterDetailsEventProcessor;
    private final NodeConfigCache nodeConfigCache;
    private volatile Set<String> mutedActions;

    public AppContext() {
        this.clusterDetailsEventProcessor = null;
        this.nodeConfigCache = new NodeConfigCache();
        this.mutedActions = ImmutableSet.of();
    }

    public AppContext(AppContext other) {
        this.clusterDetailsEventProcessor = new ClusterDetailsEventProcessor(other.clusterDetailsEventProcessor);
        this.nodeConfigCache = new NodeConfigCache();
        this.mutedActions = ImmutableSet.copyOf(other.getMutedActions());
    }

    public void setClusterDetailsEventProcessor(ClusterDetailsEventProcessor clusterDetailsEventProcessor) {
        this.clusterDetailsEventProcessor = clusterDetailsEventProcessor;
    }

    public InstanceDetails getMyInstanceDetails() {
        InstanceDetails ret = new InstanceDetails(AllMetrics.NodeRole.UNKNOWN);
        if (this.clusterDetailsEventProcessor != null && this.clusterDetailsEventProcessor.getCurrentNodeDetails() != null) {
            ClusterDetailsEventProcessor.NodeDetails nodeDetails = this.clusterDetailsEventProcessor.getCurrentNodeDetails();
            ret = new InstanceDetails(nodeDetails);
        }
        return ret;
    }

    public List<InstanceDetails> getAllClusterInstances() {
        List<InstanceDetails> ret = Collections.EMPTY_LIST;
        if (this.clusterDetailsEventProcessor != null) {
            ret = AppContext.getInstanceDetailsFromNodeDetails(this.clusterDetailsEventProcessor.getNodesDetails());
        }
        return ret;
    }

    public List<InstanceDetails> getDataNodeInstances() {
        List<InstanceDetails> ret = Collections.EMPTY_LIST;
        if (this.clusterDetailsEventProcessor != null) {
            ret = AppContext.getInstanceDetailsFromNodeDetails(this.clusterDetailsEventProcessor.getDataNodesDetails());
        }
        return ret;
    }

    private static List<InstanceDetails> getInstanceDetailsFromNodeDetails(List<ClusterDetailsEventProcessor.NodeDetails> nodeDetails) {
        ImmutableList.Builder instanceDetails = ImmutableList.builder();
        for (ClusterDetailsEventProcessor.NodeDetails node : nodeDetails) {
            instanceDetails.add((Object)new InstanceDetails(node));
        }
        return instanceDetails.build();
    }

    @VisibleForTesting
    public ClusterDetailsEventProcessor getClusterDetailsEventProcessor() {
        return this.clusterDetailsEventProcessor;
    }

    public Set<InstanceDetails> getPeerInstances() {
        return ImmutableSet.copyOf((Collection)this.getAllClusterInstances().stream().skip(1L).collect(Collectors.toSet()));
    }

    public NodeConfigCache getNodeConfigCache() {
        return this.nodeConfigCache;
    }

    public InstanceDetails getInstanceById(InstanceDetails.Id instanceIdKey) {
        return this.getPeerInstances().stream().filter(x -> x.getInstanceId().equals(instanceIdKey)).findFirst().orElse(new InstanceDetails(AllMetrics.NodeRole.UNKNOWN));
    }

    public boolean isActionMuted(String action) {
        return this.mutedActions.contains(action);
    }

    public void updateMutedActions(Set<String> mutedActions) {
        this.mutedActions = ImmutableSet.copyOf(mutedActions);
    }

    public Set<String> getMutedActions() {
        return this.mutedActions;
    }
}

