/* BackgroundManager.c generated by valac 0.56.3, the Vala compiler
 * generated from BackgroundManager.vala, do not modify */

/*
 * Copyright (c) 2011-2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>

#define WINGPANEL_SERVICES_BACKGROUND_MANAGER_DBUS_NAME "org.pantheon.gala.WingpanelInterface"
#define WINGPANEL_SERVICES_BACKGROUND_MANAGER_DBUS_PATH "/org/pantheon/gala/WingpanelInterface"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	WINGPANEL_SERVICES_BACKGROUND_STATE_LIGHT,
	WINGPANEL_SERVICES_BACKGROUND_STATE_DARK,
	WINGPANEL_SERVICES_BACKGROUND_STATE_MAXIMIZED,
	WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_DARK,
	WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_LIGHT
} WingpanelServicesBackgroundState;

#define WINGPANEL_SERVICES_TYPE_BACKGROUND_STATE (wingpanel_services_background_state_get_type ())

#define WINGPANEL_SERVICES_TYPE_INTERFACE_BUS (wingpanel_services_interface_bus_get_type ())
#define WINGPANEL_SERVICES_INTERFACE_BUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_SERVICES_TYPE_INTERFACE_BUS, WingpanelServicesInterfaceBus))
#define WINGPANEL_SERVICES_IS_INTERFACE_BUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_SERVICES_TYPE_INTERFACE_BUS))
#define WINGPANEL_SERVICES_INTERFACE_BUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), WINGPANEL_SERVICES_TYPE_INTERFACE_BUS, WingpanelServicesInterfaceBusIface))

typedef struct _WingpanelServicesInterfaceBus WingpanelServicesInterfaceBus;
typedef struct _WingpanelServicesInterfaceBusIface WingpanelServicesInterfaceBusIface;

#define WINGPANEL_SERVICES_TYPE_INTERFACE_BUS_PROXY (wingpanel_services_interface_bus_proxy_get_type ())
enum  {
	WINGPANEL_SERVICES_INTERFACE_BUS_STATE_CHANGED_SIGNAL,
	WINGPANEL_SERVICES_INTERFACE_BUS_NUM_SIGNALS
};
static guint wingpanel_services_interface_bus_signals[WINGPANEL_SERVICES_INTERFACE_BUS_NUM_SIGNALS] = {0};
typedef GDBusProxy WingpanelServicesInterfaceBusProxy;
typedef GDBusProxyClass WingpanelServicesInterfaceBusProxyClass;

#define WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER (wingpanel_services_background_manager_get_type ())
#define WINGPANEL_SERVICES_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER, WingpanelServicesBackgroundManager))
#define WINGPANEL_SERVICES_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER, WingpanelServicesBackgroundManagerClass))
#define WINGPANEL_SERVICES_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER))
#define WINGPANEL_SERVICES_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER))
#define WINGPANEL_SERVICES_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER, WingpanelServicesBackgroundManagerClass))

typedef struct _WingpanelServicesBackgroundManager WingpanelServicesBackgroundManager;
typedef struct _WingpanelServicesBackgroundManagerClass WingpanelServicesBackgroundManagerClass;
typedef struct _WingpanelServicesBackgroundManagerPrivate WingpanelServicesBackgroundManagerPrivate;
enum  {
	WINGPANEL_SERVICES_BACKGROUND_MANAGER_0_PROPERTY,
	WINGPANEL_SERVICES_BACKGROUND_MANAGER_NUM_PROPERTIES
};
static GParamSpec* wingpanel_services_background_manager_properties[WINGPANEL_SERVICES_BACKGROUND_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	WINGPANEL_SERVICES_BACKGROUND_MANAGER_BACKGROUND_STATE_CHANGED_SIGNAL,
	WINGPANEL_SERVICES_BACKGROUND_MANAGER_NUM_SIGNALS
};
static guint wingpanel_services_background_manager_signals[WINGPANEL_SERVICES_BACKGROUND_MANAGER_NUM_SIGNALS] = {0};

struct _WingpanelServicesInterfaceBusIface {
	GTypeInterface parent_iface;
	void (*initialize) (WingpanelServicesInterfaceBus* self, gint monitor, gint panel_height, GError** error);
	void (*remember_focused_window) (WingpanelServicesInterfaceBus* self, GError** error);
	void (*restore_focused_window) (WingpanelServicesInterfaceBus* self, GError** error);
	gboolean (*begin_grab_focused_window) (WingpanelServicesInterfaceBus* self, gint x, gint y, gint button, guint time, guint state, GError** error);
};

struct _WingpanelServicesBackgroundManager {
	GObject parent_instance;
	WingpanelServicesBackgroundManagerPrivate * priv;
};

struct _WingpanelServicesBackgroundManagerClass {
	GObjectClass parent_class;
};

struct _WingpanelServicesBackgroundManagerPrivate {
	WingpanelServicesInterfaceBus* bus;
	WingpanelServicesBackgroundState current_state;
	gboolean use_transparency;
	gint monitor;
	gint panel_height;
};

struct _Block4Data {
	int _ref_count_;
	WingpanelServicesBackgroundManager* self;
	GSettings* panel_settings;
};

static gint WingpanelServicesBackgroundManager_private_offset;
static gpointer wingpanel_services_background_manager_parent_class = NULL;
static WingpanelServicesBackgroundManager* wingpanel_services_background_manager_instance;
static WingpanelServicesBackgroundManager* wingpanel_services_background_manager_instance = NULL;

VALA_EXTERN GType wingpanel_services_background_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType wingpanel_services_interface_bus_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint wingpanel_services_interface_bus_register_object (void* object,
                                                        GDBusConnection* connection,
                                                        const gchar* path,
                                                        GError** error);
VALA_EXTERN GType wingpanel_services_interface_bus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WingpanelServicesInterfaceBus, g_object_unref)
VALA_EXTERN void wingpanel_services_interface_bus_initialize (WingpanelServicesInterfaceBus* self,
                                                  gint monitor,
                                                  gint panel_height,
                                                  GError** error);
VALA_EXTERN void wingpanel_services_interface_bus_remember_focused_window (WingpanelServicesInterfaceBus* self,
                                                               GError** error);
VALA_EXTERN void wingpanel_services_interface_bus_restore_focused_window (WingpanelServicesInterfaceBus* self,
                                                              GError** error);
VALA_EXTERN gboolean wingpanel_services_interface_bus_begin_grab_focused_window (WingpanelServicesInterfaceBus* self,
                                                                     gint x,
                                                                     gint y,
                                                                     gint button,
                                                                     guint time,
                                                                     guint state,
                                                                     GError** error);
static void g_cclosure_user_marshal_VOID__ENUM_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static GType wingpanel_services_interface_bus_get_type_once (void);
static void wingpanel_services_interface_bus_proxy_g_signal (GDBusProxy* proxy,
                                                      const gchar* sender_name,
                                                      const gchar* signal_name,
                                                      GVariant* parameters);
static void _dbus_handle_wingpanel_services_interface_bus_state_changed (WingpanelServicesInterfaceBus* self,
                                                                  GVariant* parameters);
static void wingpanel_services_interface_bus_proxy_initialize (WingpanelServicesInterfaceBus* self,
                                                        gint monitor,
                                                        gint panel_height,
                                                        GError** error);
static void wingpanel_services_interface_bus_proxy_remember_focused_window (WingpanelServicesInterfaceBus* self,
                                                                     GError** error);
static void wingpanel_services_interface_bus_proxy_restore_focused_window (WingpanelServicesInterfaceBus* self,
                                                                    GError** error);
static gboolean wingpanel_services_interface_bus_proxy_begin_grab_focused_window (WingpanelServicesInterfaceBus* self,
                                                                           gint x,
                                                                           gint y,
                                                                           gint button,
                                                                           guint time,
                                                                           guint state,
                                                                           GError** error);
static void wingpanel_services_interface_bus_proxy_wingpanel_services_interface_bus_interface_init (WingpanelServicesInterfaceBusIface* iface);
static void _dbus_wingpanel_services_interface_bus_initialize (WingpanelServicesInterfaceBus* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_wingpanel_services_interface_bus_remember_focused_window (WingpanelServicesInterfaceBus* self,
                                                                     GVariant* _parameters_,
                                                                     GDBusMethodInvocation* invocation);
static void _dbus_wingpanel_services_interface_bus_restore_focused_window (WingpanelServicesInterfaceBus* self,
                                                                    GVariant* _parameters_,
                                                                    GDBusMethodInvocation* invocation);
static void _dbus_wingpanel_services_interface_bus_begin_grab_focused_window (WingpanelServicesInterfaceBus* self,
                                                                       GVariant* _parameters_,
                                                                       GDBusMethodInvocation* invocation);
static void wingpanel_services_interface_bus_dbus_interface_method_call (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* method_name,
                                                                  GVariant* parameters,
                                                                  GDBusMethodInvocation* invocation,
                                                                  gpointer user_data);
static GVariant* wingpanel_services_interface_bus_dbus_interface_get_property (GDBusConnection* connection,
                                                                        const gchar* sender,
                                                                        const gchar* object_path,
                                                                        const gchar* interface_name,
                                                                        const gchar* property_name,
                                                                        GError** error,
                                                                        gpointer user_data);
static gboolean wingpanel_services_interface_bus_dbus_interface_set_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GVariant* value,
                                                                       GError** error,
                                                                       gpointer user_data);
static void _dbus_wingpanel_services_interface_bus_state_changed (GObject* _sender,
                                                           WingpanelServicesBackgroundState state,
                                                           guint animation_duration,
                                                           gpointer* _data);
static void _wingpanel_services_interface_bus_unregister_object (gpointer user_data);
VALA_EXTERN GType wingpanel_services_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WingpanelServicesBackgroundManager, g_object_unref)
VALA_EXTERN void wingpanel_services_background_manager_initialize (gint monitor,
                                                       gint panel_height);
VALA_EXTERN WingpanelServicesBackgroundManager* wingpanel_services_background_manager_get_default (void);
static WingpanelServicesBackgroundManager* wingpanel_services_background_manager_new (void);
static WingpanelServicesBackgroundManager* wingpanel_services_background_manager_construct (GType object_type);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda5_ (Block4Data* _data4_);
static void wingpanel_services_background_manager_state_updated (WingpanelServicesBackgroundManager* self,
                                                          guint animation_duration);
static void ___lambda5__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void __lambda6_ (WingpanelServicesBackgroundManager* self);
static gboolean wingpanel_services_background_manager_connect_dbus (WingpanelServicesBackgroundManager* self);
static void ___lambda6__gbus_name_appeared_callback (GDBusConnection* connection,
                                              const gchar* name,
                                              const gchar* name_owner,
                                              gpointer self);
static void __lambda8_ (WingpanelServicesBackgroundManager* self);
static void ___lambda8__gbus_name_vanished_callback (GDBusConnection* connection,
                                              const gchar* name,
                                              gpointer self);
VALA_EXTERN void wingpanel_services_background_manager_remember_window (WingpanelServicesBackgroundManager* self);
static gboolean wingpanel_services_background_manager_get_bus_available (WingpanelServicesBackgroundManager* self);
VALA_EXTERN void wingpanel_services_background_manager_restore_window (WingpanelServicesBackgroundManager* self);
VALA_EXTERN gboolean wingpanel_services_background_manager_begin_grab_focused_window (WingpanelServicesBackgroundManager* self,
                                                                          gint x,
                                                                          gint y,
                                                                          gint button,
                                                                          guint time,
                                                                          guint state);
static void __lambda7_ (WingpanelServicesBackgroundManager* self,
                 WingpanelServicesBackgroundState state,
                 guint animation_duration);
static void ___lambda7__wingpanel_services_interface_bus_state_changed (WingpanelServicesInterfaceBus* _sender,
                                                                 WingpanelServicesBackgroundState state,
                                                                 guint animation_duration,
                                                                 gpointer self);
static void wingpanel_services_background_manager_finalize (GObject * obj);
static GType wingpanel_services_background_manager_get_type_once (void);
static void _vala_wingpanel_services_background_manager_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);

static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_initialize_monitor = {-1, "monitor", "i", NULL};
static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_initialize_panel_height = {-1, "panel_height", "i", NULL};
static const GDBusArgInfo * const _wingpanel_services_interface_bus_dbus_arg_info_initialize_in[] = {&_wingpanel_services_interface_bus_dbus_arg_info_initialize_monitor, &_wingpanel_services_interface_bus_dbus_arg_info_initialize_panel_height, NULL};
static const GDBusArgInfo * const _wingpanel_services_interface_bus_dbus_arg_info_initialize_out[] = {NULL};
static const GDBusMethodInfo _wingpanel_services_interface_bus_dbus_method_info_initialize = {-1, "Initialize", (GDBusArgInfo **) (&_wingpanel_services_interface_bus_dbus_arg_info_initialize_in), (GDBusArgInfo **) (&_wingpanel_services_interface_bus_dbus_arg_info_initialize_out), NULL};
static const GDBusArgInfo * const _wingpanel_services_interface_bus_dbus_arg_info_remember_focused_window_in[] = {NULL};
static const GDBusArgInfo * const _wingpanel_services_interface_bus_dbus_arg_info_remember_focused_window_out[] = {NULL};
static const GDBusMethodInfo _wingpanel_services_interface_bus_dbus_method_info_remember_focused_window = {-1, "RememberFocusedWindow", (GDBusArgInfo **) (&_wingpanel_services_interface_bus_dbus_arg_info_remember_focused_window_in), (GDBusArgInfo **) (&_wingpanel_services_interface_bus_dbus_arg_info_remember_focused_window_out), NULL};
static const GDBusArgInfo * const _wingpanel_services_interface_bus_dbus_arg_info_restore_focused_window_in[] = {NULL};
static const GDBusArgInfo * const _wingpanel_services_interface_bus_dbus_arg_info_restore_focused_window_out[] = {NULL};
static const GDBusMethodInfo _wingpanel_services_interface_bus_dbus_method_info_restore_focused_window = {-1, "RestoreFocusedWindow", (GDBusArgInfo **) (&_wingpanel_services_interface_bus_dbus_arg_info_restore_focused_window_in), (GDBusArgInfo **) (&_wingpanel_services_interface_bus_dbus_arg_info_restore_focused_window_out), NULL};
static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_y = {-1, "y", "i", NULL};
static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_button = {-1, "button", "i", NULL};
static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_time = {-1, "time", "u", NULL};
static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_state = {-1, "state", "u", NULL};
static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_in[] = {&_wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_x, &_wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_y, &_wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_button, &_wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_time, &_wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_state, NULL};
static const GDBusArgInfo * const _wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_out[] = {&_wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_result, NULL};
static const GDBusMethodInfo _wingpanel_services_interface_bus_dbus_method_info_begin_grab_focused_window = {-1, "BeginGrabFocusedWindow", (GDBusArgInfo **) (&_wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_in), (GDBusArgInfo **) (&_wingpanel_services_interface_bus_dbus_arg_info_begin_grab_focused_window_out), NULL};
static const GDBusMethodInfo * const _wingpanel_services_interface_bus_dbus_method_info[] = {&_wingpanel_services_interface_bus_dbus_method_info_initialize, &_wingpanel_services_interface_bus_dbus_method_info_remember_focused_window, &_wingpanel_services_interface_bus_dbus_method_info_restore_focused_window, &_wingpanel_services_interface_bus_dbus_method_info_begin_grab_focused_window, NULL};
static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_state_changed_state = {-1, "state", "i", NULL};
static const GDBusArgInfo _wingpanel_services_interface_bus_dbus_arg_info_state_changed_animation_duration = {-1, "animation_duration", "u", NULL};
static const GDBusArgInfo * const _wingpanel_services_interface_bus_dbus_arg_info_state_changed[] = {&_wingpanel_services_interface_bus_dbus_arg_info_state_changed_state, &_wingpanel_services_interface_bus_dbus_arg_info_state_changed_animation_duration, NULL};
static const GDBusSignalInfo _wingpanel_services_interface_bus_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_wingpanel_services_interface_bus_dbus_arg_info_state_changed), NULL};
static const GDBusSignalInfo * const _wingpanel_services_interface_bus_dbus_signal_info[] = {&_wingpanel_services_interface_bus_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo * const _wingpanel_services_interface_bus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _wingpanel_services_interface_bus_dbus_interface_info = {-1, "org.pantheon.gala.WingpanelInterface", (GDBusMethodInfo **) (&_wingpanel_services_interface_bus_dbus_method_info), (GDBusSignalInfo **) (&_wingpanel_services_interface_bus_dbus_signal_info), (GDBusPropertyInfo **) (&_wingpanel_services_interface_bus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _wingpanel_services_interface_bus_dbus_interface_vtable = {wingpanel_services_interface_bus_dbus_interface_method_call, wingpanel_services_interface_bus_dbus_interface_get_property, wingpanel_services_interface_bus_dbus_interface_set_property};

static GType
wingpanel_services_background_state_get_type_once (void)
{
	static const GEnumValue values[] = {{WINGPANEL_SERVICES_BACKGROUND_STATE_LIGHT, "WINGPANEL_SERVICES_BACKGROUND_STATE_LIGHT", "light"}, {WINGPANEL_SERVICES_BACKGROUND_STATE_DARK, "WINGPANEL_SERVICES_BACKGROUND_STATE_DARK", "dark"}, {WINGPANEL_SERVICES_BACKGROUND_STATE_MAXIMIZED, "WINGPANEL_SERVICES_BACKGROUND_STATE_MAXIMIZED", "maximized"}, {WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_DARK, "WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_DARK", "translucent-dark"}, {WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_LIGHT, "WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_LIGHT", "translucent-light"}, {0, NULL, NULL}};
	GType wingpanel_services_background_state_type_id;
	wingpanel_services_background_state_type_id = g_enum_register_static ("WingpanelServicesBackgroundState", values);
	return wingpanel_services_background_state_type_id;
}

GType
wingpanel_services_background_state_get_type (void)
{
	static volatile gsize wingpanel_services_background_state_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_services_background_state_type_id__once)) {
		GType wingpanel_services_background_state_type_id;
		wingpanel_services_background_state_type_id = wingpanel_services_background_state_get_type_once ();
		g_once_init_leave (&wingpanel_services_background_state_type_id__once, wingpanel_services_background_state_type_id);
	}
	return wingpanel_services_background_state_type_id__once;
}

void
wingpanel_services_interface_bus_initialize (WingpanelServicesInterfaceBus* self,
                                             gint monitor,
                                             gint panel_height,
                                             GError** error)
{
	WingpanelServicesInterfaceBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = WINGPANEL_SERVICES_INTERFACE_BUS_GET_INTERFACE (self);
	if (_iface_->initialize) {
		_iface_->initialize (self, monitor, panel_height, error);
	}
}

void
wingpanel_services_interface_bus_remember_focused_window (WingpanelServicesInterfaceBus* self,
                                                          GError** error)
{
	WingpanelServicesInterfaceBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = WINGPANEL_SERVICES_INTERFACE_BUS_GET_INTERFACE (self);
	if (_iface_->remember_focused_window) {
		_iface_->remember_focused_window (self, error);
	}
}

void
wingpanel_services_interface_bus_restore_focused_window (WingpanelServicesInterfaceBus* self,
                                                         GError** error)
{
	WingpanelServicesInterfaceBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = WINGPANEL_SERVICES_INTERFACE_BUS_GET_INTERFACE (self);
	if (_iface_->restore_focused_window) {
		_iface_->restore_focused_window (self, error);
	}
}

gboolean
wingpanel_services_interface_bus_begin_grab_focused_window (WingpanelServicesInterfaceBus* self,
                                                            gint x,
                                                            gint y,
                                                            gint button,
                                                            guint time,
                                                            guint state,
                                                            GError** error)
{
	WingpanelServicesInterfaceBusIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = WINGPANEL_SERVICES_INTERFACE_BUS_GET_INTERFACE (self);
	if (_iface_->begin_grab_focused_window) {
		return _iface_->begin_grab_focused_window (self, x, y, button, time, state, error);
	}
	return FALSE;
}

static void
g_cclosure_user_marshal_VOID__ENUM_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_UINT) (gpointer data1, gint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
wingpanel_services_interface_bus_default_init (WingpanelServicesInterfaceBusIface * iface,
                                               gpointer iface_data)
{
	wingpanel_services_interface_bus_signals[WINGPANEL_SERVICES_INTERFACE_BUS_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", WINGPANEL_SERVICES_TYPE_INTERFACE_BUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_UINT, G_TYPE_NONE, 2, WINGPANEL_SERVICES_TYPE_BACKGROUND_STATE, G_TYPE_UINT);
}

static GType
wingpanel_services_interface_bus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelServicesInterfaceBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_services_interface_bus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType wingpanel_services_interface_bus_type_id;
	wingpanel_services_interface_bus_type_id = g_type_register_static (G_TYPE_INTERFACE, "WingpanelServicesInterfaceBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (wingpanel_services_interface_bus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (wingpanel_services_interface_bus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) wingpanel_services_interface_bus_proxy_get_type);
	g_type_set_qdata (wingpanel_services_interface_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.pantheon.gala.WingpanelInterface");
	g_type_set_qdata (wingpanel_services_interface_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_wingpanel_services_interface_bus_dbus_interface_info));
	g_type_set_qdata (wingpanel_services_interface_bus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) wingpanel_services_interface_bus_register_object);
	return wingpanel_services_interface_bus_type_id;
}

GType
wingpanel_services_interface_bus_get_type (void)
{
	static volatile gsize wingpanel_services_interface_bus_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_services_interface_bus_type_id__once)) {
		GType wingpanel_services_interface_bus_type_id;
		wingpanel_services_interface_bus_type_id = wingpanel_services_interface_bus_get_type_once ();
		g_once_init_leave (&wingpanel_services_interface_bus_type_id__once, wingpanel_services_interface_bus_type_id);
	}
	return wingpanel_services_interface_bus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (WingpanelServicesInterfaceBusProxy, wingpanel_services_interface_bus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (WINGPANEL_SERVICES_TYPE_INTERFACE_BUS, wingpanel_services_interface_bus_proxy_wingpanel_services_interface_bus_interface_init) )
static void
wingpanel_services_interface_bus_proxy_class_init (WingpanelServicesInterfaceBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = wingpanel_services_interface_bus_proxy_g_signal;
}

static void
_dbus_handle_wingpanel_services_interface_bus_state_changed (WingpanelServicesInterfaceBus* self,
                                                             GVariant* parameters)
{
	GVariantIter _arguments_iter;
	WingpanelServicesBackgroundState state = 0;
	GVariant* _tmp7_;
	guint animation_duration = 0U;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	state = g_variant_get_int32 (_tmp7_);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	animation_duration = g_variant_get_uint32 (_tmp8_);
	g_variant_unref (_tmp8_);
	g_signal_emit_by_name (self, "state-changed", state, animation_duration);
}

static void
wingpanel_services_interface_bus_proxy_g_signal (GDBusProxy* proxy,
                                                 const gchar* sender_name,
                                                 const gchar* signal_name,
                                                 GVariant* parameters)
{
	if (strcmp (signal_name, "StateChanged") == 0) {
		_dbus_handle_wingpanel_services_interface_bus_state_changed ((WingpanelServicesInterfaceBus*) proxy, parameters);
	}
}

static void
wingpanel_services_interface_bus_proxy_init (WingpanelServicesInterfaceBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_wingpanel_services_interface_bus_dbus_interface_info));
}

static void
wingpanel_services_interface_bus_proxy_initialize (WingpanelServicesInterfaceBus* self,
                                                   gint monitor,
                                                   gint panel_height,
                                                   GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala.WingpanelInterface", "Initialize");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (monitor));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (panel_height));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
wingpanel_services_interface_bus_proxy_remember_focused_window (WingpanelServicesInterfaceBus* self,
                                                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala.WingpanelInterface", "RememberFocusedWindow");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
wingpanel_services_interface_bus_proxy_restore_focused_window (WingpanelServicesInterfaceBus* self,
                                                               GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala.WingpanelInterface", "RestoreFocusedWindow");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gboolean
wingpanel_services_interface_bus_proxy_begin_grab_focused_window (WingpanelServicesInterfaceBus* self,
                                                                  gint x,
                                                                  gint y,
                                                                  gint button,
                                                                  guint time,
                                                                  guint state,
                                                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp11_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala.WingpanelInterface", "BeginGrabFocusedWindow");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (x));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (y));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (button));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (time));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (state));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp9_ = FALSE;
		return _tmp9_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp10_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp10_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp11_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp11_);
	g_variant_unref (_tmp11_);
	g_object_unref (_reply_message);
	return _result;
}

static void
wingpanel_services_interface_bus_proxy_wingpanel_services_interface_bus_interface_init (WingpanelServicesInterfaceBusIface* iface)
{
	iface->initialize = wingpanel_services_interface_bus_proxy_initialize;
	iface->remember_focused_window = wingpanel_services_interface_bus_proxy_remember_focused_window;
	iface->restore_focused_window = wingpanel_services_interface_bus_proxy_restore_focused_window;
	iface->begin_grab_focused_window = wingpanel_services_interface_bus_proxy_begin_grab_focused_window;
}

static void
_dbus_wingpanel_services_interface_bus_initialize (WingpanelServicesInterfaceBus* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint monitor = 0;
	GVariant* _tmp12_;
	gint panel_height = 0;
	GVariant* _tmp13_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	monitor = g_variant_get_int32 (_tmp12_);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	panel_height = g_variant_get_int32 (_tmp13_);
	g_variant_unref (_tmp13_);
	wingpanel_services_interface_bus_initialize (self, monitor, panel_height, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_wingpanel_services_interface_bus_remember_focused_window (WingpanelServicesInterfaceBus* self,
                                                                GVariant* _parameters_,
                                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	wingpanel_services_interface_bus_remember_focused_window (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_wingpanel_services_interface_bus_restore_focused_window (WingpanelServicesInterfaceBus* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	wingpanel_services_interface_bus_restore_focused_window (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_wingpanel_services_interface_bus_begin_grab_focused_window (WingpanelServicesInterfaceBus* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint x = 0;
	GVariant* _tmp14_;
	gint y = 0;
	GVariant* _tmp15_;
	gint button = 0;
	GVariant* _tmp16_;
	guint time = 0U;
	GVariant* _tmp17_;
	guint state = 0U;
	GVariant* _tmp18_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp14_);
	g_variant_unref (_tmp14_);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp15_);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	button = g_variant_get_int32 (_tmp16_);
	g_variant_unref (_tmp16_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	time = g_variant_get_uint32 (_tmp17_);
	g_variant_unref (_tmp17_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	state = g_variant_get_uint32 (_tmp18_);
	g_variant_unref (_tmp18_);
	result = wingpanel_services_interface_bus_begin_grab_focused_window (self, x, y, button, time, state, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
wingpanel_services_interface_bus_dbus_interface_method_call (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* method_name,
                                                             GVariant* parameters,
                                                             GDBusMethodInvocation* invocation,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Initialize") == 0) {
		_dbus_wingpanel_services_interface_bus_initialize (object, parameters, invocation);
	} else if (strcmp (method_name, "RememberFocusedWindow") == 0) {
		_dbus_wingpanel_services_interface_bus_remember_focused_window (object, parameters, invocation);
	} else if (strcmp (method_name, "RestoreFocusedWindow") == 0) {
		_dbus_wingpanel_services_interface_bus_restore_focused_window (object, parameters, invocation);
	} else if (strcmp (method_name, "BeginGrabFocusedWindow") == 0) {
		_dbus_wingpanel_services_interface_bus_begin_grab_focused_window (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
wingpanel_services_interface_bus_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
wingpanel_services_interface_bus_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_wingpanel_services_interface_bus_state_changed (GObject* _sender,
                                                      WingpanelServicesBackgroundState state,
                                                      guint animation_duration,
                                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (state));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (animation_duration));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.gala.WingpanelInterface", "StateChanged", _arguments, NULL);
}

guint
wingpanel_services_interface_bus_register_object (gpointer object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_wingpanel_services_interface_bus_dbus_interface_info), &_wingpanel_services_interface_bus_dbus_interface_vtable, data, _wingpanel_services_interface_bus_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_wingpanel_services_interface_bus_state_changed, data);
	return result;
}

static void
_wingpanel_services_interface_bus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_wingpanel_services_interface_bus_state_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
wingpanel_services_background_manager_get_instance_private (WingpanelServicesBackgroundManager* self)
{
	return G_STRUCT_MEMBER_P (self, WingpanelServicesBackgroundManager_private_offset);
}

void
wingpanel_services_background_manager_initialize (gint monitor,
                                                  gint panel_height)
{
	WingpanelServicesBackgroundManager* manager = NULL;
	WingpanelServicesBackgroundManager* _tmp0_;
	_tmp0_ = wingpanel_services_background_manager_get_default ();
	manager = _tmp0_;
	manager->priv->monitor = monitor;
	manager->priv->panel_height = panel_height;
	_g_object_unref0 (manager);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		WingpanelServicesBackgroundManager* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->panel_settings);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda5_ (Block4Data* _data4_)
{
	WingpanelServicesBackgroundManager* self;
	self = _data4_->self;
	self->priv->use_transparency = g_settings_get_boolean (_data4_->panel_settings, "use-transparency");
	wingpanel_services_background_manager_state_updated (self, (guint) 0);
}

static void
___lambda5__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda5_ (self);
}

static void
__lambda6_ (WingpanelServicesBackgroundManager* self)
{
	wingpanel_services_background_manager_connect_dbus (self);
}

static void
___lambda6__gbus_name_appeared_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         const gchar* name_owner,
                                         gpointer self)
{
	__lambda6_ ((WingpanelServicesBackgroundManager*) self);
}

static void
__lambda8_ (WingpanelServicesBackgroundManager* self)
{
	_g_object_unref0 (self->priv->bus);
	self->priv->bus = NULL;
	g_signal_emit (self, wingpanel_services_background_manager_signals[WINGPANEL_SERVICES_BACKGROUND_MANAGER_BACKGROUND_STATE_CHANGED_SIGNAL], 0, WINGPANEL_SERVICES_BACKGROUND_STATE_MAXIMIZED, (guint) 0);
}

static void
___lambda8__gbus_name_vanished_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         gpointer self)
{
	__lambda8_ ((WingpanelServicesBackgroundManager*) self);
}

static WingpanelServicesBackgroundManager*
wingpanel_services_background_manager_construct (GType object_type)
{
	WingpanelServicesBackgroundManager * self = NULL;
	Block4Data* _data4_;
	GSettings* _tmp0_;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	self = (WingpanelServicesBackgroundManager*) g_object_new (object_type, NULL);
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("io.elementary.desktop.wingpanel");
	_data4_->panel_settings = _tmp0_;
	g_signal_connect_data (_data4_->panel_settings, "changed::use-transparency", (GCallback) ___lambda5__g_settings_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	self->priv->use_transparency = g_settings_get_boolean (_data4_->panel_settings, "use-transparency");
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, WINGPANEL_SERVICES_BACKGROUND_MANAGER_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((___lambda6__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda6__gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda8__gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda8__gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}

static WingpanelServicesBackgroundManager*
wingpanel_services_background_manager_new (void)
{
	return wingpanel_services_background_manager_construct (WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER);
}

void
wingpanel_services_background_manager_remember_window (WingpanelServicesBackgroundManager* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = wingpanel_services_background_manager_get_bus_available (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		WingpanelServicesInterfaceBus* _tmp2_;
		_tmp2_ = self->priv->bus;
		wingpanel_services_interface_bus_remember_focused_window (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("BackgroundManager.vala:95: Remembering focused window failed: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
wingpanel_services_background_manager_restore_window (WingpanelServicesBackgroundManager* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = wingpanel_services_background_manager_get_bus_available (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		WingpanelServicesInterfaceBus* _tmp2_;
		_tmp2_ = self->priv->bus;
		wingpanel_services_interface_bus_restore_focused_window (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("BackgroundManager.vala:107: Restoring last focused window failed: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
wingpanel_services_background_manager_begin_grab_focused_window (WingpanelServicesBackgroundManager* self,
                                                                 gint x,
                                                                 gint y,
                                                                 gint button,
                                                                 guint time,
                                                                 guint state)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		WingpanelServicesInterfaceBus* _tmp1_;
		_tmp1_ = self->priv->bus;
		_tmp0_ = wingpanel_services_interface_bus_begin_grab_focused_window (_tmp1_, x, y, button, time, state, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("BackgroundManager.vala:115: Grabbing focused window failed: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	result = FALSE;
	return result;
}

static void
__lambda7_ (WingpanelServicesBackgroundManager* self,
            WingpanelServicesBackgroundState state,
            guint animation_duration)
{
	self->priv->current_state = state;
	wingpanel_services_background_manager_state_updated (self, animation_duration);
}

static void
___lambda7__wingpanel_services_interface_bus_state_changed (WingpanelServicesInterfaceBus* _sender,
                                                            WingpanelServicesBackgroundState state,
                                                            guint animation_duration,
                                                            gpointer self)
{
	__lambda7_ ((WingpanelServicesBackgroundManager*) self, state, animation_duration);
}

static gboolean
wingpanel_services_background_manager_connect_dbus (WingpanelServicesBackgroundManager* self)
{
	WingpanelServicesInterfaceBus* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		WingpanelServicesInterfaceBus* _tmp0_ = NULL;
		WingpanelServicesInterfaceBus* _tmp1_;
		WingpanelServicesInterfaceBus* _tmp2_;
		WingpanelServicesInterfaceBus* _tmp3_;
		_tmp1_ = (WingpanelServicesInterfaceBus*) g_initable_new (WINGPANEL_SERVICES_TYPE_INTERFACE_BUS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", WINGPANEL_SERVICES_BACKGROUND_MANAGER_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", WINGPANEL_SERVICES_BACKGROUND_MANAGER_DBUS_PATH, "g-interface-name", "org.pantheon.gala.WingpanelInterface", NULL);
		_tmp0_ = (WingpanelServicesInterfaceBus*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->bus);
		self->priv->bus = _tmp2_;
		_tmp3_ = self->priv->bus;
		wingpanel_services_interface_bus_initialize (_tmp3_, self->priv->monitor, self->priv->panel_height, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("BackgroundManager.vala:126: Connecting to \"%s\" failed: %s", WINGPANEL_SERVICES_BACKGROUND_MANAGER_DBUS_NAME, _tmp5_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	_tmp7_ = self->priv->bus;
	g_signal_connect_object (_tmp7_, "state-changed", (GCallback) ___lambda7__wingpanel_services_interface_bus_state_changed, self, 0);
	wingpanel_services_background_manager_state_updated (self, (guint) 0);
	result = TRUE;
	return result;
}

static void
wingpanel_services_background_manager_state_updated (WingpanelServicesBackgroundManager* self,
                                                     guint animation_duration)
{
	WingpanelServicesBackgroundState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	if (self->priv->use_transparency) {
		_tmp0_ = self->priv->current_state;
	} else {
		_tmp0_ = WINGPANEL_SERVICES_BACKGROUND_STATE_MAXIMIZED;
	}
	g_signal_emit (self, wingpanel_services_background_manager_signals[WINGPANEL_SERVICES_BACKGROUND_MANAGER_BACKGROUND_STATE_CHANGED_SIGNAL], 0, _tmp0_, animation_duration);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

WingpanelServicesBackgroundManager*
wingpanel_services_background_manager_get_default (void)
{
	WingpanelServicesBackgroundManager* _tmp0_;
	WingpanelServicesBackgroundManager* _tmp2_;
	WingpanelServicesBackgroundManager* _tmp3_;
	WingpanelServicesBackgroundManager* result;
	_tmp0_ = wingpanel_services_background_manager_instance;
	if (_tmp0_ == NULL) {
		WingpanelServicesBackgroundManager* _tmp1_;
		_tmp1_ = wingpanel_services_background_manager_new ();
		_g_object_unref0 (wingpanel_services_background_manager_instance);
		wingpanel_services_background_manager_instance = _tmp1_;
	}
	_tmp2_ = wingpanel_services_background_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
wingpanel_services_background_manager_get_bus_available (WingpanelServicesBackgroundManager* self)
{
	gboolean result;
	WingpanelServicesInterfaceBus* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->bus;
	result = _tmp0_ != NULL;
	return result;
}

static void
wingpanel_services_background_manager_class_init (WingpanelServicesBackgroundManagerClass * klass,
                                                  gpointer klass_data)
{
	wingpanel_services_background_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WingpanelServicesBackgroundManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_wingpanel_services_background_manager_get_property;
	G_OBJECT_CLASS (klass)->finalize = wingpanel_services_background_manager_finalize;
	wingpanel_services_background_manager_signals[WINGPANEL_SERVICES_BACKGROUND_MANAGER_BACKGROUND_STATE_CHANGED_SIGNAL] = g_signal_new ("background-state-changed", WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_UINT, G_TYPE_NONE, 2, WINGPANEL_SERVICES_TYPE_BACKGROUND_STATE, G_TYPE_UINT);
}

static void
wingpanel_services_background_manager_instance_init (WingpanelServicesBackgroundManager * self,
                                                     gpointer klass)
{
	self->priv = wingpanel_services_background_manager_get_instance_private (self);
	self->priv->bus = NULL;
	self->priv->current_state = WINGPANEL_SERVICES_BACKGROUND_STATE_LIGHT;
	self->priv->use_transparency = TRUE;
}

static void
wingpanel_services_background_manager_finalize (GObject * obj)
{
	WingpanelServicesBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER, WingpanelServicesBackgroundManager);
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (wingpanel_services_background_manager_parent_class)->finalize (obj);
}

static GType
wingpanel_services_background_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelServicesBackgroundManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_services_background_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WingpanelServicesBackgroundManager), 0, (GInstanceInitFunc) wingpanel_services_background_manager_instance_init, NULL };
	GType wingpanel_services_background_manager_type_id;
	wingpanel_services_background_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "WingpanelServicesBackgroundManager", &g_define_type_info, 0);
	WingpanelServicesBackgroundManager_private_offset = g_type_add_instance_private (wingpanel_services_background_manager_type_id, sizeof (WingpanelServicesBackgroundManagerPrivate));
	return wingpanel_services_background_manager_type_id;
}

GType
wingpanel_services_background_manager_get_type (void)
{
	static volatile gsize wingpanel_services_background_manager_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_services_background_manager_type_id__once)) {
		GType wingpanel_services_background_manager_type_id;
		wingpanel_services_background_manager_type_id = wingpanel_services_background_manager_get_type_once ();
		g_once_init_leave (&wingpanel_services_background_manager_type_id__once, wingpanel_services_background_manager_type_id);
	}
	return wingpanel_services_background_manager_type_id__once;
}

static void
_vala_wingpanel_services_background_manager_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	WingpanelServicesBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER, WingpanelServicesBackgroundManager);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

