"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _AddButton = _interopRequireDefault(require("../AddButton"));

var _IconButton = _interopRequireDefault(require("../IconButton"));

var _react = _interopRequireWildcard(require("react"));

var _includes = _interopRequireDefault(require("core-js-pure/es/array/includes"));

var types = _interopRequireWildcard(require("../../types"));

var _utils = require("../../utils");

var _nanoid = require("nanoid");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function ArrayFieldTitle(_ref) {
  var TitleField = _ref.TitleField,
      idSchema = _ref.idSchema,
      title = _ref.title,
      required = _ref.required;

  if (!title) {
    return null;
  }

  var id = "".concat(idSchema.$id, "__title");
  return _react["default"].createElement(TitleField, {
    id: id,
    title: title,
    required: required
  });
}

function ArrayFieldDescription(_ref2) {
  var DescriptionField = _ref2.DescriptionField,
      idSchema = _ref2.idSchema,
      description = _ref2.description;

  if (!description) {
    return null;
  }

  var id = "".concat(idSchema.$id, "__description");
  return _react["default"].createElement(DescriptionField, {
    id: id,
    description: description
  });
} // Used in the two templates


function DefaultArrayItem(props) {
  var btnStyle = {
    flex: 1,
    paddingLeft: 6,
    paddingRight: 6,
    fontWeight: "bold"
  };
  return _react["default"].createElement("div", {
    key: props.key,
    className: props.className
  }, _react["default"].createElement("div", {
    className: props.hasToolbar ? "col-xs-9" : "col-xs-12"
  }, props.children), props.hasToolbar && _react["default"].createElement("div", {
    className: "col-xs-3 array-item-toolbox"
  }, _react["default"].createElement("div", {
    className: "btn-group",
    style: {
      display: "flex",
      justifyContent: "space-around"
    }
  }, (props.hasMoveUp || props.hasMoveDown) && _react["default"].createElement(_IconButton["default"], {
    icon: "arrow-up",
    "aria-label": "Move up",
    className: "array-item-move-up",
    tabIndex: "-1",
    style: btnStyle,
    disabled: props.disabled || props.readonly || !props.hasMoveUp,
    onClick: props.onReorderClick(props.index, props.index - 1)
  }), (props.hasMoveUp || props.hasMoveDown) && _react["default"].createElement(_IconButton["default"], {
    icon: "arrow-down",
    className: "array-item-move-down",
    "aria-label": "Move down",
    tabIndex: "-1",
    style: btnStyle,
    disabled: props.disabled || props.readonly || !props.hasMoveDown,
    onClick: props.onReorderClick(props.index, props.index + 1)
  }), props.hasRemove && _react["default"].createElement(_IconButton["default"], {
    type: "danger",
    icon: "remove",
    "aria-label": "Remove",
    className: "array-item-remove",
    tabIndex: "-1",
    style: btnStyle,
    disabled: props.disabled || props.readonly,
    onClick: props.onDropIndexClick(props.index)
  }))));
}

function DefaultFixedArrayFieldTemplate(props) {
  return _react["default"].createElement("fieldset", {
    className: props.className,
    id: props.idSchema.$id
  }, _react["default"].createElement(ArrayFieldTitle, {
    key: "array-field-title-".concat(props.idSchema.$id),
    TitleField: props.TitleField,
    idSchema: props.idSchema,
    title: props.uiSchema["ui:title"] || props.title,
    required: props.required
  }), (props.uiSchema["ui:description"] || props.schema.description) && _react["default"].createElement("div", {
    className: "field-description",
    key: "field-description-".concat(props.idSchema.$id)
  }, props.uiSchema["ui:description"] || props.schema.description), _react["default"].createElement("div", {
    className: "row array-item-list",
    key: "array-item-list-".concat(props.idSchema.$id)
  }, props.items && props.items.map(DefaultArrayItem)), props.canAdd && _react["default"].createElement(_AddButton["default"], {
    className: "array-item-add",
    onClick: props.onAddClick,
    disabled: props.disabled || props.readonly
  }));
}

function DefaultNormalArrayFieldTemplate(props) {
  return _react["default"].createElement("fieldset", {
    className: props.className,
    id: props.idSchema.$id
  }, _react["default"].createElement(ArrayFieldTitle, {
    key: "array-field-title-".concat(props.idSchema.$id),
    TitleField: props.TitleField,
    idSchema: props.idSchema,
    title: props.uiSchema["ui:title"] || props.title,
    required: props.required
  }), (props.uiSchema["ui:description"] || props.schema.description) && _react["default"].createElement(ArrayFieldDescription, {
    key: "array-field-description-".concat(props.idSchema.$id),
    DescriptionField: props.DescriptionField,
    idSchema: props.idSchema,
    description: props.uiSchema["ui:description"] || props.schema.description
  }), _react["default"].createElement("div", {
    className: "row array-item-list",
    key: "array-item-list-".concat(props.idSchema.$id)
  }, props.items && props.items.map(function (p) {
    return DefaultArrayItem(p);
  })), props.canAdd && _react["default"].createElement(_AddButton["default"], {
    className: "array-item-add",
    onClick: props.onAddClick,
    disabled: props.disabled || props.readonly
  }));
}

function generateRowId() {
  return (0, _nanoid.nanoid)();
}

function generateKeyedFormData(formData) {
  return !Array.isArray(formData) ? [] : formData.map(function (item) {
    return {
      key: generateRowId(),
      item: item
    };
  });
}

function keyedToPlainFormData(keyedFormData) {
  return keyedFormData.map(function (keyedItem) {
    return keyedItem.item;
  });
}

var ArrayField =
/*#__PURE__*/
function (_Component) {
  _inherits(ArrayField, _Component);

  function ArrayField(props) {
    var _this;

    _classCallCheck(this, ArrayField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ArrayField).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "_getNewFormDataRow", function () {
      var _this$props = _this.props,
          schema = _this$props.schema,
          _this$props$registry = _this$props.registry,
          registry = _this$props$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props$registry;
      var rootSchema = registry.rootSchema;
      var itemSchema = schema.items;

      if ((0, _utils.isFixedItems)(schema) && (0, _utils.allowAdditionalItems)(schema)) {
        itemSchema = schema.additionalItems;
      }

      return (0, _utils.getDefaultFormState)(itemSchema, undefined, rootSchema);
    });

    _defineProperty(_assertThisInitialized(_this), "onAddClick", function (event) {
      if (event) {
        event.preventDefault();
      }

      var onChange = _this.props.onChange;
      var newKeyedFormDataRow = {
        key: generateRowId(),
        item: _this._getNewFormDataRow()
      };
      var newKeyedFormData = [].concat(_toConsumableArray(_this.state.keyedFormData), [newKeyedFormDataRow]);

      _this.setState({
        keyedFormData: newKeyedFormData,
        updatedKeyedFormData: true
      }, function () {
        return onChange(keyedToPlainFormData(newKeyedFormData));
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onAddIndexClick", function (index) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        var onChange = _this.props.onChange;
        var newKeyedFormDataRow = {
          key: generateRowId(),
          item: _this._getNewFormDataRow()
        };

        var newKeyedFormData = _toConsumableArray(_this.state.keyedFormData);

        newKeyedFormData.splice(index, 0, newKeyedFormDataRow);

        _this.setState({
          keyedFormData: newKeyedFormData,
          updatedKeyedFormData: true
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData));
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onDropIndexClick", function (index) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        var onChange = _this.props.onChange;
        var keyedFormData = _this.state.keyedFormData; // refs #195: revalidate to ensure properly reindexing errors

        var newErrorSchema;

        if (_this.props.errorSchema) {
          newErrorSchema = {};
          var errorSchema = _this.props.errorSchema;

          for (var i in errorSchema) {
            i = parseInt(i);

            if (i < index) {
              newErrorSchema[i] = errorSchema[i];
            } else if (i > index) {
              newErrorSchema[i - 1] = errorSchema[i];
            }
          }
        }

        var newKeyedFormData = keyedFormData.filter(function (_, i) {
          return i !== index;
        });

        _this.setState({
          keyedFormData: newKeyedFormData,
          updatedKeyedFormData: true
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema);
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onReorderClick", function (index, newIndex) {
      return function (event) {
        if (event) {
          event.preventDefault();
          event.target.blur();
        }

        var onChange = _this.props.onChange;
        var newErrorSchema;

        if (_this.props.errorSchema) {
          newErrorSchema = {};
          var errorSchema = _this.props.errorSchema;

          for (var i in errorSchema) {
            if (i == index) {
              newErrorSchema[newIndex] = errorSchema[index];
            } else if (i == newIndex) {
              newErrorSchema[index] = errorSchema[newIndex];
            } else {
              newErrorSchema[i] = errorSchema[i];
            }
          }
        }

        var keyedFormData = _this.state.keyedFormData;

        function reOrderArray() {
          // Copy item
          var _newKeyedFormData = keyedFormData.slice(); // Moves item from index to newIndex


          _newKeyedFormData.splice(index, 1);

          _newKeyedFormData.splice(newIndex, 0, keyedFormData[index]);

          return _newKeyedFormData;
        }

        var newKeyedFormData = reOrderArray();

        _this.setState({
          keyedFormData: newKeyedFormData
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema);
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onChangeForIndex", function (index) {
      return function (value, errorSchema) {
        var _this$props2 = _this.props,
            formData = _this$props2.formData,
            onChange = _this$props2.onChange;
        var newFormData = formData.map(function (item, i) {
          // We need to treat undefined items as nulls to have validation.
          // See https://github.com/tdegrunt/jsonschema/issues/206
          var jsonValue = typeof value === "undefined" ? null : value;
          return index === i ? jsonValue : item;
        });
        onChange(newFormData, errorSchema && _this.props.errorSchema && _objectSpread({}, _this.props.errorSchema, _defineProperty({}, index, errorSchema)));
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onSelectChange", function (value) {
      _this.props.onChange(value);
    });

    var _formData = props.formData;

    var _keyedFormData = generateKeyedFormData(_formData);

    _this.state = {
      keyedFormData: _keyedFormData,
      updatedKeyedFormData: false
    };
    return _this;
  }

  _createClass(ArrayField, [{
    key: "isItemRequired",
    value: function isItemRequired(itemSchema) {
      if (Array.isArray(itemSchema.type)) {
        // While we don't yet support composite/nullable jsonschema types, it's
        // future-proof to check for requirement against these.
        return !(0, _includes["default"])(itemSchema.type, "null");
      } // All non-null array item types are inherently required by design


      return itemSchema.type !== "null";
    }
  }, {
    key: "canAddItem",
    value: function canAddItem(formItems) {
      var _this$props3 = this.props,
          schema = _this$props3.schema,
          uiSchema = _this$props3.uiSchema;

      var _getUiOptions = (0, _utils.getUiOptions)(uiSchema),
          addable = _getUiOptions.addable;

      if (addable !== false) {
        // if ui:options.addable was not explicitly set to false, we can add
        // another item if we have not exceeded maxItems yet
        if (schema.maxItems !== undefined) {
          addable = formItems.length < schema.maxItems;
        } else {
          addable = true;
        }
      }

      return addable;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          schema = _this$props4.schema,
          uiSchema = _this$props4.uiSchema,
          idSchema = _this$props4.idSchema,
          _this$props4$registry = _this$props4.registry,
          registry = _this$props4$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props4$registry;
      var rootSchema = registry.rootSchema;

      if (!schema.hasOwnProperty("items")) {
        var fields = registry.fields;
        var UnsupportedField = fields.UnsupportedField;
        return _react["default"].createElement(UnsupportedField, {
          schema: schema,
          idSchema: idSchema,
          reason: "Missing items definition"
        });
      }

      if ((0, _utils.isMultiSelect)(schema, rootSchema)) {
        // If array has enum or uniqueItems set to true, call renderMultiSelect() to render the default multiselect widget or a custom widget, if specified.
        return this.renderMultiSelect();
      }

      if ((0, _utils.isCustomWidget)(uiSchema)) {
        return this.renderCustomWidget();
      }

      if ((0, _utils.isFixedItems)(schema)) {
        return this.renderFixedArray();
      }

      if ((0, _utils.isFilesArray)(schema, uiSchema, rootSchema)) {
        return this.renderFiles();
      }

      return this.renderNormalArray();
    }
  }, {
    key: "renderNormalArray",
    value: function renderNormalArray() {
      var _this2 = this;

      var _this$props5 = this.props,
          schema = _this$props5.schema,
          uiSchema = _this$props5.uiSchema,
          errorSchema = _this$props5.errorSchema,
          idSchema = _this$props5.idSchema,
          name = _this$props5.name,
          required = _this$props5.required,
          disabled = _this$props5.disabled,
          readonly = _this$props5.readonly,
          hideError = _this$props5.hideError,
          autofocus = _this$props5.autofocus,
          _this$props5$registry = _this$props5.registry,
          registry = _this$props5$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props5$registry,
          onBlur = _this$props5.onBlur,
          onFocus = _this$props5.onFocus,
          idPrefix = _this$props5.idPrefix,
          _this$props5$idSepara = _this$props5.idSeparator,
          idSeparator = _this$props5$idSepara === void 0 ? "_" : _this$props5$idSepara,
          rawErrors = _this$props5.rawErrors;
      var title = schema.title === undefined ? name : schema.title;
      var ArrayFieldTemplate = registry.ArrayFieldTemplate,
          rootSchema = registry.rootSchema,
          fields = registry.fields,
          formContext = registry.formContext;
      var TitleField = fields.TitleField,
          DescriptionField = fields.DescriptionField;
      var itemsSchema = (0, _utils.retrieveSchema)(schema.items, rootSchema);
      var formData = keyedToPlainFormData(this.state.keyedFormData);
      var arrayProps = {
        canAdd: this.canAddItem(formData),
        items: this.state.keyedFormData.map(function (keyedItem, index) {
          var key = keyedItem.key,
              item = keyedItem.item;
          var itemSchema = (0, _utils.retrieveSchema)(schema.items, rootSchema, item);
          var itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
          var itemIdPrefix = idSchema.$id + idSeparator + index;
          var itemIdSchema = (0, _utils.toIdSchema)(itemSchema, itemIdPrefix, rootSchema, item, idPrefix, idSeparator);
          return _this2.renderArrayFieldItem({
            key: key,
            index: index,
            canMoveUp: index > 0,
            canMoveDown: index < formData.length - 1,
            itemSchema: itemSchema,
            itemIdSchema: itemIdSchema,
            itemErrorSchema: itemErrorSchema,
            itemData: item,
            itemUiSchema: uiSchema.items,
            autofocus: autofocus && index === 0,
            onBlur: onBlur,
            onFocus: onFocus
          });
        }),
        className: "field field-array field-array-of-".concat(itemsSchema.type),
        DescriptionField: DescriptionField,
        disabled: disabled,
        idSchema: idSchema,
        uiSchema: uiSchema,
        onAddClick: this.onAddClick,
        readonly: readonly,
        hideError: hideError,
        required: required,
        schema: schema,
        title: title,
        TitleField: TitleField,
        formContext: formContext,
        formData: formData,
        rawErrors: rawErrors,
        registry: registry
      }; // Check if a custom render function was passed in

      var Component = uiSchema["ui:ArrayFieldTemplate"] || ArrayFieldTemplate || DefaultNormalArrayFieldTemplate;
      return _react["default"].createElement(Component, arrayProps);
    }
  }, {
    key: "renderCustomWidget",
    value: function renderCustomWidget() {
      var _this$props6 = this.props,
          schema = _this$props6.schema,
          idSchema = _this$props6.idSchema,
          uiSchema = _this$props6.uiSchema,
          disabled = _this$props6.disabled,
          readonly = _this$props6.readonly,
          hideError = _this$props6.hideError,
          required = _this$props6.required,
          placeholder = _this$props6.placeholder,
          autofocus = _this$props6.autofocus,
          onBlur = _this$props6.onBlur,
          onFocus = _this$props6.onFocus,
          items = _this$props6.formData,
          _this$props6$registry = _this$props6.registry,
          registry = _this$props6$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props6$registry,
          rawErrors = _this$props6.rawErrors,
          name = _this$props6.name;
      var widgets = registry.widgets,
          formContext = registry.formContext;
      var title = schema.title || name;

      var _getUiOptions2 = _objectSpread({}, (0, _utils.getUiOptions)(uiSchema)),
          widget = _getUiOptions2.widget,
          options = _objectWithoutProperties(_getUiOptions2, ["widget"]);

      var Widget = (0, _utils.getWidget)(schema, widget, widgets);
      return _react["default"].createElement(Widget, {
        id: idSchema && idSchema.$id,
        multiple: true,
        onChange: this.onSelectChange,
        onBlur: onBlur,
        onFocus: onFocus,
        options: options,
        schema: schema,
        registry: registry,
        value: items,
        disabled: disabled,
        readonly: readonly,
        hideError: hideError,
        required: required,
        label: title,
        placeholder: placeholder,
        formContext: formContext,
        autofocus: autofocus,
        rawErrors: rawErrors
      });
    }
  }, {
    key: "renderMultiSelect",
    value: function renderMultiSelect() {
      var _this$props7 = this.props,
          schema = _this$props7.schema,
          idSchema = _this$props7.idSchema,
          uiSchema = _this$props7.uiSchema,
          formData = _this$props7.formData,
          disabled = _this$props7.disabled,
          readonly = _this$props7.readonly,
          required = _this$props7.required,
          placeholder = _this$props7.placeholder,
          autofocus = _this$props7.autofocus,
          onBlur = _this$props7.onBlur,
          onFocus = _this$props7.onFocus,
          _this$props7$registry = _this$props7.registry,
          registry = _this$props7$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props7$registry,
          rawErrors = _this$props7.rawErrors,
          name = _this$props7.name;
      var items = this.props.formData;
      var widgets = registry.widgets,
          rootSchema = registry.rootSchema,
          formContext = registry.formContext;
      var itemsSchema = (0, _utils.retrieveSchema)(schema.items, rootSchema, formData);
      var title = schema.title || name;
      var enumOptions = (0, _utils.optionsList)(itemsSchema);

      var _getUiOptions$enumOpt = _objectSpread({}, (0, _utils.getUiOptions)(uiSchema), {
        enumOptions: enumOptions
      }),
          _getUiOptions$enumOpt2 = _getUiOptions$enumOpt.widget,
          widget = _getUiOptions$enumOpt2 === void 0 ? "select" : _getUiOptions$enumOpt2,
          options = _objectWithoutProperties(_getUiOptions$enumOpt, ["widget"]);

      var Widget = (0, _utils.getWidget)(schema, widget, widgets);
      return _react["default"].createElement(Widget, {
        id: idSchema && idSchema.$id,
        multiple: true,
        onChange: this.onSelectChange,
        onBlur: onBlur,
        onFocus: onFocus,
        options: options,
        schema: schema,
        registry: registry,
        value: items,
        disabled: disabled,
        readonly: readonly,
        required: required,
        label: title,
        placeholder: placeholder,
        formContext: formContext,
        autofocus: autofocus,
        rawErrors: rawErrors
      });
    }
  }, {
    key: "renderFiles",
    value: function renderFiles() {
      var _this$props8 = this.props,
          schema = _this$props8.schema,
          uiSchema = _this$props8.uiSchema,
          idSchema = _this$props8.idSchema,
          name = _this$props8.name,
          disabled = _this$props8.disabled,
          readonly = _this$props8.readonly,
          autofocus = _this$props8.autofocus,
          onBlur = _this$props8.onBlur,
          onFocus = _this$props8.onFocus,
          _this$props8$registry = _this$props8.registry,
          registry = _this$props8$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props8$registry,
          rawErrors = _this$props8.rawErrors;
      var title = schema.title || name;
      var items = this.props.formData;
      var widgets = registry.widgets,
          formContext = registry.formContext;

      var _getUiOptions3 = (0, _utils.getUiOptions)(uiSchema),
          _getUiOptions3$widget = _getUiOptions3.widget,
          widget = _getUiOptions3$widget === void 0 ? "files" : _getUiOptions3$widget,
          options = _objectWithoutProperties(_getUiOptions3, ["widget"]);

      var Widget = (0, _utils.getWidget)(schema, widget, widgets);
      return _react["default"].createElement(Widget, {
        options: options,
        id: idSchema && idSchema.$id,
        multiple: true,
        onChange: this.onSelectChange,
        onBlur: onBlur,
        onFocus: onFocus,
        schema: schema,
        title: title,
        value: items,
        disabled: disabled,
        readonly: readonly,
        formContext: formContext,
        autofocus: autofocus,
        rawErrors: rawErrors
      });
    }
  }, {
    key: "renderFixedArray",
    value: function renderFixedArray() {
      var _this3 = this;

      var _this$props9 = this.props,
          schema = _this$props9.schema,
          uiSchema = _this$props9.uiSchema,
          formData = _this$props9.formData,
          errorSchema = _this$props9.errorSchema,
          idPrefix = _this$props9.idPrefix,
          _this$props9$idSepara = _this$props9.idSeparator,
          idSeparator = _this$props9$idSepara === void 0 ? "_" : _this$props9$idSepara,
          idSchema = _this$props9.idSchema,
          name = _this$props9.name,
          required = _this$props9.required,
          disabled = _this$props9.disabled,
          readonly = _this$props9.readonly,
          autofocus = _this$props9.autofocus,
          _this$props9$registry = _this$props9.registry,
          registry = _this$props9$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props9$registry,
          onBlur = _this$props9.onBlur,
          onFocus = _this$props9.onFocus,
          rawErrors = _this$props9.rawErrors;
      var title = schema.title || name;
      var items = this.props.formData;
      var ArrayFieldTemplate = registry.ArrayFieldTemplate,
          rootSchema = registry.rootSchema,
          fields = registry.fields,
          formContext = registry.formContext;
      var TitleField = fields.TitleField;
      var itemSchemas = schema.items.map(function (item, index) {
        return (0, _utils.retrieveSchema)(item, rootSchema, formData[index]);
      });
      var additionalSchema = (0, _utils.allowAdditionalItems)(schema) ? (0, _utils.retrieveSchema)(schema.additionalItems, rootSchema, formData) : null;

      if (!items || items.length < itemSchemas.length) {
        // to make sure at least all fixed items are generated
        items = items || [];
        items = items.concat(new Array(itemSchemas.length - items.length));
      } // These are the props passed into the render function


      var arrayProps = {
        canAdd: this.canAddItem(items) && additionalSchema,
        className: "field field-array field-array-fixed-items",
        disabled: disabled,
        idSchema: idSchema,
        formData: formData,
        items: this.state.keyedFormData.map(function (keyedItem, index) {
          var key = keyedItem.key,
              item = keyedItem.item;
          var additional = index >= itemSchemas.length;
          var itemSchema = additional ? (0, _utils.retrieveSchema)(schema.additionalItems, rootSchema, item) : itemSchemas[index];
          var itemIdPrefix = idSchema.$id + idSeparator + index;
          var itemIdSchema = (0, _utils.toIdSchema)(itemSchema, itemIdPrefix, rootSchema, item, idPrefix, idSeparator);
          var itemUiSchema = additional ? uiSchema.additionalItems || {} : Array.isArray(uiSchema.items) ? uiSchema.items[index] : uiSchema.items || {};
          var itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
          return _this3.renderArrayFieldItem({
            key: key,
            index: index,
            canRemove: additional,
            canMoveUp: index >= itemSchemas.length + 1,
            canMoveDown: additional && index < items.length - 1,
            itemSchema: itemSchema,
            itemData: item,
            itemUiSchema: itemUiSchema,
            itemIdSchema: itemIdSchema,
            itemErrorSchema: itemErrorSchema,
            autofocus: autofocus && index === 0,
            onBlur: onBlur,
            onFocus: onFocus
          });
        }),
        onAddClick: this.onAddClick,
        readonly: readonly,
        required: required,
        schema: schema,
        uiSchema: uiSchema,
        title: title,
        TitleField: TitleField,
        formContext: formContext,
        rawErrors: rawErrors
      }; // Check if a custom template template was passed in

      var Template = uiSchema["ui:ArrayFieldTemplate"] || ArrayFieldTemplate || DefaultFixedArrayFieldTemplate;
      return _react["default"].createElement(Template, arrayProps);
    }
  }, {
    key: "renderArrayFieldItem",
    value: function renderArrayFieldItem(props) {
      var key = props.key,
          index = props.index,
          _props$canRemove = props.canRemove,
          canRemove = _props$canRemove === void 0 ? true : _props$canRemove,
          _props$canMoveUp = props.canMoveUp,
          canMoveUp = _props$canMoveUp === void 0 ? true : _props$canMoveUp,
          _props$canMoveDown = props.canMoveDown,
          canMoveDown = _props$canMoveDown === void 0 ? true : _props$canMoveDown,
          itemSchema = props.itemSchema,
          itemData = props.itemData,
          itemUiSchema = props.itemUiSchema,
          itemIdSchema = props.itemIdSchema,
          itemErrorSchema = props.itemErrorSchema,
          autofocus = props.autofocus,
          onBlur = props.onBlur,
          onFocus = props.onFocus,
          rawErrors = props.rawErrors;
      var _this$props10 = this.props,
          disabled = _this$props10.disabled,
          readonly = _this$props10.readonly,
          uiSchema = _this$props10.uiSchema,
          _this$props10$registr = _this$props10.registry,
          registry = _this$props10$registr === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props10$registr;
      var SchemaField = registry.fields.SchemaField;

      var _getUiOptions4 = (0, _utils.getUiOptions)(uiSchema),
          _getUiOptions4$ordera = _getUiOptions4.orderable,
          orderable = _getUiOptions4$ordera === void 0 ? true : _getUiOptions4$ordera,
          _getUiOptions4$remova = _getUiOptions4.removable,
          removable = _getUiOptions4$remova === void 0 ? true : _getUiOptions4$remova;

      var has = {
        moveUp: orderable && canMoveUp,
        moveDown: orderable && canMoveDown,
        remove: removable && canRemove
      };
      has.toolbar = Object.keys(has).some(function (key) {
        return has[key];
      });
      return {
        children: _react["default"].createElement(SchemaField, {
          index: index,
          schema: itemSchema,
          uiSchema: itemUiSchema,
          formData: itemData,
          errorSchema: itemErrorSchema,
          idPrefix: this.props.idPrefix,
          idSeparator: this.props.idSeparator,
          idSchema: itemIdSchema,
          required: this.isItemRequired(itemSchema),
          onChange: this.onChangeForIndex(index),
          onBlur: onBlur,
          onFocus: onFocus,
          registry: this.props.registry,
          disabled: this.props.disabled,
          readonly: this.props.readonly,
          hideError: this.props.hideError,
          autofocus: autofocus,
          rawErrors: rawErrors
        }),
        className: "array-item",
        disabled: disabled,
        hasToolbar: has.toolbar,
        hasMoveUp: has.moveUp,
        hasMoveDown: has.moveDown,
        hasRemove: has.remove,
        index: index,
        key: key,
        onAddIndexClick: this.onAddIndexClick,
        onDropIndexClick: this.onDropIndexClick,
        onReorderClick: this.onReorderClick,
        readonly: readonly
      };
    }
  }, {
    key: "itemTitle",
    get: function get() {
      var schema = this.props.schema;
      return schema.items.title || schema.items.description || "Item";
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      // Don't call getDerivedStateFromProps if keyed formdata was just updated.
      if (prevState.updatedKeyedFormData) {
        return {
          updatedKeyedFormData: false
        };
      }

      var nextFormData = nextProps.formData || [];
      var previousKeyedFormData = prevState.keyedFormData || [];
      var newKeyedFormData = nextFormData.length === previousKeyedFormData.length ? previousKeyedFormData.map(function (previousKeyedFormDatum, index) {
        return {
          key: previousKeyedFormDatum.key,
          item: nextFormData[index]
        };
      }) : generateKeyedFormData(nextFormData);
      return {
        keyedFormData: newKeyedFormData
      };
    }
  }]);

  return ArrayField;
}(_react.Component);

_defineProperty(ArrayField, "defaultProps", {
  uiSchema: {},
  formData: [],
  idSchema: {},
  required: false,
  disabled: false,
  readonly: false,
  autofocus: false
});

if (process.env.NODE_ENV !== "production") {
  ArrayField.propTypes = types.fieldProps;
}

var _default = ArrayField;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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