/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompactConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Argument
extends LocalDeclaration {
    private static final char[] SET = "set".toCharArray();

    public Argument(char[] cArray, long l, TypeReference typeReference, int n) {
        super(cArray, (int)(l >>> 32), (int)l);
        this.declarationSourceEnd = (int)l;
        this.modifiers = n;
        this.type = typeReference;
        if (typeReference != null) {
            this.bits |= typeReference.bits & 0x100000;
        }
        this.bits |= 0x40000004;
    }

    public Argument(char[] cArray, long l, TypeReference typeReference, int n, boolean bl) {
        super(cArray, (int)(l >>> 32), (int)l);
        this.declarationSourceEnd = (int)l;
        this.modifiers = n;
        this.type = typeReference;
        if (typeReference != null) {
            this.bits |= typeReference.bits & 0x100000;
        }
        this.bits |= 0x40000006;
    }

    @Override
    public boolean isRecoveredFromLoneIdentifier() {
        return false;
    }

    public TypeBinding createBinding(MethodScope methodScope, TypeBinding typeBinding) {
        MethodBinding methodBinding;
        Annotation[] annotationArray;
        if (this.binding == null) {
            this.binding = new LocalVariableBinding((LocalDeclaration)this, typeBinding, this.modifiers, methodScope);
        } else if (!this.binding.type.isValidBinding() && (annotationArray = methodScope.referenceMethod()) != null && (methodBinding = annotationArray.binding) != null) {
            methodBinding.tagBits |= 0x200L;
        }
        if ((this.binding.tagBits & 0x200000000L) == 0L) {
            annotationArray = this.annotations;
            long l = methodScope.compilerOptions().sourceLevel;
            if (l >= 0x3A0000L && annotationArray == null) {
                annotationArray = this.getCorrespondingRecordComponentAnnotationsIfApplicable(methodScope.referenceMethod());
                annotationArray = ASTNode.copyRecordComponentAnnotations(methodScope, this.binding, annotationArray);
            }
            if (annotationArray != null) {
                Argument.resolveAnnotations(methodScope, annotationArray, this.binding, true);
            }
            if (l >= 0x340000L) {
                Annotation.isTypeUseCompatible(this.type, methodScope, annotationArray);
                methodScope.validateNullAnnotation(this.binding.tagBits, this.type, annotationArray);
            }
        }
        this.binding.declaration = this;
        return this.binding.type;
    }

    private Annotation[] getCorrespondingRecordComponentAnnotationsIfApplicable(AbstractMethodDeclaration abstractMethodDeclaration) {
        if (abstractMethodDeclaration != null && abstractMethodDeclaration.isConstructor() && (abstractMethodDeclaration.bits & 0x200) != 0 && (abstractMethodDeclaration.bits & 0x400) != 0) {
            ReferenceBinding referenceBinding;
            MethodBinding methodBinding = abstractMethodDeclaration.binding;
            ReferenceBinding referenceBinding2 = referenceBinding = methodBinding == null ? null : methodBinding.declaringClass;
            if (referenceBinding instanceof SourceTypeBinding) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)referenceBinding;
                assert (sourceTypeBinding.isRecord());
                sourceTypeBinding.components();
                RecordComponentBinding recordComponentBinding = sourceTypeBinding.getRecordComponent(this.name);
                if (recordComponentBinding != null) {
                    RecordComponent recordComponent = recordComponentBinding.sourceRecordComponent();
                    return recordComponent.annotations;
                }
            }
        }
        return null;
    }

    public TypeBinding bind(MethodScope methodScope, TypeBinding typeBinding, boolean bl) {
        TypeBinding typeBinding2 = this.createBinding(methodScope, typeBinding);
        Binding binding = methodScope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (binding != null && binding.isValidBinding()) {
            boolean bl2 = binding instanceof LocalVariableBinding;
            if (bl2 && this.hiddenVariableDepth == 0) {
                if ((this.bits & 0x200000) != 0 && methodScope.isLambdaSubscope()) {
                    methodScope.problemReporter().lambdaRedeclaresArgument(this);
                } else if (!(methodScope.referenceContext instanceof CompactConstructorDeclaration)) {
                    methodScope.problemReporter().redefineArgument(this);
                }
            } else {
                boolean bl3 = false;
                if (binding instanceof FieldBinding) {
                    AbstractMethodDeclaration abstractMethodDeclaration;
                    if (methodScope.isInsideConstructor()) {
                        bl3 = true;
                    } else if (!((FieldBinding)binding).isRecordComponent() && (abstractMethodDeclaration = methodScope.referenceMethod()) != null && CharOperation.prefixEquals(SET, abstractMethodDeclaration.selector)) {
                        bl3 = true;
                    }
                }
                methodScope.problemReporter().localVariableHiding(this, binding, bl3);
            }
        }
        methodScope.addLocalVariable(this.binding);
        this.binding.useFlag = bl ? 1 : 0;
        return typeBinding2;
    }

    @Override
    public int getKind() {
        return (this.bits & 4) != 0 ? 5 : 4;
    }

    @Override
    public boolean isArgument() {
        return true;
    }

    public boolean isVarArgs() {
        return this.type != null && (this.type.bits & 0x4000) != 0;
    }

    public boolean hasElidedType() {
        return (this.bits & 2) != 0;
    }

    public boolean hasNullTypeAnnotation(TypeReference.AnnotationPosition annotationPosition) {
        return TypeReference.containsNullAnnotation(this.annotations) || this.type != null && this.type.hasNullTypeAnnotation(annotationPosition);
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Argument.printIndent(n, stringBuffer);
        Argument.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            Argument.printAnnotations(this.annotations, stringBuffer);
            stringBuffer.append(' ');
        }
        if (this.type == null) {
            stringBuffer.append("<no type> ");
        } else {
            this.type.print(0, stringBuffer).append(' ');
        }
        return stringBuffer.append(this.name);
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(';');
    }

    public TypeBinding resolveForCatch(BlockScope blockScope) {
        boolean bl;
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        if (typeBinding == null) {
            bl = true;
        } else {
            bl = false;
            switch (typeBinding.kind()) {
                case 260: {
                    if (!typeBinding.isBoundParameterizedType()) break;
                    bl = true;
                    blockScope.problemReporter().invalidParameterizedExceptionType(typeBinding, this);
                    break;
                }
                case 4100: {
                    blockScope.problemReporter().invalidTypeVariableAsException(typeBinding, this);
                    bl = true;
                }
            }
            if (typeBinding.findSuperTypeOriginatingFrom(21, true) == null && typeBinding.isValidBinding()) {
                blockScope.problemReporter().cannotThrowType(this.type, typeBinding);
                bl = true;
            }
        }
        Binding binding = blockScope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (binding != null && binding.isValidBinding()) {
            if (binding instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                blockScope.problemReporter().redefineArgument(this);
            } else {
                blockScope.problemReporter().localVariableHiding(this, binding, false);
            }
        }
        if ((this.type.bits & 0x20000000) != 0) {
            this.binding = new CatchParameterBinding((LocalDeclaration)this, typeBinding, this.modifiers | 0x10, false);
            this.binding.tagBits |= 0x1000L;
        } else {
            this.binding = new CatchParameterBinding((LocalDeclaration)this, typeBinding, this.modifiers, false);
        }
        Argument.resolveAnnotations(blockScope, this.annotations, this.binding, true);
        Annotation.isTypeUseCompatible(this.type, blockScope, this.annotations);
        if (blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled && (this.type.hasNullTypeAnnotation(TypeReference.AnnotationPosition.ANY) || TypeReference.containsNullAnnotation(this.annotations))) {
            blockScope.problemReporter().nullAnnotationUnsupportedLocation(this.type);
        }
        blockScope.addLocalVariable(this.binding);
        this.binding.setConstant(Constant.NotAConstant);
        if (bl) {
            return null;
        }
        return typeBinding;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, classScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

