// third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-params-data.h"
#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_VIRTUAL_AUTHENTICATOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_VIRTUAL_AUTHENTICATOR_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace test {
namespace mojom {
VirtualAuthenticatorOptions::VirtualAuthenticatorOptions()
    : protocol(),
      ctap2_version(),
      transport(),
      attachment(),
      has_resident_key(),
      has_user_verification(),
      is_user_present(true) {}

VirtualAuthenticatorOptions::VirtualAuthenticatorOptions(
    ::device::ProtocolVersion protocol_in,
    ::device::Ctap2Version ctap2_version_in,
    ::device::FidoTransportProtocol transport_in,
    ::device::AuthenticatorAttachment attachment_in,
    bool has_resident_key_in,
    bool has_user_verification_in,
    bool is_user_present_in)
    : protocol(std::move(protocol_in)),
      ctap2_version(std::move(ctap2_version_in)),
      transport(std::move(transport_in)),
      attachment(std::move(attachment_in)),
      has_resident_key(std::move(has_resident_key_in)),
      has_user_verification(std::move(has_user_verification_in)),
      is_user_present(std::move(is_user_present_in)) {}

VirtualAuthenticatorOptions::~VirtualAuthenticatorOptions() = default;

void VirtualAuthenticatorOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("protocol", static_cast<int>(this->protocol));
  value->SetInteger("ctap2_version", static_cast<int>(this->ctap2_version));
  value->SetInteger("transport", static_cast<int>(this->transport));
  value->SetInteger("attachment", static_cast<int>(this->attachment));
  value->SetBoolean("has_resident_key", this->has_resident_key);
  value->SetBoolean("has_user_verification", this->has_user_verification);
  value->SetBoolean("is_user_present", this->is_user_present);
}

bool VirtualAuthenticatorOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RegisteredKey::RegisteredKey()
    : key_handle(),
      rp_id(),
      private_key(),
      counter() {}

RegisteredKey::RegisteredKey(
    std::vector<uint8_t> key_handle_in,
    const std::string& rp_id_in,
    std::vector<uint8_t> private_key_in,
    int32_t counter_in)
    : key_handle(std::move(key_handle_in)),
      rp_id(std::move(rp_id_in)),
      private_key(std::move(private_key_in)),
      counter(std::move(counter_in)) {}

RegisteredKey::~RegisteredKey() = default;

void RegisteredKey::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("key_handle");
  for (const auto& item0 : this->key_handle) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetString("rp_id", this->rp_id);
  value->BeginArray("private_key");
  for (const auto& item0 : this->private_key) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetInteger("counter", this->counter);
}

bool RegisteredKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char VirtualAuthenticator::Name_[] = "blink.test.mojom.VirtualAuthenticator";

class VirtualAuthenticator_GetUniqueId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_GetUniqueId_ForwardToCallback(
      VirtualAuthenticator::GetUniqueIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::GetUniqueIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetUniqueId_ForwardToCallback);
};

class VirtualAuthenticator_AddRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_AddRegistration_ForwardToCallback(
      VirtualAuthenticator::AddRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::AddRegistrationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_AddRegistration_ForwardToCallback);
};

class VirtualAuthenticator_GetRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_GetRegistrations_ForwardToCallback(
      VirtualAuthenticator::GetRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::GetRegistrationsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetRegistrations_ForwardToCallback);
};

class VirtualAuthenticator_RemoveRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_RemoveRegistration_ForwardToCallback(
      VirtualAuthenticator::RemoveRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::RemoveRegistrationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_RemoveRegistration_ForwardToCallback);
};

class VirtualAuthenticator_ClearRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_ClearRegistrations_ForwardToCallback(
      VirtualAuthenticator::ClearRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::ClearRegistrationsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_ClearRegistrations_ForwardToCallback);
};

class VirtualAuthenticator_SetUserVerified_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_SetUserVerified_ForwardToCallback(
      VirtualAuthenticator::SetUserVerifiedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::SetUserVerifiedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_SetUserVerified_ForwardToCallback);
};

VirtualAuthenticatorProxy::VirtualAuthenticatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VirtualAuthenticatorProxy::GetUniqueId(
    GetUniqueIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticator::GetUniqueId");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetUniqueId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_GetUniqueId_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetUniqueId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_GetUniqueId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::AddRegistration(
    RegisteredKeyPtr in_key, AddRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticator::AddRegistration", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_key.is_null()) {
        raw_value->SetString("key", "nullptr");
      } else {
        raw_value->BeginDictionary("key");
        in_key->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_AddRegistration_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_AddRegistration_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->key)::BaseType::BufferWriter
      key_writer;
  mojo::internal::Serialize<::blink::test::mojom::RegisteredKeyDataView>(
      in_key, buffer, &key_writer, &serialization_context);
  params->key.Set(
      key_writer.is_null() ? nullptr : key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in VirtualAuthenticator.AddRegistration request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("AddRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_AddRegistration_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::GetRegistrations(
    GetRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticator::GetRegistrations");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_GetRegistrations_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_GetRegistrations_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::RemoveRegistration(
    const std::vector<uint8_t>& in_key_handle, RemoveRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticator::RemoveRegistration", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("key_handle");
      for (const auto& item0 : in_key_handle) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_RemoveRegistration_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_RemoveRegistration_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->key_handle)::BaseType::BufferWriter
      key_handle_writer;
  const mojo::internal::ContainerValidateParams key_handle_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key_handle, buffer, &key_handle_writer, &key_handle_validate_params,
      &serialization_context);
  params->key_handle.Set(
      key_handle_writer.is_null() ? nullptr : key_handle_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_handle in VirtualAuthenticator.RemoveRegistration request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("RemoveRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_RemoveRegistration_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::ClearRegistrations(
    ClearRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticator::ClearRegistrations");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_ClearRegistrations_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_ClearRegistrations_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("ClearRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_ClearRegistrations_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::SetUserVerified(
    bool in_verified, SetUserVerifiedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticator::SetUserVerified", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("verified", in_verified);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_SetUserVerified_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_SetUserVerified_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->verified = in_verified;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("SetUserVerified");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_SetUserVerified_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VirtualAuthenticator_GetUniqueId_ProxyToResponder {
 public:
  static VirtualAuthenticator::GetUniqueIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_GetUniqueId_ProxyToResponder> proxy(
        new VirtualAuthenticator_GetUniqueId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_GetUniqueId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_GetUniqueId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_GetUniqueId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::GetUniqueIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetUniqueId_ProxyToResponder);
};

bool VirtualAuthenticator_GetUniqueId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::GetUniqueIdCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_GetUniqueId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_GetUniqueId_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::string p_id{};
  VirtualAuthenticator_GetUniqueId_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_id));
  return true;
}

void VirtualAuthenticator_GetUniqueId_ProxyToResponder::Run(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetUniqueIdCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("id", in_id);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetUniqueId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_GetUniqueId_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->id)::BaseType::BufferWriter
      id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, buffer, &id_writer, &serialization_context);
  params->id.Set(
      id_writer.is_null() ? nullptr : id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetUniqueIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetUniqueId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_AddRegistration_ProxyToResponder {
 public:
  static VirtualAuthenticator::AddRegistrationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_AddRegistration_ProxyToResponder> proxy(
        new VirtualAuthenticator_AddRegistration_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_AddRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_AddRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_AddRegistration_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::AddRegistrationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_added);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_AddRegistration_ProxyToResponder);
};

bool VirtualAuthenticator_AddRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::AddRegistrationCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_AddRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_AddRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_added{};
  VirtualAuthenticator_AddRegistration_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_added = input_data_view.added();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_added));
  return true;
}

void VirtualAuthenticator_AddRegistration_ProxyToResponder::Run(
    bool in_added) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::AddRegistrationCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("added", in_added);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_AddRegistration_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_AddRegistration_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->added = in_added;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::AddRegistrationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("AddRegistration");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_GetRegistrations_ProxyToResponder {
 public:
  static VirtualAuthenticator::GetRegistrationsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_GetRegistrations_ProxyToResponder> proxy(
        new VirtualAuthenticator_GetRegistrations_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_GetRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_GetRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_GetRegistrations_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::GetRegistrationsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<RegisteredKeyPtr> in_keys);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetRegistrations_ProxyToResponder);
};

bool VirtualAuthenticator_GetRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::GetRegistrationsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_GetRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_GetRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::vector<RegisteredKeyPtr> p_keys{};
  VirtualAuthenticator_GetRegistrations_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadKeys(&p_keys))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_keys));
  return true;
}

void VirtualAuthenticator_GetRegistrations_ProxyToResponder::Run(
    std::vector<RegisteredKeyPtr> in_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetRegistrationsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("keys");
      for (const auto& item0 : in_keys) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_GetRegistrations_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->keys)::BaseType::BufferWriter
      keys_writer;
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::test::mojom::RegisteredKeyDataView>>(
      in_keys, buffer, &keys_writer, &keys_validate_params,
      &serialization_context);
  params->keys.Set(
      keys_writer.is_null() ? nullptr : keys_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetRegistrationsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetRegistrations");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_RemoveRegistration_ProxyToResponder {
 public:
  static VirtualAuthenticator::RemoveRegistrationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_RemoveRegistration_ProxyToResponder> proxy(
        new VirtualAuthenticator_RemoveRegistration_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_RemoveRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_RemoveRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_RemoveRegistration_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::RemoveRegistrationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_removed);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_RemoveRegistration_ProxyToResponder);
};

bool VirtualAuthenticator_RemoveRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::RemoveRegistrationCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_RemoveRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_RemoveRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_removed{};
  VirtualAuthenticator_RemoveRegistration_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_removed = input_data_view.removed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_removed));
  return true;
}

void VirtualAuthenticator_RemoveRegistration_ProxyToResponder::Run(
    bool in_removed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::RemoveRegistrationCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("removed", in_removed);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_RemoveRegistration_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_RemoveRegistration_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->removed = in_removed;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::RemoveRegistrationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("RemoveRegistration");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_ClearRegistrations_ProxyToResponder {
 public:
  static VirtualAuthenticator::ClearRegistrationsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_ClearRegistrations_ProxyToResponder> proxy(
        new VirtualAuthenticator_ClearRegistrations_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_ClearRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_ClearRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_ClearRegistrations_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::ClearRegistrationsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_ClearRegistrations_ProxyToResponder);
};

bool VirtualAuthenticator_ClearRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::ClearRegistrationsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_ClearRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_ClearRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  VirtualAuthenticator_ClearRegistrations_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VirtualAuthenticator_ClearRegistrations_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::ClearRegistrationsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_ClearRegistrations_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_ClearRegistrations_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::ClearRegistrationsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("ClearRegistrations");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_SetUserVerified_ProxyToResponder {
 public:
  static VirtualAuthenticator::SetUserVerifiedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_SetUserVerified_ProxyToResponder> proxy(
        new VirtualAuthenticator_SetUserVerified_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_SetUserVerified_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_SetUserVerified_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_SetUserVerified_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::SetUserVerifiedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_SetUserVerified_ProxyToResponder);
};

bool VirtualAuthenticator_SetUserVerified_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::SetUserVerifiedCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_SetUserVerified_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_SetUserVerified_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  VirtualAuthenticator_SetUserVerified_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VirtualAuthenticator_SetUserVerified_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::SetUserVerifiedCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_SetUserVerified_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticator_SetUserVerified_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::SetUserVerifiedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("SetUserVerified");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VirtualAuthenticatorStubDispatch::Accept(
    VirtualAuthenticator* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kVirtualAuthenticator_GetUniqueId_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_AddRegistration_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_GetRegistrations_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_RemoveRegistration_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_ClearRegistrations_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_SetUserVerified_Name: {
      break;
    }
  }
  return false;
}

// static
bool VirtualAuthenticatorStubDispatch::AcceptWithResponder(
    VirtualAuthenticator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVirtualAuthenticator_GetUniqueId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::GetUniqueId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::GetUniqueId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_GetUniqueId_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_GetUniqueId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticator_GetUniqueId_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 0, false);
        return false;
      }
      VirtualAuthenticator::GetUniqueIdCallback callback =
          VirtualAuthenticator_GetUniqueId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUniqueId(std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_AddRegistration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::AddRegistration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::AddRegistration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_AddRegistration_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_AddRegistration_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      RegisteredKeyPtr p_key{};
      VirtualAuthenticator_AddRegistration_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 1, false);
        return false;
      }
      VirtualAuthenticator::AddRegistrationCallback callback =
          VirtualAuthenticator_AddRegistration_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddRegistration(
std::move(p_key), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_GetRegistrations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::GetRegistrations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::GetRegistrations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_GetRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_GetRegistrations_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticator_GetRegistrations_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 2, false);
        return false;
      }
      VirtualAuthenticator::GetRegistrationsCallback callback =
          VirtualAuthenticator_GetRegistrations_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrations(std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_RemoveRegistration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::RemoveRegistration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::RemoveRegistration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_RemoveRegistration_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_RemoveRegistration_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key_handle{};
      VirtualAuthenticator_RemoveRegistration_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadKeyHandle(&p_key_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 3, false);
        return false;
      }
      VirtualAuthenticator::RemoveRegistrationCallback callback =
          VirtualAuthenticator_RemoveRegistration_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveRegistration(
std::move(p_key_handle), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_ClearRegistrations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::ClearRegistrations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::ClearRegistrations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_ClearRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_ClearRegistrations_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticator_ClearRegistrations_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 4, false);
        return false;
      }
      VirtualAuthenticator::ClearRegistrationsCallback callback =
          VirtualAuthenticator_ClearRegistrations_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearRegistrations(std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_SetUserVerified_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::SetUserVerified",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::SetUserVerified");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_SetUserVerified_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_SetUserVerified_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_verified{};
      VirtualAuthenticator_SetUserVerified_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_verified = input_data_view.verified();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 5, false);
        return false;
      }
      VirtualAuthenticator::SetUserVerifiedCallback callback =
          VirtualAuthenticator_SetUserVerified_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserVerified(
std::move(p_verified), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kVirtualAuthenticatorValidationInfo[] = {
    {&internal::VirtualAuthenticator_GetUniqueId_Params_Data::Validate,
     &internal::VirtualAuthenticator_GetUniqueId_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_AddRegistration_Params_Data::Validate,
     &internal::VirtualAuthenticator_AddRegistration_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_GetRegistrations_Params_Data::Validate,
     &internal::VirtualAuthenticator_GetRegistrations_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_RemoveRegistration_Params_Data::Validate,
     &internal::VirtualAuthenticator_RemoveRegistration_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_ClearRegistrations_Params_Data::Validate,
     &internal::VirtualAuthenticator_ClearRegistrations_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_SetUserVerified_Params_Data::Validate,
     &internal::VirtualAuthenticator_SetUserVerified_ResponseParams_Data::Validate},
};

bool VirtualAuthenticatorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::VirtualAuthenticator::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kVirtualAuthenticatorValidationInfo);
}

bool VirtualAuthenticatorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::VirtualAuthenticator::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kVirtualAuthenticatorValidationInfo);
}
const char VirtualAuthenticatorManager::Name_[] = "blink.test.mojom.VirtualAuthenticatorManager";

class VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback(
      VirtualAuthenticatorManager::CreateAuthenticatorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticatorManager::CreateAuthenticatorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback);
};

class VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback(
      VirtualAuthenticatorManager::GetAuthenticatorsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticatorManager::GetAuthenticatorsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback);
};

class VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback(
      VirtualAuthenticatorManager::RemoveAuthenticatorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticatorManager::RemoveAuthenticatorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback);
};

class VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback(
      VirtualAuthenticatorManager::ClearAuthenticatorsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticatorManager::ClearAuthenticatorsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback);
};

VirtualAuthenticatorManagerProxy::VirtualAuthenticatorManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VirtualAuthenticatorManagerProxy::CreateAuthenticator(
    VirtualAuthenticatorOptionsPtr in_options, CreateAuthenticatorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticator", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_CreateAuthenticator_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticatorManager_CreateAuthenticator_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::blink::test::mojom::VirtualAuthenticatorOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in VirtualAuthenticatorManager.CreateAuthenticator request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("CreateAuthenticator");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorManagerProxy::GetAuthenticators(
    GetAuthenticatorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticators");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_GetAuthenticators_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticatorManager_GetAuthenticators_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("GetAuthenticators");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorManagerProxy::RemoveAuthenticator(
    const std::string& in_id, RemoveAuthenticatorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticator", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("id", in_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_RemoveAuthenticator_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticatorManager_RemoveAuthenticator_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->id)::BaseType::BufferWriter
      id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, buffer, &id_writer, &serialization_context);
  params->id.Set(
      id_writer.is_null() ? nullptr : id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in VirtualAuthenticatorManager.RemoveAuthenticator request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("RemoveAuthenticator");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorManagerProxy::ClearAuthenticators(
    ClearAuthenticatorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticators");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_ClearAuthenticators_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticatorManager_ClearAuthenticators_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("ClearAuthenticators");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder {
 public:
  static VirtualAuthenticatorManager::CreateAuthenticatorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder> proxy(
        new VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticatorManager::CreateAuthenticatorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<VirtualAuthenticator> in_authenticator);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder);
};

bool VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticatorCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticatorManager_CreateAuthenticator_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticatorManager_CreateAuthenticator_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::mojo::PendingRemote<VirtualAuthenticator> p_authenticator{};
  VirtualAuthenticatorManager_CreateAuthenticator_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success) {
    p_authenticator =
        input_data_view.TakeAuthenticator<decltype(p_authenticator)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticatorManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_authenticator));
  return true;
}

void VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder::Run(
    ::mojo::PendingRemote<VirtualAuthenticator> in_authenticator) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticatorCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("authenticator", in_authenticator.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_CreateAuthenticator_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticatorManager_CreateAuthenticator_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::test::mojom::VirtualAuthenticatorInterfaceBase>>(
      in_authenticator, &params->authenticator, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->authenticator),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid authenticator in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticatorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("CreateAuthenticator");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder {
 public:
  static VirtualAuthenticatorManager::GetAuthenticatorsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder> proxy(
        new VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticatorManager::GetAuthenticatorsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::mojo::PendingRemote<VirtualAuthenticator>> in_authenticators);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder);
};

bool VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticatorsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticatorManager_GetAuthenticators_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticatorManager_GetAuthenticators_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::vector<::mojo::PendingRemote<VirtualAuthenticator>> p_authenticators{};
  VirtualAuthenticatorManager_GetAuthenticators_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadAuthenticators(&p_authenticators))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticatorManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_authenticators));
  return true;
}

void VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder::Run(
    std::vector<::mojo::PendingRemote<VirtualAuthenticator>> in_authenticators) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticatorsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("authenticators");
      for (const auto& item0 : in_authenticators) {
        raw_value->AppendBoolean(item0.is_valid());
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_GetAuthenticators_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticatorManager_GetAuthenticators_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->authenticators)::BaseType::BufferWriter
      authenticators_writer;
  const mojo::internal::ContainerValidateParams authenticators_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::test::mojom::VirtualAuthenticatorInterfaceBase>>>(
      in_authenticators, buffer, &authenticators_writer, &authenticators_validate_params,
      &serialization_context);
  params->authenticators.Set(
      authenticators_writer.is_null() ? nullptr : authenticators_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->authenticators.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null authenticators in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticatorsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("GetAuthenticators");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder {
 public:
  static VirtualAuthenticatorManager::RemoveAuthenticatorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder> proxy(
        new VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticatorManager::RemoveAuthenticatorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_removed);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder);
};

bool VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticatorCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_removed{};
  VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_removed = input_data_view.removed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticatorManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_removed));
  return true;
}

void VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder::Run(
    bool in_removed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticatorCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("removed", in_removed);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_RemoveAuthenticator_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->removed = in_removed;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticatorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("RemoveAuthenticator");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder {
 public:
  static VirtualAuthenticatorManager::ClearAuthenticatorsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder> proxy(
        new VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticatorManager::ClearAuthenticatorsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder);
};

bool VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticatorsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticatorManager_ClearAuthenticators_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticatorManager_ClearAuthenticators_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  VirtualAuthenticatorManager_ClearAuthenticators_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticatorManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticatorsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_ClearAuthenticators_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::test::mojom::internal::VirtualAuthenticatorManager_ClearAuthenticators_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticatorsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("ClearAuthenticators");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VirtualAuthenticatorManagerStubDispatch::Accept(
    VirtualAuthenticatorManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kVirtualAuthenticatorManager_CreateAuthenticator_Name: {
      break;
    }
    case internal::kVirtualAuthenticatorManager_GetAuthenticators_Name: {
      break;
    }
    case internal::kVirtualAuthenticatorManager_RemoveAuthenticator_Name: {
      break;
    }
    case internal::kVirtualAuthenticatorManager_ClearAuthenticators_Name: {
      break;
    }
  }
  return false;
}

// static
bool VirtualAuthenticatorManagerStubDispatch::AcceptWithResponder(
    VirtualAuthenticatorManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVirtualAuthenticatorManager_CreateAuthenticator_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticator",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticator");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticatorManager_CreateAuthenticator_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticatorManager_CreateAuthenticator_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticatorOptionsPtr p_options{};
      VirtualAuthenticatorManager_CreateAuthenticator_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticatorManager::Name_, 0, false);
        return false;
      }
      VirtualAuthenticatorManager::CreateAuthenticatorCallback callback =
          VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAuthenticator(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticatorManager_GetAuthenticators_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticators",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticators");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticatorManager_GetAuthenticators_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticatorManager_GetAuthenticators_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticatorManager_GetAuthenticators_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticatorManager::Name_, 1, false);
        return false;
      }
      VirtualAuthenticatorManager::GetAuthenticatorsCallback callback =
          VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAuthenticators(std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticatorManager_RemoveAuthenticator_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticator",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticator");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticatorManager_RemoveAuthenticator_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticatorManager_RemoveAuthenticator_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_id{};
      VirtualAuthenticatorManager_RemoveAuthenticator_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticatorManager::Name_, 2, false);
        return false;
      }
      VirtualAuthenticatorManager::RemoveAuthenticatorCallback callback =
          VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveAuthenticator(
std::move(p_id), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticatorManager_ClearAuthenticators_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticators",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticators");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticatorManager_ClearAuthenticators_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticatorManager_ClearAuthenticators_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticatorManager_ClearAuthenticators_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticatorManager::Name_, 3, false);
        return false;
      }
      VirtualAuthenticatorManager::ClearAuthenticatorsCallback callback =
          VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearAuthenticators(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kVirtualAuthenticatorManagerValidationInfo[] = {
    {&internal::VirtualAuthenticatorManager_CreateAuthenticator_Params_Data::Validate,
     &internal::VirtualAuthenticatorManager_CreateAuthenticator_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticatorManager_GetAuthenticators_Params_Data::Validate,
     &internal::VirtualAuthenticatorManager_GetAuthenticators_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticatorManager_RemoveAuthenticator_Params_Data::Validate,
     &internal::VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticatorManager_ClearAuthenticators_Params_Data::Validate,
     &internal::VirtualAuthenticatorManager_ClearAuthenticators_ResponseParams_Data::Validate},
};

bool VirtualAuthenticatorManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::VirtualAuthenticatorManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kVirtualAuthenticatorManagerValidationInfo);
}

bool VirtualAuthenticatorManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::VirtualAuthenticatorManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kVirtualAuthenticatorManagerValidationInfo);
}
}  // namespace mojom
}  // namespace test
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::test::mojom::VirtualAuthenticatorOptions::DataView, ::blink::test::mojom::VirtualAuthenticatorOptionsPtr>::Read(
    ::blink::test::mojom::VirtualAuthenticatorOptions::DataView input,
    ::blink::test::mojom::VirtualAuthenticatorOptionsPtr* output) {
  bool success = true;
  ::blink::test::mojom::VirtualAuthenticatorOptionsPtr result(::blink::test::mojom::VirtualAuthenticatorOptions::New());
  
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadCtap2Version(&result->ctap2_version))
        success = false;
      if (success && !input.ReadTransport(&result->transport))
        success = false;
      if (success && !input.ReadAttachment(&result->attachment))
        success = false;
      if (success)
        result->has_resident_key = input.has_resident_key();
      if (success)
        result->has_user_verification = input.has_user_verification();
      if (success)
        result->is_user_present = input.is_user_present();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::test::mojom::RegisteredKey::DataView, ::blink::test::mojom::RegisteredKeyPtr>::Read(
    ::blink::test::mojom::RegisteredKey::DataView input,
    ::blink::test::mojom::RegisteredKeyPtr* output) {
  bool success = true;
  ::blink::test::mojom::RegisteredKeyPtr result(::blink::test::mojom::RegisteredKey::New());
  
      if (success && !input.ReadKeyHandle(&result->key_handle))
        success = false;
      if (success && !input.ReadRpId(&result->rp_id))
        success = false;
      if (success && !input.ReadPrivateKey(&result->private_key))
        success = false;
      if (success)
        result->counter = input.counter();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif