/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.windows;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.openide.util.ContextAwareAction;
import org.openide.util.ContextGlobalProvider;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public final class GlobalActionContextImpl
implements ContextGlobalProvider,
Lookup.Provider,
PropertyChangeListener,
Runnable {
    private TopComponent.Registry registry;
    private static Reference<Component> focusOwner;
    private static volatile Lookup temporary;

    public GlobalActionContextImpl() {
        this(TopComponent.getRegistry());
    }

    public GlobalActionContextImpl(TopComponent.Registry registry) {
        this.registry = registry;
        if (EventQueue.isDispatchThread()) {
            this.run();
        } else {
            EventQueue.invokeLater(this);
        }
    }

    @Override
    public void run() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", this);
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this);
        GlobalActionContextImpl.setFocusOwner(keyboardFocusManager.getPermanentFocusOwner());
    }

    public static void blickActionMap(ActionMap actionMap) {
        GlobalActionContextImpl.blickActionMap(actionMap, null);
    }

    private static void blickActionMap(final ActionMap actionMap, final Component[] componentArray) {
        if (EventQueue.isDispatchThread()) {
            GlobalActionContextImpl.blickActionMapImpl(actionMap, componentArray);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GlobalActionContextImpl.blickActionMapImpl(actionMap, componentArray);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void blickActionMapImpl(ActionMap actionMap, Component[] componentArray) {
        assert (EventQueue.isDispatchThread());
        Object object = Lookup.getDefault().lookup(ContextGlobalProvider.class);
        if (object instanceof GlobalActionContextImpl) {
            GlobalActionContextImpl globalActionContextImpl = (GlobalActionContextImpl)object;
            Lookup[] lookupArray = new Lookup[]{actionMap == null ? Lookup.EMPTY : Lookups.singleton((Object)actionMap), Lookups.exclude((Lookup)globalActionContextImpl.getLookup(), (Class[])new Class[]{ActionMap.class})};
            Lookup lookup = globalActionContextImpl.getLookup();
            Lookup lookup2 = temporary;
            try {
                temporary = new ProxyLookup(lookupArray);
                Lookup lookup3 = Utilities.actionsGlobalContext();
                Object object2 = lookup3.lookup(ActionMap.class);
                assert (object2 == actionMap) : GlobalActionContextImpl.dumpActionMapInfo(actionMap, object2, lookup2, temporary, lookup3, lookup);
                if (componentArray != null) {
                    GlobalActionContextImpl.setFocusOwner(componentArray[0]);
                }
            }
            finally {
                temporary = lookup2;
                Utilities.actionsGlobalContext().lookup(ActionMap.class);
            }
        }
    }

    private static String dumpActionMapInfo(ActionMap actionMap, Object object, Lookup lookup, Lookup lookup2, Lookup lookup3, Lookup lookup4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("We really get map from the lookup. Map: ").append(actionMap).append(" returned: ").append(object);
        stringBuilder.append("\nprev: ").append(lookup == null ? "null prev" : lookup.lookupAll(Object.class));
        stringBuilder.append("\nnow : ").append(lookup2 == null ? "null now" : lookup2.lookupAll(Object.class));
        stringBuilder.append("\nglobal ctx : ").append(lookup3 == null ? "null" : lookup3.lookupAll(Object.class));
        stringBuilder.append("\noriginal lkp : ").append(lookup4 == null ? "null" : lookup4.lookupAll(Object.class));
        return stringBuilder.toString();
    }

    private static void setFocusOwner(Component component) {
        focusOwner = new WeakReference<Component>(component);
    }

    public static Component findFocusOwner() {
        if (focusOwner == null) {
            Utilities.actionsGlobalContext();
            if (focusOwner == null) {
                GlobalActionContextImpl.setFocusOwner(null);
            }
        }
        return focusOwner.get();
    }

    public Lookup createGlobalContext() {
        this.registry.addPropertyChangeListener(this);
        return Lookups.proxy((Lookup.Provider)this);
    }

    public Lookup getLookup() {
        Lookup lookup = temporary;
        if (lookup != null) {
            return lookup;
        }
        TopComponent topComponent = this.registry.getActivated();
        return topComponent == null ? Lookup.EMPTY : topComponent.getLookup();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            Utilities.actionsGlobalContext().lookup(ActionMap.class);
        }
        if ("permanentFocusOwner".equals(propertyChangeEvent.getPropertyName())) {
            Action action;
            Component[] componentArray = new Component[]{(Component)propertyChangeEvent.getNewValue()};
            if (componentArray[0] instanceof AbstractButton && (action = ((AbstractButton)componentArray[0]).getAction()) instanceof ContextAwareAction) {
                return;
            }
            GlobalActionContextImpl.blickActionMap(null, componentArray);
        }
    }
}

