
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "bookmarks_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void BookmarksWrapper::pysideInitQtMetaTypes()
{
}

void BookmarksWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

BookmarksWrapper::BookmarksWrapper(QObject * parent) : Bookmarks(parent)
{
    resetPyMethodCache();
    // ... middle
}

void BookmarksWrapper::childEvent(QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void BookmarksWrapper::connectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void BookmarksWrapper::customEvent(QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void BookmarksWrapper::disconnectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool BookmarksWrapper::event(QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "Bookmarks.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool BookmarksWrapper::eventFilter(QObject * watched, QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "Bookmarks.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void BookmarksWrapper::timerEvent(QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *BookmarksWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Bookmarks::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int BookmarksWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Bookmarks::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *BookmarksWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< BookmarksWrapper *>(this));
        return Bookmarks::qt_metacast(_clname);
}

BookmarksWrapper::~BookmarksWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Bookmarks_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Bookmarks >()))
        return -1;

    ::BookmarksWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:Bookmarks", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: Bookmarks::Bookmarks(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // Bookmarks(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // Bookmarks(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Bookmarks_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Bookmarks_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_Bookmarks_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                // fall through to handle extra keyword signals and properties
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // Bookmarks(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::BookmarksWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::BookmarksWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Bookmarks >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Bookmarks_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Bookmarks_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Bookmarks_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_BookmarksFunc_addBookmark(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.addBookmark";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addBookmark", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: Bookmarks::addBookmark(BookmarkItem*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // addBookmark(BookmarkItem*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_addBookmark_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addBookmark(BookmarkItem*,BookmarkItem*)
            cppSelf->addBookmark(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksFunc_addBookmark_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_canBeModified(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.canBeModified";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::canBeModified(BookmarkItem*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // canBeModified(BookmarkItem*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_canBeModified_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // canBeModified(BookmarkItem*)const
            bool cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->canBeModified(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarksFunc_canBeModified_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_changeBookmark(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.changeBookmark";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::changeBookmark(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // changeBookmark(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_changeBookmark_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // changeBookmark(BookmarkItem*)
            cppSelf->changeBookmark(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksFunc_changeBookmark_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_insertBookmark(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.insertBookmark";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertBookmark", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: Bookmarks::insertBookmark(BookmarkItem*,int,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[2])))) {
        overloadId = 0; // insertBookmark(BookmarkItem*,int,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_insertBookmark_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // insertBookmark(BookmarkItem*,int,BookmarkItem*)
            cppSelf->insertBookmark(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksFunc_insertBookmark_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_isBookmarked(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.isBookmarked";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::isBookmarked(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // isBookmarked(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_isBookmarked_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isBookmarked(QUrl)
            bool cppResult = cppSelf->isBookmarked(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarksFunc_isBookmarked_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_lastUsedFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.lastUsedFolder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastUsedFolder()const
            BookmarkItem * cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->lastUsedFolder();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarksFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.loadSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loadSettings()
            cppSelf->loadSettings();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_BookmarksFunc_menuFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.menuFolder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // menuFolder()const
            BookmarkItem * cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->menuFolder();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarksFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.model";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // model()const
            BookmarksModel * cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->model();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKSMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarksFunc_removeBookmark(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.removeBookmark";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::removeBookmark(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // removeBookmark(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_removeBookmark_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeBookmark(BookmarkItem*)
            bool cppResult = cppSelf->removeBookmark(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarksFunc_removeBookmark_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_rootItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.rootItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rootItem()const
            BookmarkItem * cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->rootItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarksFunc_searchBookmarks(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.searchBookmarks";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_BookmarksFunc_searchBookmarks_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_BookmarksFunc_searchBookmarks_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:searchBookmarks", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: Bookmarks::searchBookmarks(QString,int,Qt::CaseSensitivity)const
    // 1: Bookmarks::searchBookmarks(QUrl)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // searchBookmarks(QString,int,Qt::CaseSensitivity)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // searchBookmarks(QString,int,Qt::CaseSensitivity)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // searchBookmarks(QString,int,Qt::CaseSensitivity)const
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 1; // searchBookmarks(QUrl)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_searchBookmarks_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // searchBookmarks(const QString & string, int limit, Qt::CaseSensitivity sensitive) const
        {
            if (kwds) {
                PyObject *value{};
                PyObject *kwds_dup = PyDict_Copy(kwds);
                static PyObject *const key_limit = Shiboken::String::createStaticString("limit");
                if (PyDict_Contains(kwds, key_limit)) {
                    value = PyDict_GetItem(kwds, key_limit);
                    if (value && pyArgs[1]) {
                        errInfo = key_limit;
                        Py_INCREF(errInfo);
                        goto Sbk_BookmarksFunc_searchBookmarks_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_BookmarksFunc_searchBookmarks_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_limit);
                }
                static PyObject *const key_sensitive = Shiboken::String::createStaticString("sensitive");
                if (PyDict_Contains(kwds, key_sensitive)) {
                    value = PyDict_GetItem(kwds, key_sensitive);
                    if (value && pyArgs[2]) {
                        errInfo = key_sensitive;
                        Py_INCREF(errInfo);
                        goto Sbk_BookmarksFunc_searchBookmarks_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_BookmarksFunc_searchBookmarks_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sensitive);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup;
                    goto Sbk_BookmarksFunc_searchBookmarks_TypeError;
                } else {
                    Py_DECREF(kwds_dup);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = -1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::CaseSensitivity cppArg2 = Qt::CaseInsensitive;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // searchBookmarks(QString,int,Qt::CaseSensitivity)const
                QList<BookmarkItem* > cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->searchBookmarks(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BOOKMARKITEMPTR_IDX], &cppResult);
            }
            break;
        }
        case 1: // searchBookmarks(const QUrl & url) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_BookmarksFunc_searchBookmarks_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // searchBookmarks(QUrl)const
                QList<BookmarkItem* > cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->searchBookmarks(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BOOKMARKITEMPTR_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarksFunc_searchBookmarks_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_searchKeyword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.searchKeyword";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::searchKeyword(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // searchKeyword(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_searchKeyword_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // searchKeyword(QString)const
            QList<BookmarkItem* > cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->searchKeyword(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BOOKMARKITEMPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarksFunc_searchKeyword_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_setShowOnlyIconsInToolbar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.setShowOnlyIconsInToolbar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::setShowOnlyIconsInToolbar(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowOnlyIconsInToolbar(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_setShowOnlyIconsInToolbar_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShowOnlyIconsInToolbar(bool)
            cppSelf->setShowOnlyIconsInToolbar(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksFunc_setShowOnlyIconsInToolbar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_setShowOnlyTextInToolbar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.setShowOnlyTextInToolbar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::setShowOnlyTextInToolbar(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowOnlyTextInToolbar(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksFunc_setShowOnlyTextInToolbar_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShowOnlyTextInToolbar(bool)
            cppSelf->setShowOnlyTextInToolbar(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksFunc_setShowOnlyTextInToolbar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarksFunc_showOnlyIconsInToolbar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.showOnlyIconsInToolbar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // showOnlyIconsInToolbar()const
            bool cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->showOnlyIconsInToolbar();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarksFunc_showOnlyTextInToolbar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.showOnlyTextInToolbar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // showOnlyTextInToolbar()const
            bool cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->showOnlyTextInToolbar();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarksFunc_toolbarFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.toolbarFolder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toolbarFolder()const
            BookmarkItem * cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->toolbarFolder();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarksFunc_unsortedFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Bookmarks.unsortedFolder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unsortedFolder()const
            BookmarkItem * cppResult = const_cast<const ::BookmarksWrapper *>(cppSelf)->unsortedFolder();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Bookmarks_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Bookmarks_methods[] = {
    {"addBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_addBookmark), METH_VARARGS},
    {"canBeModified", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_canBeModified), METH_O},
    {"changeBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_changeBookmark), METH_O},
    {"insertBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_insertBookmark), METH_VARARGS},
    {"isBookmarked", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_isBookmarked), METH_O},
    {"lastUsedFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_lastUsedFolder), METH_NOARGS},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_loadSettings), METH_NOARGS},
    {"menuFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_menuFolder), METH_NOARGS},
    {"model", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_model), METH_NOARGS},
    {"removeBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_removeBookmark), METH_O},
    {"rootItem", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_rootItem), METH_NOARGS},
    {"searchBookmarks", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_searchBookmarks), METH_VARARGS|METH_KEYWORDS},
    {"searchKeyword", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_searchKeyword), METH_O},
    {"setShowOnlyIconsInToolbar", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_setShowOnlyIconsInToolbar), METH_O},
    {"setShowOnlyTextInToolbar", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_setShowOnlyTextInToolbar), METH_O},
    {"showOnlyIconsInToolbar", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_showOnlyIconsInToolbar), METH_NOARGS},
    {"showOnlyTextInToolbar", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_showOnlyTextInToolbar), METH_NOARGS},
    {"toolbarFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_toolbarFolder), METH_NOARGS},
    {"unsortedFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_unsortedFolder), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Bookmarks_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<BookmarksWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Bookmarks_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Bookmarks_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Bookmarks_Type = nullptr;
static SbkObjectType *Sbk_Bookmarks_TypeF(void)
{
    return _Sbk_Bookmarks_Type;
}

static PyType_Slot Sbk_Bookmarks_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Bookmarks_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Bookmarks_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Bookmarks_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Bookmarks_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Bookmarks_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Bookmarks_spec = {
    "1:PyFalkon.Bookmarks",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Bookmarks_slots
};

} //extern "C"

static void *Sbk_Bookmarks_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Bookmarks *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Bookmarks_PythonToCpp_Bookmarks_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Bookmarks_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Bookmarks_PythonToCpp_Bookmarks_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Bookmarks_TypeF())))
        return Bookmarks_PythonToCpp_Bookmarks_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Bookmarks_PTR_CppToPython_Bookmarks(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Bookmarks *>(const_cast<void *>(cppIn)), Sbk_Bookmarks_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Bookmarks_SignatureStrings[] = {
    "PyFalkon.Bookmarks(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PyFalkon.Bookmarks.addBookmark(self,parent:PyFalkon.BookmarkItem,item:PyFalkon.BookmarkItem)",
    "PyFalkon.Bookmarks.canBeModified(self,item:PyFalkon.BookmarkItem)->bool",
    "PyFalkon.Bookmarks.changeBookmark(self,item:PyFalkon.BookmarkItem)",
    "PyFalkon.Bookmarks.insertBookmark(self,parent:PyFalkon.BookmarkItem,row:int,item:PyFalkon.BookmarkItem)",
    "PyFalkon.Bookmarks.isBookmarked(self,url:PySide2.QtCore.QUrl)->bool",
    "PyFalkon.Bookmarks.lastUsedFolder(self)->PyFalkon.BookmarkItem",
    "PyFalkon.Bookmarks.loadSettings(self)",
    "PyFalkon.Bookmarks.menuFolder(self)->PyFalkon.BookmarkItem",
    "PyFalkon.Bookmarks.model(self)->PyFalkon.BookmarksModel",
    "PyFalkon.Bookmarks.removeBookmark(self,item:PyFalkon.BookmarkItem)->bool",
    "PyFalkon.Bookmarks.rootItem(self)->PyFalkon.BookmarkItem",
    "1:PyFalkon.Bookmarks.searchBookmarks(self,string:QString,limit:int=-1,sensitive:PySide2.QtCore.Qt.CaseSensitivity=Qt.CaseInsensitive)->QList[PyFalkon.BookmarkItem]",
    "0:PyFalkon.Bookmarks.searchBookmarks(self,url:PySide2.QtCore.QUrl)->QList[PyFalkon.BookmarkItem]",
    "PyFalkon.Bookmarks.searchKeyword(self,keyword:QString)->QList[PyFalkon.BookmarkItem]",
    "PyFalkon.Bookmarks.setShowOnlyIconsInToolbar(self,state:bool)",
    "PyFalkon.Bookmarks.setShowOnlyTextInToolbar(self,state:bool)",
    "PyFalkon.Bookmarks.showOnlyIconsInToolbar(self)->bool",
    "PyFalkon.Bookmarks.showOnlyTextInToolbar(self)->bool",
    "PyFalkon.Bookmarks.toolbarFolder(self)->PyFalkon.BookmarkItem",
    "PyFalkon.Bookmarks.unsortedFolder(self)->PyFalkon.BookmarkItem",
    nullptr}; // Sentinel

void init_Bookmarks(PyObject *module)
{
    _Sbk_Bookmarks_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Bookmarks",
        "Bookmarks*",
        &Sbk_Bookmarks_spec,
        &Shiboken::callCppDestructor< ::Bookmarks >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Bookmarks_Type);
    InitSignatureStrings(pyType, Bookmarks_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Bookmarks_Type), Sbk_Bookmarks_PropertyStrings);
    SbkPyFalkonTypes[SBK_BOOKMARKS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Bookmarks_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Bookmarks_TypeF(),
        Bookmarks_PythonToCpp_Bookmarks_PTR,
        is_Bookmarks_PythonToCpp_Bookmarks_PTR_Convertible,
        Bookmarks_PTR_CppToPython_Bookmarks);

    Shiboken::Conversions::registerConverterName(converter, "Bookmarks");
    Shiboken::Conversions::registerConverterName(converter, "Bookmarks*");
    Shiboken::Conversions::registerConverterName(converter, "Bookmarks&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Bookmarks).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::BookmarksWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Bookmarks_TypeF(), &Sbk_Bookmarks_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_Bookmarks_TypeF(), &::Bookmarks::staticMetaObject);
    BookmarksWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Bookmarks_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Bookmarks_TypeF(), &::Bookmarks::staticMetaObject, sizeof(BookmarksWrapper));
}
