/* utils.c generated by valac 0.56.0, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gee.h>
#include "folks/folks.h"
#include <stdarg.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FOLKS_INSPECT_TYPE_UTILS (folks_inspect_utils_get_type ())
#define FOLKS_INSPECT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtils))
#define FOLKS_INSPECT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))
#define FOLKS_INSPECT_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))

typedef struct _FolksInspectUtils FolksInspectUtils;
typedef struct _FolksInspectUtilsClass FolksInspectUtilsClass;
typedef struct _FolksInspectUtilsPrivate FolksInspectUtilsPrivate;

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;
typedef struct _FolksInspectClientPrivate FolksInspectClientPrivate;
typedef struct _FolksInspectParamSpecUtils FolksInspectParamSpecUtils;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksInspectUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectUtilsPrivate * priv;
};

struct _FolksInspectUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectUtils *self);
};

struct _FolksInspectClient {
	GObject parent_instance;
	FolksInspectClientPrivate * priv;
	GeeHashMap* commands;
};

struct _FolksInspectClientClass {
	GObjectClass parent_class;
};

struct _FolksInspectParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer folks_inspect_utils_parent_class = NULL;
static guint folks_inspect_utils_indentation;
static guint folks_inspect_utils_indentation = (guint) 0;
static gchar* folks_inspect_utils_indentation_string;
static gchar* folks_inspect_utils_indentation_string = NULL;
VALA_EXTERN FILE* folks_inspect_utils_output_filestream;
FILE* folks_inspect_utils_output_filestream = NULL;
static GeeMapIterator* folks_inspect_utils_command_name_iter;
static GeeMapIterator* folks_inspect_utils_command_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_individual_id_iter;
static GeeMapIterator* folks_inspect_utils_individual_id_iter = NULL;
static GeeIterator* folks_inspect_utils_persona_uid_iter;
static GeeIterator* folks_inspect_utils_persona_uid_iter = NULL;
static GeeIterator* folks_inspect_utils_backend_name_iter;
static GeeIterator* folks_inspect_utils_backend_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter = NULL;
VALA_EXTERN FolksInspectClient* main_client;

VALA_EXTERN gpointer folks_inspect_utils_ref (gpointer instance);
VALA_EXTERN void folks_inspect_utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* folks_inspect_param_spec_utils (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void folks_inspect_value_set_utils (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void folks_inspect_value_take_utils (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer folks_inspect_value_get_utils (const GValue* value);
VALA_EXTERN GType folks_inspect_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectUtils, folks_inspect_utils_unref)
VALA_EXTERN gpointer folks_inspect_command_ref (gpointer instance);
VALA_EXTERN void folks_inspect_command_unref (gpointer instance);
VALA_EXTERN GParamSpec* folks_inspect_param_spec_command (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void folks_inspect_value_set_command (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void folks_inspect_value_take_command (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer folks_inspect_value_get_command (const GValue* value);
VALA_EXTERN GType folks_inspect_command_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommand, folks_inspect_command_unref)
VALA_EXTERN void folks_inspect_utils_init (void);
static void folks_inspect_utils_transform_object_to_string (GValue* src,
                                                     GValue* dest);
static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value,
                                                                       GValue* dest_value);
static void folks_inspect_utils_transform_persona_store_to_string (GValue* src,
                                                            GValue* dest);
static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value,
                                                                              GValue* dest_value);
static void folks_inspect_utils_transform_string_array_to_string (GValue* src,
                                                           GValue* dest);
static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value,
                                                                             GValue* dest_value);
static void folks_inspect_utils_transform_date_time_to_string (GValue* src,
                                                        GValue* dest);
static void _folks_inspect_utils_transform_date_time_to_string_gvalue_transform (GValue* src_value,
                                                                          GValue* dest_value);
VALA_EXTERN void folks_inspect_utils_indent (void);
VALA_EXTERN void folks_inspect_utils_unindent (void);
VALA_EXTERN void folks_inspect_utils_print_line (const gchar* format,
                                     ...)  G_GNUC_PRINTF(1,2) ;
VALA_EXTERN void folks_inspect_utils_print_blank_line (void);
VALA_EXTERN void folks_inspect_utils_print_individual (FolksIndividual* individual,
                                           gboolean show_personas);
static gchar* folks_inspect_utils_property_to_string (GType object_type,
                                               const gchar* prop_name,
                                               GValue* prop_value);
VALA_EXTERN void folks_inspect_utils_print_persona (FolksPersona* persona);
VALA_EXTERN void folks_inspect_utils_print_persona_store (FolksPersonaStore* store,
                                              gboolean show_personas);
VALA_EXTERN gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
VALA_EXTERN gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word,
                                                       gint state);
VALA_EXTERN GType folks_inspect_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectClient, g_object_unref)
VALA_EXTERN gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word,
                                                        gint state);
VALA_EXTERN FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
VALA_EXTERN gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word,
                                                      gint state);
VALA_EXTERN gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word,
                                                       gint state);
VALA_EXTERN FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
VALA_EXTERN gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word,
                                                           gint state);
VALA_EXTERN gboolean folks_inspect_utils_validate_subcommand (const gchar* command,
                                                  const gchar* command_string,
                                                  const gchar* subcommand,
                                                  gchar** valid_subcommands,
                                                  gint valid_subcommands_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN FolksInspectUtils* folks_inspect_utils_new (void);
VALA_EXTERN FolksInspectUtils* folks_inspect_utils_construct (GType object_type);
static void folks_inspect_utils_finalize (FolksInspectUtils * obj);
static GType folks_inspect_utils_get_type_once (void);

static void
_folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value,
                                                                  GValue* dest_value)
{
	folks_inspect_utils_transform_object_to_string (src_value, dest_value);
}

static void
_folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value,
                                                                         GValue* dest_value)
{
	folks_inspect_utils_transform_persona_store_to_string (src_value, dest_value);
}

static void
_folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value,
                                                                        GValue* dest_value)
{
	folks_inspect_utils_transform_string_array_to_string (src_value, dest_value);
}

static void
_folks_inspect_utils_transform_date_time_to_string_gvalue_transform (GValue* src_value,
                                                                     GValue* dest_value)
{
	folks_inspect_utils_transform_date_time_to_string (src_value, dest_value);
}

void
folks_inspect_utils_init (void)
{
	gchar* _tmp0_;
	FILE* _tmp1_;
	_tmp0_ = g_strdup ("");
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
	folks_inspect_utils_indentation = (guint) 0;
	_tmp1_ = stdout;
	folks_inspect_utils_output_filestream = _tmp1_;
	g_value_register_transform_func (G_TYPE_OBJECT, G_TYPE_STRING, _folks_inspect_utils_transform_object_to_string_gvalue_transform);
	g_value_register_transform_func (FOLKS_TYPE_PERSONA_STORE, G_TYPE_STRING, _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_STRV, G_TYPE_STRING, _folks_inspect_utils_transform_string_array_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_DATE_TIME, G_TYPE_STRING, _folks_inspect_utils_transform_date_time_to_string_gvalue_transform);
}

static void
folks_inspect_utils_transform_object_to_string (GValue* src,
                                                GValue* dest)
{
	GValue _vala_dest = {0};
	gchar* output = NULL;
	GObject* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GValue _tmp3_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = g_value_get_object (src);
	_tmp1_ = g_strdup_printf ("%p", _tmp0_);
	output = _tmp1_;
	_tmp2_ = output;
	output = NULL;
	g_value_init (&_tmp3_, G_TYPE_STRING);
	g_value_take_string (&_tmp3_, _tmp2_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp3_;
	_g_free0 (output);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_inspect_utils_transform_persona_store_to_string (GValue* src,
                                                       GValue* dest)
{
	GValue _vala_dest = {0};
	FolksPersonaStore* store = NULL;
	GValue _tmp0_;
	FolksPersonaStore* _tmp1_;
	gchar* output = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GValue _tmp10_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = *src;
	_tmp1_ = _g_object_ref0 (g_value_get_object (&_tmp0_));
	store = _tmp1_;
	_tmp2_ = folks_persona_store_get_type_id (store);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_persona_store_get_id (store);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_persona_store_get_display_name (store);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%p: %s, %s (%s)", store, _tmp3_, _tmp5_, _tmp7_);
	output = _tmp8_;
	_tmp9_ = output;
	output = NULL;
	g_value_init (&_tmp10_, G_TYPE_STRING);
	g_value_take_string (&_tmp10_, _tmp9_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp10_;
	_g_free0 (output);
	_g_object_unref0 (store);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}

static void
folks_inspect_utils_transform_string_array_to_string (GValue* src,
                                                      GValue* dest)
{
	GValue _vala_dest = {0};
	gchar** array = NULL;
	GValue _tmp0_;
	gchar** _tmp1_;
	gint array_length1;
	gint _array_size_;
	gchar* output = NULL;
	gchar* _tmp2_;
	gboolean first = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GValue _tmp14_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = *src;
	_tmp1_ = g_value_get_boxed (&_tmp0_);
	array = _tmp1_;
	array_length1 = g_strv_length (_tmp1_);
	_array_size_ = array_length1;
	_tmp2_ = g_strdup ("{ ");
	output = _tmp2_;
	first = TRUE;
	_tmp3_ = array;
	_tmp3__length1 = array_length1;
	{
		gchar** element_collection = NULL;
		gint element_collection_length1 = 0;
		gint _element_collection_size_ = 0;
		gint element_it = 0;
		element_collection = _tmp3_;
		element_collection_length1 = _tmp3__length1;
		for (element_it = 0; element_it < element_collection_length1; element_it = element_it + 1) {
			const gchar* element = NULL;
			element = element_collection[element_it];
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				if (first == FALSE) {
					const gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp4_ = output;
					_tmp5_ = g_strconcat (_tmp4_, ", ", NULL);
					_g_free0 (output);
					output = _tmp5_;
				}
				_tmp6_ = output;
				_tmp7_ = element;
				_tmp8_ = g_strdup_printf ("'%s'", _tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
				_g_free0 (output);
				output = _tmp10_;
				_g_free0 (_tmp9_);
				first = FALSE;
			}
		}
	}
	_tmp11_ = output;
	_tmp12_ = g_strconcat (_tmp11_, " }", NULL);
	_g_free0 (output);
	output = _tmp12_;
	_tmp13_ = output;
	output = NULL;
	g_value_init (&_tmp14_, G_TYPE_STRING);
	g_value_take_string (&_tmp14_, _tmp13_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp14_;
	_g_free0 (output);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}

static void
folks_inspect_utils_transform_date_time_to_string (GValue* src,
                                                   GValue* dest)
{
	GValue _vala_dest = {0};
	GDateTime* date_time = NULL;
	GValue _tmp0_;
	gchar* output = NULL;
	gchar* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp5_;
	GValue _tmp6_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = *src;
	date_time = g_value_get_boxed (&_tmp0_);
	_tmp1_ = g_strdup ("(null)");
	output = _tmp1_;
	_tmp2_ = date_time;
	if (_tmp2_ != NULL) {
		GDateTime* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = date_time;
		_tmp4_ = g_date_time_format ((GDateTime*) _tmp3_, "%FT%T%z");
		_g_free0 (output);
		output = _tmp4_;
	}
	_tmp5_ = output;
	output = NULL;
	g_value_init (&_tmp6_, G_TYPE_STRING);
	g_value_take_string (&_tmp6_, _tmp5_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp6_;
	_g_free0 (output);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}

void
folks_inspect_utils_indent (void)
{
	gchar* _tmp0_;
	folks_inspect_utils_indentation = folks_inspect_utils_indentation + 2;
	_tmp0_ = g_strnfill ((gsize) folks_inspect_utils_indentation, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
}

void
folks_inspect_utils_unindent (void)
{
	gchar* _tmp0_;
	folks_inspect_utils_indentation = folks_inspect_utils_indentation - 2;
	_tmp0_ = g_strnfill ((gsize) folks_inspect_utils_indentation, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
}

void
folks_inspect_utils_print_line (const gchar* format,
                                ...)
{
	va_list valist = {0};
	gchar* output = NULL;
	gchar* _tmp0_;
	gchar* str = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	g_return_if_fail (format != NULL);
	va_start (valist, format);
	_tmp0_ = g_strdup_vprintf (format, valist);
	output = _tmp0_;
	_tmp1_ = folks_inspect_utils_indentation_string;
	_tmp2_ = g_strdup_printf ("%s%s", _tmp1_, output);
	str = _tmp2_;
	_tmp3_ = folks_inspect_utils_output_filestream;
	fputs (str, _tmp3_);
	_g_free0 (str);
	_g_free0 (output);
	va_end (valist);
}

void
folks_inspect_utils_print_blank_line (void)
{
	FILE* _tmp0_;
	_tmp0_ = folks_inspect_utils_output_filestream;
	fputs ("", _tmp0_);
}

void
folks_inspect_utils_print_individual (FolksIndividual* individual,
                                      gboolean show_personas)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GParamSpec** properties = NULL;
	GObjectClass* _tmp6_;
	guint _tmp7_ = 0;
	GParamSpec** _tmp8_;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (individual != NULL);
	_tmp0_ = folks_individual_get_id (individual);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_individual_get_personas (individual);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	folks_inspect_utils_print_line ("Individual '%s' with %u personas:", _tmp1_, (guint) _tmp5_);
	_tmp6_ = G_OBJECT_GET_CLASS ((GObject*) individual);
	_tmp8_ = g_object_class_list_properties (_tmp6_, &_tmp7_);
	properties = _tmp8_;
	properties_length1 = _tmp7_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp9_ = properties;
	_tmp9__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp9_;
		pspec_collection_length1 = _tmp9__length1;
		for (pspec_it = 0; pspec_it < pspec_collection_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp10_ = FALSE;
				GParamSpec* _tmp13_;
				GValue _tmp14_ = {0};
				GParamSpec* _tmp15_;
				const gchar* _tmp16_;
				GParamSpec* _tmp17_;
				const gchar* _tmp18_;
				GValue _tmp19_;
				gchar* _tmp20_;
				GParamSpec* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				if (show_personas == TRUE) {
					GParamSpec* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = pspec;
					_tmp12_ = g_param_spec_get_name (_tmp11_);
					_tmp10_ = g_strcmp0 (_tmp12_, "personas") == 0;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				_tmp13_ = pspec;
				g_value_init (&_tmp14_, _tmp13_->value_type);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp14_;
				_tmp15_ = pspec;
				_tmp16_ = g_param_spec_get_name (_tmp15_);
				g_object_get_property ((GObject*) individual, _tmp16_, &prop_value);
				_tmp17_ = pspec;
				_tmp18_ = g_param_spec_get_name (_tmp17_);
				_tmp19_ = prop_value;
				_tmp20_ = folks_inspect_utils_property_to_string (G_TYPE_FROM_INSTANCE ((GObject*) individual), _tmp18_, &_tmp19_);
				_g_free0 (output_string);
				output_string = _tmp20_;
				_tmp21_ = pspec;
				_tmp22_ = g_param_spec_get_nick (_tmp21_);
				_tmp23_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp22_, _tmp23_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	if (show_personas == TRUE) {
		folks_inspect_utils_print_blank_line ();
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			GeeIterator* _persona_it = NULL;
			GeeSet* _tmp24_;
			GeeSet* _tmp25_;
			GeeIterator* _tmp26_;
			_tmp24_ = folks_individual_get_personas (individual);
			_tmp25_ = _tmp24_;
			_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
			_persona_it = _tmp26_;
			while (TRUE) {
				GeeIterator* _tmp27_;
				FolksPersona* persona = NULL;
				GeeIterator* _tmp28_;
				gpointer _tmp29_;
				FolksPersona* _tmp30_;
				_tmp27_ = _persona_it;
				if (!gee_iterator_next (_tmp27_)) {
					break;
				}
				_tmp28_ = _persona_it;
				_tmp29_ = gee_iterator_get (_tmp28_);
				persona = (FolksPersona*) _tmp29_;
				_tmp30_ = persona;
				folks_inspect_utils_print_persona (_tmp30_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
	properties = (g_free (properties), NULL);
}

void
folks_inspect_utils_print_persona (FolksPersona* persona)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GParamSpec** properties = NULL;
	GObjectClass* _tmp2_;
	guint _tmp3_ = 0;
	GParamSpec** _tmp4_;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (persona != NULL);
	_tmp0_ = folks_persona_get_uid (persona);
	_tmp1_ = _tmp0_;
	folks_inspect_utils_print_line ("Persona '%s':", _tmp1_);
	_tmp2_ = G_OBJECT_GET_CLASS ((GObject*) persona);
	_tmp4_ = g_object_class_list_properties (_tmp2_, &_tmp3_);
	properties = _tmp4_;
	properties_length1 = _tmp3_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp5_ = properties;
	_tmp5__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp5_;
		pspec_collection_length1 = _tmp5__length1;
		for (pspec_it = 0; pspec_it < pspec_collection_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				GParamSpec* _tmp6_;
				GValue _tmp7_ = {0};
				GParamSpec* _tmp8_;
				const gchar* _tmp9_;
				GParamSpec* _tmp10_;
				const gchar* _tmp11_;
				GValue _tmp12_;
				gchar* _tmp13_;
				GParamSpec* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp6_ = pspec;
				g_value_init (&_tmp7_, _tmp6_->value_type);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp7_;
				_tmp8_ = pspec;
				_tmp9_ = g_param_spec_get_name (_tmp8_);
				g_object_get_property ((GObject*) persona, _tmp9_, &prop_value);
				_tmp10_ = pspec;
				_tmp11_ = g_param_spec_get_name (_tmp10_);
				_tmp12_ = prop_value;
				_tmp13_ = folks_inspect_utils_property_to_string (G_TYPE_FROM_INSTANCE ((GObject*) persona), _tmp11_, &_tmp12_);
				_g_free0 (output_string);
				output_string = _tmp13_;
				_tmp14_ = pspec;
				_tmp15_ = g_param_spec_get_nick (_tmp14_);
				_tmp16_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp15_, _tmp16_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	properties = (g_free (properties), NULL);
}

void
folks_inspect_utils_print_persona_store (FolksPersonaStore* store,
                                         gboolean show_personas)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GeeMap* _tmp6_;
	GeeMap* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GParamSpec** properties = NULL;
	GObjectClass* _tmp10_;
	guint _tmp11_ = 0;
	GParamSpec** _tmp12_;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp13_;
	gint _tmp13__length1;
	g_return_if_fail (store != NULL);
	_tmp0_ = folks_persona_store_get_is_prepared (store);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == FALSE) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = folks_persona_store_get_id (store);
		_tmp3_ = _tmp2_;
		folks_inspect_utils_print_line ("Persona store '%s':", _tmp3_);
		folks_inspect_utils_indent ();
		folks_inspect_utils_print_line ("Not prepared.");
		folks_inspect_utils_unindent ();
		return;
	}
	_tmp4_ = folks_persona_store_get_id (store);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_persona_store_get_personas (store);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	folks_inspect_utils_print_line ("Persona store '%s' with %u personas:", _tmp5_, (guint) _tmp9_);
	_tmp10_ = G_OBJECT_GET_CLASS ((GObject*) store);
	_tmp12_ = g_object_class_list_properties (_tmp10_, &_tmp11_);
	properties = _tmp12_;
	properties_length1 = _tmp11_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp13_ = properties;
	_tmp13__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp13_;
		pspec_collection_length1 = _tmp13__length1;
		for (pspec_it = 0; pspec_it < pspec_collection_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp14_ = FALSE;
				GParamSpec* _tmp17_;
				GValue _tmp18_ = {0};
				GParamSpec* _tmp19_;
				const gchar* _tmp20_;
				GParamSpec* _tmp21_;
				const gchar* _tmp22_;
				GValue _tmp23_;
				gchar* _tmp24_;
				GParamSpec* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				if (show_personas == TRUE) {
					GParamSpec* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = pspec;
					_tmp16_ = g_param_spec_get_name (_tmp15_);
					_tmp14_ = g_strcmp0 (_tmp16_, "personas") == 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				_tmp17_ = pspec;
				g_value_init (&_tmp18_, _tmp17_->value_type);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp18_;
				_tmp19_ = pspec;
				_tmp20_ = g_param_spec_get_name (_tmp19_);
				g_object_get_property ((GObject*) store, _tmp20_, &prop_value);
				_tmp21_ = pspec;
				_tmp22_ = g_param_spec_get_name (_tmp21_);
				_tmp23_ = prop_value;
				_tmp24_ = folks_inspect_utils_property_to_string (G_TYPE_FROM_INSTANCE ((GObject*) store), _tmp22_, &_tmp23_);
				_g_free0 (output_string);
				output_string = _tmp24_;
				_tmp25_ = pspec;
				_tmp26_ = g_param_spec_get_nick (_tmp25_);
				_tmp27_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp26_, _tmp27_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	if (show_personas == TRUE) {
		folks_inspect_utils_print_blank_line ();
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			GeeIterator* _persona_it = NULL;
			GeeMap* _tmp28_;
			GeeMap* _tmp29_;
			GeeCollection* _tmp30_;
			GeeCollection* _tmp31_;
			GeeCollection* _tmp32_;
			GeeIterator* _tmp33_;
			GeeIterator* _tmp34_;
			_tmp28_ = folks_persona_store_get_personas (store);
			_tmp29_ = _tmp28_;
			_tmp30_ = gee_map_get_values (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = _tmp31_;
			_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
			_tmp34_ = _tmp33_;
			_g_object_unref0 (_tmp32_);
			_persona_it = _tmp34_;
			while (TRUE) {
				GeeIterator* _tmp35_;
				FolksPersona* persona = NULL;
				GeeIterator* _tmp36_;
				gpointer _tmp37_;
				FolksPersona* _tmp38_;
				_tmp35_ = _persona_it;
				if (!gee_iterator_next (_tmp35_)) {
					break;
				}
				_tmp36_ = _persona_it;
				_tmp37_ = gee_iterator_get (_tmp36_);
				persona = (FolksPersona*) _tmp37_;
				_tmp38_ = persona;
				folks_inspect_utils_print_persona (_tmp38_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
	properties = (g_free (properties), NULL);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static gchar*
folks_inspect_utils_property_to_string (GType object_type,
                                        const gchar* prop_name,
                                        GValue* prop_value)
{
	gchar* output_string = NULL;
	gboolean _tmp0_ = FALSE;
	GValue _tmp172_;
	gchar* _tmp173_;
	gchar* result;
	g_return_val_if_fail (prop_name != NULL, NULL);
	g_return_val_if_fail (prop_value != NULL, NULL);
	if (g_type_is_a (object_type, FOLKS_TYPE_INDIVIDUAL)) {
		_tmp0_ = g_strcmp0 (prop_name, "personas") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeSet* personas = NULL;
		GObject* _tmp1_;
		GeeSet* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = g_value_get_object (prop_value);
		personas = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
		_tmp2_ = personas;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("List of %u personas", (guint) _tmp4_);
		result = _tmp5_;
		_g_free0 (output_string);
		return result;
	} else {
		gboolean _tmp6_ = FALSE;
		if (g_type_is_a (object_type, FOLKS_TYPE_PERSONA_STORE)) {
			_tmp6_ = g_strcmp0 (prop_name, "personas") == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GeeMap* personas = NULL;
			GObject* _tmp7_;
			GeeMap* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = g_value_get_object (prop_value);
			personas = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_MAP, GeeMap);
			_tmp8_ = personas;
			_tmp9_ = gee_map_get_size (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf ("Set of %u personas", (guint) _tmp10_);
			result = _tmp11_;
			_g_free0 (output_string);
			return result;
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			if (g_strcmp0 (prop_name, "groups") == 0) {
				_tmp14_ = TRUE;
			} else {
				_tmp14_ = g_strcmp0 (prop_name, "local-ids") == 0;
			}
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				_tmp13_ = g_strcmp0 (prop_name, "supported-fields") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = g_strcmp0 (prop_name, "anti-links") == 0;
			}
			if (_tmp12_) {
				GeeSet* groups = NULL;
				GObject* _tmp15_;
				gchar* _tmp16_;
				gboolean first = FALSE;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp15_ = g_value_get_object (prop_value);
				groups = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_SET, GeeSet);
				_tmp16_ = g_strdup ("{ ");
				_g_free0 (output_string);
				output_string = _tmp16_;
				first = TRUE;
				{
					GeeIterator* _group_it = NULL;
					GeeSet* _tmp17_;
					GeeIterator* _tmp18_;
					_tmp17_ = groups;
					_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
					_group_it = _tmp18_;
					while (TRUE) {
						GeeIterator* _tmp19_;
						gchar* group = NULL;
						GeeIterator* _tmp20_;
						gpointer _tmp21_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp19_ = _group_it;
						if (!gee_iterator_next (_tmp19_)) {
							break;
						}
						_tmp20_ = _group_it;
						_tmp21_ = gee_iterator_get (_tmp20_);
						group = (gchar*) _tmp21_;
						if (first == FALSE) {
							const gchar* _tmp22_;
							gchar* _tmp23_;
							_tmp22_ = output_string;
							_tmp23_ = g_strconcat (_tmp22_, ", ", NULL);
							_g_free0 (output_string);
							output_string = _tmp23_;
						}
						_tmp24_ = output_string;
						_tmp25_ = group;
						_tmp26_ = g_strdup_printf ("'%s'", _tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
						_g_free0 (output_string);
						output_string = _tmp28_;
						_g_free0 (_tmp27_);
						first = FALSE;
						_g_free0 (group);
					}
					_g_object_unref0 (_group_it);
				}
				_tmp29_ = output_string;
				_tmp30_ = g_strconcat (_tmp29_, " }", NULL);
				_g_free0 (output_string);
				output_string = _tmp30_;
				result = output_string;
				return result;
			} else {
				if (g_strcmp0 (prop_name, "avatar") == 0) {
					gchar* ret = NULL;
					GLoadableIcon* avatar = NULL;
					GObject* _tmp31_;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					GLoadableIcon* _tmp34_;
					ret = NULL;
					_tmp31_ = g_value_get_object (prop_value);
					avatar = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, g_loadable_icon_get_type (), GLoadableIcon);
					_tmp34_ = avatar;
					if (_tmp34_ != NULL) {
						GLoadableIcon* _tmp35_;
						_tmp35_ = avatar;
						_tmp33_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, g_file_icon_get_type ());
					} else {
						_tmp33_ = FALSE;
					}
					if (_tmp33_) {
						GLoadableIcon* _tmp36_;
						GFile* _tmp37_;
						_tmp36_ = avatar;
						_tmp37_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, g_file_icon_get_type (), GFileIcon));
						_tmp32_ = _tmp37_ != NULL;
					} else {
						_tmp32_ = FALSE;
					}
					if (_tmp32_) {
						GLoadableIcon* _tmp38_;
						GLoadableIcon* _tmp39_;
						GFile* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp38_ = avatar;
						_tmp39_ = avatar;
						_tmp40_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, g_file_icon_get_type (), GFileIcon));
						_tmp41_ = g_file_get_uri (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strdup_printf ("%p (file: %s)", _tmp38_, _tmp42_);
						_g_free0 (ret);
						ret = _tmp43_;
						_g_free0 (_tmp42_);
					} else {
						GLoadableIcon* _tmp44_;
						_tmp44_ = avatar;
						if (_tmp44_ != NULL) {
							GLoadableIcon* _tmp45_;
							gchar* _tmp46_;
							_tmp45_ = avatar;
							_tmp46_ = g_strdup_printf ("%p", _tmp45_);
							_g_free0 (ret);
							ret = _tmp46_;
						}
					}
					result = ret;
					_g_free0 (output_string);
					return result;
				} else {
					if (g_strcmp0 (prop_name, "file") == 0) {
						gchar* ret = NULL;
						GFile* file = NULL;
						GObject* _tmp47_;
						GFile* _tmp48_;
						ret = NULL;
						_tmp47_ = g_value_get_object (prop_value);
						file = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, g_file_get_type (), GFile);
						_tmp48_ = file;
						if (_tmp48_ != NULL) {
							GFile* _tmp49_;
							GFile* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							gchar* _tmp53_;
							_tmp49_ = file;
							_tmp50_ = file;
							_tmp51_ = g_file_get_uri (_tmp50_);
							_tmp52_ = _tmp51_;
							_tmp53_ = g_strdup_printf ("%p (file: %s)", _tmp49_, _tmp52_);
							_g_free0 (ret);
							ret = _tmp53_;
							_g_free0 (_tmp52_);
						}
						result = ret;
						_g_free0 (output_string);
						return result;
					} else {
						gboolean _tmp54_ = FALSE;
						if (g_strcmp0 (prop_name, "im-addresses") == 0) {
							_tmp54_ = TRUE;
						} else {
							_tmp54_ = g_strcmp0 (prop_name, "web-service-addresses") == 0;
						}
						if (_tmp54_) {
							GeeMultiMap* prop_list = NULL;
							GObject* _tmp55_;
							gchar* _tmp56_;
							gboolean first = FALSE;
							const gchar* _tmp91_;
							gchar* _tmp92_;
							_tmp55_ = g_value_get_object (prop_value);
							prop_list = G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
							_tmp56_ = g_strdup ("{ ");
							_g_free0 (output_string);
							output_string = _tmp56_;
							first = TRUE;
							{
								GeeIterator* _k_it = NULL;
								GeeMultiMap* _tmp57_;
								GeeSet* _tmp58_;
								GeeSet* _tmp59_;
								GeeIterator* _tmp60_;
								GeeIterator* _tmp61_;
								_tmp57_ = prop_list;
								_tmp58_ = gee_multi_map_get_keys (_tmp57_);
								_tmp59_ = _tmp58_;
								_tmp60_ = gee_iterable_iterator ((GeeIterable*) _tmp59_);
								_tmp61_ = _tmp60_;
								_g_object_unref0 (_tmp59_);
								_k_it = _tmp61_;
								while (TRUE) {
									GeeIterator* _tmp62_;
									gchar* k = NULL;
									GeeIterator* _tmp63_;
									gpointer _tmp64_;
									const gchar* _tmp67_;
									const gchar* _tmp68_;
									gchar* _tmp69_;
									gchar* _tmp70_;
									gchar* _tmp71_;
									GeeCollection* v = NULL;
									GeeMultiMap* _tmp72_;
									const gchar* _tmp73_;
									GeeCollection* _tmp74_;
									gboolean _first = FALSE;
									const gchar* _tmp89_;
									gchar* _tmp90_;
									_tmp62_ = _k_it;
									if (!gee_iterator_next (_tmp62_)) {
										break;
									}
									_tmp63_ = _k_it;
									_tmp64_ = gee_iterator_get (_tmp63_);
									k = (gchar*) _tmp64_;
									if (first == FALSE) {
										const gchar* _tmp65_;
										gchar* _tmp66_;
										_tmp65_ = output_string;
										_tmp66_ = g_strconcat (_tmp65_, ", ", NULL);
										_g_free0 (output_string);
										output_string = _tmp66_;
									}
									_tmp67_ = output_string;
									_tmp68_ = k;
									_tmp69_ = g_strdup_printf ("'%s' : { ", _tmp68_);
									_tmp70_ = _tmp69_;
									_tmp71_ = g_strconcat (_tmp67_, _tmp70_, NULL);
									_g_free0 (output_string);
									output_string = _tmp71_;
									_g_free0 (_tmp70_);
									first = FALSE;
									_tmp72_ = prop_list;
									_tmp73_ = k;
									_tmp74_ = gee_multi_map_get (_tmp72_, _tmp73_);
									v = _tmp74_;
									_first = TRUE;
									{
										GeeIterator* _a_it = NULL;
										GeeCollection* _tmp75_;
										GeeIterator* _tmp76_;
										_tmp75_ = v;
										_tmp76_ = gee_iterable_iterator ((GeeIterable*) _tmp75_);
										_a_it = _tmp76_;
										while (TRUE) {
											GeeIterator* _tmp77_;
											FolksAbstractFieldDetails* a = NULL;
											GeeIterator* _tmp78_;
											gpointer _tmp79_;
											const gchar* _tmp82_;
											FolksAbstractFieldDetails* _tmp83_;
											gconstpointer _tmp84_;
											gconstpointer _tmp85_;
											gchar* _tmp86_;
											gchar* _tmp87_;
											gchar* _tmp88_;
											_tmp77_ = _a_it;
											if (!gee_iterator_next (_tmp77_)) {
												break;
											}
											_tmp78_ = _a_it;
											_tmp79_ = gee_iterator_get (_tmp78_);
											a = (FolksAbstractFieldDetails*) _tmp79_;
											if (_first == FALSE) {
												const gchar* _tmp80_;
												gchar* _tmp81_;
												_tmp80_ = output_string;
												_tmp81_ = g_strconcat (_tmp80_, ", ", NULL);
												_g_free0 (output_string);
												output_string = _tmp81_;
											}
											_tmp82_ = output_string;
											_tmp83_ = a;
											_tmp84_ = folks_abstract_field_details_get_value (_tmp83_);
											_tmp85_ = _tmp84_;
											_tmp86_ = g_strdup_printf ("'%s'", (const gchar*) _tmp85_);
											_tmp87_ = _tmp86_;
											_tmp88_ = g_strconcat (_tmp82_, _tmp87_, NULL);
											_g_free0 (output_string);
											output_string = _tmp88_;
											_g_free0 (_tmp87_);
											_first = FALSE;
											_g_object_unref0 (a);
										}
										_g_object_unref0 (_a_it);
									}
									_tmp89_ = output_string;
									_tmp90_ = g_strconcat (_tmp89_, " }", NULL);
									_g_free0 (output_string);
									output_string = _tmp90_;
									_g_object_unref0 (v);
									_g_free0 (k);
								}
								_g_object_unref0 (_k_it);
							}
							_tmp91_ = output_string;
							_tmp92_ = g_strconcat (_tmp91_, " }", NULL);
							_g_free0 (output_string);
							output_string = _tmp92_;
							result = output_string;
							return result;
						} else {
							gboolean _tmp93_ = FALSE;
							gboolean _tmp94_ = FALSE;
							if (g_strcmp0 (prop_name, "email-addresses") == 0) {
								_tmp94_ = TRUE;
							} else {
								_tmp94_ = g_strcmp0 (prop_name, "phone-numbers") == 0;
							}
							if (_tmp94_) {
								_tmp93_ = TRUE;
							} else {
								_tmp93_ = g_strcmp0 (prop_name, "urls") == 0;
							}
							if (_tmp93_) {
								gchar* _tmp95_;
								gboolean first = FALSE;
								GeeSet* prop_list = NULL;
								GObject* _tmp96_;
								const gchar* _tmp109_;
								gchar* _tmp110_;
								_tmp95_ = g_strdup ("{ ");
								_g_free0 (output_string);
								output_string = _tmp95_;
								first = TRUE;
								_tmp96_ = g_value_get_object (prop_value);
								prop_list = G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, GEE_TYPE_SET, GeeSet);
								{
									GeeIterator* _p_it = NULL;
									GeeSet* _tmp97_;
									GeeIterator* _tmp98_;
									_tmp97_ = prop_list;
									_tmp98_ = gee_iterable_iterator ((GeeIterable*) _tmp97_);
									_p_it = _tmp98_;
									while (TRUE) {
										GeeIterator* _tmp99_;
										FolksAbstractFieldDetails* p = NULL;
										GeeIterator* _tmp100_;
										gpointer _tmp101_;
										const gchar* _tmp104_;
										FolksAbstractFieldDetails* _tmp105_;
										gconstpointer _tmp106_;
										gconstpointer _tmp107_;
										gchar* _tmp108_;
										_tmp99_ = _p_it;
										if (!gee_iterator_next (_tmp99_)) {
											break;
										}
										_tmp100_ = _p_it;
										_tmp101_ = gee_iterator_get (_tmp100_);
										p = (FolksAbstractFieldDetails*) _tmp101_;
										if (!first) {
											const gchar* _tmp102_;
											gchar* _tmp103_;
											_tmp102_ = output_string;
											_tmp103_ = g_strconcat (_tmp102_, ", ", NULL);
											_g_free0 (output_string);
											output_string = _tmp103_;
										}
										_tmp104_ = output_string;
										_tmp105_ = p;
										_tmp106_ = folks_abstract_field_details_get_value (_tmp105_);
										_tmp107_ = _tmp106_;
										_tmp108_ = g_strconcat (_tmp104_, (const gchar*) _tmp107_, NULL);
										_g_free0 (output_string);
										output_string = _tmp108_;
										first = FALSE;
										_g_object_unref0 (p);
									}
									_g_object_unref0 (_p_it);
								}
								_tmp109_ = output_string;
								_tmp110_ = g_strconcat (_tmp109_, " }", NULL);
								_g_free0 (output_string);
								output_string = _tmp110_;
								result = output_string;
								return result;
							} else {
								if (g_strcmp0 (prop_name, "birthday") == 0) {
									GDateTime* dobj = NULL;
									void* _tmp111_;
									GDateTime* _tmp112_;
									_tmp111_ = g_value_get_boxed (prop_value);
									dobj = (GDateTime*) _tmp111_;
									_tmp112_ = dobj;
									if (_tmp112_ != NULL) {
										GDateTime* _tmp113_;
										gchar* _tmp114_;
										_tmp113_ = dobj;
										_tmp114_ = g_date_time_to_string (_tmp113_);
										result = _tmp114_;
										_g_free0 (output_string);
										return result;
									} else {
										gchar* _tmp115_;
										_tmp115_ = g_strdup ("");
										result = _tmp115_;
										_g_free0 (output_string);
										return result;
									}
								} else {
									if (g_strcmp0 (prop_name, "postal-addresses") == 0) {
										gchar* _tmp116_;
										gboolean first = FALSE;
										GeeSet* prop_list = NULL;
										GObject* _tmp117_;
										const gchar* _tmp132_;
										gchar* _tmp133_;
										_tmp116_ = g_strdup ("{ ");
										_g_free0 (output_string);
										output_string = _tmp116_;
										first = TRUE;
										_tmp117_ = g_value_get_object (prop_value);
										prop_list = G_TYPE_CHECK_INSTANCE_CAST (_tmp117_, GEE_TYPE_SET, GeeSet);
										{
											GeeIterator* _p_it = NULL;
											GeeSet* _tmp118_;
											GeeIterator* _tmp119_;
											_tmp118_ = prop_list;
											_tmp119_ = gee_iterable_iterator ((GeeIterable*) _tmp118_);
											_p_it = _tmp119_;
											while (TRUE) {
												GeeIterator* _tmp120_;
												FolksPostalAddressFieldDetails* p = NULL;
												GeeIterator* _tmp121_;
												gpointer _tmp122_;
												const gchar* _tmp125_;
												FolksPostalAddressFieldDetails* _tmp126_;
												gconstpointer _tmp127_;
												gconstpointer _tmp128_;
												gchar* _tmp129_;
												gchar* _tmp130_;
												gchar* _tmp131_;
												_tmp120_ = _p_it;
												if (!gee_iterator_next (_tmp120_)) {
													break;
												}
												_tmp121_ = _p_it;
												_tmp122_ = gee_iterator_get (_tmp121_);
												p = (FolksPostalAddressFieldDetails*) _tmp122_;
												if (!first) {
													const gchar* _tmp123_;
													gchar* _tmp124_;
													_tmp123_ = output_string;
													_tmp124_ = g_strconcat (_tmp123_, ". ", NULL);
													_g_free0 (output_string);
													output_string = _tmp124_;
												}
												_tmp125_ = output_string;
												_tmp126_ = p;
												_tmp127_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp126_);
												_tmp128_ = _tmp127_;
												_tmp129_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp128_);
												_tmp130_ = _tmp129_;
												_tmp131_ = g_strconcat (_tmp125_, _tmp130_, NULL);
												_g_free0 (output_string);
												output_string = _tmp131_;
												_g_free0 (_tmp130_);
												first = FALSE;
												_g_object_unref0 (p);
											}
											_g_object_unref0 (_p_it);
										}
										_tmp132_ = output_string;
										_tmp133_ = g_strconcat (_tmp132_, " }", NULL);
										_g_free0 (output_string);
										output_string = _tmp133_;
										result = output_string;
										return result;
									} else {
										if (g_strcmp0 (prop_name, "notes") == 0) {
											GeeSet* notes = NULL;
											GObject* _tmp134_;
											gchar* _tmp135_;
											gboolean first = FALSE;
											const gchar* _tmp148_;
											gchar* _tmp149_;
											_tmp134_ = g_value_get_object (prop_value);
											notes = G_TYPE_CHECK_INSTANCE_TYPE (_tmp134_, GEE_TYPE_SET) ? ((GeeSet*) _tmp134_) : NULL;
											_tmp135_ = g_strdup ("{ ");
											_g_free0 (output_string);
											output_string = _tmp135_;
											first = TRUE;
											{
												GeeIterator* _note_it = NULL;
												GeeSet* _tmp136_;
												GeeIterator* _tmp137_;
												_tmp136_ = notes;
												_tmp137_ = gee_iterable_iterator ((GeeIterable*) _tmp136_);
												_note_it = _tmp137_;
												while (TRUE) {
													GeeIterator* _tmp138_;
													FolksNoteFieldDetails* note = NULL;
													GeeIterator* _tmp139_;
													gpointer _tmp140_;
													const gchar* _tmp143_;
													FolksNoteFieldDetails* _tmp144_;
													const gchar* _tmp145_;
													const gchar* _tmp146_;
													gchar* _tmp147_;
													_tmp138_ = _note_it;
													if (!gee_iterator_next (_tmp138_)) {
														break;
													}
													_tmp139_ = _note_it;
													_tmp140_ = gee_iterator_get (_tmp139_);
													note = (FolksNoteFieldDetails*) _tmp140_;
													if (!first) {
														const gchar* _tmp141_;
														gchar* _tmp142_;
														_tmp141_ = output_string;
														_tmp142_ = g_strconcat (_tmp141_, ", ", NULL);
														_g_free0 (output_string);
														output_string = _tmp142_;
													}
													_tmp143_ = output_string;
													_tmp144_ = note;
													_tmp145_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) _tmp144_);
													_tmp146_ = _tmp145_;
													_tmp147_ = g_strconcat (_tmp143_, _tmp146_, NULL);
													_g_free0 (output_string);
													output_string = _tmp147_;
													first = FALSE;
													_g_object_unref0 (note);
												}
												_g_object_unref0 (_note_it);
											}
											_tmp148_ = output_string;
											_tmp149_ = g_strconcat (_tmp148_, " }", NULL);
											_g_free0 (output_string);
											output_string = _tmp149_;
											result = output_string;
											return result;
										} else {
											if (g_strcmp0 (prop_name, "roles") == 0) {
												GeeSet* roles = NULL;
												GObject* _tmp150_;
												gchar* _tmp151_;
												gboolean first = FALSE;
												const gchar* _tmp166_;
												gchar* _tmp167_;
												_tmp150_ = g_value_get_object (prop_value);
												roles = G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, GEE_TYPE_SET, GeeSet);
												_tmp151_ = g_strdup ("{ ");
												_g_free0 (output_string);
												output_string = _tmp151_;
												first = TRUE;
												{
													GeeIterator* _role_it = NULL;
													GeeSet* _tmp152_;
													GeeIterator* _tmp153_;
													_tmp152_ = roles;
													_tmp153_ = gee_iterable_iterator ((GeeIterable*) _tmp152_);
													_role_it = _tmp153_;
													while (TRUE) {
														GeeIterator* _tmp154_;
														FolksRoleFieldDetails* role = NULL;
														GeeIterator* _tmp155_;
														gpointer _tmp156_;
														const gchar* _tmp159_;
														FolksRoleFieldDetails* _tmp160_;
														gconstpointer _tmp161_;
														gconstpointer _tmp162_;
														gchar* _tmp163_;
														gchar* _tmp164_;
														gchar* _tmp165_;
														_tmp154_ = _role_it;
														if (!gee_iterator_next (_tmp154_)) {
															break;
														}
														_tmp155_ = _role_it;
														_tmp156_ = gee_iterator_get (_tmp155_);
														role = (FolksRoleFieldDetails*) _tmp156_;
														if (!first) {
															const gchar* _tmp157_;
															gchar* _tmp158_;
															_tmp157_ = output_string;
															_tmp158_ = g_strconcat (_tmp157_, ", ", NULL);
															_g_free0 (output_string);
															output_string = _tmp158_;
														}
														_tmp159_ = output_string;
														_tmp160_ = role;
														_tmp161_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp160_);
														_tmp162_ = _tmp161_;
														_tmp163_ = folks_role_to_string ((FolksRole*) _tmp162_);
														_tmp164_ = _tmp163_;
														_tmp165_ = g_strconcat (_tmp159_, _tmp164_, NULL);
														_g_free0 (output_string);
														output_string = _tmp165_;
														_g_free0 (_tmp164_);
														first = FALSE;
														_g_object_unref0 (role);
													}
													_g_object_unref0 (_role_it);
												}
												_tmp166_ = output_string;
												_tmp167_ = g_strconcat (_tmp166_, " }", NULL);
												_g_free0 (output_string);
												output_string = _tmp167_;
												result = output_string;
												return result;
											} else {
												if (g_strcmp0 (prop_name, "structured-name") == 0) {
													FolksStructuredName* sn = NULL;
													GObject* _tmp168_;
													gchar* ret = NULL;
													FolksStructuredName* _tmp169_;
													_tmp168_ = g_value_get_object (prop_value);
													sn = G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
													ret = NULL;
													_tmp169_ = sn;
													if (_tmp169_ != NULL) {
														FolksStructuredName* _tmp170_;
														gchar* _tmp171_;
														_tmp170_ = sn;
														_tmp171_ = folks_structured_name_to_string (_tmp170_);
														_g_free0 (ret);
														ret = _tmp171_;
													}
													result = ret;
													_g_free0 (output_string);
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp172_ = *prop_value;
	_tmp173_ = folks_inspect_utils_transform_value_to_string (&_tmp172_);
	result = _tmp173_;
	_g_free0 (output_string);
	return result;
}

gchar*
folks_inspect_utils_transform_value_to_string (GValue* prop_value)
{
	gchar* result;
	g_return_val_if_fail (prop_value != NULL, NULL);
	if (g_value_type_transformable (G_VALUE_TYPE (prop_value), G_TYPE_STRING)) {
		GValue string_value = {0};
		GValue _tmp0_ = {0};
		const gchar* _tmp1_;
		gchar* _tmp2_;
		g_value_init (&_tmp0_, G_TYPE_STRING);
		string_value = _tmp0_;
		g_value_transform (prop_value, &string_value);
		_tmp1_ = g_value_get_string (&string_value);
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		G_IS_VALUE (&string_value) ? (g_value_unset (&string_value), NULL) : NULL;
		return result;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = g_type_name (G_VALUE_TYPE (prop_value));
		_tmp4_ = g_type_name (G_TYPE_STRING);
		_tmp5_ = g_strdup_printf ("Can't convert from type '%s' to '%s'", _tmp3_, _tmp4_);
		result = _tmp5_;
		return result;
	}
}

gchar*
folks_inspect_utils_command_name_completion_cb (const gchar* word,
                                                gint state)
{
	gchar* result;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksInspectClient* _tmp0_;
		GeeHashMap* _tmp1_;
		GeeMapIterator* _tmp2_;
		_tmp0_ = main_client;
		_tmp1_ = _tmp0_->commands;
		_tmp2_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp1_);
		_g_object_unref0 (folks_inspect_utils_command_name_iter);
		folks_inspect_utils_command_name_iter = _tmp2_;
	}
	while (TRUE) {
		GeeMapIterator* _tmp3_;
		gchar* command_name = NULL;
		GeeMapIterator* _tmp4_;
		gpointer _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = folks_inspect_utils_command_name_iter;
		if (!(gee_map_iterator_next (_tmp3_) == TRUE)) {
			break;
		}
		_tmp4_ = folks_inspect_utils_command_name_iter;
		_tmp5_ = gee_map_iterator_get_key (_tmp4_);
		command_name = (gchar*) _tmp5_;
		_tmp6_ = command_name;
		if (g_str_has_prefix (_tmp6_, word)) {
			result = command_name;
			return result;
		}
		_g_free0 (command_name);
	}
	_g_object_unref0 (folks_inspect_utils_command_name_iter);
	folks_inspect_utils_command_name_iter = NULL;
	result = NULL;
	return result;
}

gchar*
folks_inspect_utils_individual_id_completion_cb (const gchar* word,
                                                 gint state)
{
	gchar* result;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksInspectClient* _tmp0_;
		FolksIndividualAggregator* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		GeeMap* _tmp3_;
		GeeMap* _tmp4_;
		GeeMapIterator* _tmp5_;
		_tmp0_ = main_client;
		_tmp1_ = folks_inspect_client_get_aggregator (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = folks_individual_aggregator_get_individuals (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_map_map_iterator (_tmp4_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp5_;
	}
	while (TRUE) {
		GeeMapIterator* _tmp6_;
		gchar* id = NULL;
		GeeMapIterator* _tmp7_;
		gpointer _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = folks_inspect_utils_individual_id_iter;
		if (!(gee_map_iterator_next (_tmp6_) == TRUE)) {
			break;
		}
		_tmp7_ = folks_inspect_utils_individual_id_iter;
		_tmp8_ = gee_map_iterator_get_key (_tmp7_);
		id = (gchar*) _tmp8_;
		_tmp9_ = id;
		if (g_str_has_prefix (_tmp9_, word)) {
			result = id;
			return result;
		}
		_g_free0 (id);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}

gchar*
folks_inspect_utils_persona_uid_completion_cb (const gchar* word,
                                               gint state)
{
	gchar* result;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksInspectClient* _tmp0_;
		FolksIndividualAggregator* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		GeeMap* _tmp3_;
		GeeMap* _tmp4_;
		GeeMapIterator* _tmp5_;
		_tmp0_ = main_client;
		_tmp1_ = folks_inspect_client_get_aggregator (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = folks_individual_aggregator_get_individuals (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_map_map_iterator (_tmp4_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp5_;
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		GeeIterator* _tmp7_;
		FolksIndividual* individual = NULL;
		GeeMapIterator* _tmp9_;
		gpointer _tmp10_;
		GeeIterator* _tmp11_;
		_tmp7_ = folks_inspect_utils_persona_uid_iter;
		if (_tmp7_ != NULL) {
			_tmp6_ = TRUE;
		} else {
			GeeMapIterator* _tmp8_;
			_tmp8_ = folks_inspect_utils_individual_id_iter;
			_tmp6_ = gee_map_iterator_next (_tmp8_) == TRUE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp9_ = folks_inspect_utils_individual_id_iter;
		_tmp10_ = gee_map_iterator_get_value (_tmp9_);
		individual = (FolksIndividual*) _tmp10_;
		_tmp11_ = folks_inspect_utils_persona_uid_iter;
		if (_tmp11_ == NULL) {
			FolksIndividual* _tmp12_;
			FolksIndividual* _tmp13_;
			GeeSet* _tmp14_;
			GeeSet* _tmp15_;
			GeeIterator* _tmp16_;
			_tmp12_ = individual;
			_vala_assert (_tmp12_ != NULL, "individual != null");
			_tmp13_ = individual;
			_tmp14_ = folks_individual_get_personas (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
			_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
			folks_inspect_utils_persona_uid_iter = _tmp16_;
		}
		while (TRUE) {
			GeeIterator* _tmp17_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp18_;
			gpointer _tmp19_;
			FolksPersona* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_tmp17_ = folks_inspect_utils_persona_uid_iter;
			if (!gee_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = folks_inspect_utils_persona_uid_iter;
			_tmp19_ = gee_iterator_get (_tmp18_);
			persona = (FolksPersona*) _tmp19_;
			_tmp20_ = persona;
			_tmp21_ = folks_persona_get_uid (_tmp20_);
			_tmp22_ = _tmp21_;
			if (g_str_has_prefix (_tmp22_, word)) {
				FolksPersona* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp23_ = persona;
				_tmp24_ = folks_persona_get_uid (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strdup (_tmp25_);
				result = _tmp26_;
				_g_object_unref0 (persona);
				_g_object_unref0 (individual);
				return result;
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
		_g_object_unref0 (individual);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}

gchar*
folks_inspect_utils_backend_name_completion_cb (const gchar* word,
                                                gint state)
{
	gchar* result;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksInspectClient* _tmp0_;
		FolksBackendStore* _tmp1_;
		FolksBackendStore* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = main_client;
		_tmp1_ = folks_inspect_client_get_backend_store (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = folks_backend_store_list_backends (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp5_;
		_g_object_unref0 (_tmp4_);
	}
	while (TRUE) {
		GeeIterator* _tmp6_;
		FolksBackend* backend = NULL;
		GeeIterator* _tmp7_;
		gpointer _tmp8_;
		FolksBackend* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp6_ = folks_inspect_utils_backend_name_iter;
		if (!(gee_iterator_next (_tmp6_) == TRUE)) {
			break;
		}
		_tmp7_ = folks_inspect_utils_backend_name_iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		backend = (FolksBackend*) _tmp8_;
		_tmp9_ = backend;
		_tmp10_ = folks_backend_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		if (g_str_has_prefix (_tmp11_, word)) {
			FolksBackend* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = backend;
			_tmp13_ = folks_backend_get_name (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup (_tmp14_);
			result = _tmp15_;
			_g_object_unref0 (backend);
			return result;
		}
		_g_object_unref0 (backend);
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}

gchar*
folks_inspect_utils_persona_store_id_completion_cb (const gchar* word,
                                                    gint state)
{
	gchar* result;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksInspectClient* _tmp0_;
		FolksBackendStore* _tmp1_;
		FolksBackendStore* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = main_client;
		_tmp1_ = folks_inspect_client_get_backend_store (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = folks_backend_store_list_backends (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		GeeMapIterator* _tmp7_;
		GeeMapIterator* _tmp9_;
		_tmp7_ = folks_inspect_utils_persona_store_id_iter;
		if (_tmp7_ != NULL) {
			_tmp6_ = TRUE;
		} else {
			GeeIterator* _tmp8_;
			_tmp8_ = folks_inspect_utils_backend_name_iter;
			_tmp6_ = gee_iterator_next (_tmp8_) == TRUE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp9_ = folks_inspect_utils_persona_store_id_iter;
		if (_tmp9_ == NULL) {
			FolksBackend* backend = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			FolksBackend* _tmp12_;
			GeeMap* _tmp13_;
			GeeMap* _tmp14_;
			GeeMapIterator* _tmp15_;
			_tmp10_ = folks_inspect_utils_backend_name_iter;
			_tmp11_ = gee_iterator_get (_tmp10_);
			backend = (FolksBackend*) _tmp11_;
			_tmp12_ = backend;
			_tmp13_ = folks_backend_get_persona_stores (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_map_map_iterator (_tmp14_);
			_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
			folks_inspect_utils_persona_store_id_iter = _tmp15_;
			_g_object_unref0 (backend);
		}
		while (TRUE) {
			GeeMapIterator* _tmp16_;
			gchar* id = NULL;
			GeeMapIterator* _tmp17_;
			gpointer _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = folks_inspect_utils_persona_store_id_iter;
			if (!(gee_map_iterator_next (_tmp16_) == TRUE)) {
				break;
			}
			_tmp17_ = folks_inspect_utils_persona_store_id_iter;
			_tmp18_ = gee_map_iterator_get_key (_tmp17_);
			id = (gchar*) _tmp18_;
			_tmp19_ = id;
			if (g_str_has_prefix (_tmp19_, word)) {
				result = id;
				return result;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
folks_inspect_utils_validate_subcommand (const gchar* command,
                                         const gchar* command_string,
                                         const gchar* subcommand,
                                         gchar** valid_subcommands,
                                         gint valid_subcommands_length1)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean result;
	g_return_val_if_fail (command != NULL, FALSE);
	if (subcommand != NULL) {
		_tmp0_ = _vala_string_array_contains (valid_subcommands, valid_subcommands_length1, subcommand);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (command_string != NULL) {
		_tmp1_ = command_string;
	} else {
		_tmp1_ = "";
	}
	folks_inspect_utils_print_line ("Unrecognised '%s' command '%s'.", command, _tmp1_);
	folks_inspect_utils_print_line ("Valid commands:");
	folks_inspect_utils_indent ();
	{
		gchar** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = valid_subcommands;
		c_collection_length1 = valid_subcommands_length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			gchar* _tmp2_;
			gchar* c = NULL;
			_tmp2_ = g_strdup (c_collection[c_it]);
			c = _tmp2_;
			{
				const gchar* _tmp3_;
				_tmp3_ = c;
				folks_inspect_utils_print_line ("%s", _tmp3_);
				_g_free0 (c);
			}
		}
	}
	folks_inspect_utils_unindent ();
	result = FALSE;
	return result;
}

FolksInspectUtils*
folks_inspect_utils_construct (GType object_type)
{
	FolksInspectUtils* self = NULL;
	self = (FolksInspectUtils*) g_type_create_instance (object_type);
	return self;
}

FolksInspectUtils*
folks_inspect_utils_new (void)
{
	return folks_inspect_utils_construct (FOLKS_INSPECT_TYPE_UTILS);
}

static void
folks_inspect_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
folks_inspect_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		folks_inspect_utils_unref (value->data[0].v_pointer);
	}
}

static void
folks_inspect_value_utils_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = folks_inspect_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
folks_inspect_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
folks_inspect_value_utils_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FolksInspectUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = folks_inspect_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
folks_inspect_value_utils_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	FolksInspectUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = folks_inspect_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
folks_inspect_param_spec_utils (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	FolksInspectParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOLKS_INSPECT_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
folks_inspect_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
folks_inspect_value_set_utils (GValue* value,
                               gpointer v_object)
{
	FolksInspectUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		folks_inspect_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}

void
folks_inspect_value_take_utils (GValue* value,
                                gpointer v_object)
{
	FolksInspectUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}

static void
folks_inspect_utils_class_init (FolksInspectUtilsClass * klass,
                                gpointer klass_data)
{
	gchar* _tmp0_;
	FILE* _tmp1_;
	folks_inspect_utils_parent_class = g_type_class_peek_parent (klass);
	((FolksInspectUtilsClass *) klass)->finalize = folks_inspect_utils_finalize;
	_tmp0_ = g_strdup ("");
	folks_inspect_utils_indentation_string = _tmp0_;
	_tmp1_ = stdout;
	folks_inspect_utils_output_filestream = _tmp1_;
}

static void
folks_inspect_utils_instance_init (FolksInspectUtils * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
folks_inspect_utils_finalize (FolksInspectUtils * obj)
{
	FolksInspectUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtils);
	g_signal_handlers_destroy (self);
}

static GType
folks_inspect_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { folks_inspect_value_utils_init, folks_inspect_value_utils_free_value, folks_inspect_value_utils_copy_value, folks_inspect_value_utils_peek_pointer, "p", folks_inspect_value_utils_collect_value, "p", folks_inspect_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FolksInspectUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectUtils), 0, (GInstanceInitFunc) folks_inspect_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType folks_inspect_utils_type_id;
	folks_inspect_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FolksInspectUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return folks_inspect_utils_type_id;
}

GType
folks_inspect_utils_get_type (void)
{
	static volatile gsize folks_inspect_utils_type_id__once = 0;
	if (g_once_init_enter (&folks_inspect_utils_type_id__once)) {
		GType folks_inspect_utils_type_id;
		folks_inspect_utils_type_id = folks_inspect_utils_get_type_once ();
		g_once_init_leave (&folks_inspect_utils_type_id__once, folks_inspect_utils_type_id);
	}
	return folks_inspect_utils_type_id__once;
}

gpointer
folks_inspect_utils_ref (gpointer instance)
{
	FolksInspectUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
folks_inspect_utils_unref (gpointer instance)
{
	FolksInspectUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOLKS_INSPECT_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

