/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class NetDetailsProvider
extends DetailsProvider.Basic {
    private static final String URL_MASK = "java.net.URL";
    private static final String INET4_ADDRESS_MASK = "java.net.Inet4Address";
    private static final String INET6_ADDRESS_MASK = "java.net.Inet6Address";
    private static final String NETWORK_IF_MASK = "java.net.NetworkInterface";
    private static final String IF_ADDRESS_MASK = "java.net.InterfaceAddress+";
    private static final String URL_CONN_MASK = "java.net.URLConnection+";
    private static final String URI_MASK = "java.net.URI";
    private static final String HTTP_COOKIE_MASK = "java.net.HttpCookie";
    private static final String INET_SOCKET_ADDRERSS_MASK = "java.net.InetSocketAddress+";
    private static final String INET_SOCKET_ADDR_HOLDER_MASK = "java.net.InetSocketAddress$InetSocketAddressHolder";

    public NetDetailsProvider() {
        super(URL_MASK, INET4_ADDRESS_MASK, INET6_ADDRESS_MASK, NETWORK_IF_MASK, IF_ADDRESS_MASK, URL_CONN_MASK, URI_MASK, HTTP_COOKIE_MASK, INET_SOCKET_ADDRERSS_MASK, INET_SOCKET_ADDR_HOLDER_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "java.net.URL": {
                String file = DetailsUtils.getInstanceFieldString(instance, "file");
                String host = DetailsUtils.getInstanceFieldString(instance, "host");
                String protocol = DetailsUtils.getInstanceFieldString(instance, "protocol");
                int port = DetailsUtils.getIntFieldValue(instance, "port", -1);
                if (file != null && protocol != null) {
                    try {
                        return new URL(protocol, host, port, file).toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return DetailsUtils.getInstanceFieldString(instance, "path");
            }
            case "java.net.Inet4Address": 
            case "java.net.Inet6Address": {
                String host;
                Instance holder = (Instance)instance.getValueOfField("holder");
                if (holder != null) {
                    host = DetailsUtils.getInstanceFieldString(holder, "hostName");
                    instance = INET4_ADDRESS_MASK.equals(className) ? holder : (Instance)instance.getValueOfField("holder6");
                } else {
                    host = DetailsUtils.getInstanceFieldString(instance, "hostName");
                }
                String addr = null;
                if (!"0.0.0.0".equals(host)) {
                    if (INET4_ADDRESS_MASK.equals(className)) {
                        int address = DetailsUtils.getIntFieldValue(instance, "address", 0);
                        addr = NetDetailsProvider.getHostInet4Address(address);
                    } else {
                        Object ifname;
                        List<String> items = DetailsUtils.getPrimitiveArrayFieldValues(instance, "ipaddress");
                        byte[] ipaddress = DetailsUtils.getByteArray(items);
                        boolean scope_ifname_set = DetailsUtils.getBooleanFieldValue(instance, "scope_ifname_set", false);
                        String scope_ifname = null;
                        if (scope_ifname_set && (ifname = instance.getValueOfField("scope_ifname")) instanceof Instance) {
                            scope_ifname = DetailsUtils.getInstanceFieldString(instance, "name");
                        }
                        boolean scope_id_set = DetailsUtils.getBooleanFieldValue(instance, "scope_id_set", false);
                        int scope_id = DetailsUtils.getIntFieldValue(instance, "scope_id", 0);
                        addr = this.getHostInet6Address(ipaddress, scope_ifname_set, scope_ifname, scope_id_set, scope_id);
                    }
                }
                if (host == null) {
                    return addr;
                }
                if (addr == null) {
                    return host;
                }
                return host + " [" + addr + "]";
            }
            case "java.net.NetworkInterface": {
                String displayName;
                String name = DetailsUtils.getInstanceFieldString(instance, "name");
                if (name == null) {
                    name = new String();
                }
                if ((displayName = DetailsUtils.getInstanceFieldString(instance, "displayName")) == null) {
                    displayName = new String();
                }
                if (!name.isEmpty() && !displayName.isEmpty()) {
                    name = name + " - ";
                }
                return name + displayName;
            }
            case "java.net.InterfaceAddress+": {
                String broadcast;
                String address = DetailsUtils.getInstanceFieldString(instance, "address");
                if (address == null) {
                    address = "";
                }
                if ((broadcast = DetailsUtils.getInstanceFieldString(instance, "broadcast")) == null) {
                    broadcast = new String();
                }
                short maskLength = DetailsUtils.getShortFieldValue(instance, "maskLength", (short)0);
                return address + "/" + maskLength + " [" + broadcast + "]";
            }
            case "java.net.URLConnection+": {
                String url = DetailsUtils.getInstanceFieldString(instance, "url");
                if (url == null) {
                    url = "";
                }
                return url;
            }
            case "java.net.URI": {
                String name = DetailsUtils.getInstanceFieldString(instance, "string");
                if (name != null) {
                    return name;
                }
                String scheme = DetailsUtils.getInstanceFieldString(instance, "scheme");
                String path = DetailsUtils.getInstanceFieldString(instance, "path");
                String schemeSpecificPart = DetailsUtils.getInstanceFieldString(instance, "schemeSpecificPart");
                String host = DetailsUtils.getInstanceFieldString(instance, "host");
                String userInfo = DetailsUtils.getInstanceFieldString(instance, "userInfo");
                int port = DetailsUtils.getIntFieldValue(instance, "name", -1);
                String authority = DetailsUtils.getInstanceFieldString(instance, "authority");
                String query = DetailsUtils.getInstanceFieldString(instance, "query");
                String fragment = DetailsUtils.getInstanceFieldString(instance, "fragment");
                return this.defineURIString(scheme, path, schemeSpecificPart, host, userInfo, port, authority, query, fragment);
            }
            case "java.net.HttpCookie": {
                String name = DetailsUtils.getInstanceFieldString(instance, "name");
                String value = DetailsUtils.getInstanceFieldString(instance, "value");
                return name + "=" + value;
            }
            case "java.net.InetSocketAddress+": {
                String holder = DetailsUtils.getInstanceFieldString(instance, "holder");
                if (holder != null) {
                    return holder;
                }
                return this.getInetSocketAddress(instance);
            }
            case "java.net.InetSocketAddress$InetSocketAddressHolder": {
                return this.getInetSocketAddress(instance);
            }
        }
        return null;
    }

    private String getInetSocketAddress(Instance instance) {
        String host = DetailsUtils.getInstanceFieldString(instance, "hostname");
        String address = DetailsUtils.getInstanceFieldString(instance, "addr");
        int port = DetailsUtils.getIntFieldValue(instance, "port", -1);
        StringBuilder str = new StringBuilder();
        if (host != null) {
            str.append(host);
        }
        if (address != null) {
            if (host != null) {
                str.append("[").append(address).append("]");
            } else {
                str.append(address);
            }
        }
        str.append(":").append(port);
        return str.toString();
    }

    private static String getHostInet4Address(int address) {
        return NetDetailsProvider.numericToTextFormatInet4(NetDetailsProvider.getInet4Address(address));
    }

    private static byte[] getInet4Address(int address) {
        byte[] addr = new byte[]{(byte)(address >>> 24 & 0xFF), (byte)(address >>> 16 & 0xFF), (byte)(address >>> 8 & 0xFF), (byte)(address & 0xFF)};
        return addr;
    }

    private static String numericToTextFormatInet4(byte[] src) {
        return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
    }

    public String getHostInet6Address(byte[] ipaddress, boolean scope_ifname_set, String scope_ifname, boolean scope_id_set, int scope_id) {
        String s = NetDetailsProvider.numericToTextFormatInet6(ipaddress);
        if (scope_ifname_set) {
            s = s + "%" + scope_ifname;
        } else if (scope_id_set) {
            s = s + "%" + scope_id;
        }
        return s;
    }

    private static String numericToTextFormatInet6(byte[] src) {
        StringBuilder sb = new StringBuilder(39);
        for (int i = 0; i < 8; ++i) {
            sb.append(Integer.toHexString(src[i << 1] << 8 & 0xFF00 | src[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    private String defineURIString(String scheme, String path, String schemeSpecificPart, String host, String userInfo, int port, String authority, String query, String fragment) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        if (path == null) {
            sb.append(schemeSpecificPart);
        } else {
            if (host != null) {
                boolean needBrackets;
                sb.append("//");
                if (userInfo != null) {
                    sb.append(userInfo);
                    sb.append('@');
                }
                boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
                if (needBrackets) {
                    sb.append('[');
                }
                sb.append(host);
                if (needBrackets) {
                    sb.append(']');
                }
                if (port != -1) {
                    sb.append(':');
                    sb.append(port);
                }
            } else if (authority != null) {
                sb.append("//");
                sb.append(authority);
            }
            if (path != null) {
                sb.append(path);
            }
            if (query != null) {
                sb.append('?');
                sb.append(query);
            }
        }
        if (fragment != null) {
            sb.append('#');
            sb.append(fragment);
        }
        return sb.toString();
    }
}

