// Generated by gmmproc 2.74.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <glibmm/datetime.h>
#include <glibmm/private/datetime_p.h>


/* Copyright (C) 2011 The glibmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/utility.h>
#include <glibmm/wrap.h>

namespace Glib
{

DateTime::operator bool() const
{
  return (gobject_ != nullptr);
}

} // namespace Glib

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::DateTime wrap(GDateTime* object, bool take_copy)
{
  return Glib::DateTime(object, take_copy);
}

} // namespace Glib


namespace Glib
{


// static
GType DateTime::get_type()
{
  return g_date_time_get_type();
}

DateTime::DateTime()
:
  gobject_ (nullptr) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

DateTime::DateTime(const DateTime& other)
:
  gobject_ ((other.gobject_) ? g_date_time_ref(other.gobject_) : nullptr)
{}

DateTime::DateTime(DateTime&& other) noexcept
:
  gobject_(other.gobject_)
{
  other.gobject_ = nullptr;
}

DateTime& DateTime::operator=(DateTime&& other) noexcept
{
  DateTime temp (std::move(other));
  swap(temp);
  return *this;
}

DateTime::DateTime(GDateTime* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? g_date_time_ref(gobject) : gobject)
{}

DateTime& DateTime::operator=(const DateTime& other)
{
  DateTime temp (other);
  swap(temp);
  return *this;
}

DateTime::~DateTime() noexcept
{
  if(gobject_)
    g_date_time_unref(gobject_);
}

void DateTime::swap(DateTime& other) noexcept
{
  std::swap(gobject_, other.gobject_);
}

GDateTime* DateTime::gobj_copy() const
{
  return g_date_time_ref(gobject_);
}


DateTime DateTime::create_now(const TimeZone& tz)
{
  return Glib::wrap(g_date_time_new_now(const_cast<GTimeZone*>(tz.gobj())));
}

DateTime DateTime::create_now_local()
{
  return Glib::wrap(g_date_time_new_now_local());
}

DateTime DateTime::create_now_utc()
{
  return Glib::wrap(g_date_time_new_now_utc());
}

DateTime DateTime::create_now_local(gint64 t)
{
  return Glib::wrap(g_date_time_new_from_unix_local(t));
}

DateTime DateTime::create_now_utc(gint64 t)
{
  return Glib::wrap(g_date_time_new_from_unix_utc(t));
}

DateTime DateTime::create_from_iso8601(const Glib::ustring& text, const TimeZone& default_tz)
{
  return Glib::wrap(g_date_time_new_from_iso8601(text.c_str(), const_cast<GTimeZone*>(default_tz.gobj())));
}

DateTime DateTime::create_from_iso8601(const Glib::ustring& text)
{
  return Glib::wrap(g_date_time_new_from_iso8601(text.c_str(), nullptr));
}

DateTime DateTime::create(const TimeZone& tz, int year, int month, int day, int hour, int minute, double seconds)
{
  return Glib::wrap(g_date_time_new(const_cast<GTimeZone*>(tz.gobj()), year, month, day, hour, minute, seconds));
}

DateTime DateTime::create_local(int year, int month, int day, int hour, int minute, double seconds)
{
  return Glib::wrap(g_date_time_new_local(year, month, day, hour, minute, seconds));
}

DateTime DateTime::create_utc(int year, int month, int day, int hour, int minute, double seconds)
{
  return Glib::wrap(g_date_time_new_utc(year, month, day, hour, minute, seconds));
}

DateTime DateTime::add(TimeSpan timespan) const
{
  return Glib::wrap(g_date_time_add(const_cast<GDateTime*>(gobj()), timespan));
}

DateTime DateTime::add_years(int years) const
{
  return Glib::wrap(g_date_time_add_years(const_cast<GDateTime*>(gobj()), years));
}

DateTime DateTime::add_months(int months) const
{
  return Glib::wrap(g_date_time_add_months(const_cast<GDateTime*>(gobj()), months));
}

DateTime DateTime::add_weeks(int weeks) const
{
  return Glib::wrap(g_date_time_add_weeks(const_cast<GDateTime*>(gobj()), weeks));
}

DateTime DateTime::add_days(int days) const
{
  return Glib::wrap(g_date_time_add_days(const_cast<GDateTime*>(gobj()), days));
}

DateTime DateTime::add_hours(int hours) const
{
  return Glib::wrap(g_date_time_add_hours(const_cast<GDateTime*>(gobj()), hours));
}

DateTime DateTime::add_minutes(int minutes) const
{
  return Glib::wrap(g_date_time_add_minutes(const_cast<GDateTime*>(gobj()), minutes));
}

DateTime DateTime::add_seconds(double seconds) const
{
  return Glib::wrap(g_date_time_add_seconds(const_cast<GDateTime*>(gobj()), seconds));
}

DateTime DateTime::add_full(int years, int months, int days, int hours, int minutes, double seconds) const
{
  return Glib::wrap(g_date_time_add_full(const_cast<GDateTime*>(gobj()), years, months, days, hours, minutes, seconds));
}

TimeSpan DateTime::difference(const DateTime& other) const
{
  return g_date_time_difference(const_cast<GDateTime*>(gobj()), const_cast<GDateTime*>(other.gobj()));
}

int DateTime::compare(const DateTime& other) const
{
  return g_date_time_compare(const_cast<GDateTime*>(gobj()), static_cast<gconstpointer>(other.gobj()));
}

guint DateTime::hash() const
{
  return g_date_time_hash(const_cast<GDateTime*>(gobj()));
}

bool DateTime::equal(const DateTime& other) const
{
  return g_date_time_equal(const_cast<GDateTime*>(gobj()), static_cast<gconstpointer>(other.gobj()));
}

void DateTime::get_ymd(int& year, int& month, int& day) const
{
  g_date_time_get_ymd(const_cast<GDateTime*>(gobj()), &(year), &(month), &(day));
}

int DateTime::get_year() const
{
  return g_date_time_get_year(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_month() const
{
  return g_date_time_get_month(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_day_of_month() const
{
  return g_date_time_get_day_of_month(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_week_numbering_year() const
{
  return g_date_time_get_week_numbering_year(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_week_of_year() const
{
  return g_date_time_get_week_of_year(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_day_of_week() const
{
  return g_date_time_get_day_of_week(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_day_of_year() const
{
  return g_date_time_get_day_of_year(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_hour() const
{
  return g_date_time_get_hour(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_minute() const
{
  return g_date_time_get_minute(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_second() const
{
  return g_date_time_get_second(const_cast<GDateTime*>(gobj()));
}

int DateTime::get_microsecond() const
{
  return g_date_time_get_microsecond(const_cast<GDateTime*>(gobj()));
}

double DateTime::get_seconds() const
{
  return g_date_time_get_seconds(const_cast<GDateTime*>(gobj()));
}

gint64 DateTime::to_unix() const
{
  return g_date_time_to_unix(const_cast<GDateTime*>(gobj()));
}

TimeSpan DateTime::get_utc_offset() const
{
  return g_date_time_get_utc_offset(const_cast<GDateTime*>(gobj()));
}

TimeZone DateTime::get_timezone() const
{
  return Glib::wrap(g_date_time_get_timezone(const_cast<GDateTime*>(gobj())), true);
}

Glib::ustring DateTime::get_timezone_abbreviation() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(g_date_time_get_timezone_abbreviation(const_cast<GDateTime*>(gobj())));
}

bool DateTime::is_daylight_savings() const
{
  return g_date_time_is_daylight_savings(const_cast<GDateTime*>(gobj()));
}

DateTime DateTime::to_timezone(const TimeZone& tz) const
{
  return Glib::wrap(g_date_time_to_timezone(const_cast<GDateTime*>(gobj()), const_cast<GTimeZone*>(tz.gobj())));
}

DateTime DateTime::to_local() const
{
  return Glib::wrap(g_date_time_to_local(const_cast<GDateTime*>(gobj())));
}

DateTime DateTime::to_utc() const
{
  return Glib::wrap(g_date_time_to_utc(const_cast<GDateTime*>(gobj())));
}

Glib::ustring DateTime::format(const Glib::ustring& format_str) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(g_date_time_format(const_cast<GDateTime*>(gobj()), format_str.c_str()));
}

Glib::ustring DateTime::format_iso8601() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(g_date_time_format_iso8601(const_cast<GDateTime*>(gobj())));
}


} // namespace Glib


