/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FormLayoutHelper {
    public static final Column DEFAULT_COLUMN = new DefaultColumn();
    public static final Column EAGER_COLUMN = new EagerColumn();
    public static final Column EXPANDING_COLUMN = new ExpandingColumn();
    JPanel panel;
    GroupLayout layout;
    Column[] columns;
    GroupLayout.Group[] columnGroups;
    private GroupLayout.Group horizontalGroup;
    private GroupLayout.Group verticalGroup;

    public FormLayoutHelper(JPanel jPanel, Column ... columnArray) {
        this.panel = jPanel;
        this.layout = new GroupLayout(jPanel);
        jPanel.setLayout(this.layout);
        this.horizontalGroup = this.layout.createSequentialGroup();
        this.verticalGroup = this.layout.createSequentialGroup();
        this.columns = columnArray;
        this.columnGroups = new GroupLayout.Group[columnArray.length];
        for (int i = 0; i < columnArray.length; ++i) {
            GroupLayout.Group group;
            this.columnGroups[i] = group = columnArray[i].createParallelGroup(this.layout);
            this.horizontalGroup.addGroup(group);
        }
        this.layout.setHorizontalGroup(this.horizontalGroup);
        this.layout.setVerticalGroup(this.verticalGroup);
    }

    public void setAllGaps(boolean bl) {
        this.setInlineGaps(bl);
        this.setContainerGaps(bl);
    }

    public void setInlineGaps(boolean bl) {
        this.layout.setAutoCreateGaps(bl);
    }

    public void setContainerGaps(boolean bl) {
        this.layout.setAutoCreateContainerGaps(bl);
    }

    public GroupLayout getLayout() {
        return this.layout;
    }

    public void addRow(int n, int n2, int n3, JComponent ... jComponentArray) {
        GroupLayout.ParallelGroup parallelGroup = this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        for (int i = 0; i < jComponentArray.length && i < this.columns.length; ++i) {
            JComponent jComponent = jComponentArray[i];
            ((GroupLayout.Group)parallelGroup).addComponent(jComponent, n, n2, n3);
            this.columns[i].addComponent(jComponent, this.columnGroups[i]);
        }
        this.verticalGroup.addGroup(parallelGroup);
    }

    public void addRow(JComponent ... jComponentArray) {
        this.addRow(-1, -1, -1, jComponentArray);
    }

    private static class EagerColumn
    extends DefaultColumn {
        private EagerColumn() {
        }

        @Override
        protected void addComponent(JComponent jComponent, GroupLayout.Group group) {
            group.addComponent(jComponent, -1, -1, Short.MAX_VALUE);
        }
    }

    private static class ExpandingColumn
    extends Column {
        private ExpandingColumn() {
        }

        @Override
        protected void addComponent(JComponent jComponent, GroupLayout.Group group) {
            group.addComponent(jComponent, -1, -1, Short.MAX_VALUE);
        }

        @Override
        protected GroupLayout.Group createParallelGroup(GroupLayout groupLayout) {
            return groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false);
        }
    }

    private static class DefaultColumn
    extends Column {
        private DefaultColumn() {
        }

        @Override
        protected void addComponent(JComponent jComponent, GroupLayout.Group group) {
            group.addComponent(jComponent);
        }

        @Override
        protected GroupLayout.Group createParallelGroup(GroupLayout groupLayout) {
            return groupLayout.createParallelGroup();
        }
    }

    public static abstract class Column {
        protected abstract void addComponent(JComponent var1, GroupLayout.Group var2);

        protected abstract GroupLayout.Group createParallelGroup(GroupLayout var1);
    }
}

