/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-time-span.h"
#include "libical-glib-private.h"

G_DEFINE_TYPE (ICalTimeSpan, i_cal_time_span, I_CAL_TYPE_OBJECT)

static void i_cal_time_span_class_init (G_GNUC_UNUSED ICalTimeSpanClass *klass)
{
}

static void i_cal_time_span_init (G_GNUC_UNUSED ICalTimeSpan *self)
{
}

/**
 * i_cal_time_span_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalTimeSpan *
i_cal_time_span_new_full (struct icaltime_span native)
{
    ICalTimeSpan *object;
    struct icaltime_span *clone;
    
    
    clone = g_new (struct icaltime_span, 1);
    *clone = native;
    object = i_cal_object_construct (I_CAL_TYPE_TIME_SPAN,
                            (gpointer) clone,
                            (GDestroyNotify) g_free,
                            FALSE,
                            NULL);

    return object;
}


/**
 * i_cal_time_span_new_timet:
 * @start: Start of the time span
 * @end: End of the time span
 * @is_busy: Whether the time span is busy
 *
 * Creates a new #ICalTimeSpan. Free it with g_object_unref(), when no longer needed.
 *
 * Returns: (transfer full): The newly created #ICalTimeSpan.
 *
 * Since: 3.0.5
 *
 **/
ICalTimeSpan *
i_cal_time_span_new_timet (time_t start, 
                           time_t end, 
                           gboolean is_busy)
{
    struct icaltime_span span;
    span.start = start;
    span.end = end;
    span.is_busy = is_busy ? 1 : 0;
    return i_cal_time_span_new_full(span);
}

/**
 * i_cal_time_span_clone:
 * @src: A time span to clone
 *
 * Creates a new #ICalTimeSpan, clone of @src. Free it with g_object_unref(), when no longer needed.
 *
 * Returns: (transfer full): The newly created #ICalTimeSpan, clone of @src.
 *
 * Since: 3.0.5
 *
 **/
ICalTimeSpan *
i_cal_time_span_clone (const ICalTimeSpan *src)
{
    struct icaltime_span *span;
    g_return_val_if_fail(I_CAL_IS_TIME_SPAN(src), NULL);
    span = ((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)src));
    g_return_val_if_fail (span != NULL, NULL);
    return i_cal_time_span_new_full(*span);
}

/**
 * i_cal_time_span_get_start:
 * @timespan: The #ICalTimeSpan to be queried
 *
 * Gets the start of #ICalTimeSpan.
 *
 * Returns: The start.
 *
 * Since: 1.0
 *
 **/
time_t
i_cal_time_span_get_start (ICalTimeSpan *timespan)
{
	g_return_val_if_fail (timespan != NULL, 0);
	return ((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->start;
}

/**
 * i_cal_time_span_set_start:
 * @timespan: The #ICalTimeSpan to be set
 * @start: The start
 *
 * Sets the start of #ICalTimeSpan.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_span_set_start (ICalTimeSpan *timespan, 
                           time_t start)
{
	g_return_if_fail (timespan != NULL);
	((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->start = start;
}

/**
 * i_cal_time_span_get_end:
 * @timespan: The #ICalTimeSpan to be queried
 *
 * Gets the end of #ICalTimeSpan.
 *
 * Returns: The end.
 *
 * Since: 1.0
 *
 **/
time_t
i_cal_time_span_get_end (ICalTimeSpan *timespan)
{
	g_return_val_if_fail (timespan != NULL, 0);
	return ((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->end;
}

/**
 * i_cal_time_span_set_end:
 * @timespan: The #ICalTimeSpan to be set
 * @end: The end
 *
 * Sets the end of #ICalTimeSpan.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_span_set_end (ICalTimeSpan *timespan, 
                         time_t end)
{
	g_return_if_fail (timespan != NULL);
	((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->end = end;
}

/**
 * i_cal_time_span_get_is_busy:
 * @timespan: The #ICalTimeSpan to be queried
 *
 * Gets the is_busy of #ICalTimeSpan.
 *
 * Returns: The is_busy.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_time_span_get_is_busy (ICalTimeSpan *timespan)
{
	g_return_val_if_fail (timespan != NULL, FALSE);
	return ((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->is_busy != 0;
}

/**
 * i_cal_time_span_set_is_busy:
 * @timespan: The #ICalTimeSpan to be set
 * @is_busy: The is_busy
 *
 * Sets the is_busy of #ICalTimeSpan.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_span_set_is_busy (ICalTimeSpan *timespan, 
                             gboolean is_busy)
{
	g_return_if_fail (timespan != NULL);
	((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->is_busy = is_busy ? 1 : 0;
}
