// content/common/frame_proxy.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/frame_proxy.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/frame_proxy.mojom-params-data.h"
#include "content/common/frame_proxy.mojom-shared-message-ids.h"

#include "content/common/frame_proxy.mojom-import-headers.h"


#ifndef CONTENT_COMMON_FRAME_PROXY_MOJOM_JUMBO_H_
#define CONTENT_COMMON_FRAME_PROXY_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#include "content/common/input_messages.h"
#include "content/common/resource_messages.h"
#include "content/common/view_messages.h"
#include "content/common/widget_messages.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#endif
namespace content {
namespace mojom {
const char RenderFrameProxyHost::Name_[] = "content.mojom.RenderFrameProxyHost";

RenderFrameProxyHostProxy::RenderFrameProxyHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderFrameProxyHostProxy::OpenURL(
    ::content::mojom::OpenURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderFrameProxyHost::OpenURL", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameProxyHost_OpenURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::RenderFrameProxyHost_OpenURL_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::OpenURLParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in RenderFrameProxyHost.OpenURL request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameProxyHost::Name_);
  message.set_method_name("OpenURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RenderFrameProxyHostStubDispatch::Accept(
    RenderFrameProxyHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kRenderFrameProxyHost_OpenURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderFrameProxyHost::OpenURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderFrameProxyHost::OpenURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameProxyHost_OpenURL_Params_Data* params =
          reinterpret_cast<internal::RenderFrameProxyHost_OpenURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::mojom::OpenURLParamsPtr p_params{};
      RenderFrameProxyHost_OpenURL_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameProxyHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenURL(
std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool RenderFrameProxyHostStubDispatch::AcceptWithResponder(
    RenderFrameProxyHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderFrameProxyHost_OpenURL_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderFrameProxyHostValidationInfo[] = {
    {internal::kRenderFrameProxyHost_OpenURL_Name,
     {&internal::RenderFrameProxyHost_OpenURL_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderFrameProxyHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderFrameProxyHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderFrameProxyHostValidationInfo);
}

const char RenderFrameProxy::Name_[] = "content.mojom.RenderFrameProxy";

RenderFrameProxyProxy::RenderFrameProxyProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderFrameProxyProxy::ChildProcessGone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::RenderFrameProxy::ChildProcessGone");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameProxy_ChildProcessGone_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::RenderFrameProxy_ChildProcessGone_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameProxy::Name_);
  message.set_method_name("ChildProcessGone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RenderFrameProxyProxy::EnableAutoResize(
    const ::gfx::Size& in_min_size, const ::gfx::Size& in_max_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderFrameProxy::EnableAutoResize", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("min_size", base::trace_event::ValueToString(in_min_size, "<value of type const ::gfx::Size&>"));
      raw_value->SetString("max_size", base::trace_event::ValueToString(in_max_size, "<value of type const ::gfx::Size&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameProxy_EnableAutoResize_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::RenderFrameProxy_EnableAutoResize_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->min_size)::BaseType::BufferWriter
      min_size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_min_size, buffer, &min_size_writer, &serialization_context);
  params->min_size.Set(
      min_size_writer.is_null() ? nullptr : min_size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->min_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_size in RenderFrameProxy.EnableAutoResize request");
  typename decltype(params->max_size)::BaseType::BufferWriter
      max_size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_max_size, buffer, &max_size_writer, &serialization_context);
  params->max_size.Set(
      max_size_writer.is_null() ? nullptr : max_size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->max_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_size in RenderFrameProxy.EnableAutoResize request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameProxy::Name_);
  message.set_method_name("EnableAutoResize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RenderFrameProxyProxy::DisableAutoResize(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::RenderFrameProxy::DisableAutoResize");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameProxy_DisableAutoResize_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::RenderFrameProxy_DisableAutoResize_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameProxy::Name_);
  message.set_method_name("DisableAutoResize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RenderFrameProxyProxy::DidUpdateVisualProperties(
    const ::cc::RenderFrameMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderFrameProxy::DidUpdateVisualProperties", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("metadata", base::trace_event::ValueToString(in_metadata, "<value of type const ::cc::RenderFrameMetadata&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameProxy_DidUpdateVisualProperties_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::RenderFrameProxy_DidUpdateVisualProperties_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->metadata)::BaseType::BufferWriter
      metadata_writer;
  mojo::internal::Serialize<::cc::mojom::RenderFrameMetadataDataView>(
      in_metadata, buffer, &metadata_writer, &serialization_context);
  params->metadata.Set(
      metadata_writer.is_null() ? nullptr : metadata_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in RenderFrameProxy.DidUpdateVisualProperties request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameProxy::Name_);
  message.set_method_name("DidUpdateVisualProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RenderFrameProxyProxy::SetFrameSinkId(
    const ::viz::FrameSinkId& in_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderFrameProxy::SetFrameSinkId", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(in_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameProxy_SetFrameSinkId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::RenderFrameProxy_SetFrameSinkId_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in RenderFrameProxy.SetFrameSinkId request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameProxy::Name_);
  message.set_method_name("SetFrameSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RenderFrameProxyStubDispatch::Accept(
    RenderFrameProxy* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kRenderFrameProxy_ChildProcessGone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderFrameProxy::ChildProcessGone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderFrameProxy::ChildProcessGone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameProxy_ChildProcessGone_Params_Data* params =
          reinterpret_cast<internal::RenderFrameProxy_ChildProcessGone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RenderFrameProxy_ChildProcessGone_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameProxy::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChildProcessGone();
      return true;
    }
    case internal::kRenderFrameProxy_EnableAutoResize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderFrameProxy::EnableAutoResize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderFrameProxy::EnableAutoResize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameProxy_EnableAutoResize_Params_Data* params =
          reinterpret_cast<internal::RenderFrameProxy_EnableAutoResize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_min_size{};
      ::gfx::Size p_max_size{};
      RenderFrameProxy_EnableAutoResize_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMinSize(&p_min_size))
        success = false;
      if (success && !input_data_view.ReadMaxSize(&p_max_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameProxy::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAutoResize(
std::move(p_min_size), 
std::move(p_max_size));
      return true;
    }
    case internal::kRenderFrameProxy_DisableAutoResize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderFrameProxy::DisableAutoResize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderFrameProxy::DisableAutoResize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameProxy_DisableAutoResize_Params_Data* params =
          reinterpret_cast<internal::RenderFrameProxy_DisableAutoResize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RenderFrameProxy_DisableAutoResize_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameProxy::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableAutoResize();
      return true;
    }
    case internal::kRenderFrameProxy_DidUpdateVisualProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderFrameProxy::DidUpdateVisualProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderFrameProxy::DidUpdateVisualProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameProxy_DidUpdateVisualProperties_Params_Data* params =
          reinterpret_cast<internal::RenderFrameProxy_DidUpdateVisualProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::cc::RenderFrameMetadata p_metadata{};
      RenderFrameProxy_DidUpdateVisualProperties_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameProxy::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateVisualProperties(
std::move(p_metadata));
      return true;
    }
    case internal::kRenderFrameProxy_SetFrameSinkId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderFrameProxy::SetFrameSinkId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderFrameProxy::SetFrameSinkId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameProxy_SetFrameSinkId_Params_Data* params =
          reinterpret_cast<internal::RenderFrameProxy_SetFrameSinkId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      RenderFrameProxy_SetFrameSinkId_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameProxy::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameSinkId(
std::move(p_frame_sink_id));
      return true;
    }
  }
  return false;
}

// static
bool RenderFrameProxyStubDispatch::AcceptWithResponder(
    RenderFrameProxy* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderFrameProxy_ChildProcessGone_Name: {
      break;
    }
    case internal::kRenderFrameProxy_EnableAutoResize_Name: {
      break;
    }
    case internal::kRenderFrameProxy_DisableAutoResize_Name: {
      break;
    }
    case internal::kRenderFrameProxy_DidUpdateVisualProperties_Name: {
      break;
    }
    case internal::kRenderFrameProxy_SetFrameSinkId_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderFrameProxyValidationInfo[] = {
    {internal::kRenderFrameProxy_ChildProcessGone_Name,
     {&internal::RenderFrameProxy_ChildProcessGone_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderFrameProxy_EnableAutoResize_Name,
     {&internal::RenderFrameProxy_EnableAutoResize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderFrameProxy_DisableAutoResize_Name,
     {&internal::RenderFrameProxy_DisableAutoResize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderFrameProxy_DidUpdateVisualProperties_Name,
     {&internal::RenderFrameProxy_DidUpdateVisualProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderFrameProxy_SetFrameSinkId_Name,
     {&internal::RenderFrameProxy_SetFrameSinkId_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderFrameProxyRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderFrameProxy::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderFrameProxyValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif