// services/device/public/mojom/geoposition.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/geoposition.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/geoposition.mojom-params-data.h"
#include "services/device/public/mojom/geoposition.mojom-shared-message-ids.h"

#include "services/device/public/mojom/geoposition.mojom-import-headers.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
Geoposition::Geoposition()
    : valid(),
      latitude(kBadLatitudeLongitude),
      longitude(kBadLatitudeLongitude),
      altitude(kBadAltitude),
      accuracy(kBadAccuracy),
      altitude_accuracy(kBadAccuracy),
      heading(kBadHeading),
      speed(kBadSpeed),
      timestamp(),
      error_code(Geoposition_ErrorCode::NONE),
      error_message() {}

Geoposition::Geoposition(
    bool valid_in,
    double latitude_in,
    double longitude_in,
    double altitude_in,
    double accuracy_in,
    double altitude_accuracy_in,
    double heading_in,
    double speed_in,
    ::base::Time timestamp_in,
    Geoposition::ErrorCode error_code_in,
    const std::string& error_message_in)
    : valid(std::move(valid_in)),
      latitude(std::move(latitude_in)),
      longitude(std::move(longitude_in)),
      altitude(std::move(altitude_in)),
      accuracy(std::move(accuracy_in)),
      altitude_accuracy(std::move(altitude_accuracy_in)),
      heading(std::move(heading_in)),
      speed(std::move(speed_in)),
      timestamp(std::move(timestamp_in)),
      error_code(std::move(error_code_in)),
      error_message(std::move(error_message_in)) {}

Geoposition::~Geoposition() = default;

void Geoposition::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("valid", this->valid);
  value->SetDouble("latitude", this->latitude);
  value->SetDouble("longitude", this->longitude);
  value->SetDouble("altitude", this->altitude);
  value->SetDouble("accuracy", this->accuracy);
  value->SetDouble("altitude_accuracy", this->altitude_accuracy);
  value->SetDouble("heading", this->heading);
  value->SetDouble("speed", this->speed);
  value->SetString("timestamp", base::trace_event::ValueToString(this->timestamp, "<value of type ::base::Time>"));
  value->SetString("error_code", base::trace_event::ValueToString(this->error_code));
  value->SetString("error_message", this->error_message);
}

bool Geoposition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace device

namespace mojo {


// static
bool StructTraits<::device::mojom::Geoposition::DataView, ::device::mojom::GeopositionPtr>::Read(
    ::device::mojom::Geoposition::DataView input,
    ::device::mojom::GeopositionPtr* output) {
  bool success = true;
  ::device::mojom::GeopositionPtr result(::device::mojom::Geoposition::New());
  
      if (success)
        result->valid = input.valid();
      if (success)
        result->latitude = input.latitude();
      if (success)
        result->longitude = input.longitude();
      if (success)
        result->altitude = input.altitude();
      if (success)
        result->accuracy = input.accuracy();
      if (success)
        result->altitude_accuracy = input.altitude_accuracy();
      if (success)
        result->heading = input.heading();
      if (success)
        result->speed = input.speed();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadErrorCode(&result->error_code))
        success = false;
      if (success && !input.ReadErrorMessage(&result->error_message))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif