// services/tracing/public/mojom/tracing_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/tracing/public/mojom/tracing_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/tracing/public/mojom/tracing_service.mojom-params-data.h"
#include "services/tracing/public/mojom/tracing_service.mojom-shared-message-ids.h"

#include "services/tracing/public/mojom/tracing_service.mojom-import-headers.h"


#ifndef SERVICES_TRACING_PUBLIC_MOJOM_TRACING_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_TRACING_SERVICE_MOJOM_JUMBO_H_
#endif
namespace tracing {
namespace mojom {
ClientInfo::ClientInfo()
    : pid(),
      process() {}

ClientInfo::ClientInfo(
    int32_t pid_in,
    ::mojo::PendingRemote<::tracing::mojom::TracedProcess> process_in)
    : pid(std::move(pid_in)),
      process(std::move(process_in)) {}

ClientInfo::~ClientInfo() = default;

void ClientInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("pid", this->pid);
  value->SetBoolean("process", this->process.is_valid());
}

bool ClientInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char TracingService::Name_[] = "tracing.mojom.TracingService";

TracingServiceProxy::TracingServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TracingServiceProxy::Initialize(
    std::vector<ClientInfoPtr> in_clients) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::TracingService::Initialize", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("clients");
      for (const auto& item0 : in_clients) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTracingService_Initialize_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::tracing::mojom::internal::TracingService_Initialize_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->clients)::BaseType::BufferWriter
      clients_writer;
  const mojo::internal::ContainerValidateParams clients_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::ClientInfoDataView>>(
      in_clients, buffer, &clients_writer, &clients_validate_params,
      &serialization_context);
  params->clients.Set(
      clients_writer.is_null() ? nullptr : clients_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->clients.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clients in TracingService.Initialize request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingService::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TracingServiceProxy::AddClient(
    ClientInfoPtr in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::TracingService::AddClient", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_client.is_null()) {
        raw_value->SetString("client", "nullptr");
      } else {
        raw_value->BeginDictionary("client");
        in_client->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTracingService_AddClient_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::tracing::mojom::internal::TracingService_AddClient_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->client)::BaseType::BufferWriter
      client_writer;
  mojo::internal::Serialize<::tracing::mojom::ClientInfoDataView>(
      in_client, buffer, &client_writer, &serialization_context);
  params->client.Set(
      client_writer.is_null() ? nullptr : client_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client in TracingService.AddClient request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingService::Name_);
  message.set_method_name("AddClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TracingServiceProxy::BindConsumerHost(
    ::mojo::PendingReceiver<::tracing::mojom::ConsumerHost> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::TracingService::BindConsumerHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTracingService_BindConsumerHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::tracing::mojom::internal::TracingService_BindConsumerHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tracing::mojom::ConsumerHostInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in TracingService.BindConsumerHost request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingService::Name_);
  message.set_method_name("BindConsumerHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool TracingServiceStubDispatch::Accept(
    TracingService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kTracingService_Initialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingService::Initialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingService::Initialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TracingService_Initialize_Params_Data* params =
          reinterpret_cast<internal::TracingService_Initialize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<ClientInfoPtr> p_clients{};
      TracingService_Initialize_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadClients(&p_clients))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(
std::move(p_clients));
      return true;
    }
    case internal::kTracingService_AddClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingService::AddClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingService::AddClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TracingService_AddClient_Params_Data* params =
          reinterpret_cast<internal::TracingService_AddClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ClientInfoPtr p_client{};
      TracingService_AddClient_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadClient(&p_client))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddClient(
std::move(p_client));
      return true;
    }
    case internal::kTracingService_BindConsumerHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingService::BindConsumerHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingService::BindConsumerHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TracingService_BindConsumerHost_Params_Data* params =
          reinterpret_cast<internal::TracingService_BindConsumerHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::tracing::mojom::ConsumerHost> p_receiver{};
      TracingService_BindConsumerHost_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindConsumerHost(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool TracingServiceStubDispatch::AcceptWithResponder(
    TracingService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTracingService_Initialize_Name: {
      break;
    }
    case internal::kTracingService_AddClient_Name: {
      break;
    }
    case internal::kTracingService_BindConsumerHost_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTracingServiceValidationInfo[] = {
    {internal::kTracingService_Initialize_Name,
     {&internal::TracingService_Initialize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTracingService_AddClient_Name,
     {&internal::TracingService_AddClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTracingService_BindConsumerHost_Name,
     {&internal::TracingService_BindConsumerHost_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TracingServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::TracingService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTracingServiceValidationInfo);
}

}  // namespace mojom
}  // namespace tracing

namespace mojo {


// static
bool StructTraits<::tracing::mojom::ClientInfo::DataView, ::tracing::mojom::ClientInfoPtr>::Read(
    ::tracing::mojom::ClientInfo::DataView input,
    ::tracing::mojom::ClientInfoPtr* output) {
  bool success = true;
  ::tracing::mojom::ClientInfoPtr result(::tracing::mojom::ClientInfo::New());
  
      if (success)
        result->pid = input.pid();
      if (success) {
        result->process =
            input.TakeProcess<decltype(result->process)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif