/* cheese-preferences.c generated by valac 0.56.3, the Vala compiler
 * generated from cheese-preferences.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "cheese-camera.h"
#include <gio/gio.h>
#include "cheese-fileutil.h"
#include <glib.h>
#include "cheese-camera-device.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;
typedef struct _CheesePreferencesDialogPrivate CheesePreferencesDialogPrivate;
enum  {
	CHEESE_PREFERENCES_DIALOG_0_PROPERTY,
	CHEESE_PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* cheese_preferences_dialog_properties[CHEESE_PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_CheeseVideoFormat_free0(var) ((var == NULL) ? NULL : (var = (_vala_CheeseVideoFormat_free (var), NULL)))
typedef struct _Block2Data Block2Data;

struct _CheesePreferencesDialog {
	GtkDialog parent_instance;
	CheesePreferencesDialogPrivate * priv;
};

struct _CheesePreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _CheesePreferencesDialogPrivate {
	CheeseCamera* camera;
	GSettings* settings;
	GtkComboBox* photo_resolution_combo;
	GtkComboBox* video_resolution_combo;
	GtkComboBox* source_combo;
	GtkListStore* camera_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* hue_adjustment;
	GtkAdjustment* saturation_adjustment;
	GtkSpinButton* burst_repeat_spin;
	GtkSpinButton* burst_delay_spin;
	GtkCheckButton* countdown_check;
	GtkCheckButton* flash_check;
	CheeseMediaMode current_mode;
};

struct _Block1Data {
	int _ref_count_;
	CheesePreferencesDialog* self;
	GtkListStore* resolution_model;
};

struct _Block2Data {
	int _ref_count_;
	CheesePreferencesDialog* self;
	GtkTreeIter iter;
	CheeseCameraDevice* active_device;
	gboolean device_removed;
};

static gint CheesePreferencesDialog_private_offset;
static gpointer cheese_preferences_dialog_parent_class = NULL;

VALA_EXTERN GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheesePreferencesDialog, g_object_unref)
VALA_EXTERN CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera);
VALA_EXTERN CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type,
                                                              CheeseCamera* camera);
static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_on_camera_update_num_camera_devices (CheesePreferencesDialog* self);
static void _cheese_preferences_dialog_on_camera_update_num_camera_devices_g_object_notify (GObject* _sender,
                                                                                     GParamSpec* pspec,
                                                                                     gpointer self);
static void cheese_preferences_dialog_add_camera_device (CheesePreferencesDialog* self,
                                                  CheeseCameraDevice* device);
static void _cheese_preferences_dialog_add_camera_device_gfunc (gconstpointer data,
                                                         gpointer self);
static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self,
                                                             CheeseCameraDevice* device);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_,
                 CheeseVideoFormat* format);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
static void cheese_preferences_dialog_on_source_change (CheesePreferencesDialog* self,
                                                 GtkComboBox* combo);
static void _cheese_preferences_dialog_on_source_change_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self);
static void cheese_preferences_dialog_on_photo_resolution_change (CheesePreferencesDialog* self,
                                                           GtkComboBox* combo);
static void _vala_CheeseVideoFormat_free (CheeseVideoFormat* self);
static void _cheese_preferences_dialog_on_photo_resolution_change_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                  gpointer self);
static void cheese_preferences_dialog_on_video_resolution_change (CheesePreferencesDialog* self,
                                                           GtkComboBox* combo);
static void _cheese_preferences_dialog_on_video_resolution_change_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                  gpointer self);
static gboolean cheese_preferences_dialog_on_delete (CheesePreferencesDialog* self);
static gboolean _cheese_preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                                       GdkEventAny* event,
                                                                       gpointer self);
static void cheese_preferences_dialog_on_dialog_close (CheesePreferencesDialog* self,
                                                GtkButton* button);
static void _cheese_preferences_dialog_on_dialog_close_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void cheese_preferences_dialog_on_dialog_help (CheesePreferencesDialog* self,
                                               GtkButton* button);
static void _cheese_preferences_dialog_on_dialog_help_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void cheese_preferences_dialog_on_burst_delay_change (CheesePreferencesDialog* self,
                                                      GtkSpinButton* spinbutton);
static void _cheese_preferences_dialog_on_burst_delay_change_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                                     gpointer self);
static void cheese_preferences_dialog_on_brightness_change (CheesePreferencesDialog* self,
                                                     GtkAdjustment* adjustment);
static void _cheese_preferences_dialog_on_brightness_change_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                   gpointer self);
static void cheese_preferences_dialog_on_contrast_change (CheesePreferencesDialog* self,
                                                   GtkAdjustment* adjustment);
static void _cheese_preferences_dialog_on_contrast_change_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                 gpointer self);
static void cheese_preferences_dialog_on_hue_change (CheesePreferencesDialog* self,
                                              GtkAdjustment* adjustment);
static void _cheese_preferences_dialog_on_hue_change_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                            gpointer self);
static void cheese_preferences_dialog_on_saturation_change (CheesePreferencesDialog* self,
                                                     GtkAdjustment* adjustment);
static void _cheese_preferences_dialog_on_saturation_change_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                   gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda6_ (Block2Data* _data2_,
                  CheeseCameraDevice* device);
static void cheese_preferences_dialog_remove_camera_device (CheesePreferencesDialog* self,
                                                     GtkTreeIter* iter,
                                                     CheeseCameraDevice* device_node,
                                                     CheeseCameraDevice* active_device_node);
static void ____lambda6__gfunc (gconstpointer data,
                         gpointer self);
static void cheese_preferences_dialog_set_new_available_camera_device (CheesePreferencesDialog* self,
                                                                GtkTreeIter* iter);
VALA_EXTERN void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self,
                                                 CheeseMediaMode mode);
static void cheese_preferences_dialog_finalize (GObject * obj);
static GType cheese_preferences_dialog_get_type_once (void);

static inline gpointer
cheese_preferences_dialog_get_instance_private (CheesePreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, CheesePreferencesDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_cheese_preferences_dialog_on_camera_update_num_camera_devices_g_object_notify (GObject* _sender,
                                                                                GParamSpec* pspec,
                                                                                gpointer self)
{
	cheese_preferences_dialog_on_camera_update_num_camera_devices ((CheesePreferencesDialog*) self);
}

CheesePreferencesDialog*
cheese_preferences_dialog_construct (GType object_type,
                                     CheeseCamera* camera)
{
	CheesePreferencesDialog * self = NULL;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	gint _tmp2_ = 0;
	GtkSettings* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	CheeseCamera* _tmp6_;
	GSettings* _tmp7_;
	g_return_val_if_fail (camera != NULL, NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gtk_settings = _tmp1_;
	_tmp3_ = gtk_settings;
	g_object_get (_tmp3_, "gtk-dialogs-use-header", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = 1;
	} else {
		_tmp2_ = 0;
	}
	self = (CheesePreferencesDialog*) g_object_new (object_type, "use-header-bar", _tmp2_, NULL);
	_tmp6_ = _g_object_ref0 (camera);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp6_;
	_tmp7_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp7_;
	cheese_preferences_dialog_setup_combo_box_models (self);
	cheese_preferences_dialog_initialize_camera_devices (self);
	cheese_preferences_dialog_initialize_values_from_settings (self);
	g_signal_connect_object ((GObject*) camera, "notify::num-camera-devices", (GCallback) _cheese_preferences_dialog_on_camera_update_num_camera_devices_g_object_notify, self, 0);
	_g_object_unref0 (gtk_settings);
	return self;
}

CheesePreferencesDialog*
cheese_preferences_dialog_new (CheeseCamera* camera)
{
	return cheese_preferences_dialog_construct (CHEESE_TYPE_PREFERENCES_DIALOG, camera);
}

/**
   * Set up combo box cell renderers.
   */
static void
cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self)
{
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkComboBox* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp0_);
	cell = _tmp0_;
	_tmp1_ = self->priv->photo_resolution_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) cell, FALSE);
	_tmp2_ = self->priv->photo_resolution_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp2_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_tmp3_ = self->priv->video_resolution_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) cell, FALSE);
	_tmp4_ = self->priv->video_resolution_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_tmp5_ = self->priv->source_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp5_, (GtkCellRenderer*) cell, FALSE);
	_tmp6_ = self->priv->source_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_g_object_unref0 (cell);
}

/**
   * Initialize and populate the camera device combo box model.
   */
static void
_cheese_preferences_dialog_add_camera_device_gfunc (gconstpointer data,
                                                    gpointer self)
{
	cheese_preferences_dialog_add_camera_device ((CheesePreferencesDialog*) self, (CheeseCameraDevice*) data);
}

static void
cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self)
{
	GPtrArray* devices = NULL;
	CheeseCamera* _tmp0_;
	GPtrArray* _tmp1_;
	GtkListStore* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkListStore* _tmp4_;
	GtkComboBox* _tmp5_;
	GSettings* _tmp6_;
	CheeseCamera* _tmp7_;
	CheeseCameraDevice* _tmp8_;
	const gchar* _tmp9_;
	CheeseCamera* _tmp10_;
	CheeseCameraDevice* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_CAMERA_DEVICE, -1);
	_g_object_unref0 (self->priv->camera_model);
	self->priv->camera_model = _tmp2_;
	_tmp3_ = self->priv->source_combo;
	_tmp4_ = self->priv->camera_model;
	gtk_combo_box_set_model (_tmp3_, (GtkTreeModel*) _tmp4_);
	_tmp5_ = self->priv->source_combo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	g_ptr_array_foreach (devices, _cheese_preferences_dialog_add_camera_device_gfunc, self);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->camera;
	_tmp8_ = cheese_camera_get_selected_device (_tmp7_);
	_tmp9_ = cheese_camera_device_get_name (_tmp8_);
	g_settings_set_string (_tmp6_, "camera", _tmp9_);
	_tmp10_ = self->priv->camera;
	_tmp11_ = cheese_camera_get_selected_device (_tmp10_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp11_);
	_g_ptr_array_unref0 (devices);
}

/**
   * Initialize and populate the resolution combo box models for the device.
   *
   * @param device the Cheese.CameraDevice for which to enumerate resolutions
   */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CheesePreferencesDialog* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->resolution_model);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda5_ (Block1Data* _data1_,
            CheeseVideoFormat* format)
{
	CheesePreferencesDialog* self;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	CheeseCamera* _tmp13_;
	CheeseVideoFormat* _tmp14_;
	gboolean _tmp21_ = FALSE;
	GSettings* _tmp22_;
	self = _data1_->self;
	g_return_if_fail (format != NULL);
	_tmp0_ = _data1_->resolution_model;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = _data1_->resolution_model;
	_tmp3_ = iter;
	_tmp4_ = g_strdup_printf ("%i", format->width);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, " × ", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%i", format->height);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gtk_list_store_set (_tmp2_, &_tmp3_, 0, _tmp11_, 1, format, -1);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp13_ = self->priv->camera;
	_tmp14_ = cheese_camera_get_current_video_format (_tmp13_);
	if (_tmp14_->width == format->width) {
		CheeseCamera* _tmp15_;
		CheeseVideoFormat* _tmp16_;
		_tmp15_ = self->priv->camera;
		_tmp16_ = cheese_camera_get_current_video_format (_tmp15_);
		_tmp12_ = _tmp16_->height == format->height;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GtkComboBox* _tmp17_;
		GtkTreeIter _tmp18_;
		GSettings* _tmp19_;
		GSettings* _tmp20_;
		_tmp17_ = self->priv->photo_resolution_combo;
		_tmp18_ = iter;
		gtk_combo_box_set_active_iter (_tmp17_, &_tmp18_);
		_tmp19_ = self->priv->settings;
		g_settings_set_int (_tmp19_, "photo-x-resolution", format->width);
		_tmp20_ = self->priv->settings;
		g_settings_set_int (_tmp20_, "photo-y-resolution", format->height);
	}
	_tmp22_ = self->priv->settings;
	if (g_settings_get_int (_tmp22_, "video-x-resolution") == format->width) {
		GSettings* _tmp23_;
		_tmp23_ = self->priv->settings;
		_tmp21_ = g_settings_get_int (_tmp23_, "video-y-resolution") == format->height;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		GtkComboBox* _tmp24_;
		GtkTreeIter _tmp25_;
		_tmp24_ = self->priv->video_resolution_combo;
		_tmp25_ = iter;
		gtk_combo_box_set_active_iter (_tmp24_, &_tmp25_);
	}
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ (self, (CheeseVideoFormat*) data);
}

static void
cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self,
                                                        CheeseCameraDevice* device)
{
	Block1Data* _data1_;
	GList* formats = NULL;
	GList* _tmp0_;
	GtkListStore* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkListStore* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkListStore* _tmp5_;
	GList* _tmp6_;
	GtkComboBox* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = cheese_camera_device_get_format_list (device);
	formats = _tmp0_;
	_tmp1_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_VIDEO_FORMAT, -1);
	_data1_->resolution_model = _tmp1_;
	_tmp2_ = self->priv->photo_resolution_combo;
	_tmp3_ = _data1_->resolution_model;
	gtk_combo_box_set_model (_tmp2_, (GtkTreeModel*) _tmp3_);
	_tmp4_ = self->priv->video_resolution_combo;
	_tmp5_ = _data1_->resolution_model;
	gtk_combo_box_set_model (_tmp4_, (GtkTreeModel*) _tmp5_);
	_tmp6_ = formats;
	g_list_foreach (_tmp6_, ___lambda5__gfunc, _data1_);
	_tmp7_ = self->priv->video_resolution_combo;
	if (gtk_combo_box_get_active (_tmp7_) == -1) {
		GtkComboBox* _tmp8_;
		GtkComboBox* _tmp9_;
		GSettings* _tmp10_;
		GSettings* _tmp11_;
		GSettings* _tmp12_;
		GSettings* _tmp13_;
		_tmp8_ = self->priv->video_resolution_combo;
		_tmp9_ = self->priv->photo_resolution_combo;
		gtk_combo_box_set_active (_tmp8_, gtk_combo_box_get_active (_tmp9_));
		_tmp10_ = self->priv->settings;
		_tmp11_ = self->priv->settings;
		g_settings_set_int (_tmp10_, "video-x-resolution", g_settings_get_int (_tmp11_, "photo-x-resolution"));
		_tmp12_ = self->priv->settings;
		_tmp13_ = self->priv->settings;
		g_settings_set_int (_tmp12_, "video-y-resolution", g_settings_get_int (_tmp13_, "photo-y-resolution"));
	}
	(formats == NULL) ? NULL : (formats = (g_list_free (formats), NULL));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

/**
     * Take the user preferences from GSettings.
     */
static void
cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self)
{
	GtkAdjustment* _tmp0_;
	GSettings* _tmp1_;
	GtkAdjustment* _tmp2_;
	GSettings* _tmp3_;
	GtkAdjustment* _tmp4_;
	GSettings* _tmp5_;
	GtkAdjustment* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GtkSpinButton* _tmp9_;
	GtkSpinButton* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GtkCheckButton* _tmp13_;
	GSettings* _tmp14_;
	GtkCheckButton* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->brightness_adjustment;
	_tmp1_ = self->priv->settings;
	gtk_adjustment_set_value (_tmp0_, g_settings_get_double (_tmp1_, "brightness"));
	_tmp2_ = self->priv->contrast_adjustment;
	_tmp3_ = self->priv->settings;
	gtk_adjustment_set_value (_tmp2_, g_settings_get_double (_tmp3_, "contrast"));
	_tmp4_ = self->priv->hue_adjustment;
	_tmp5_ = self->priv->settings;
	gtk_adjustment_set_value (_tmp4_, g_settings_get_double (_tmp5_, "hue"));
	_tmp6_ = self->priv->saturation_adjustment;
	_tmp7_ = self->priv->settings;
	gtk_adjustment_set_value (_tmp6_, g_settings_get_double (_tmp7_, "saturation"));
	_tmp8_ = self->priv->settings;
	_tmp9_ = self->priv->burst_repeat_spin;
	g_settings_bind (_tmp8_, "burst-repeat", (GObject*) _tmp9_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp10_ = self->priv->burst_delay_spin;
	_tmp11_ = self->priv->settings;
	gtk_spin_button_set_value (_tmp10_, (gdouble) (g_settings_get_int (_tmp11_, "burst-delay") / 1000));
	_tmp12_ = self->priv->settings;
	_tmp13_ = self->priv->countdown_check;
	g_settings_bind (_tmp12_, "countdown", (GObject*) _tmp13_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp14_ = self->priv->settings;
	_tmp15_ = self->priv->flash_check;
	g_settings_bind (_tmp14_, "flash", (GObject*) _tmp15_, "active", G_SETTINGS_BIND_DEFAULT);
}

/**
   * Update the active device to the active iter of the device combo box.
   *
   * @param combo the video device combo box
   */
static void
cheese_preferences_dialog_on_source_change (CheesePreferencesDialog* self,
                                            GtkComboBox* combo)
{
	CheeseCamera* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GtkTreeIter iter = {0};
	CheeseCameraDevice* dev = NULL;
	GtkTreeIter _tmp3_ = {0};
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	CheeseCameraDevice* _tmp7_ = NULL;
	CheeseCamera* _tmp8_;
	CheeseCamera* _tmp9_;
	CheeseCamera* _tmp10_;
	CheeseCameraDevice* _tmp11_;
	GSettings* _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->camera;
	g_object_get (_tmp0_, "num-camera-devices", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ > ((guint) 0));
	gtk_combo_box_get_active_iter (combo, &_tmp3_);
	iter = _tmp3_;
	_tmp4_ = gtk_combo_box_get_model (combo);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &_tmp7_, -1);
	_g_object_unref0 (dev);
	dev = _tmp7_;
	_tmp8_ = self->priv->camera;
	cheese_camera_set_device (_tmp8_, dev);
	_tmp9_ = self->priv->camera;
	cheese_camera_switch_camera_device (_tmp9_);
	_tmp10_ = self->priv->camera;
	_tmp11_ = cheese_camera_get_selected_device (_tmp10_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = cheese_camera_device_get_name (dev);
	g_settings_set_string (_tmp12_, "camera", _tmp13_);
	_g_object_unref0 (dev);
}

static void
_cheese_preferences_dialog_on_source_change_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self)
{
	cheese_preferences_dialog_on_source_change ((CheesePreferencesDialog*) self, _sender);
}

/**
   * Update the current photo capture resolution to the active iter of the
   * photo resolution combo box.
   *
   * @param combo the photo resolution combo box
   */
static void
_vala_CheeseVideoFormat_free (CheeseVideoFormat* self)
{
	g_boxed_free (CHEESE_TYPE_VIDEO_FORMAT, self);
}

static void
cheese_preferences_dialog_on_photo_resolution_change (CheesePreferencesDialog* self,
                                                      GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkTreeIter _tmp0_ = {0};
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	CheeseVideoFormat* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp8_;
	CheeseVideoFormat* _tmp9_;
	GSettings* _tmp10_;
	CheeseVideoFormat* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	_tmp1_ = gtk_combo_box_get_model (combo);
	_tmp2_ = _tmp1_;
	_tmp3_ = iter;
	gtk_tree_model_get (_tmp2_, &_tmp3_, 1, &_tmp4_, -1);
	__vala_CheeseVideoFormat_free0 (format);
	format = _tmp4_;
	if (self->priv->current_mode == CHEESE_MEDIA_MODE_PHOTO) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = self->priv->current_mode == CHEESE_MEDIA_MODE_BURST;
	}
	if (_tmp5_) {
		CheeseCamera* _tmp6_;
		CheeseVideoFormat* _tmp7_;
		_tmp6_ = self->priv->camera;
		_tmp7_ = format;
		cheese_camera_set_video_format (_tmp6_, _tmp7_);
	}
	_tmp8_ = self->priv->settings;
	_tmp9_ = format;
	g_settings_set_int (_tmp8_, "photo-x-resolution", _tmp9_->width);
	_tmp10_ = self->priv->settings;
	_tmp11_ = format;
	g_settings_set_int (_tmp10_, "photo-y-resolution", _tmp11_->height);
	__vala_CheeseVideoFormat_free0 (format);
}

static void
_cheese_preferences_dialog_on_photo_resolution_change_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                             gpointer self)
{
	cheese_preferences_dialog_on_photo_resolution_change ((CheesePreferencesDialog*) self, _sender);
}

/**
   * Update the current video capture resolution to the active iter of the
   * video resolution combo box.
   *
   * @param combo the video resolution combo box
   */
static void
cheese_preferences_dialog_on_video_resolution_change (CheesePreferencesDialog* self,
                                                      GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkTreeIter _tmp0_ = {0};
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	CheeseVideoFormat* _tmp4_ = NULL;
	GSettings* _tmp7_;
	CheeseVideoFormat* _tmp8_;
	GSettings* _tmp9_;
	CheeseVideoFormat* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	_tmp1_ = gtk_combo_box_get_model (combo);
	_tmp2_ = _tmp1_;
	_tmp3_ = iter;
	gtk_tree_model_get (_tmp2_, &_tmp3_, 1, &_tmp4_, -1);
	__vala_CheeseVideoFormat_free0 (format);
	format = _tmp4_;
	if (self->priv->current_mode == CHEESE_MEDIA_MODE_VIDEO) {
		CheeseCamera* _tmp5_;
		CheeseVideoFormat* _tmp6_;
		_tmp5_ = self->priv->camera;
		_tmp6_ = format;
		cheese_camera_set_video_format (_tmp5_, _tmp6_);
	}
	_tmp7_ = self->priv->settings;
	_tmp8_ = format;
	g_settings_set_int (_tmp7_, "video-x-resolution", _tmp8_->width);
	_tmp9_ = self->priv->settings;
	_tmp10_ = format;
	g_settings_set_int (_tmp9_, "video-y-resolution", _tmp10_->height);
	__vala_CheeseVideoFormat_free0 (format);
}

static void
_cheese_preferences_dialog_on_video_resolution_change_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                             gpointer self)
{
	cheese_preferences_dialog_on_video_resolution_change ((CheesePreferencesDialog*) self, _sender);
}

/**
    * Hide the dialog when it is closed, rather than deleting it.
    */
static gboolean
cheese_preferences_dialog_on_delete (CheesePreferencesDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_widget_hide_on_delete ((GtkWidget*) self);
	return result;
}

static gboolean
_cheese_preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                              GdkEventAny* event,
                                                              gpointer self)
{
	gboolean result;
	result = cheese_preferences_dialog_on_delete ((CheesePreferencesDialog*) self);
	return result;
}

/**
    * Hide the dialog when it is closed, rather than deleting it.
    */
static void
cheese_preferences_dialog_on_dialog_close (CheesePreferencesDialog* self,
                                           GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_widget_hide ((GtkWidget*) self);
}

static void
_cheese_preferences_dialog_on_dialog_close_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	cheese_preferences_dialog_on_dialog_close ((CheesePreferencesDialog*) self, _sender);
}

/**
    * Show the help for the preferences dialog.
    *
    * @param button the help button
    */
static void
cheese_preferences_dialog_on_dialog_help (CheesePreferencesDialog* self,
                                          GtkButton* button)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	{
		GdkScreen* _tmp0_;
		_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
		gtk_show_uri (_tmp0_, "help:cheese/index#preferences", (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("cheese-preferences.vala:284: %s", "Error showing help");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_cheese_preferences_dialog_on_dialog_help_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	cheese_preferences_dialog_on_dialog_help ((CheesePreferencesDialog*) self, _sender);
}

/**
   * Change the burst-delay GSetting when changing the spin button.
   *
   * The burst delay is the time, in milliseconds, between individual photos in
   * a burst.
   *
   * @param spinbutton the burst-delay spin button
   */
static void
cheese_preferences_dialog_on_burst_delay_change (CheesePreferencesDialog* self,
                                                 GtkSpinButton* spinbutton)
{
	GSettings* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = gtk_spin_button_get_value (spinbutton);
	_tmp2_ = _tmp1_;
	g_settings_set_int (_tmp0_, "burst-delay", ((gint) _tmp2_) * 1000);
}

static void
_cheese_preferences_dialog_on_burst_delay_change_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                                gpointer self)
{
	cheese_preferences_dialog_on_burst_delay_change ((CheesePreferencesDialog*) self, _sender);
}

/**
   * Change the brightness of the image, and update the GSetting, when changing
   * the scale.
   *
   * @param adjustment the adjustment of the brightness Gtk.Scale
   */
static void
cheese_preferences_dialog_on_brightness_change (CheesePreferencesDialog* self,
                                                GtkAdjustment* adjustment)
{
	CheeseCamera* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GSettings* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = gtk_adjustment_get_value (adjustment);
	_tmp2_ = _tmp1_;
	cheese_camera_set_balance_property (_tmp0_, "brightness", _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = gtk_adjustment_get_value (adjustment);
	_tmp5_ = _tmp4_;
	g_settings_set_double (_tmp3_, "brightness", _tmp5_);
}

static void
_cheese_preferences_dialog_on_brightness_change_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                              gpointer self)
{
	cheese_preferences_dialog_on_brightness_change ((CheesePreferencesDialog*) self, _sender);
}

/**
   * Change the contrast of the image, and update the GSetting, when changing
   * the scale.
   *
   * @param adjustment the adjustment of the contrast Gtk.Scale
   */
static void
cheese_preferences_dialog_on_contrast_change (CheesePreferencesDialog* self,
                                              GtkAdjustment* adjustment)
{
	CheeseCamera* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GSettings* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = gtk_adjustment_get_value (adjustment);
	_tmp2_ = _tmp1_;
	cheese_camera_set_balance_property (_tmp0_, "contrast", _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = gtk_adjustment_get_value (adjustment);
	_tmp5_ = _tmp4_;
	g_settings_set_double (_tmp3_, "contrast", _tmp5_);
}

static void
_cheese_preferences_dialog_on_contrast_change_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                            gpointer self)
{
	cheese_preferences_dialog_on_contrast_change ((CheesePreferencesDialog*) self, _sender);
}

/**
   * Change the hue of the image, and update the GSetting, when changing the
   * scale.
   *
   * @param adjustment the adjustment of the hue Gtk.Scale
   */
static void
cheese_preferences_dialog_on_hue_change (CheesePreferencesDialog* self,
                                         GtkAdjustment* adjustment)
{
	CheeseCamera* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GSettings* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = gtk_adjustment_get_value (adjustment);
	_tmp2_ = _tmp1_;
	cheese_camera_set_balance_property (_tmp0_, "hue", _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = gtk_adjustment_get_value (adjustment);
	_tmp5_ = _tmp4_;
	g_settings_set_double (_tmp3_, "hue", _tmp5_);
}

static void
_cheese_preferences_dialog_on_hue_change_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                       gpointer self)
{
	cheese_preferences_dialog_on_hue_change ((CheesePreferencesDialog*) self, _sender);
}

/**
   * Change the saturation of the image, and update the GSetting, when changing
   * the scale.
   *
   * @param adjustment the adjustment of the saturation Gtk.Scale
   */
static void
cheese_preferences_dialog_on_saturation_change (CheesePreferencesDialog* self,
                                                GtkAdjustment* adjustment)
{
	CheeseCamera* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GSettings* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = gtk_adjustment_get_value (adjustment);
	_tmp2_ = _tmp1_;
	cheese_camera_set_balance_property (_tmp0_, "saturation", _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = gtk_adjustment_get_value (adjustment);
	_tmp5_ = _tmp4_;
	g_settings_set_double (_tmp3_, "saturation", _tmp5_);
}

static void
_cheese_preferences_dialog_on_saturation_change_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                              gpointer self)
{
	cheese_preferences_dialog_on_saturation_change ((CheesePreferencesDialog*) self, _sender);
}

/**
   * Update the video device combo box when a camera device was added or
   * removed.
   */
static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CheesePreferencesDialog* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->active_device);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda6_ (Block2Data* _data2_,
             CheeseCameraDevice* device)
{
	CheesePreferencesDialog* self;
	CheeseCameraDevice* new_device = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	CheeseCameraDevice* _tmp2_ = NULL;
	CheeseCameraDevice* _tmp3_;
	GtkListStore* _tmp7_;
	self = _data2_->self;
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->camera_model;
	_tmp1_ = _data2_->iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, 1, &_tmp2_, -1, -1);
	_g_object_unref0 (new_device);
	new_device = _tmp2_;
	_tmp3_ = new_device;
	if (device != _tmp3_) {
		GtkTreeIter _tmp4_;
		CheeseCameraDevice* _tmp5_;
		CheeseCameraDevice* _tmp6_;
		_tmp4_ = _data2_->iter;
		_tmp5_ = new_device;
		_tmp6_ = _data2_->active_device;
		cheese_preferences_dialog_remove_camera_device (self, &_tmp4_, _tmp5_, _tmp6_);
		_data2_->device_removed = TRUE;
		_g_object_unref0 (new_device);
		return;
	}
	_tmp7_ = self->priv->camera_model;
	gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &_data2_->iter);
	_g_object_unref0 (new_device);
}

static void
____lambda6__gfunc (gconstpointer data,
                    gpointer self)
{
	___lambda6_ (self, (CheeseCameraDevice*) data);
}

static void
cheese_preferences_dialog_on_camera_update_num_camera_devices (CheesePreferencesDialog* self)
{
	GPtrArray* devices = NULL;
	CheeseCamera* _tmp0_;
	GPtrArray* _tmp1_;
	CheeseCameraDevice* dev = NULL;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkListStore* _tmp5_;
	GSettings* _tmp26_;
	CheeseCamera* _tmp27_;
	CheeseCameraDevice* _tmp28_;
	const gchar* _tmp29_;
	CheeseCamera* _tmp30_;
	CheeseCameraDevice* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	_tmp2_ = devices;
	_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->camera_model;
	if (_tmp4_ > gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp5_, NULL)) {
		GPtrArray* _tmp6_;
		GPtrArray* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gconstpointer _tmp10_;
		CheeseCameraDevice* _tmp11_;
		_tmp6_ = devices;
		_tmp7_ = devices;
		_tmp8_ = vala_g_ptr_array_get_length (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_ptr_array_index (_tmp6_, (guint) (_tmp9_ - 1));
		dev = (CheeseCameraDevice*) _tmp10_;
		_tmp11_ = dev;
		cheese_preferences_dialog_add_camera_device (self, _tmp11_);
	} else {
		Block2Data* _data2_;
		GtkListStore* _tmp12_;
		GtkTreeIter _tmp13_ = {0};
		GtkTreeIter active_iter = {0};
		GtkComboBox* _tmp14_;
		GtkTreeIter _tmp15_ = {0};
		GtkListStore* _tmp16_;
		GtkTreeIter _tmp17_;
		CheeseCameraDevice* _tmp18_ = NULL;
		GPtrArray* _tmp19_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->self = g_object_ref (self);
		_tmp12_ = self->priv->camera_model;
		gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp12_, &_tmp13_);
		_data2_->iter = _tmp13_;
		_tmp14_ = self->priv->source_combo;
		gtk_combo_box_get_active_iter (_tmp14_, &_tmp15_);
		active_iter = _tmp15_;
		_tmp16_ = self->priv->camera_model;
		_tmp17_ = active_iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp16_, &_tmp17_, 1, &_tmp18_, -1, -1);
		_g_object_unref0 (_data2_->active_device);
		_data2_->active_device = _tmp18_;
		_data2_->device_removed = FALSE;
		_tmp19_ = devices;
		g_ptr_array_foreach (_tmp19_, ____lambda6__gfunc, _data2_);
		if (!_data2_->device_removed) {
			CheeseCameraDevice* old_device = NULL;
			GtkListStore* _tmp20_;
			GtkTreeIter _tmp21_;
			CheeseCameraDevice* _tmp22_ = NULL;
			GtkTreeIter _tmp23_;
			CheeseCameraDevice* _tmp24_;
			CheeseCameraDevice* _tmp25_;
			_tmp20_ = self->priv->camera_model;
			_tmp21_ = _data2_->iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp20_, &_tmp21_, 1, &_tmp22_, -1, -1);
			_g_object_unref0 (old_device);
			old_device = _tmp22_;
			_tmp23_ = _data2_->iter;
			_tmp24_ = old_device;
			_tmp25_ = _data2_->active_device;
			cheese_preferences_dialog_remove_camera_device (self, &_tmp23_, _tmp24_, _tmp25_);
			_g_object_unref0 (old_device);
		}
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	_tmp26_ = self->priv->settings;
	_tmp27_ = self->priv->camera;
	_tmp28_ = cheese_camera_get_selected_device (_tmp27_);
	_tmp29_ = cheese_camera_device_get_name (_tmp28_);
	g_settings_set_string (_tmp26_, "camera", _tmp29_);
	_tmp30_ = self->priv->camera;
	_tmp31_ = cheese_camera_get_selected_device (_tmp30_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp31_);
	_g_ptr_array_unref0 (devices);
}

/**
   * Add the supplied camera device to the device combo box model.
   *
   * This method is intended to be used with the foreach method of GLib
   * containers.
   *
   * @param device a Cheese.CameraDevice to add to the device combo box model
   */
static void
cheese_preferences_dialog_add_camera_device (CheesePreferencesDialog* self,
                                             CheeseCameraDevice* device)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	const gchar* _tmp4_;
	CheeseCamera* _tmp5_;
	CheeseCameraDevice* _tmp6_;
	GtkListStore* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->camera_model;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->camera_model;
	_tmp3_ = iter;
	_tmp4_ = cheese_camera_device_get_name (device);
	gtk_list_store_set (_tmp2_, &_tmp3_, 0, _tmp4_, 1, device, -1);
	_tmp5_ = self->priv->camera;
	_tmp6_ = cheese_camera_get_selected_device (_tmp5_);
	if (_tmp6_ == device) {
		GtkComboBox* _tmp7_;
		GtkTreeIter _tmp8_;
		_tmp7_ = self->priv->source_combo;
		_tmp8_ = iter;
		gtk_combo_box_set_active_iter (_tmp7_, &_tmp8_);
	}
	_tmp9_ = self->priv->camera_model;
	if (gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp9_, NULL) > 1) {
		GtkComboBox* _tmp10_;
		_tmp10_ = self->priv->source_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
	}
}

/**
   * Remove the supplied camera device from the device combo box model.
   *
   * @param iter the iterator of the device to remove
   * @param device_node the device to remove from the combo box model
   * @param active_device_node the currently-active camera device
   */
static void
cheese_preferences_dialog_remove_camera_device (CheesePreferencesDialog* self,
                                                GtkTreeIter* iter,
                                                CheeseCameraDevice* device_node,
                                                CheeseCameraDevice* active_device_node)
{
	GPtrArray* devices = NULL;
	CheeseCamera* _tmp0_;
	GPtrArray* _tmp1_;
	GtkListStore* _tmp6_;
	GtkListStore* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (device_node != NULL);
	g_return_if_fail (active_device_node != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	if (device_node == active_device_node) {
		GPtrArray* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = devices;
		_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ > 0) {
			GtkTreeIter _tmp5_;
			_tmp5_ = *iter;
			cheese_preferences_dialog_set_new_available_camera_device (self, &_tmp5_);
		} else {
			gtk_widget_hide ((GtkWidget*) self);
		}
	}
	_tmp6_ = self->priv->camera_model;
	gtk_list_store_remove (_tmp6_, iter);
	_tmp7_ = self->priv->camera_model;
	if (gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp7_, NULL) <= 1) {
		GtkComboBox* _tmp8_;
		_tmp8_ = self->priv->source_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
	}
	_g_ptr_array_unref0 (devices);
}

/**
   * Search for an available camera device and activate it in the device combo
   * box model.
   *
   * @param iter a device in the combo box model to search either side of
   */
static void
cheese_preferences_dialog_set_new_available_camera_device (CheesePreferencesDialog* self,
                                                           GtkTreeIter* iter)
{
	GtkTreeIter new_iter = {0};
	GtkTreeIter _tmp0_;
	GtkListStore* _tmp1_;
	gboolean _tmp2_;
	GtkComboBox* _tmp5_;
	GtkTreeIter _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	new_iter = _tmp0_;
	_tmp1_ = self->priv->camera_model;
	_tmp2_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp1_, &new_iter);
	if (!_tmp2_) {
		GtkTreeIter _tmp3_;
		GtkListStore* _tmp4_;
		_tmp3_ = *iter;
		new_iter = _tmp3_;
		_tmp4_ = self->priv->camera_model;
		gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp4_, &new_iter);
	}
	_tmp5_ = self->priv->source_combo;
	_tmp6_ = new_iter;
	gtk_combo_box_set_active_iter (_tmp5_, &_tmp6_);
}

/**
     * Set the current media mode (photo, video or burst).
     *
     * The current mode is used to update the video format on the Cheese.Camera
     * when the resolution for the current mode is changed.
     *
     * @param mode the media mode to set
     */
void
cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self,
                                            CheeseMediaMode mode)
{
	g_return_if_fail (self != NULL);
	self->priv->current_mode = mode;
}

static void
cheese_preferences_dialog_class_init (CheesePreferencesDialogClass * klass,
                                      gpointer klass_data)
{
	cheese_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CheesePreferencesDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = cheese_preferences_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Cheese/cheese-prefs.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_resolution_combo", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, photo_resolution_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "video_resolution_combo", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, video_resolution_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "source_combo", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, source_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "brightness_adjustment", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, brightness_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contrast_adjustment", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, contrast_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hue_adjustment", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, hue_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "saturation_adjustment", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, saturation_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "burst_repeat_spin", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, burst_repeat_spin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "burst_delay_spin", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, burst_delay_spin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "countdown_check", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, countdown_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "flash_check", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, flash_check));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_source_change", G_CALLBACK(_cheese_preferences_dialog_on_source_change_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_photo_resolution_change", G_CALLBACK(_cheese_preferences_dialog_on_photo_resolution_change_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_video_resolution_change", G_CALLBACK(_cheese_preferences_dialog_on_video_resolution_change_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete", G_CALLBACK(_cheese_preferences_dialog_on_delete_gtk_widget_delete_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_dialog_close", G_CALLBACK(_cheese_preferences_dialog_on_dialog_close_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_dialog_help", G_CALLBACK(_cheese_preferences_dialog_on_dialog_help_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_burst_delay_change", G_CALLBACK(_cheese_preferences_dialog_on_burst_delay_change_gtk_spin_button_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_brightness_change", G_CALLBACK(_cheese_preferences_dialog_on_brightness_change_gtk_adjustment_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_contrast_change", G_CALLBACK(_cheese_preferences_dialog_on_contrast_change_gtk_adjustment_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_hue_change", G_CALLBACK(_cheese_preferences_dialog_on_hue_change_gtk_adjustment_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_saturation_change", G_CALLBACK(_cheese_preferences_dialog_on_saturation_change_gtk_adjustment_value_changed));
}

static void
cheese_preferences_dialog_instance_init (CheesePreferencesDialog * self,
                                         gpointer klass)
{
	self->priv = cheese_preferences_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
cheese_preferences_dialog_finalize (GObject * obj)
{
	CheesePreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->camera_model);
	G_OBJECT_CLASS (cheese_preferences_dialog_parent_class)->finalize (obj);
}

static GType
cheese_preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CheesePreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheesePreferencesDialog), 0, (GInstanceInitFunc) cheese_preferences_dialog_instance_init, NULL };
	GType cheese_preferences_dialog_type_id;
	cheese_preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "CheesePreferencesDialog", &g_define_type_info, 0);
	CheesePreferencesDialog_private_offset = g_type_add_instance_private (cheese_preferences_dialog_type_id, sizeof (CheesePreferencesDialogPrivate));
	return cheese_preferences_dialog_type_id;
}

GType
cheese_preferences_dialog_get_type (void)
{
	static volatile gsize cheese_preferences_dialog_type_id__once = 0;
	if (g_once_init_enter (&cheese_preferences_dialog_type_id__once)) {
		GType cheese_preferences_dialog_type_id;
		cheese_preferences_dialog_type_id = cheese_preferences_dialog_get_type_once ();
		g_once_init_leave (&cheese_preferences_dialog_type_id__once, cheese_preferences_dialog_type_id);
	}
	return cheese_preferences_dialog_type_id__once;
}

