/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BDFileSystemImpl;
import java.io.DefaultFileSystem;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.videolan.BDJLoader;
import org.videolan.BDJXletContext;
import org.videolan.Libbluray;
import org.videolan.Logger;

public abstract class BDFileSystem
extends FileSystem {
    private static FileSystem nativeFileSystem;
    private static Logger logger;
    private static boolean booted;
    protected final FileSystem fs;

    public static String[] nativeList(File f) {
        return nativeFileSystem.list(f);
    }

    public static boolean nativeFileExists(String path) {
        return nativeFileSystem.getBooleanAttributes(new File(path)) != 0;
    }

    public static void init(final Class c) {
        BDFileSystem.setBooted();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BDFileSystem.init0(c);
                return null;
            }
        });
    }

    private static void init0(Class c) {
        try {
            Field filesystem = c.getDeclaredField("fs");
            filesystem.setAccessible(true);
            FileSystem fs = (FileSystem)filesystem.get(null);
            if (!(fs instanceof BDFileSystemImpl)) {
                filesystem.set(null, new BDFileSystemImpl(fs));
            }
        }
        catch (Exception t) {
            BDFileSystem.error("Hooking FileSystem class failed: " + t);
        }
    }

    public static void setBooted() {
        if (!booted) {
            booted = true;
            logger = Logger.getLogger(BDFileSystem.class.getName());
        }
    }

    private static void error(String msg) {
        if (logger != null) {
            logger.error(msg);
        }
    }

    public BDFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public char getSeparator() {
        return this.fs.getSeparator();
    }

    @Override
    public char getPathSeparator() {
        return this.fs.getPathSeparator();
    }

    @Override
    public String normalize(String pathname) {
        return this.fs.normalize(pathname);
    }

    @Override
    public int prefixLength(String pathname) {
        return this.fs.prefixLength(pathname);
    }

    public static boolean isAbsolutePath(String path) {
        return path.startsWith("/") || path.indexOf(":\\") == 1 || path.startsWith("\\");
    }

    private String getHomeDir() {
        String home = BDJXletContext.getCurrentXletHome();
        if (home == null) {
            return "";
        }
        return home;
    }

    @Override
    public String resolve(String parent, String child) {
        if (!booted) {
            return this.fs.resolve(parent, child);
        }
        if (parent == null || parent.equals("") || parent.equals(".")) {
            parent = this.getHomeDir();
        } else if (!BDFileSystem.isAbsolutePath(parent)) {
            logger.info("resolve relative file at " + parent);
            parent = this.getHomeDir() + parent;
        }
        String resolvedPath = this.fs.resolve(parent, child);
        String cachePath = BDJLoader.getCachedFile(resolvedPath);
        if (cachePath != resolvedPath && !cachePath.equals(resolvedPath)) {
            logger.info("resolve(p,c): using cached " + cachePath + " (" + resolvedPath + ")");
        }
        return cachePath;
    }

    @Override
    public String getDefaultParent() {
        return this.fs.getDefaultParent();
    }

    @Override
    public String fromURIPath(String path) {
        return this.fs.fromURIPath(path);
    }

    @Override
    public boolean isAbsolute(File f) {
        return this.fs.isAbsolute(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInvalid(File f) {
        try {
            Method m = this.fs.getClass().getDeclaredMethod("isInvalid", File.class);
            Object[] args = new Object[]{f};
            Boolean result = (Boolean)m.invoke((Object)this.fs, args);
            boolean bl = result;
            return bl;
        }
        finally {
            return false;
        }
    }

    @Override
    public String resolve(File f) {
        if (!booted) {
            return this.fs.resolve(f);
        }
        if (!f.isAbsolute()) {
            logger.info("resolve relative file " + f.getPath());
            return this.resolve(BDJXletContext.getCurrentXletHome(), f.getPath());
        }
        String resolvedPath = this.fs.resolve(f);
        String cachePath = BDJLoader.getCachedFile(resolvedPath);
        if (cachePath != resolvedPath && !cachePath.equals(resolvedPath)) {
            logger.info("resolve(f): using cached " + cachePath + " (" + resolvedPath + ")");
        }
        return cachePath;
    }

    @Override
    public String canonicalize(String path) throws IOException {
        if (!booted) {
            return this.fs.canonicalize(path);
        }
        String canonPath = this.fs.canonicalize(path);
        String cachePath = BDJLoader.getCachedFile(canonPath);
        if (cachePath != canonPath && !cachePath.equals(canonPath)) {
            logger.info("canonicalize(): Using cached " + cachePath + " for " + canonPath + "(" + path + ")");
        }
        return cachePath;
    }

    @Override
    public int getBooleanAttributes(File f) {
        if (!booted) {
            return this.fs.getBooleanAttributes(f);
        }
        if (f.isAbsolute()) {
            return this.fs.getBooleanAttributes(f);
        }
        String home = BDJXletContext.getCurrentXletHome();
        if (home == null) {
            logger.error("no home found for " + f.getPath() + " at " + Logger.dumpStack());
            return 0;
        }
        String path = home + f.getPath();
        logger.info("Relative path " + f.getPath() + " translated to " + path);
        return this.fs.getBooleanAttributes(new File(path));
    }

    @Override
    public long getLastModifiedTime(File f) {
        return this.fs.getLastModifiedTime(f);
    }

    @Override
    public long getLength(File f) {
        if (!booted) {
            return this.fs.getLength(f);
        }
        if (f.isAbsolute()) {
            return this.fs.getLength(f);
        }
        String home = BDJXletContext.getCurrentXletHome();
        if (home == null) {
            logger.error("no home found for " + f.getPath() + " at " + Logger.dumpStack());
            return 0L;
        }
        String path = home + f.getPath();
        logger.info("Relative path " + f.getPath() + " translated to " + path);
        return this.fs.getLength(new File(path));
    }

    public boolean createFileExclusively(String path, boolean restrictive) throws IOException {
        return this.createFileExclusivelyImpl(path, restrictive);
    }

    @Override
    public boolean createFileExclusively(String path) throws IOException {
        return this.createFileExclusivelyImpl(path, false);
    }

    private boolean createFileExclusivelyImpl(String path, boolean restrictive) throws IOException {
        Object[] args;
        Method m;
        try {
            try {
                m = this.fs.getClass().getDeclaredMethod("createFileExclusively", String.class);
                args = new Object[]{path};
            }
            catch (NoSuchMethodException e) {
                m = this.fs.getClass().getDeclaredMethod("createFileExclusively", String.class, Boolean.TYPE);
                args = new Object[]{path, new Boolean(restrictive)};
            }
        }
        catch (NoSuchMethodException e) {
            BDFileSystem.error("no matching FileSystem.createFileExclusively found !");
            throw new IOException();
        }
        try {
            Boolean result = (Boolean)m.invoke((Object)this.fs, args);
            return result;
        }
        catch (IllegalAccessException e) {
            BDFileSystem.error("" + e);
            throw new IOException();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            BDFileSystem.error("" + t);
            throw new IOException();
        }
    }

    @Override
    public boolean delete(File f) {
        return this.fs.delete(f);
    }

    @Override
    public String[] list(File f) {
        if (!booted) {
            return this.fs.list(f);
        }
        String path = f.getPath();
        String root = System.getProperty("bluray.vfs.root");
        if (root == null || !path.startsWith(root)) {
            return this.fs.list(f);
        }
        int rootLength = root.length();
        path = path.substring(rootLength);
        String[] names = Libbluray.listBdFiles(path, false);
        return names;
    }

    @Override
    public boolean createDirectory(File f) {
        return this.fs.createDirectory(f);
    }

    @Override
    public boolean rename(File f1, File f2) {
        return this.fs.rename(f1, f2);
    }

    @Override
    public boolean setLastModifiedTime(File f, long time) {
        return this.fs.setLastModifiedTime(f, time);
    }

    @Override
    public boolean setReadOnly(File f) {
        return this.fs.setReadOnly(f);
    }

    @Override
    public File[] listRoots() {
        return this.fs.listRoots();
    }

    @Override
    public int compare(File f1, File f2) {
        return this.fs.compare(f1, f2);
    }

    @Override
    public int hashCode(File f) {
        return this.fs.hashCode(f);
    }

    static {
        try {
            String v = System.getProperty("java.version");
            int i = 0;
            if (v.startsWith("1.")) {
                v = v.substring(2, 3);
            }
            if (v.indexOf(".") != -1) {
                v = v.substring(0, v.indexOf("."));
            }
            if (v.indexOf("-") != -1) {
                v = v.substring(0, v.indexOf("-"));
            }
            try {
                i = Integer.parseInt(v);
            }
            catch (Throwable t) {
                i = 0;
            }
            if (i >= 8) {
                throw new Exception("java>7");
            }
            nativeFileSystem = (FileSystem)FileSystem.class.getDeclaredMethod("getFileSystem", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            try {
                nativeFileSystem = DefaultFileSystem.getNativeFileSystem();
            }
            catch (Throwable t) {
                System.err.print("Couldn't find native filesystem: " + e);
            }
        }
        logger = null;
        booted = false;
    }
}

