/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.Filter;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class FilterBase
implements Filter {
    private final SpreadsheetView spv;
    private final int column;
    private MenuButton menuButton;
    private BitSet hiddenRows;
    private Set<String> stringSet = new HashSet<String>();
    private Set<String> copySet = new HashSet<String>();
    private final Comparator ascendingComp = new Comparator<ObservableList<SpreadsheetCell>>(){

        @Override
        public int compare(ObservableList<SpreadsheetCell> o1, ObservableList<SpreadsheetCell> o2) {
            SpreadsheetCell cell1 = (SpreadsheetCell)o1.get(FilterBase.this.column);
            SpreadsheetCell cell2 = (SpreadsheetCell)o2.get(FilterBase.this.column);
            if (cell1.getRow() <= FilterBase.this.spv.getFilteredRow()) {
                return Integer.compare(cell1.getRow(), cell2.getRow());
            }
            if (cell2.getRow() <= FilterBase.this.spv.getFilteredRow()) {
                return Integer.compare(cell1.getRow(), cell2.getRow());
            }
            if (cell1.getCellType() == SpreadsheetCellType.INTEGER && cell2.getCellType() == SpreadsheetCellType.INTEGER) {
                return Integer.compare((Integer)cell1.getItem(), (Integer)cell2.getItem());
            }
            if (cell1.getCellType() == SpreadsheetCellType.DOUBLE && cell2.getCellType() == SpreadsheetCellType.DOUBLE) {
                return Double.compare((Double)cell1.getItem(), (Double)cell2.getItem());
            }
            return cell1.getText().compareToIgnoreCase(cell2.getText());
        }
    };
    private final Comparator descendingComp = new Comparator<ObservableList<SpreadsheetCell>>(){

        @Override
        public int compare(ObservableList<SpreadsheetCell> o1, ObservableList<SpreadsheetCell> o2) {
            SpreadsheetCell cell1 = (SpreadsheetCell)o1.get(FilterBase.this.column);
            SpreadsheetCell cell2 = (SpreadsheetCell)o2.get(FilterBase.this.column);
            if (cell1.getRow() <= FilterBase.this.spv.getFilteredRow()) {
                return Integer.compare(cell1.getRow(), cell2.getRow());
            }
            if (cell2.getRow() <= FilterBase.this.spv.getFilteredRow()) {
                return Integer.compare(cell1.getRow(), cell2.getRow());
            }
            if (cell1.getCellType() == SpreadsheetCellType.INTEGER && cell2.getCellType() == SpreadsheetCellType.INTEGER) {
                return Integer.compare((Integer)cell2.getItem(), (Integer)cell1.getItem());
            }
            if (cell1.getCellType() == SpreadsheetCellType.DOUBLE && cell2.getCellType() == SpreadsheetCellType.DOUBLE) {
                return Double.compare((Double)cell2.getItem(), (Double)cell1.getItem());
            }
            return cell2.getText().compareToIgnoreCase(cell1.getText());
        }
    };

    public FilterBase(SpreadsheetView spv, int column) {
        this.spv = spv;
        this.column = column;
    }

    @Override
    public MenuButton getMenuButton() {
        if (this.menuButton == null) {
            this.menuButton = new MenuButton();
            this.menuButton.getStyleClass().add((Object)"filter-menu-button");
            this.menuButton.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable2, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        FilterBase.this.addMenuItems();
                        FilterBase.this.hiddenRows = new BitSet(FilterBase.this.spv.getHiddenRows().size());
                        FilterBase.this.hiddenRows.or(FilterBase.this.spv.getHiddenRows());
                    } else {
                        for (int i = FilterBase.this.spv.getFilteredRow() + 1; i < FilterBase.this.spv.getGrid().getRowCount(); ++i) {
                            FilterBase.this.hiddenRows.set(i, !FilterBase.this.copySet.contains(((SpreadsheetCell)((ObservableList)FilterBase.this.spv.getGrid().getRows().get(i)).get(FilterBase.this.column)).getText()));
                        }
                        FilterBase.this.spv.setHiddenRows(FilterBase.this.hiddenRows);
                    }
                }
            });
        }
        return this.menuButton;
    }

    private void addMenuItems() {
        if (this.menuButton.getItems().isEmpty()) {
            final MenuItem sortItem = new MenuItem("Sort ascending");
            sortItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (FilterBase.this.spv.getComparator() == FilterBase.this.ascendingComp) {
                        FilterBase.this.spv.setComparator(FilterBase.this.descendingComp);
                        sortItem.setText("Remove sort");
                    } else if (FilterBase.this.spv.getComparator() == FilterBase.this.descendingComp) {
                        FilterBase.this.spv.setComparator(null);
                        sortItem.setText("Sort ascending");
                    } else {
                        FilterBase.this.spv.setComparator(FilterBase.this.ascendingComp);
                        sortItem.setText("Sort descending");
                    }
                }
            });
            ListView listView = new ListView();
            listView.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> param) {
                    return new ListCell<String>(){

                        public void updateItem(final String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setText(item);
                            if (item != null) {
                                CheckBox checkBox = new CheckBox();
                                checkBox.setSelected(FilterBase.this.copySet.contains(item));
                                checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                                    public void changed(ObservableValue<? extends Boolean> observable2, Boolean oldValue, Boolean newValue) {
                                        if (newValue.booleanValue()) {
                                            FilterBase.this.copySet.add(item);
                                        } else {
                                            FilterBase.this.copySet.remove(item);
                                        }
                                    }
                                });
                                this.setGraphic((Node)checkBox);
                            }
                        }
                    };
                }
            });
            for (int i = this.spv.getFilteredRow() + 1; i < this.spv.getGrid().getRowCount(); ++i) {
                this.stringSet.add(((SpreadsheetCell)((ObservableList)this.spv.getGrid().getRows().get(i)).get(this.column)).getText());
            }
            listView.setItems(FXCollections.observableArrayList(this.stringSet));
            CustomMenuItem customMenuItem = new CustomMenuItem((Node)listView);
            customMenuItem.setHideOnClick(false);
            this.menuButton.getItems().addAll((Object[])new MenuItem[]{sortItem, customMenuItem});
        }
        this.copySet.clear();
        for (int i = this.spv.getFilteredRow() + 1; i < this.spv.getGrid().getRowCount(); ++i) {
            if (this.spv.getHiddenRows().get(i)) continue;
            this.copySet.add(((SpreadsheetCell)((ObservableList)this.spv.getGrid().getRows().get(i)).get(this.column)).getText());
        }
    }
}

