/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.notifications.core.setting.PluginSettings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.spi.model.MessageContent;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/opensearch/notifications/core/client/EmailMessageValidator;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "isMessageSizeOverLimit", "", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "opensearch-notifications-core"})
public final class EmailMessageValidator {
    @NotNull
    public static final EmailMessageValidator INSTANCE = new EmailMessageValidator();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(EmailMessageValidator.class);

    private EmailMessageValidator() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final boolean isMessageSizeOverLimit(@NotNull MessageContent message) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message.getFileData() != null && message.getFileName() != null) {
            int n3 = PluginSettings.INSTANCE.getEmailMinimumHeaderLength();
            String string = message.getFileData();
            Intrinsics.checkNotNull((Object)string);
            int n4 = n3 + string.length();
            String string2 = message.getFileName();
            Intrinsics.checkNotNull((Object)string2);
            n2 = n4 + string2.length();
        } else {
            n2 = 0;
        }
        int approxAttachmentLength = n2;
        String string = message.getHtmlDescription();
        int approxEmailLength = PluginSettings.INSTANCE.getEmailMinimumHeaderLength() + message.getTitle().length() + message.getTextDescription().length() + (string == null ? 0 : (n = string.length())) + approxAttachmentLength;
        return approxEmailLength > PluginSettings.INSTANCE.getEmailSizeLimit();
    }
}

