/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.validation;

import java.util.Map;
import java.util.regex.Pattern;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.compress.NotXContentException;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.ssl.util.Utils;

public class CredentialsValidator
extends AbstractConfigurationValidator {
    public CredentialsValidator(RestRequest request, BytesReference ref, Settings opensearchSettings, Object ... param) {
        super(request, ref, opensearchSettings, param);
        this.payloadMandatory = true;
        this.allowedKeys.put("hash", AbstractConfigurationValidator.DataType.STRING);
        this.allowedKeys.put("password", AbstractConfigurationValidator.DataType.STRING);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        String regex = this.opensearchSettings.get("plugins.security.restapi.password_validation_regex", null);
        if ((this.request.method() == RestRequest.Method.PUT || this.request.method() == RestRequest.Method.PATCH) && this.content != null && this.content.length() > 1) {
            try {
                Map contentAsMap = (Map)XContentHelper.convertToMap((BytesReference)this.content, (boolean)false, (XContentType)XContentType.JSON).v2();
                String password = (String)contentAsMap.get("password");
                if (password != null) {
                    if (password.isEmpty()) {
                        this.errorType = AbstractConfigurationValidator.ErrorType.INVALID_PASSWORD;
                        return false;
                    }
                    if (!Strings.isNullOrEmpty((String)regex)) {
                        if (!Pattern.compile("^" + regex + "$").matcher(password).matches()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Regex does not match password");
                            }
                            this.errorType = AbstractConfigurationValidator.ErrorType.INVALID_PASSWORD;
                            return false;
                        }
                        String username = Utils.coalesce(this.request.param("name"), this.hasParams() ? (String)this.param[0] : null);
                        boolean isDebugEnabled = this.log.isDebugEnabled();
                        if (username == null || username.isEmpty()) {
                            if (isDebugEnabled) {
                                this.log.debug("Unable to validate username because no user is given");
                            }
                            return false;
                        }
                        if (username.toLowerCase().equals(password.toLowerCase())) {
                            if (isDebugEnabled) {
                                this.log.debug("Username must not match password");
                            }
                            this.errorType = AbstractConfigurationValidator.ErrorType.INVALID_PASSWORD;
                            return false;
                        }
                    }
                }
            }
            catch (NotXContentException e) {
                this.log.error("Invalid xContent: " + e, (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

