import * as LSP from 'vscode-languageserver';
type LinterOptions = {
    executablePath: string | null;
    cwd?: string;
};
export declare function getLinterExecutablePath(): Promise<string | null>;
export declare class Linter {
    executablePath: string | null;
    private cwd;
    _canLint: boolean;
    constructor(opts: LinterOptions);
    get canLint(): boolean;
    lint(document: LSP.TextDocument, folders: LSP.WorkspaceFolder[]): Promise<LSP.Diagnostic[]>;
    private runShellcheck;
}
export type ShellcheckResult = Readonly<{
    comments: ReadonlyArray<ShellcheckComment>;
}>;
export type ShellcheckComment = Readonly<{
    file: string;
    line: number;
    endLine: number;
    column: number;
    endColumn: number;
    level: string;
    code: number;
    message: string;
}>;
export declare function assertShellcheckResult(val: any): asserts val is ShellcheckResult;
export {};
