"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shebang_1 = require("../shebang");
describe('hasBashShebang', () => {
    it('returns false for empty file', () => {
        expect((0, shebang_1.hasBashShebang)('')).toBe(false);
    });
    it('returns false for python files', () => {
        expect((0, shebang_1.hasBashShebang)(`#!/usr/bin/env python2.7\n# set -x`)).toBe(false);
    });
    it('returns false for "#!/usr/bin/pwsh"', () => {
        expect((0, shebang_1.hasBashShebang)('#!/usr/bin/pwsh')).toBe(false);
    });
    test.each([
        ['#!/bin/sh -'],
        ['#!/usr/bin/env bash'],
        ['#!/bin/sh'],
        ['#!/bin/bash'],
        ['#!/bin/bash -u'],
    ])('returns true for %p', (command) => {
        expect((0, shebang_1.hasBashShebang)(command)).toBe(true);
        expect((0, shebang_1.hasBashShebang)(`${command} `)).toBe(true);
    });
});
//# sourceMappingURL=shebang.test.js.map