/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtileRoot;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileHexagonInside;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithIncomingArrow;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithMargin;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithOutgoingArrow;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Gtiles {
    public static GtileHexagonInside hexagonInside(Swimlane swimlane, StringBounder stringBounder, ISkinParam skinParam, StyleSignatureBasic styleSignature, HColor color, Display label) {
        Style style = styleSignature.getMergedStyle(skinParam.getCurrentStyleBuilder());
        HColor borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        HColor backColor = color == null ? style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet()) : color;
        FontConfiguration fcTest = style.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        Sheet sheet = Parser.build(fcTest, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), skinParam, CreoleMode.FULL).createSheet(label);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, skinParam.getPadding());
        SheetBlock2 tbTest = new SheetBlock2(sheetBlock1, Hexagon.asStencil(sheetBlock1), new UStroke());
        return new GtileHexagonInside(stringBounder, tbTest, skinParam, backColor, borderColor, swimlane);
    }

    public static AbstractGtileRoot diamondEmpty(Swimlane swimlane, StringBounder stringBounder, ISkinParam skinParam, StyleSignatureBasic styleSignature, HColor color) {
        Style style = styleSignature.getMergedStyle(skinParam.getCurrentStyleBuilder());
        HColor borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        HColor backColor = color == null ? style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet()) : color;
        return new GtileHexagonInside(stringBounder, TextBlockUtils.EMPTY_TEXT_BLOCK, skinParam, backColor, borderColor, swimlane);
    }

    public static Gtile withSouthMargin(Gtile orig, double south) {
        return new GtileWithMargin((AbstractGtileRoot)orig, 0.0, south, 0.0);
    }

    public static Gtile withNorthMargin(Gtile orig, double north) {
        return new GtileWithMargin((AbstractGtileRoot)orig, north, 0.0, 0.0);
    }

    public static Gtile withIncomingArrow(Gtile orig, double margin) {
        if (orig instanceof GtileEmpty) {
            return orig;
        }
        return new GtileWithIncomingArrow((AbstractGtileRoot)orig, margin);
    }

    public static Gtile withOutgoingArrow(Gtile orig, double margin) {
        if (orig instanceof GtileEmpty) {
            return orig;
        }
        return new GtileWithOutgoingArrow((AbstractGtileRoot)orig, margin);
    }
}

