/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class ElementRadioCheckbox
extends AbstractElement {
    private static final int RECTANGLE = 10;
    private static final int ELLIPSE = 10;
    private static final int ELLIPSE2 = 4;
    private final TextBlock block;
    private final int margin = 20;
    private final double stroke = 1.5;
    private final boolean radio;
    private final boolean checked;

    public ElementRadioCheckbox(List<String> text, UFont font, boolean radio, boolean checked, ISkinSimple spriteContainer) {
        FontConfiguration config = FontConfiguration.blackBlueTrue(font);
        this.block = Display.create(text).create(config, HorizontalAlignment.LEFT, spriteContainer);
        this.radio = radio;
        this.checked = checked;
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        Dimension2D dim = this.block.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dim, 20.0, 0.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        ug = ug.apply(this.getBlack());
        this.block.drawU(ug.apply(UTranslate.dx(20.0)));
        Dimension2D dim = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        double height = dim.getHeight();
        ug = ug.apply(new UStroke(1.5));
        if (this.radio) {
            this.drawRadio(ug, height);
        } else {
            this.drawOther(ug, height);
        }
    }

    private void drawOther(UGraphic ug, double height) {
        ug.apply(new UTranslate(2.0, (height - 10.0) / 2.0)).draw(new URectangle(10.0, 10.0));
        if (this.checked) {
            UPolygon poly = new UPolygon();
            poly.addPoint(0.0, 0.0);
            poly.addPoint(3.0, 3.0);
            poly.addPoint(10.0, -6.0);
            poly.addPoint(3.0, 1.0);
            ug = ug.apply(HColors.changeBack(ug));
            ug = ug.apply(new UTranslate(3.0, 6.0));
            ug.draw(poly);
        }
    }

    private void drawRadio(UGraphic ug, double height) {
        ug.apply(new UTranslate(2.0, (height - 10.0) / 2.0)).draw(new UEllipse(10.0, 10.0));
        if (this.checked) {
            ug = ug.apply(HColors.changeBack(ug));
            ug = ug.apply(new UTranslate(5.0, (height - 4.0) / 2.0));
            ug.draw(new UEllipse(4.0, 4.0));
        }
    }
}

