/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class EntityImageLollipopInterfaceEye2
extends AbstractEntityImage {
    public static final double SIZE = 14.0;
    private final TextBlock desc;
    private final TextBlock stereo;
    private final SymbolContext ctx;
    private final Url url;

    public EntityImageLollipopInterfaceEye2(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        FontParam fontParam = FontParam.COMPONENT;
        this.desc = BodyFactory.create2(skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), entity.getDisplay(), skinParam, stereotype, entity, this.getStyle(fontParam));
        this.url = entity.getUrl99();
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        HColor forecolor = HColors.BLACK;
        this.ctx = new SymbolContext(backcolor, forecolor).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing(this.getEntity().getStereotype()) ? 3.0 : 0.0);
        this.stereo = stereotype != null && stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.empty(0.0, 0.0);
    }

    private Style getStyle(FontParam fontParam) {
        return fontParam.getStyleDefinition(SName.componentDiagram).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(14.0, 14.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UEllipse circle = new UEllipse(14.0, 14.0);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            circle.setDeltaShadow(4.0);
        }
        this.ctx.apply(ug).draw(circle);
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x1 = 7.0 - dimDesc.getWidth() / 2.0;
        double y1 = 19.599999999999998;
        this.desc.drawU(ug.apply(new UTranslate(x1, 19.599999999999998)));
        Dimension2D dimStereo = this.stereo.calculateDimension(ug.getStringBounder());
        double x2 = 7.0 - dimStereo.getWidth() / 2.0;
        double y2 = -dimStereo.getHeight();
        this.stereo.drawU(ug.apply(new UTranslate(x2, y2)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

