/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.UShapeSized;

public class ULine
extends AbstractShadowable
implements UShapeSized {
    private final double dx;
    private final double dy;

    public ULine(Point2D p1, Point2D p2) {
        this(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public ULine(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public ULine rotate(double theta) {
        if (theta == 0.0) {
            return this;
        }
        AffineTransform rot = AffineTransform.getRotateInstance(theta);
        Point2D result = rot.transform(new Point2D.Double(this.dx, this.dy), null);
        return new ULine(result.getX(), result.getY());
    }

    public static ULine hline(double dx) {
        return new ULine(dx, 0.0);
    }

    public static ULine vline(double dy) {
        return new ULine(0.0, dy);
    }

    public String toString() {
        return "ULine dx=" + this.dx + " dy=" + this.dy;
    }

    public double getDX() {
        return this.dx;
    }

    public double getDY() {
        return this.dy;
    }

    public double getLength() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    @Override
    public double getWidth() {
        return this.dx;
    }

    @Override
    public double getHeight() {
        return this.dy;
    }
}

