/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public abstract class AbstractColorMapper
implements ColorMapper {
    @Override
    public final String toRGB(HColor hcolor) {
        if (hcolor == null) {
            return null;
        }
        Color color = this.toColor(hcolor);
        return StringUtils.sharp000000(color.getRGB());
    }

    @Override
    public final String toSvg(HColor hcolor) {
        if (hcolor == null) {
            return "none";
        }
        if (HColors.isTransparent(hcolor)) {
            return "#00000000";
        }
        Color color = this.toColor(hcolor);
        int alpha = color.getAlpha();
        if (alpha == 255) {
            return this.toRGB(hcolor);
        }
        String s = "0" + Integer.toHexString(alpha).toUpperCase();
        s = s.substring(s.length() - 2);
        return this.toRGB(hcolor) + s;
    }

    private static String sharpAlpha(int color) {
        int v = color & 0xFFFFFF;
        String s = "00000" + Integer.toHexString(v).toUpperCase();
        s = s.substring(s.length() - 6);
        int alpha = (int)((long)color & 0xFFL) << 24;
        String s2 = "0" + Integer.toHexString(alpha).toUpperCase();
        return "#" + s + s2.substring(0, 2);
    }
}

