"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.processResponsePayload = exports.processGlobFilter = exports.handleResponseCode = exports.createErrorFromResponse = void 0;
var minimatch_1 = __importDefault(require("minimatch"));
function createErrorFromResponse(response, prefix) {
    if (prefix === void 0) { prefix = ""; }
    var err = new Error("".concat(prefix, "Invalid response: ").concat(response.status, " ").concat(response.statusText));
    err.status = response.status;
    err.response = response;
    return err;
}
exports.createErrorFromResponse = createErrorFromResponse;
function handleResponseCode(context, response) {
    var status = response.status;
    if (status === 401 && context.digest)
        return response;
    if (status >= 400) {
        var err = createErrorFromResponse(response);
        throw err;
    }
    return response;
}
exports.handleResponseCode = handleResponseCode;
function processGlobFilter(files, glob) {
    return files.filter(function (file) { return (0, minimatch_1.default)(file.filename, glob, { matchBase: true }); });
}
exports.processGlobFilter = processGlobFilter;
function processResponsePayload(response, data, isDetailed) {
    if (isDetailed === void 0) { isDetailed = false; }
    return isDetailed
        ? {
            data: data,
            headers: response.headers || {},
            status: response.status,
            statusText: response.statusText
        }
        : data;
}
exports.processResponsePayload = processResponsePayload;
