/* App.c generated by valac 0.56.3, the Vala compiler
 * generated from App.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. <https://elementary.io>
 * Copyright 2021 Corentin Noël <tintou@noel.tf>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <gio/gdesktopappinfo.h>
#include <glib.h>
#include <meta/window.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <meta/meta-startup-notification.h>
#include <glib-object.h>
#include <sys/types.h>
#include <glib/gi18n-lib.h>

enum  {
	GALA_APP_0_PROPERTY,
	GALA_APP_ID_PROPERTY,
	GALA_APP_APP_INFO_PROPERTY,
	GALA_APP_ICON_PROPERTY,
	GALA_APP_NAME_PROPERTY,
	GALA_APP_DESCRIPTION_PROPERTY,
	GALA_APP_STATE_PROPERTY,
	GALA_APP_NUM_PROPERTIES
};
static GParamSpec* gala_app_properties[GALA_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaAppPrivate {
	GDesktopAppInfo* _app_info;
	GalaAppState _state;
	GSList* windows;
	guint interesting_windows;
	gchar* window_id_string;
	GIcon* fallback_icon;
	gint started_on_workspace;
};

static gint GalaApp_private_offset;
static gpointer gala_app_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void gala_app_sync_running_state (GalaApp* self);
static void gala_app_set_state (GalaApp* self,
                         GalaAppState value);
static MetaWindow* gala_app_get_backing_window (GalaApp* self);
static pid_t* _pid_t_dup (pid_t* self);
static void gala_app_finalize (GObject * obj);
static GType gala_app_get_type_once (void);
static void _vala_gala_app_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_gala_app_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

static GType
gala_app_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_APP_STATE_STOPPED, "GALA_APP_STATE_STOPPED", "stopped"}, {GALA_APP_STATE_STARTING, "GALA_APP_STATE_STARTING", "starting"}, {GALA_APP_STATE_RUNNING, "GALA_APP_STATE_RUNNING", "running"}, {0, NULL, NULL}};
	GType gala_app_state_type_id;
	gala_app_state_type_id = g_enum_register_static ("GalaAppState", values);
	return gala_app_state_type_id;
}

GType
gala_app_state_get_type (void)
{
	static volatile gsize gala_app_state_type_id__once = 0;
	if (g_once_init_enter (&gala_app_state_type_id__once)) {
		GType gala_app_state_type_id;
		gala_app_state_type_id = gala_app_state_get_type_once ();
		g_once_init_leave (&gala_app_state_type_id__once, gala_app_state_type_id);
	}
	return gala_app_state_type_id__once;
}

static inline gpointer
gala_app_get_instance_private (GalaApp* self)
{
	return G_STRUCT_MEMBER_P (self, GalaApp_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GalaApp*
gala_app_new_from_startup_sequence (MetaStartupSequence* sequence)
{
	const gchar* app_id = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* basename = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GalaAppSystem* appsys = NULL;
	GalaAppSystem* _tmp4_;
	GalaAppSystem* _tmp5_;
	const gchar* _tmp6_;
	GalaApp* _tmp7_;
	GalaApp* result;
	g_return_val_if_fail (sequence != NULL, NULL);
	_tmp0_ = meta_startup_sequence_get_application_id (sequence);
	app_id = _tmp0_;
	_tmp1_ = app_id;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = app_id;
	_tmp3_ = g_path_get_basename (_tmp2_);
	basename = _tmp3_;
	_tmp4_ = gala_app_system_get_default ();
	appsys = _tmp4_;
	_tmp5_ = appsys;
	_tmp6_ = basename;
	_tmp7_ = gala_app_system_lookup_app (_tmp5_, _tmp6_);
	result = _tmp7_;
	_g_free0 (basename);
	return result;
}

GalaApp*
gala_app_construct (GType object_type,
                    GDesktopAppInfo* info)
{
	GalaApp * self = NULL;
	g_return_val_if_fail (info != NULL, NULL);
	self = (GalaApp*) g_object_new (object_type, "app-info", info, NULL);
	return self;
}

GalaApp*
gala_app_new (GDesktopAppInfo* info)
{
	return gala_app_construct (GALA_TYPE_APP, info);
}

GalaApp*
gala_app_construct_for_window (GType object_type,
                               MetaWindow* window)
{
	GalaApp * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaApp*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup_printf ("window:%u", meta_window_get_stable_sequence (window));
	_g_free0 (self->priv->window_id_string);
	self->priv->window_id_string = _tmp0_;
	gala_app_add_window (self, window);
	return self;
}

GalaApp*
gala_app_new_for_window (MetaWindow* window)
{
	return gala_app_construct_for_window (GALA_TYPE_APP, window);
}

GSList*
gala_app_get_windows (GalaApp* self)
{
	GSList* _tmp0_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->windows;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_app_add_window (GalaApp* self,
                     MetaWindow* window)
{
	GSList* _tmp0_;
	GSList* _tmp1_;
	MetaWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->windows;
	_tmp1_ = g_slist_find (_tmp0_, window);
	if (_tmp1_ != NULL) {
		return;
	}
	_tmp2_ = _g_object_ref0 (window);
	self->priv->windows = g_slist_prepend (self->priv->windows, _tmp2_);
	if (!meta_window_is_skip_taskbar (window)) {
		guint _tmp3_;
		_tmp3_ = self->priv->interesting_windows;
		self->priv->interesting_windows = _tmp3_ + 1;
	}
	gala_app_sync_running_state (self);
}

static GSList*
vala_g_slist_remove_full (GSList* self,
                          gconstpointer data,
                          GFreeFunc func)
{
	GSList* l = NULL;
	GSList* result;
	l = self;
	while (TRUE) {
		GSList* _tmp0_;
		GSList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GSList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GSList* _tmp3_;
			GSList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GSList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GSList* _tmp5_;
			gconstpointer _tmp6_;
			GSList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GSList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_slist_delete_link (self, (GSList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
gala_app_remove_window (GalaApp* self,
                        MetaWindow* window)
{
	GSList* _tmp0_;
	GSList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->windows;
	_tmp1_ = g_slist_find (_tmp0_, window);
	if (_tmp1_ == NULL) {
		return;
	}
	if (!meta_window_is_skip_taskbar (window)) {
		guint _tmp2_;
		_tmp2_ = self->priv->interesting_windows;
		self->priv->interesting_windows = _tmp2_ - 1;
	}
	self->priv->windows = vala_g_slist_remove_full (self->priv->windows, window, _g_object_unref0_);
	gala_app_sync_running_state (self);
}

static void
gala_app_sync_running_state (GalaApp* self)
{
	GalaAppState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != GALA_APP_STATE_STARTING) {
		GalaAppSystem* app_sys = NULL;
		GalaAppSystem* _tmp1_;
		_tmp1_ = gala_app_system_get_default ();
		app_sys = _tmp1_;
		if (self->priv->interesting_windows == ((guint) 0)) {
			GalaAppSystem* _tmp2_;
			gala_app_set_state (self, GALA_APP_STATE_STOPPED);
			_tmp2_ = app_sys;
			gala_app_system_notify_app_state_changed (_tmp2_, self);
		} else {
			GalaAppSystem* _tmp3_;
			gala_app_set_state (self, GALA_APP_STATE_RUNNING);
			_tmp3_ = app_sys;
			gala_app_system_notify_app_state_changed (_tmp3_, self);
		}
	}
}

void
gala_app_handle_startup_sequence (GalaApp* self,
                                  MetaStartupSequence* sequence)
{
	gboolean starting = FALSE;
	gboolean _tmp0_ = FALSE;
	GalaAppSystem* app_sys = NULL;
	GalaAppSystem* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sequence != NULL);
	starting = !meta_startup_sequence_get_completed (sequence);
	if (starting) {
		GalaAppState _tmp1_;
		_tmp1_ = self->priv->_state;
		_tmp0_ = _tmp1_ == GALA_APP_STATE_STOPPED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_app_set_state (self, GALA_APP_STATE_STARTING);
	}
	if (starting) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = meta_startup_sequence_get_workspace (sequence);
		_tmp3_ = _tmp2_;
		self->priv->started_on_workspace = _tmp3_;
	} else {
		if (self->priv->interesting_windows > ((guint) 0)) {
			gala_app_set_state (self, GALA_APP_STATE_RUNNING);
		} else {
			gala_app_set_state (self, GALA_APP_STATE_STOPPED);
		}
	}
	_tmp4_ = gala_app_system_get_default ();
	app_sys = _tmp4_;
	gala_app_system_notify_app_state_changed (app_sys, self);
}

static MetaWindow*
gala_app_get_backing_window (GalaApp* self)
{
	GDesktopAppInfo* _tmp0_;
	GSList* _tmp1_;
	gconstpointer _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	_vala_return_val_if_fail (_tmp0_ == NULL, "app_info == null", NULL);
	_tmp1_ = self->priv->windows;
	_tmp2_ = _tmp1_->data;
	_tmp3_ = _g_object_ref0 ((MetaWindow*) _tmp2_);
	result = _tmp3_;
	return result;
}

static pid_t*
_pid_t_dup (pid_t* self)
{
	pid_t* dup;
	dup = g_new0 (pid_t, 1);
	memcpy (dup, self, sizeof (pid_t));
	return dup;
}

static gpointer
__pid_t_dup0 (gpointer self)
{
	return self ? _pid_t_dup (self) : NULL;
}

GSList*
gala_app_get_pids (GalaApp* self)
{
	GSList* results = NULL;
	GSList* _tmp0_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	results = NULL;
	_tmp0_ = self->priv->windows;
	{
		GSList* window_collection = NULL;
		GSList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				gint pid = 0;
				MetaWindow* _tmp1_;
				GSList* _tmp2_;
				pid_t _tmp3_;
				GSList* _tmp4_;
				_tmp1_ = window;
				pid = meta_window_get_pid (_tmp1_);
				if (pid < 1) {
					continue;
				}
				_tmp2_ = results;
				_tmp3_ = (pid_t) pid;
				_tmp4_ = g_slist_find (_tmp2_, &_tmp3_);
				if (_tmp4_ == NULL) {
					pid_t _tmp5_;
					pid_t* _tmp6_;
					_tmp5_ = (pid_t) pid;
					_tmp6_ = __pid_t_dup0 (&_tmp5_);
					results = g_slist_prepend (results, _tmp6_);
				}
			}
		}
	}
	result = results;
	return result;
}

const gchar*
gala_app_get_id (GalaApp* self)
{
	const gchar* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	if (_tmp0_ != NULL) {
		GDesktopAppInfo* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->_app_info;
		_tmp2_ = g_app_info_get_id ((GAppInfo*) _tmp1_);
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->window_id_string;
		result = _tmp3_;
		return result;
	}
}

GDesktopAppInfo*
gala_app_get_app_info (GalaApp* self)
{
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static void
gala_app_set_app_info (GalaApp* self,
                       GDesktopAppInfo* value)
{
	GDesktopAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_app_get_app_info (self);
	if (old_value != value) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_app_properties[GALA_APP_APP_INFO_PROPERTY]);
	}
}

GIcon*
gala_app_get_icon (GalaApp* self)
{
	GIcon* result;
	GDesktopAppInfo* _tmp0_;
	GIcon* _tmp3_;
	GIcon* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	if (_tmp0_ != NULL) {
		GDesktopAppInfo* _tmp1_;
		GIcon* _tmp2_;
		_tmp1_ = self->priv->_app_info;
		_tmp2_ = g_app_info_get_icon ((GAppInfo*) _tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->fallback_icon;
	if (_tmp3_ == NULL) {
		GThemedIcon* _tmp4_;
		_tmp4_ = (GThemedIcon*) g_themed_icon_new ("application-x-executable");
		_g_object_unref0 (self->priv->fallback_icon);
		self->priv->fallback_icon = (GIcon*) _tmp4_;
	}
	_tmp5_ = self->priv->fallback_icon;
	result = _tmp5_;
	return result;
}

const gchar*
gala_app_get_name (GalaApp* self)
{
	const gchar* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	if (_tmp0_ != NULL) {
		GDesktopAppInfo* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->_app_info;
		_tmp2_ = g_app_info_get_name ((GAppInfo*) _tmp1_);
		result = _tmp2_;
		return result;
	} else {
		const gchar* name = NULL;
		MetaWindow* window = NULL;
		MetaWindow* _tmp3_;
		MetaWindow* _tmp4_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		name = NULL;
		_tmp3_ = gala_app_get_backing_window (self);
		window = _tmp3_;
		_tmp4_ = window;
		if (_tmp4_ != NULL) {
			MetaWindow* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = window;
			_tmp6_ = meta_window_get_wm_class (_tmp5_);
			name = _tmp6_;
		}
		_tmp8_ = name;
		_tmp7_ = _tmp8_;
		if (_tmp7_ == NULL) {
			_tmp7_ = C_ ("program", "Unknown");
		}
		result = _tmp7_;
		_g_object_unref0 (window);
		return result;
	}
}

const gchar*
gala_app_get_description (GalaApp* self)
{
	const gchar* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	if (_tmp0_ != NULL) {
		GDesktopAppInfo* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->_app_info;
		_tmp2_ = g_app_info_get_description ((GAppInfo*) _tmp1_);
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

GalaAppState
gala_app_get_state (GalaApp* self)
{
	GalaAppState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
gala_app_set_state (GalaApp* self,
                    GalaAppState value)
{
	GalaAppState old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_app_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, gala_app_properties[GALA_APP_STATE_PROPERTY]);
	}
}

static void
gala_app_class_init (GalaAppClass * klass,
                     gpointer klass_data)
{
	gala_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaApp_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_app_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_app_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_app_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_APP_ID_PROPERTY, gala_app_properties[GALA_APP_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_APP_APP_INFO_PROPERTY, gala_app_properties[GALA_APP_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_APP_ICON_PROPERTY, gala_app_properties[GALA_APP_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_APP_NAME_PROPERTY, gala_app_properties[GALA_APP_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_APP_DESCRIPTION_PROPERTY, gala_app_properties[GALA_APP_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_APP_STATE_PROPERTY, gala_app_properties[GALA_APP_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", GALA_TYPE_APP_STATE, GALA_APP_STATE_STOPPED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_app_instance_init (GalaApp * self,
                        gpointer klass)
{
	self->priv = gala_app_get_instance_private (self);
	self->priv->_state = GALA_APP_STATE_STOPPED;
	self->priv->windows = NULL;
	self->priv->interesting_windows = (guint) 0;
	self->priv->window_id_string = NULL;
	self->priv->fallback_icon = NULL;
}

static void
gala_app_finalize (GObject * obj)
{
	GalaApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_APP, GalaApp);
	_g_object_unref0 (self->priv->_app_info);
	(self->priv->windows == NULL) ? NULL : (self->priv->windows = (_g_slist_free__g_object_unref0_ (self->priv->windows), NULL));
	_g_free0 (self->priv->window_id_string);
	_g_object_unref0 (self->priv->fallback_icon);
	G_OBJECT_CLASS (gala_app_parent_class)->finalize (obj);
}

static GType
gala_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaApp), 0, (GInstanceInitFunc) gala_app_instance_init, NULL };
	GType gala_app_type_id;
	gala_app_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaApp", &g_define_type_info, 0);
	GalaApp_private_offset = g_type_add_instance_private (gala_app_type_id, sizeof (GalaAppPrivate));
	return gala_app_type_id;
}

GType
gala_app_get_type (void)
{
	static volatile gsize gala_app_type_id__once = 0;
	if (g_once_init_enter (&gala_app_type_id__once)) {
		GType gala_app_type_id;
		gala_app_type_id = gala_app_get_type_once ();
		g_once_init_leave (&gala_app_type_id__once, gala_app_type_id);
	}
	return gala_app_type_id__once;
}

static void
_vala_gala_app_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	GalaApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_APP, GalaApp);
	switch (property_id) {
		case GALA_APP_ID_PROPERTY:
		g_value_set_string (value, gala_app_get_id (self));
		break;
		case GALA_APP_APP_INFO_PROPERTY:
		g_value_set_object (value, gala_app_get_app_info (self));
		break;
		case GALA_APP_ICON_PROPERTY:
		g_value_set_object (value, gala_app_get_icon (self));
		break;
		case GALA_APP_NAME_PROPERTY:
		g_value_set_string (value, gala_app_get_name (self));
		break;
		case GALA_APP_DESCRIPTION_PROPERTY:
		g_value_set_string (value, gala_app_get_description (self));
		break;
		case GALA_APP_STATE_PROPERTY:
		g_value_set_enum (value, gala_app_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_app_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	GalaApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_APP, GalaApp);
	switch (property_id) {
		case GALA_APP_APP_INFO_PROPERTY:
		gala_app_set_app_info (self, g_value_get_object (value));
		break;
		case GALA_APP_STATE_PROPERTY:
		gala_app_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

