/* SelectionArea.c generated by valac 0.56.3, the Vala compiler
 * generated from SelectionArea.vala, do not modify */

/**/
/*  Copyright (C) 2017 Santiago León O., Adam Bieńkowski*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <gdk/gdk.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/common.h>
#include <stdlib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_SELECTION_AREA (gala_selection_area_get_type ())
#define GALA_SELECTION_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SELECTION_AREA, GalaSelectionArea))
#define GALA_SELECTION_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SELECTION_AREA, GalaSelectionAreaClass))
#define GALA_IS_SELECTION_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SELECTION_AREA))
#define GALA_IS_SELECTION_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SELECTION_AREA))
#define GALA_SELECTION_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SELECTION_AREA, GalaSelectionAreaClass))

typedef struct _GalaSelectionArea GalaSelectionArea;
typedef struct _GalaSelectionAreaClass GalaSelectionAreaClass;
typedef struct _GalaSelectionAreaPrivate GalaSelectionAreaPrivate;
enum  {
	GALA_SELECTION_AREA_0_PROPERTY,
	GALA_SELECTION_AREA_WM_PROPERTY,
	GALA_SELECTION_AREA_CANCELLED_PROPERTY,
	GALA_SELECTION_AREA_NUM_PROPERTIES
};
static GParamSpec* gala_selection_area_properties[GALA_SELECTION_AREA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_SELECTION_AREA_CLOSED_SIGNAL,
	GALA_SELECTION_AREA_NUM_SIGNALS
};
static guint gala_selection_area_signals[GALA_SELECTION_AREA_NUM_SIGNALS] = {0};

struct _GalaSelectionArea {
	ClutterActor parent_instance;
	GalaSelectionAreaPrivate * priv;
};

struct _GalaSelectionAreaClass {
	ClutterActorClass parent_class;
};

struct _GalaSelectionAreaPrivate {
	GalaWindowManager* _wm;
	gboolean _cancelled;
	GalaModalProxy* modal_proxy;
	GdkPoint start_point;
	GdkPoint end_point;
	gboolean dragging;
	gboolean clicked;
};

static gint GalaSelectionArea_private_offset;
static gpointer gala_selection_area_parent_class = NULL;

VALA_EXTERN GType gala_selection_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaSelectionArea, g_object_unref)
VALA_EXTERN GalaSelectionArea* gala_selection_area_new (GalaWindowManager* wm);
VALA_EXTERN GalaSelectionArea* gala_selection_area_construct (GType object_type,
                                                  GalaWindowManager* wm);
static gboolean gala_selection_area_real_key_press_event (ClutterActor* base,
                                                   ClutterKeyEvent* e);
VALA_EXTERN void gala_selection_area_close (GalaSelectionArea* self);
static void gala_selection_area_set_cancelled (GalaSelectionArea* self,
                                        gboolean value);
static gboolean gala_selection_area_real_button_press_event (ClutterActor* base,
                                                      ClutterButtonEvent* e);
static gboolean gala_selection_area_real_button_release_event (ClutterActor* base,
                                                        ClutterButtonEvent* e);
static gboolean gala_selection_area_real_motion_event (ClutterActor* base,
                                                ClutterMotionEvent* e);
VALA_EXTERN GalaWindowManager* gala_selection_area_get_wm (GalaSelectionArea* self);
VALA_EXTERN void gala_selection_area_start_selection (GalaSelectionArea* self);
VALA_EXTERN void gala_selection_area_get_selection_rectangle (GalaSelectionArea* self,
                                                  gint* x,
                                                  gint* y,
                                                  gint* width,
                                                  gint* height);
static gboolean gala_selection_area_draw_area (GalaSelectionArea* self,
                                        cairo_t* ctx);
static void gala_selection_area_set_wm (GalaSelectionArea* self,
                                 GalaWindowManager* value);
VALA_EXTERN gboolean gala_selection_area_get_cancelled (GalaSelectionArea* self);
static GObject * gala_selection_area_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static gboolean _gala_selection_area_draw_area_clutter_canvas_draw (ClutterCanvas* _sender,
                                                             cairo_t* cr,
                                                             gint width,
                                                             gint height,
                                                             gpointer self);
static void gala_selection_area_finalize (GObject * obj);
static GType gala_selection_area_get_type_once (void);
static void _vala_gala_selection_area_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gala_selection_area_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_selection_area_get_instance_private (GalaSelectionArea* self)
{
	return G_STRUCT_MEMBER_P (self, GalaSelectionArea_private_offset);
}

GalaSelectionArea*
gala_selection_area_construct (GType object_type,
                               GalaWindowManager* wm)
{
	GalaSelectionArea * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaSelectionArea*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaSelectionArea*
gala_selection_area_new (GalaWindowManager* wm)
{
	return gala_selection_area_construct (GALA_TYPE_SELECTION_AREA, wm);
}

static gboolean
gala_selection_area_real_key_press_event (ClutterActor* base,
                                          ClutterKeyEvent* e)
{
	GalaSelectionArea * self;
	gboolean result;
	self = (GalaSelectionArea*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->keyval == CLUTTER_KEY_Escape) {
		gala_selection_area_close (self);
		gala_selection_area_set_cancelled (self, TRUE);
		g_signal_emit (self, gala_selection_area_signals[GALA_SELECTION_AREA_CLOSED_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
gala_selection_area_real_button_press_event (ClutterActor* base,
                                             ClutterButtonEvent* e)
{
	GalaSelectionArea * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (GalaSelectionArea*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (self->priv->dragging) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = e->button != ((guint32) 1);
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	self->priv->clicked = TRUE;
	self->priv->start_point.x = (gint) e->x;
	self->priv->start_point.y = (gint) e->y;
	result = TRUE;
	return result;
}

static gboolean
gala_selection_area_real_button_release_event (ClutterActor* base,
                                               ClutterButtonEvent* e)
{
	GalaSelectionArea * self;
	ClutterContent* _tmp0_;
	ClutterContent* _tmp1_;
	gboolean result;
	self = (GalaSelectionArea*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint32) 1)) {
		result = TRUE;
		return result;
	}
	if (!self->priv->dragging) {
		gala_selection_area_close (self);
		gala_selection_area_set_cancelled (self, TRUE);
		g_signal_emit (self, gala_selection_area_signals[GALA_SELECTION_AREA_CLOSED_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	self->priv->dragging = FALSE;
	self->priv->clicked = FALSE;
	gala_selection_area_close (self);
	clutter_actor_hide ((ClutterActor*) self);
	_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	clutter_content_invalidate (_tmp1_);
	g_signal_emit (self, gala_selection_area_signals[GALA_SELECTION_AREA_CLOSED_SIGNAL], 0);
	result = TRUE;
	return result;
}

static gboolean
gala_selection_area_real_motion_event (ClutterActor* base,
                                       ClutterMotionEvent* e)
{
	GalaSelectionArea * self;
	ClutterContent* _tmp0_;
	ClutterContent* _tmp1_;
	gboolean result;
	self = (GalaSelectionArea*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (!self->priv->clicked) {
		result = TRUE;
		return result;
	}
	self->priv->end_point.x = (gint) e->x;
	self->priv->end_point.y = (gint) e->y;
	_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	clutter_content_invalidate (_tmp1_);
	if (!self->priv->dragging) {
		self->priv->dragging = TRUE;
	}
	result = TRUE;
	return result;
}

void
gala_selection_area_close (GalaSelectionArea* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaModalProxy* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_set_cursor (_tmp1_, META_CURSOR_DEFAULT);
	_tmp2_ = self->priv->modal_proxy;
	if (_tmp2_ != NULL) {
		GalaWindowManager* _tmp3_;
		GalaModalProxy* _tmp4_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = self->priv->modal_proxy;
		gala_window_manager_pop_modal (_tmp3_, _tmp4_);
	}
}

void
gala_selection_area_start_selection (GalaSelectionArea* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowManager* _tmp2_;
	GalaModalProxy* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_set_cursor (_tmp1_, META_CURSOR_CROSSHAIR);
	clutter_actor_grab_key_focus ((ClutterActor*) self);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = gala_window_manager_push_modal (_tmp2_, (ClutterActor*) self);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp3_;
}

void
gala_selection_area_get_selection_rectangle (GalaSelectionArea* self,
                                             gint* x,
                                             gint* y,
                                             gint* width,
                                             gint* height)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	GdkPoint _tmp2_;
	GdkPoint _tmp3_;
	GdkPoint _tmp4_;
	GdkPoint _tmp5_;
	GdkPoint _tmp6_;
	GdkPoint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->start_point;
	_tmp1_ = self->priv->end_point;
	_vala_x = MIN (_tmp0_.x, _tmp1_.x);
	_tmp2_ = self->priv->start_point;
	_tmp3_ = self->priv->end_point;
	_vala_y = MIN (_tmp2_.y, _tmp3_.y);
	_tmp4_ = self->priv->start_point;
	_tmp5_ = self->priv->end_point;
	_vala_width = abs (_tmp4_.x - _tmp5_.x);
	_tmp6_ = self->priv->start_point;
	_tmp7_ = self->priv->end_point;
	_vala_height = abs (_tmp6_.y - _tmp7_.y);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static gboolean
gala_selection_area_draw_area (GalaSelectionArea* self,
                               cairo_t* ctx)
{
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	clutter_cairo_clear (ctx);
	if (!self->priv->dragging) {
		result = TRUE;
		return result;
	}
	cairo_translate (ctx, 0.5, 0.5);
	gala_selection_area_get_selection_rectangle (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	cairo_rectangle (ctx, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	cairo_set_source_rgba (ctx, 0.1, 0.1, 0.1, 0.2);
	cairo_fill (ctx);
	cairo_rectangle (ctx, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	cairo_set_source_rgb (ctx, 0.7, 0.7, 0.7);
	cairo_set_line_width (ctx, 1.0);
	cairo_stroke (ctx);
	result = TRUE;
	return result;
}

GalaWindowManager*
gala_selection_area_get_wm (GalaSelectionArea* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_selection_area_set_wm (GalaSelectionArea* self,
                            GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_selection_area_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_selection_area_properties[GALA_SELECTION_AREA_WM_PROPERTY]);
	}
}

gboolean
gala_selection_area_get_cancelled (GalaSelectionArea* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_cancelled;
	return result;
}

static void
gala_selection_area_set_cancelled (GalaSelectionArea* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_selection_area_get_cancelled (self);
	if (old_value != value) {
		self->priv->_cancelled = value;
		g_object_notify_by_pspec ((GObject *) self, gala_selection_area_properties[GALA_SELECTION_AREA_CANCELLED_PROPERTY]);
	}
}

static gboolean
_gala_selection_area_draw_area_clutter_canvas_draw (ClutterCanvas* _sender,
                                                    cairo_t* cr,
                                                    gint width,
                                                    gint height,
                                                    gpointer self)
{
	gboolean result;
	result = gala_selection_area_draw_area ((GalaSelectionArea*) self, cr);
	return result;
}

static GObject *
gala_selection_area_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaSelectionArea * self;
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	gint screen_width = 0;
	gint screen_height = 0;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	ClutterCanvas* canvas = NULL;
	ClutterCanvas* _tmp6_;
	ClutterCanvas* _tmp7_;
	ClutterCanvas* _tmp8_;
	ClutterCanvas* _tmp9_;
	ClutterCanvas* _tmp10_;
	parent_class = G_OBJECT_CLASS (gala_selection_area_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SELECTION_AREA, GalaSelectionArea);
	_tmp0_.x = 0;
	_tmp0_.y = 0;
	self->priv->start_point = _tmp0_;
	_tmp1_.x = 0;
	_tmp1_.y = 0;
	self->priv->end_point = _tmp1_;
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	meta_display_get_size (_tmp3_, &_tmp4_, &_tmp5_);
	screen_width = _tmp4_;
	screen_height = _tmp5_;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) screen_width);
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) screen_height);
	_tmp6_ = (ClutterCanvas*) clutter_canvas_new ();
	canvas = _tmp6_;
	_tmp7_ = canvas;
	clutter_canvas_set_size (_tmp7_, screen_width, screen_height);
	_tmp8_ = canvas;
	g_signal_connect_object (_tmp8_, "draw", (GCallback) _gala_selection_area_draw_area_clutter_canvas_draw, self, 0);
	_tmp9_ = canvas;
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) _tmp9_);
	_tmp10_ = canvas;
	clutter_content_invalidate ((ClutterContent*) _tmp10_);
	_g_object_unref0 (canvas);
	return obj;
}

static void
gala_selection_area_class_init (GalaSelectionAreaClass * klass,
                                gpointer klass_data)
{
	gala_selection_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaSelectionArea_private_offset);
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterKeyEvent*)) gala_selection_area_real_key_press_event;
	((ClutterActorClass *) klass)->button_press_event = (gboolean (*) (ClutterActor*, ClutterButtonEvent*)) gala_selection_area_real_button_press_event;
	((ClutterActorClass *) klass)->button_release_event = (gboolean (*) (ClutterActor*, ClutterButtonEvent*)) gala_selection_area_real_button_release_event;
	((ClutterActorClass *) klass)->motion_event = (gboolean (*) (ClutterActor*, ClutterMotionEvent*)) gala_selection_area_real_motion_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_selection_area_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_selection_area_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_selection_area_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_selection_area_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SELECTION_AREA_WM_PROPERTY, gala_selection_area_properties[GALA_SELECTION_AREA_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SELECTION_AREA_CANCELLED_PROPERTY, gala_selection_area_properties[GALA_SELECTION_AREA_CANCELLED_PROPERTY] = g_param_spec_boolean ("cancelled", "cancelled", "cancelled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_selection_area_signals[GALA_SELECTION_AREA_CLOSED_SIGNAL] = g_signal_new ("closed", GALA_TYPE_SELECTION_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_selection_area_instance_init (GalaSelectionArea * self,
                                   gpointer klass)
{
	self->priv = gala_selection_area_get_instance_private (self);
	self->priv->dragging = FALSE;
	self->priv->clicked = FALSE;
}

static void
gala_selection_area_finalize (GObject * obj)
{
	GalaSelectionArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SELECTION_AREA, GalaSelectionArea);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->modal_proxy);
	G_OBJECT_CLASS (gala_selection_area_parent_class)->finalize (obj);
}

static GType
gala_selection_area_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaSelectionAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_selection_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaSelectionArea), 0, (GInstanceInitFunc) gala_selection_area_instance_init, NULL };
	GType gala_selection_area_type_id;
	gala_selection_area_type_id = g_type_register_static (clutter_actor_get_type (), "GalaSelectionArea", &g_define_type_info, 0);
	GalaSelectionArea_private_offset = g_type_add_instance_private (gala_selection_area_type_id, sizeof (GalaSelectionAreaPrivate));
	return gala_selection_area_type_id;
}

GType
gala_selection_area_get_type (void)
{
	static volatile gsize gala_selection_area_type_id__once = 0;
	if (g_once_init_enter (&gala_selection_area_type_id__once)) {
		GType gala_selection_area_type_id;
		gala_selection_area_type_id = gala_selection_area_get_type_once ();
		g_once_init_leave (&gala_selection_area_type_id__once, gala_selection_area_type_id);
	}
	return gala_selection_area_type_id__once;
}

static void
_vala_gala_selection_area_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GalaSelectionArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SELECTION_AREA, GalaSelectionArea);
	switch (property_id) {
		case GALA_SELECTION_AREA_WM_PROPERTY:
		g_value_set_object (value, gala_selection_area_get_wm (self));
		break;
		case GALA_SELECTION_AREA_CANCELLED_PROPERTY:
		g_value_set_boolean (value, gala_selection_area_get_cancelled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_selection_area_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GalaSelectionArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SELECTION_AREA, GalaSelectionArea);
	switch (property_id) {
		case GALA_SELECTION_AREA_WM_PROPERTY:
		gala_selection_area_set_wm (self, g_value_get_object (value));
		break;
		case GALA_SELECTION_AREA_CANCELLED_PROPERTY:
		gala_selection_area_set_cancelled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

