/* accounts-autoconfig.c generated by valac 0.56.3, the Vala compiler
 * generated from accounts-autoconfig.vala, do not modify */

/*
 * Copyright 2022 Cédric Bellegarde <cedric.bellegarde@adishatz.org>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-engine.h"
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include "geary-client-43.0.h"

#define ACCOUNTS_TYPE_AUTO_CONFIG_VALUES (accounts_auto_config_values_get_type ())
#define ACCOUNTS_AUTO_CONFIG_VALUES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ACCOUNTS_TYPE_AUTO_CONFIG_VALUES, AccountsAutoConfigValues))
#define ACCOUNTS_AUTO_CONFIG_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ACCOUNTS_TYPE_AUTO_CONFIG_VALUES, AccountsAutoConfigValuesClass))
#define ACCOUNTS_IS_AUTO_CONFIG_VALUES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ACCOUNTS_TYPE_AUTO_CONFIG_VALUES))
#define ACCOUNTS_IS_AUTO_CONFIG_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ACCOUNTS_TYPE_AUTO_CONFIG_VALUES))
#define ACCOUNTS_AUTO_CONFIG_VALUES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ACCOUNTS_TYPE_AUTO_CONFIG_VALUES, AccountsAutoConfigValuesClass))

typedef struct _AccountsAutoConfigValues AccountsAutoConfigValues;
typedef struct _AccountsAutoConfigValuesClass AccountsAutoConfigValuesClass;
typedef struct _AccountsAutoConfigValuesPrivate AccountsAutoConfigValuesPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AccountsParamSpecAutoConfigValues AccountsParamSpecAutoConfigValues;

#define ACCOUNTS_TYPE_AUTO_CONFIG_ERROR (accounts_auto_config_error_get_type ())

#define ACCOUNTS_TYPE_AUTO_CONFIG (accounts_auto_config_get_type ())
#define ACCOUNTS_AUTO_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ACCOUNTS_TYPE_AUTO_CONFIG, AccountsAutoConfig))
#define ACCOUNTS_AUTO_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ACCOUNTS_TYPE_AUTO_CONFIG, AccountsAutoConfigClass))
#define ACCOUNTS_IS_AUTO_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ACCOUNTS_TYPE_AUTO_CONFIG))
#define ACCOUNTS_IS_AUTO_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ACCOUNTS_TYPE_AUTO_CONFIG))
#define ACCOUNTS_AUTO_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ACCOUNTS_TYPE_AUTO_CONFIG, AccountsAutoConfigClass))

typedef struct _AccountsAutoConfig AccountsAutoConfig;
typedef struct _AccountsAutoConfigClass AccountsAutoConfigClass;
typedef struct _AccountsAutoConfigPrivate AccountsAutoConfigPrivate;
#define _accounts_auto_config_values_unref0(var) ((var == NULL) ? NULL : (var = (accounts_auto_config_values_unref (var), NULL)))
#define _accounts_auto_config_unref0(var) ((var == NULL) ? NULL : (var = (accounts_auto_config_unref (var), NULL)))
typedef struct _AccountsAutoConfigGetConfigData AccountsAutoConfigGetConfigData;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AccountsAutoConfigGetConfigForUriData AccountsAutoConfigGetConfigForUriData;
typedef struct _AccountsParamSpecAutoConfig AccountsParamSpecAutoConfig;

struct _AccountsAutoConfigValues {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AccountsAutoConfigValuesPrivate * priv;
};

struct _AccountsAutoConfigValuesClass {
	GTypeClass parent_class;
	void (*finalize) (AccountsAutoConfigValues *self);
};

struct _AccountsAutoConfigValuesPrivate {
	gchar* _id;
	gchar* _imap_server;
	gchar* _imap_port;
	GearyTlsNegotiationMethod _imap_tls_method;
	gchar* _smtp_server;
	gchar* _smtp_port;
	GearyTlsNegotiationMethod _smtp_tls_method;
};

struct _AccountsParamSpecAutoConfigValues {
	GParamSpec parent_instance;
};

typedef enum  {
	ACCOUNTS_AUTO_CONFIG_ERROR_ERROR
} AccountsAutoConfigError;
#define ACCOUNTS_AUTO_CONFIG_ERROR accounts_auto_config_error_quark ()

struct _AccountsAutoConfig {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AccountsAutoConfigPrivate * priv;
};

struct _AccountsAutoConfigClass {
	GTypeClass parent_class;
	void (*finalize) (AccountsAutoConfig *self);
};

struct _AccountsAutoConfigPrivate {
	GCancellable* cancellable;
};

struct _AccountsAutoConfigGetConfigData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsAutoConfig* self;
	gchar* hostname;
	AccountsAutoConfigValues* result;
	AccountsAutoConfigValues* auto_config_values;
	AccountsAutoConfigValues* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	AccountsAutoConfigValues* _tmp6_;
	AccountsAutoConfigValues* _tmp7_;
	AccountsAutoConfigValues* _tmp8_;
	AccountsAutoConfigValues* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	AccountsAutoConfigValues* _tmp13_;
	AccountsAutoConfigValues* _tmp14_;
	AccountsAutoConfigValues* _tmp15_;
	GError* _inner_error0_;
};

struct _AccountsAutoConfigGetConfigForUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsAutoConfig* self;
	gchar* uri;
	AccountsAutoConfigValues* result;
	GInputStream* stream;
	SoupSession* session;
	SoupSession* _tmp0_;
	SoupMessage* msg;
	SoupMessage* _tmp1_;
	GInputStream* _tmp2_;
	SoupSession* _tmp3_;
	SoupMessage* _tmp4_;
	GCancellable* _tmp5_;
	GInputStream* _tmp6_;
	GInputStream* _tmp7_;
	GError* err;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GMemoryOutputStream* stdout_stream;
	GMemoryOutputStream* _tmp11_;
	GMemoryOutputStream* _tmp12_;
	GInputStream* _tmp13_;
	GMemoryOutputStream* _tmp14_;
	guint8* _tmp15_;
	gint _tmp15__length1;
	gint _tmp16_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	GMemoryOutputStream* _tmp18_;
	const gchar* xml_data;
	GMemoryOutputStream* _tmp19_;
	guint8* _tmp20_;
	AccountsAutoConfigValues* _tmp21_;
	const gchar* _tmp22_;
	AccountsAutoConfigValues* _tmp23_;
	AccountsAutoConfigValues* _tmp24_;
	GInputStream* _tmp25_;
	GError* _vala1_err;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _tmp28_;
	GError* _inner_error1_;
	GInputStream* _tmp29_;
	GError* _inner_error0_;
};

struct _AccountsParamSpecAutoConfig {
	GParamSpec parent_instance;
};

static gint AccountsAutoConfigValues_private_offset;
static gpointer accounts_auto_config_values_parent_class = NULL;
static gint AccountsAutoConfig_private_offset;
static gpointer accounts_auto_config_parent_class = NULL;
static gchar* accounts_auto_config_AUTOCONFIG_BASE_URI;
static gchar* accounts_auto_config_AUTOCONFIG_BASE_URI = NULL;
static gchar* accounts_auto_config_AUTOCONFIG_PATH;
static gchar* accounts_auto_config_AUTOCONFIG_PATH = NULL;

VALA_EXTERN gpointer accounts_auto_config_values_ref (gpointer instance);
VALA_EXTERN void accounts_auto_config_values_unref (gpointer instance);
VALA_EXTERN GParamSpec* accounts_param_spec_auto_config_values (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void accounts_value_set_auto_config_values (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void accounts_value_take_auto_config_values (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer accounts_value_get_auto_config_values (const GValue* value);
VALA_EXTERN GType accounts_auto_config_values_get_type (void) G_GNUC_CONST ;
VALA_EXTERN const gchar* accounts_auto_config_values_get_id (AccountsAutoConfigValues* self);
VALA_EXTERN void accounts_auto_config_values_set_id (AccountsAutoConfigValues* self,
                                         const gchar* value);
VALA_EXTERN const gchar* accounts_auto_config_values_get_imap_server (AccountsAutoConfigValues* self);
VALA_EXTERN void accounts_auto_config_values_set_imap_server (AccountsAutoConfigValues* self,
                                                  const gchar* value);
VALA_EXTERN const gchar* accounts_auto_config_values_get_imap_port (AccountsAutoConfigValues* self);
VALA_EXTERN void accounts_auto_config_values_set_imap_port (AccountsAutoConfigValues* self,
                                                const gchar* value);
VALA_EXTERN GearyTlsNegotiationMethod accounts_auto_config_values_get_imap_tls_method (AccountsAutoConfigValues* self);
VALA_EXTERN void accounts_auto_config_values_set_imap_tls_method (AccountsAutoConfigValues* self,
                                                      GearyTlsNegotiationMethod value);
VALA_EXTERN const gchar* accounts_auto_config_values_get_smtp_server (AccountsAutoConfigValues* self);
VALA_EXTERN void accounts_auto_config_values_set_smtp_server (AccountsAutoConfigValues* self,
                                                  const gchar* value);
VALA_EXTERN const gchar* accounts_auto_config_values_get_smtp_port (AccountsAutoConfigValues* self);
VALA_EXTERN void accounts_auto_config_values_set_smtp_port (AccountsAutoConfigValues* self,
                                                const gchar* value);
VALA_EXTERN GearyTlsNegotiationMethod accounts_auto_config_values_get_smtp_tls_method (AccountsAutoConfigValues* self);
VALA_EXTERN void accounts_auto_config_values_set_smtp_tls_method (AccountsAutoConfigValues* self,
                                                      GearyTlsNegotiationMethod value);
VALA_EXTERN AccountsAutoConfigValues* accounts_auto_config_values_new (void);
VALA_EXTERN AccountsAutoConfigValues* accounts_auto_config_values_construct (GType object_type);
static void accounts_auto_config_values_finalize (AccountsAutoConfigValues * obj);
static GType accounts_auto_config_values_get_type_once (void);
VALA_EXTERN GQuark accounts_auto_config_error_quark (void);
GType accounts_auto_config_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer accounts_auto_config_ref (gpointer instance);
VALA_EXTERN void accounts_auto_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* accounts_param_spec_auto_config (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void accounts_value_set_auto_config (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void accounts_value_take_auto_config (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer accounts_value_get_auto_config (const GValue* value);
VALA_EXTERN GType accounts_auto_config_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AccountsAutoConfig* accounts_auto_config_new (GCancellable* auto_config_cancellable);
VALA_EXTERN AccountsAutoConfig* accounts_auto_config_construct (GType object_type,
                                                    GCancellable* auto_config_cancellable);
static void accounts_auto_config_get_config_data_free (gpointer _data);
VALA_EXTERN void accounts_auto_config_get_config (AccountsAutoConfig* self,
                                      const gchar* hostname,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN AccountsAutoConfigValues* accounts_auto_config_get_config_finish (AccountsAutoConfig* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static gboolean accounts_auto_config_get_config_co (AccountsAutoConfigGetConfigData* _data_);
static void accounts_auto_config_get_config_for_uri (AccountsAutoConfig* self,
                                              const gchar* uri,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static AccountsAutoConfigValues* accounts_auto_config_get_config_for_uri_finish (AccountsAutoConfig* self,
                                                                          GAsyncResult* _res_,
                                                                          GError** error);
static void accounts_auto_config_get_config_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void accounts_auto_config_get_config_for_uri_data_free (gpointer _data);
static gboolean accounts_auto_config_get_config_for_uri_co (AccountsAutoConfigGetConfigForUriData* _data_);
static void accounts_auto_config_get_config_for_uri_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static AccountsAutoConfigValues* accounts_auto_config_get_config_for_xml (AccountsAutoConfig* self,
                                                                   const gchar* xml_data,
                                                                   GError** error);
static xmlNode* accounts_auto_config_get_node (AccountsAutoConfig* self,
                                        xmlNode* root,
                                        const gchar* name);
static gchar* accounts_auto_config_get_node_value (AccountsAutoConfig* self,
                                            xmlNode* root,
                                            const gchar* name);
static GearyTlsNegotiationMethod accounts_auto_config_get_tls_method (AccountsAutoConfig* self,
                                                               const gchar* method);
static void accounts_auto_config_finalize (AccountsAutoConfig * obj);
static GType accounts_auto_config_get_type_once (void);

static inline gpointer
accounts_auto_config_values_get_instance_private (AccountsAutoConfigValues* self)
{
	return G_STRUCT_MEMBER_P (self, AccountsAutoConfigValues_private_offset);
}

const gchar*
accounts_auto_config_values_get_id (AccountsAutoConfigValues* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self), NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

void
accounts_auto_config_values_set_id (AccountsAutoConfigValues* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp0_;
}

const gchar*
accounts_auto_config_values_get_imap_server (AccountsAutoConfigValues* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self), NULL);
	_tmp0_ = self->priv->_imap_server;
	result = _tmp0_;
	return result;
}

void
accounts_auto_config_values_set_imap_server (AccountsAutoConfigValues* self,
                                             const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_imap_server);
	self->priv->_imap_server = _tmp0_;
}

const gchar*
accounts_auto_config_values_get_imap_port (AccountsAutoConfigValues* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self), NULL);
	_tmp0_ = self->priv->_imap_port;
	result = _tmp0_;
	return result;
}

void
accounts_auto_config_values_set_imap_port (AccountsAutoConfigValues* self,
                                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_imap_port);
	self->priv->_imap_port = _tmp0_;
}

GearyTlsNegotiationMethod
accounts_auto_config_values_get_imap_tls_method (AccountsAutoConfigValues* self)
{
	GearyTlsNegotiationMethod result;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self), 0);
	result = self->priv->_imap_tls_method;
	return result;
}

void
accounts_auto_config_values_set_imap_tls_method (AccountsAutoConfigValues* self,
                                                 GearyTlsNegotiationMethod value)
{
	g_return_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self));
	self->priv->_imap_tls_method = value;
}

const gchar*
accounts_auto_config_values_get_smtp_server (AccountsAutoConfigValues* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self), NULL);
	_tmp0_ = self->priv->_smtp_server;
	result = _tmp0_;
	return result;
}

void
accounts_auto_config_values_set_smtp_server (AccountsAutoConfigValues* self,
                                             const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_smtp_server);
	self->priv->_smtp_server = _tmp0_;
}

const gchar*
accounts_auto_config_values_get_smtp_port (AccountsAutoConfigValues* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self), NULL);
	_tmp0_ = self->priv->_smtp_port;
	result = _tmp0_;
	return result;
}

void
accounts_auto_config_values_set_smtp_port (AccountsAutoConfigValues* self,
                                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_smtp_port);
	self->priv->_smtp_port = _tmp0_;
}

GearyTlsNegotiationMethod
accounts_auto_config_values_get_smtp_tls_method (AccountsAutoConfigValues* self)
{
	GearyTlsNegotiationMethod result;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self), 0);
	result = self->priv->_smtp_tls_method;
	return result;
}

void
accounts_auto_config_values_set_smtp_tls_method (AccountsAutoConfigValues* self,
                                                 GearyTlsNegotiationMethod value)
{
	g_return_if_fail (ACCOUNTS_IS_AUTO_CONFIG_VALUES (self));
	self->priv->_smtp_tls_method = value;
}

AccountsAutoConfigValues*
accounts_auto_config_values_construct (GType object_type)
{
	AccountsAutoConfigValues* self = NULL;
	self = (AccountsAutoConfigValues*) g_type_create_instance (object_type);
	return self;
}

AccountsAutoConfigValues*
accounts_auto_config_values_new (void)
{
	return accounts_auto_config_values_construct (ACCOUNTS_TYPE_AUTO_CONFIG_VALUES);
}

static void
accounts_value_auto_config_values_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
accounts_value_auto_config_values_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		accounts_auto_config_values_unref (value->data[0].v_pointer);
	}
}

static void
accounts_value_auto_config_values_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = accounts_auto_config_values_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
accounts_value_auto_config_values_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
accounts_value_auto_config_values_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AccountsAutoConfigValues * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = accounts_auto_config_values_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
accounts_value_auto_config_values_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	AccountsAutoConfigValues ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = accounts_auto_config_values_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
accounts_param_spec_auto_config_values (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	AccountsParamSpecAutoConfigValues* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ACCOUNTS_TYPE_AUTO_CONFIG_VALUES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
accounts_value_get_auto_config_values (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ACCOUNTS_TYPE_AUTO_CONFIG_VALUES), NULL);
	return value->data[0].v_pointer;
}

void
accounts_value_set_auto_config_values (GValue* value,
                                       gpointer v_object)
{
	AccountsAutoConfigValues * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ACCOUNTS_TYPE_AUTO_CONFIG_VALUES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ACCOUNTS_TYPE_AUTO_CONFIG_VALUES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		accounts_auto_config_values_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		accounts_auto_config_values_unref (old);
	}
}

void
accounts_value_take_auto_config_values (GValue* value,
                                        gpointer v_object)
{
	AccountsAutoConfigValues * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ACCOUNTS_TYPE_AUTO_CONFIG_VALUES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ACCOUNTS_TYPE_AUTO_CONFIG_VALUES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		accounts_auto_config_values_unref (old);
	}
}

static void
accounts_auto_config_values_class_init (AccountsAutoConfigValuesClass * klass,
                                        gpointer klass_data)
{
	accounts_auto_config_values_parent_class = g_type_class_peek_parent (klass);
	((AccountsAutoConfigValuesClass *) klass)->finalize = accounts_auto_config_values_finalize;
	g_type_class_adjust_private_offset (klass, &AccountsAutoConfigValues_private_offset);
}

static void
accounts_auto_config_values_instance_init (AccountsAutoConfigValues * self,
                                           gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = accounts_auto_config_values_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_id = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_imap_server = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_imap_port = _tmp2_;
	self->priv->_imap_tls_method = GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT;
	_tmp3_ = g_strdup ("");
	self->priv->_smtp_server = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_smtp_port = _tmp4_;
	self->priv->_smtp_tls_method = GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT;
	self->ref_count = 1;
}

static void
accounts_auto_config_values_finalize (AccountsAutoConfigValues * obj)
{
	AccountsAutoConfigValues * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACCOUNTS_TYPE_AUTO_CONFIG_VALUES, AccountsAutoConfigValues);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_imap_server);
	_g_free0 (self->priv->_imap_port);
	_g_free0 (self->priv->_smtp_server);
	_g_free0 (self->priv->_smtp_port);
}

/**
 * Thunderbird autoconfig XML values
 */
static GType
accounts_auto_config_values_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { accounts_value_auto_config_values_init, accounts_value_auto_config_values_free_value, accounts_value_auto_config_values_copy_value, accounts_value_auto_config_values_peek_pointer, "p", accounts_value_auto_config_values_collect_value, "p", accounts_value_auto_config_values_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AccountsAutoConfigValuesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_auto_config_values_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsAutoConfigValues), 0, (GInstanceInitFunc) accounts_auto_config_values_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType accounts_auto_config_values_type_id;
	accounts_auto_config_values_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AccountsAutoConfigValues", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AccountsAutoConfigValues_private_offset = g_type_add_instance_private (accounts_auto_config_values_type_id, sizeof (AccountsAutoConfigValuesPrivate));
	return accounts_auto_config_values_type_id;
}

GType
accounts_auto_config_values_get_type (void)
{
	static volatile gsize accounts_auto_config_values_type_id__once = 0;
	if (g_once_init_enter (&accounts_auto_config_values_type_id__once)) {
		GType accounts_auto_config_values_type_id;
		accounts_auto_config_values_type_id = accounts_auto_config_values_get_type_once ();
		g_once_init_leave (&accounts_auto_config_values_type_id__once, accounts_auto_config_values_type_id);
	}
	return accounts_auto_config_values_type_id__once;
}

gpointer
accounts_auto_config_values_ref (gpointer instance)
{
	AccountsAutoConfigValues * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
accounts_auto_config_values_unref (gpointer instance)
{
	AccountsAutoConfigValues * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ACCOUNTS_AUTO_CONFIG_VALUES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GQuark
accounts_auto_config_error_quark (void)
{
	return g_quark_from_static_string ("accounts-auto-config-error-quark");
}

static GType
accounts_auto_config_error_get_type_once (void)
{
	static const GEnumValue values[] = {{ACCOUNTS_AUTO_CONFIG_ERROR_ERROR, "ACCOUNTS_AUTO_CONFIG_ERROR_ERROR", "error"}, {0, NULL, NULL}};
	GType accounts_auto_config_error_type_id;
	accounts_auto_config_error_type_id = g_enum_register_static ("AccountsAutoConfigError", values);
	return accounts_auto_config_error_type_id;
}

GType
accounts_auto_config_error_get_type (void)
{
	static volatile gsize accounts_auto_config_error_type_id__once = 0;
	if (g_once_init_enter (&accounts_auto_config_error_type_id__once)) {
		GType accounts_auto_config_error_type_id;
		accounts_auto_config_error_type_id = accounts_auto_config_error_get_type_once ();
		g_once_init_leave (&accounts_auto_config_error_type_id__once, accounts_auto_config_error_type_id);
	}
	return accounts_auto_config_error_type_id__once;
}

static inline gpointer
accounts_auto_config_get_instance_private (AccountsAutoConfig* self)
{
	return G_STRUCT_MEMBER_P (self, AccountsAutoConfig_private_offset);
}

AccountsAutoConfig*
accounts_auto_config_construct (GType object_type,
                                GCancellable* auto_config_cancellable)
{
	AccountsAutoConfig* self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (auto_config_cancellable, g_cancellable_get_type ()), NULL);
	self = (AccountsAutoConfig*) g_type_create_instance (object_type);
	self->priv->cancellable = auto_config_cancellable;
	return self;
}

AccountsAutoConfig*
accounts_auto_config_new (GCancellable* auto_config_cancellable)
{
	return accounts_auto_config_construct (ACCOUNTS_TYPE_AUTO_CONFIG, auto_config_cancellable);
}

static void
accounts_auto_config_get_config_data_free (gpointer _data)
{
	AccountsAutoConfigGetConfigData* _data_;
	_data_ = _data;
	_g_free0 (_data_->hostname);
	_accounts_auto_config_values_unref0 (_data_->result);
	_accounts_auto_config_unref0 (_data_->self);
	g_slice_free (AccountsAutoConfigGetConfigData, _data_);
}

static gpointer
_accounts_auto_config_ref0 (gpointer self)
{
	return self ? accounts_auto_config_ref (self) : NULL;
}

void
accounts_auto_config_get_config (AccountsAutoConfig* self,
                                 const gchar* hostname,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AccountsAutoConfigGetConfigData* _data_;
	AccountsAutoConfig* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (ACCOUNTS_IS_AUTO_CONFIG (self));
	g_return_if_fail (hostname != NULL);
	_data_ = g_slice_new0 (AccountsAutoConfigGetConfigData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_auto_config_get_config_data_free);
	_tmp0_ = _accounts_auto_config_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (hostname);
	_g_free0 (_data_->hostname);
	_data_->hostname = _tmp1_;
	accounts_auto_config_get_config_co (_data_);
}

AccountsAutoConfigValues*
accounts_auto_config_get_config_finish (AccountsAutoConfig* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	AccountsAutoConfigValues* result;
	AccountsAutoConfigGetConfigData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
accounts_auto_config_get_config_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AccountsAutoConfigGetConfigData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_auto_config_get_config_co (_data_);
}

static gboolean
accounts_auto_config_get_config_co (AccountsAutoConfigGetConfigData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = g_strconcat ("https://autoconfig.", _data_->hostname, NULL);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = accounts_auto_config_AUTOCONFIG_PATH;
		_data_->_tmp4_ = g_strconcat (_data_->_tmp2_, _data_->_tmp3_, NULL);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_state_ = 1;
		accounts_auto_config_get_config_for_uri (_data_->self, _data_->_tmp5_, accounts_auto_config_get_config_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = accounts_auto_config_get_config_for_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_g_free0 (_data_->_tmp5_);
		_g_free0 (_data_->_tmp2_);
		_data_->_tmp0_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == ACCOUNTS_AUTO_CONFIG_ERROR) {
				goto __catch0_accounts_auto_config_error;
			}
			_accounts_auto_config_values_unref0 (_data_->auto_config_values);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp8_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_accounts_auto_config_values_unref0 (_data_->auto_config_values);
		_data_->auto_config_values = _data_->_tmp8_;
		_accounts_auto_config_values_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_accounts_auto_config_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp10_ = accounts_auto_config_AUTOCONFIG_BASE_URI;
		_data_->_tmp11_ = g_strconcat (_data_->_tmp10_, _data_->hostname, NULL);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_state_ = 2;
		accounts_auto_config_get_config_for_uri (_data_->self, _data_->_tmp12_, accounts_auto_config_get_config_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp13_ = accounts_auto_config_get_config_for_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_g_free0 (_data_->_tmp12_);
		_data_->_tmp9_ = _data_->_tmp14_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_data_->_tmp15_ = _data_->_tmp9_;
		_data_->_tmp9_ = NULL;
		_accounts_auto_config_values_unref0 (_data_->auto_config_values);
		_data_->auto_config_values = _data_->_tmp15_;
		_accounts_auto_config_values_unref0 (_data_->_tmp9_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == ACCOUNTS_AUTO_CONFIG_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_accounts_auto_config_values_unref0 (_data_->auto_config_values);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_accounts_auto_config_values_unref0 (_data_->auto_config_values);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->auto_config_values;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_auto_config_get_config_for_uri_data_free (gpointer _data)
{
	AccountsAutoConfigGetConfigForUriData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_accounts_auto_config_values_unref0 (_data_->result);
	_accounts_auto_config_unref0 (_data_->self);
	g_slice_free (AccountsAutoConfigGetConfigForUriData, _data_);
}

static void
accounts_auto_config_get_config_for_uri (AccountsAutoConfig* self,
                                         const gchar* uri,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	AccountsAutoConfigGetConfigForUriData* _data_;
	AccountsAutoConfig* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (ACCOUNTS_IS_AUTO_CONFIG (self));
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (AccountsAutoConfigGetConfigForUriData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_auto_config_get_config_for_uri_data_free);
	_tmp0_ = _accounts_auto_config_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	accounts_auto_config_get_config_for_uri_co (_data_);
}

static AccountsAutoConfigValues*
accounts_auto_config_get_config_for_uri_finish (AccountsAutoConfig* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	AccountsAutoConfigValues* result;
	AccountsAutoConfigGetConfigForUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
accounts_auto_config_get_config_for_uri_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	AccountsAutoConfigGetConfigForUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_auto_config_get_config_for_uri_co (_data_);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
accounts_auto_config_get_config_for_uri_co (AccountsAutoConfigGetConfigForUriData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = soup_session_new ();
	_data_->session = _data_->_tmp0_;
	_data_->_tmp1_ = soup_message_new ("GET", _data_->uri);
	_data_->msg = _data_->_tmp1_;
	{
		_data_->_tmp3_ = _data_->session;
		_data_->_tmp4_ = _data_->msg;
		_data_->_tmp5_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		soup_session_send_async (_data_->_tmp3_, _data_->_tmp4_, G_PRIORITY_DEFAULT, _data_->_tmp5_, accounts_auto_config_get_config_for_uri_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = soup_session_send_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp2_ = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->_tmp2_;
		_data_->_tmp2_ = NULL;
		_g_object_unref0 (_data_->stream);
		_data_->stream = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->err;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		_data_->_tmp10_ = g_error_new_literal (ACCOUNTS_AUTO_CONFIG_ERROR, ACCOUNTS_AUTO_CONFIG_ERROR_ERROR, _data_->_tmp9_);
		_data_->_inner_error0_ = _data_->_tmp10_;
		_g_error_free0 (_data_->err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == ACCOUNTS_AUTO_CONFIG_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->msg);
			_g_object_unref0 (_data_->session);
			_g_object_unref0 (_data_->stream);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->msg);
			_g_object_unref0 (_data_->session);
			_g_object_unref0 (_data_->stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_tmp11_ = (GMemoryOutputStream*) g_memory_output_stream_new_resizable ();
		_data_->stdout_stream = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->stdout_stream;
		_data_->_tmp13_ = _data_->stream;
		_data_->_state_ = 2;
		g_output_stream_splice_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, g_output_stream_get_type (), GOutputStream), _data_->_tmp13_, 0, G_PRIORITY_DEFAULT, NULL, accounts_auto_config_get_config_for_uri_ready, _data_);
		return FALSE;
		_state_2:
		g_output_stream_splice_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stdout_stream);
			goto __catch1_g_error;
		}
		_data_->_tmp14_ = _data_->stdout_stream;
		_data_->_tmp16_ = 0;
		_data_->_tmp15_ = string_get_data ("\0", &_data_->_tmp16_);
		_data_->_tmp15__length1 = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->_tmp15_;
		_data_->_tmp17__length1 = _data_->_tmp15__length1;
		g_output_stream_write (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, g_output_stream_get_type (), GOutputStream), _data_->_tmp17_, (gsize) _data_->_tmp17__length1, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stdout_stream);
			goto __catch1_g_error;
		}
		_data_->_tmp18_ = _data_->stdout_stream;
		g_output_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, g_output_stream_get_type (), GOutputStream), NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stdout_stream);
			goto __catch1_g_error;
		}
		_data_->_tmp19_ = _data_->stdout_stream;
		_data_->_tmp20_ = g_memory_output_stream_get_data (_data_->_tmp19_);
		_data_->xml_data = (const gchar*) _data_->_tmp20_;
		_data_->_tmp22_ = _data_->xml_data;
		_data_->_tmp23_ = accounts_auto_config_get_config_for_xml (_data_->self, _data_->_tmp22_, &_data_->_inner_error0_);
		_data_->_tmp21_ = _data_->_tmp23_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stdout_stream);
			goto __catch1_g_error;
		}
		_data_->_tmp24_ = _data_->_tmp21_;
		_data_->_tmp21_ = NULL;
		_data_->result = _data_->_tmp24_;
		_accounts_auto_config_values_unref0 (_data_->_tmp21_);
		_g_object_unref0 (_data_->stdout_stream);
		{
			{
				_data_->_tmp25_ = _data_->stream;
				_data_->_state_ = 3;
				g_input_stream_close_async (_data_->_tmp25_, G_PRIORITY_DEFAULT, NULL, accounts_auto_config_get_config_for_uri_ready, _data_);
				return FALSE;
				_state_3:
				g_input_stream_close_finish (_data_->_tmp25_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				g_clear_error (&_data_->_inner_error0_);
			}
			__finally2:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		_g_object_unref0 (_data_->msg);
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->stream);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp26_ = _data_->_vala1_err;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		_data_->_tmp28_ = g_error_new_literal (ACCOUNTS_AUTO_CONFIG_ERROR, ACCOUNTS_AUTO_CONFIG_ERROR_ERROR, _data_->_tmp27_);
		_data_->_inner_error0_ = _data_->_tmp28_;
		_g_error_free0 (_data_->_vala1_err);
		goto __finally1;
	}
	__finally1:
	{
		{
			_data_->_tmp29_ = _data_->stream;
			_data_->_state_ = 4;
			g_input_stream_close_async (_data_->_tmp29_, G_PRIORITY_DEFAULT, NULL, accounts_auto_config_get_config_for_uri_ready, _data_);
			return FALSE;
			_state_4:
			g_input_stream_close_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error1_);
			if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			g_clear_error (&_data_->_inner_error1_);
		}
		__finally3:
		if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
			if (_data_->_inner_error1_->domain == ACCOUNTS_AUTO_CONFIG_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error1_);
				_g_object_unref0 (_data_->msg);
				_g_object_unref0 (_data_->session);
				_g_object_unref0 (_data_->stream);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->msg);
				_g_object_unref0 (_data_->session);
				_g_object_unref0 (_data_->stream);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error1_->message, g_quark_to_string (_data_->_inner_error1_->domain), _data_->_inner_error1_->code);
				g_clear_error (&_data_->_inner_error1_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	if (_data_->_inner_error0_->domain == ACCOUNTS_AUTO_CONFIG_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->msg);
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->stream);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_g_object_unref0 (_data_->msg);
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static AccountsAutoConfigValues*
accounts_auto_config_get_config_for_xml (AccountsAutoConfig* self,
                                         const gchar* xml_data,
                                         GError** error)
{
	xmlDoc* doc = NULL;
	gint _tmp0_;
	gint _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlNode* root = NULL;
	xmlDoc* _tmp5_;
	xmlNode* _tmp6_;
	xmlNode* email_provider = NULL;
	xmlNode* _tmp7_;
	xmlNode* _tmp8_;
	xmlNode* incoming_server = NULL;
	xmlNode* _tmp9_;
	xmlNode* _tmp10_;
	xmlNode* outgoing_server = NULL;
	xmlNode* _tmp11_;
	xmlNode* _tmp12_;
	gboolean _tmp13_ = FALSE;
	xmlNode* _tmp14_;
	gboolean _tmp17_ = FALSE;
	xmlNode* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	AccountsAutoConfigValues* auto_config_values = NULL;
	AccountsAutoConfigValues* _tmp26_;
	AccountsAutoConfigValues* _tmp27_;
	xmlNode* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	AccountsAutoConfigValues* _tmp31_;
	xmlNode* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	AccountsAutoConfigValues* _tmp35_;
	xmlNode* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	AccountsAutoConfigValues* _tmp39_;
	xmlNode* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	AccountsAutoConfigValues* _tmp43_;
	xmlNode* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	AccountsAutoConfigValues* _tmp47_;
	xmlNode* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	AccountsAutoConfigValues* _tmp51_;
	xmlNode* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	GError* _inner_error0_ = NULL;
	AccountsAutoConfigValues* result;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG (self), NULL);
	g_return_val_if_fail (xml_data != NULL, NULL);
	_tmp0_ = strlen (xml_data);
	_tmp1_ = _tmp0_;
	_tmp2_ = xmlParseMemory (xml_data, _tmp1_);
	doc = _tmp2_;
	_tmp3_ = doc;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (ACCOUNTS_AUTO_CONFIG_ERROR, ACCOUNTS_AUTO_CONFIG_ERROR_ERROR, "Invalid XML");
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == ACCOUNTS_AUTO_CONFIG_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = doc;
	_tmp6_ = xmlDocGetRootElement (_tmp5_);
	root = _tmp6_;
	_tmp7_ = root;
	_tmp8_ = accounts_auto_config_get_node (self, _tmp7_, "emailProvider");
	email_provider = _tmp8_;
	_tmp9_ = email_provider;
	_tmp10_ = accounts_auto_config_get_node (self, _tmp9_, "incomingServer");
	incoming_server = _tmp10_;
	_tmp11_ = email_provider;
	_tmp12_ = accounts_auto_config_get_node (self, _tmp11_, "outgoingServer");
	outgoing_server = _tmp12_;
	_tmp14_ = incoming_server;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		xmlNode* _tmp15_;
		_tmp15_ = outgoing_server;
		_tmp13_ = _tmp15_ == NULL;
	}
	if (_tmp13_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (ACCOUNTS_AUTO_CONFIG_ERROR, ACCOUNTS_AUTO_CONFIG_ERROR_ERROR, "Invalid XML");
		_inner_error0_ = _tmp16_;
		if (_inner_error0_->domain == ACCOUNTS_AUTO_CONFIG_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp18_ = incoming_server;
	_tmp19_ = (gchar*) xmlGetProp (_tmp18_, (xmlChar*) "type");
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strcmp0 (_tmp20_, "imap") != 0;
	_g_free0 (_tmp20_);
	if (_tmp21_) {
		_tmp17_ = TRUE;
	} else {
		xmlNode* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp22_ = outgoing_server;
		_tmp23_ = (gchar*) xmlGetProp (_tmp22_, (xmlChar*) "type");
		_tmp24_ = _tmp23_;
		_tmp17_ = g_strcmp0 (_tmp24_, "smtp") != 0;
		_g_free0 (_tmp24_);
	}
	if (_tmp17_) {
		GError* _tmp25_;
		_tmp25_ = g_error_new_literal (ACCOUNTS_AUTO_CONFIG_ERROR, ACCOUNTS_AUTO_CONFIG_ERROR_ERROR, "Unsupported protocol");
		_inner_error0_ = _tmp25_;
		if (_inner_error0_->domain == ACCOUNTS_AUTO_CONFIG_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp26_ = accounts_auto_config_values_new ();
	auto_config_values = _tmp26_;
	_tmp27_ = auto_config_values;
	_tmp28_ = email_provider;
	_tmp29_ = (gchar*) xmlGetProp (_tmp28_, (xmlChar*) "id");
	_tmp30_ = _tmp29_;
	accounts_auto_config_values_set_id (_tmp27_, _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = auto_config_values;
	_tmp32_ = incoming_server;
	_tmp33_ = accounts_auto_config_get_node_value (self, _tmp32_, "hostname");
	_tmp34_ = _tmp33_;
	accounts_auto_config_values_set_imap_server (_tmp31_, _tmp34_);
	_g_free0 (_tmp34_);
	_tmp35_ = auto_config_values;
	_tmp36_ = incoming_server;
	_tmp37_ = accounts_auto_config_get_node_value (self, _tmp36_, "port");
	_tmp38_ = _tmp37_;
	accounts_auto_config_values_set_imap_port (_tmp35_, _tmp38_);
	_g_free0 (_tmp38_);
	_tmp39_ = auto_config_values;
	_tmp40_ = incoming_server;
	_tmp41_ = accounts_auto_config_get_node_value (self, _tmp40_, "socketType");
	_tmp42_ = _tmp41_;
	accounts_auto_config_values_set_imap_tls_method (_tmp39_, accounts_auto_config_get_tls_method (self, _tmp42_));
	_g_free0 (_tmp42_);
	_tmp43_ = auto_config_values;
	_tmp44_ = outgoing_server;
	_tmp45_ = accounts_auto_config_get_node_value (self, _tmp44_, "hostname");
	_tmp46_ = _tmp45_;
	accounts_auto_config_values_set_smtp_server (_tmp43_, _tmp46_);
	_g_free0 (_tmp46_);
	_tmp47_ = auto_config_values;
	_tmp48_ = outgoing_server;
	_tmp49_ = accounts_auto_config_get_node_value (self, _tmp48_, "port");
	_tmp50_ = _tmp49_;
	accounts_auto_config_values_set_smtp_port (_tmp47_, _tmp50_);
	_g_free0 (_tmp50_);
	_tmp51_ = auto_config_values;
	_tmp52_ = outgoing_server;
	_tmp53_ = accounts_auto_config_get_node_value (self, _tmp52_, "socketType");
	_tmp54_ = _tmp53_;
	accounts_auto_config_values_set_smtp_tls_method (_tmp51_, accounts_auto_config_get_tls_method (self, _tmp54_));
	_g_free0 (_tmp54_);
	result = auto_config_values;
	return result;
}

static xmlNode*
accounts_auto_config_get_node (AccountsAutoConfig* self,
                               xmlNode* root,
                               const gchar* name)
{
	xmlNode* result;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG (self), NULL);
	g_return_val_if_fail (root != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		xmlNode* entry = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = root->children;
		entry = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = entry;
					_tmp3_ = _tmp2_->next;
					entry = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = entry;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp6_ = entry;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = entry;
					_tmp8_ = _tmp7_->name;
					_tmp5_ = g_strcmp0 (_tmp8_, name) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					xmlNode* _tmp9_;
					_tmp9_ = entry;
					result = _tmp9_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gchar*
accounts_auto_config_get_node_value (AccountsAutoConfig* self,
                                     xmlNode* root,
                                     const gchar* name)
{
	xmlNode* node = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	xmlNode* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG (self), NULL);
	g_return_val_if_fail (root != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = accounts_auto_config_get_node (self, root, name);
	node = _tmp0_;
	_tmp1_ = node;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = (gchar*) xmlNodeGetContent (_tmp3_);
	result = _tmp4_;
	return result;
}

static GearyTlsNegotiationMethod
accounts_auto_config_get_tls_method (AccountsAutoConfig* self,
                                     const gchar* method)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	GearyTlsNegotiationMethod result;
	g_return_val_if_fail (ACCOUNTS_IS_AUTO_CONFIG (self), 0);
	g_return_val_if_fail (method != NULL, 0);
	_tmp0_ = method;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("SSL")))) {
		switch (0) {
			default:
			{
				result = GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("STARTTLS")))) {
		switch (0) {
			default:
			{
				result = GEARY_TLS_NEGOTIATION_METHOD_START_TLS;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = GEARY_TLS_NEGOTIATION_METHOD_NONE;
				return result;
			}
		}
	}
}

static void
accounts_value_auto_config_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
accounts_value_auto_config_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		accounts_auto_config_unref (value->data[0].v_pointer);
	}
}

static void
accounts_value_auto_config_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = accounts_auto_config_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
accounts_value_auto_config_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
accounts_value_auto_config_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AccountsAutoConfig * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = accounts_auto_config_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
accounts_value_auto_config_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	AccountsAutoConfig ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = accounts_auto_config_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
accounts_param_spec_auto_config (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	AccountsParamSpecAutoConfig* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ACCOUNTS_TYPE_AUTO_CONFIG), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
accounts_value_get_auto_config (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ACCOUNTS_TYPE_AUTO_CONFIG), NULL);
	return value->data[0].v_pointer;
}

void
accounts_value_set_auto_config (GValue* value,
                                gpointer v_object)
{
	AccountsAutoConfig * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ACCOUNTS_TYPE_AUTO_CONFIG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ACCOUNTS_TYPE_AUTO_CONFIG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		accounts_auto_config_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		accounts_auto_config_unref (old);
	}
}

void
accounts_value_take_auto_config (GValue* value,
                                 gpointer v_object)
{
	AccountsAutoConfig * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ACCOUNTS_TYPE_AUTO_CONFIG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ACCOUNTS_TYPE_AUTO_CONFIG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		accounts_auto_config_unref (old);
	}
}

static void
accounts_auto_config_class_init (AccountsAutoConfigClass * klass,
                                 gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	accounts_auto_config_parent_class = g_type_class_peek_parent (klass);
	((AccountsAutoConfigClass *) klass)->finalize = accounts_auto_config_finalize;
	g_type_class_adjust_private_offset (klass, &AccountsAutoConfig_private_offset);
	_tmp0_ = g_strdup ("https://autoconfig.thunderbird.net/v1.1/");
	accounts_auto_config_AUTOCONFIG_BASE_URI = _tmp0_;
	_tmp1_ = g_strdup ("/mail/config-v1.1.xml");
	accounts_auto_config_AUTOCONFIG_PATH = _tmp1_;
}

static void
accounts_auto_config_instance_init (AccountsAutoConfig * self,
                                    gpointer klass)
{
	self->priv = accounts_auto_config_get_instance_private (self);
	self->ref_count = 1;
}

static void
accounts_auto_config_finalize (AccountsAutoConfig * obj)
{
	AccountsAutoConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACCOUNTS_TYPE_AUTO_CONFIG, AccountsAutoConfig);
	g_signal_handlers_destroy (self);
}

/**
 * An account autoconfiguration helper
 */
static GType
accounts_auto_config_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { accounts_value_auto_config_init, accounts_value_auto_config_free_value, accounts_value_auto_config_copy_value, accounts_value_auto_config_peek_pointer, "p", accounts_value_auto_config_collect_value, "p", accounts_value_auto_config_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AccountsAutoConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_auto_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsAutoConfig), 0, (GInstanceInitFunc) accounts_auto_config_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType accounts_auto_config_type_id;
	accounts_auto_config_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AccountsAutoConfig", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AccountsAutoConfig_private_offset = g_type_add_instance_private (accounts_auto_config_type_id, sizeof (AccountsAutoConfigPrivate));
	return accounts_auto_config_type_id;
}

GType
accounts_auto_config_get_type (void)
{
	static volatile gsize accounts_auto_config_type_id__once = 0;
	if (g_once_init_enter (&accounts_auto_config_type_id__once)) {
		GType accounts_auto_config_type_id;
		accounts_auto_config_type_id = accounts_auto_config_get_type_once ();
		g_once_init_leave (&accounts_auto_config_type_id__once, accounts_auto_config_type_id);
	}
	return accounts_auto_config_type_id__once;
}

gpointer
accounts_auto_config_ref (gpointer instance)
{
	AccountsAutoConfig * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
accounts_auto_config_unref (gpointer instance)
{
	AccountsAutoConfig * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ACCOUNTS_AUTO_CONFIG_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

