/* application-contact-store.c generated by valac 0.56.3, the Vala compiler
 * generated from application-contact-store.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include "geary-engine.h"
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define APPLICATION_CONTACT_STORE_LRU_CACHE_MAX ((guint) 128)

enum  {
	APPLICATION_CONTACT_STORE_0_PROPERTY,
	APPLICATION_CONTACT_STORE_ACCOUNT_PROPERTY,
	APPLICATION_CONTACT_STORE_NUM_PROPERTIES
};
static GParamSpec* application_contact_store_properties[APPLICATION_CONTACT_STORE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ApplicationContactStoreLoadData ApplicationContactStoreLoadData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ApplicationContactStoreSearchData ApplicationContactStoreSearchData;
typedef struct _ApplicationContactStoreLookupEngineContactData ApplicationContactStoreLookupEngineContactData;
typedef struct _ApplicationContactStoreGetContactData ApplicationContactStoreGetContactData;
typedef struct _ApplicationContactStoreSearchFolksByEmailData ApplicationContactStoreSearchFolksByEmailData;

struct _ApplicationContactStorePrivate {
	GearyAccount* _account;
	UtilCacheLru* folks_address_cache;
	UtilCacheLru* contact_id_cache;
	UtilCacheLru* engine_address_cache;
};

struct _ApplicationContactStoreLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContactStore* self;
	GearyRFC822MailboxAddress* mailbox;
	GCancellable* cancellable;
	ApplicationContact* result;
	FolksIndividual* individual;
	gchar* email_key;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	UtilCacheLru* _tmp3_;
	const gchar* _tmp4_;
	UtilCacheLru* _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_;
	FolksIndividual* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	FolksIndividual* _tmp11_;
	FolksIndividual* _tmp12_;
	UtilCacheLru* _tmp13_;
	const gchar* _tmp14_;
	FolksIndividual* _tmp15_;
	ApplicationContact* _tmp16_;
	FolksIndividual* _tmp17_;
	ApplicationContact* _tmp18_;
	ApplicationContact* _tmp19_;
	GError* _inner_error0_;
};

struct _ApplicationContactStoreSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContactStore* self;
	gchar* query;
	guint min_importance;
	guint limit;
	GCancellable* cancellable;
	GeeCollection* result;
	GeeCollection* results;
	GeeLinkedList* _tmp0_;
	GeeSet* seen;
	GeeHashSet* _tmp1_;
	FolksSearchView* view;
	FolksIndividualAggregator* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	FolksSimpleQuery* _tmp6_;
	FolksSimpleQuery* _tmp7_;
	FolksSearchView* _tmp8_;
	FolksSearchView* _tmp9_;
	FolksSearchView* _tmp10_;
	GeeIterator* _individual_it;
	FolksSearchView* _tmp11_;
	GeeSortedSet* _tmp12_;
	GeeSortedSet* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	FolksIndividual* individual;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	FolksIndividual* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	ApplicationContact* _result_;
	FolksIndividual* _tmp21_;
	ApplicationContact* _tmp22_;
	GeeIterator* _mailbox_it;
	ApplicationContact* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	GeeIterator* _tmp26_;
	GeeIterator* _tmp27_;
	GearyRFC822MailboxAddress* mailbox;
	GeeIterator* _tmp28_;
	gpointer _tmp29_;
	GeeSet* _tmp30_;
	GearyRFC822MailboxAddress* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GeeCollection* _tmp36_;
	ApplicationContact* _tmp37_;
	GeeIterator* _vala1__individual_it;
	FolksSearchView* _tmp38_;
	GeeSortedSet* _tmp39_;
	GeeSortedSet* _tmp40_;
	GeeIterator* _tmp41_;
	GeeIterator* _tmp42_;
	FolksIndividual* _vala1_individual;
	GeeIterator* _tmp43_;
	gpointer _tmp44_;
	FolksIndividual* _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	ApplicationContact* _vala1__result_;
	FolksIndividual* _tmp48_;
	ApplicationContact* _tmp49_;
	GeeIterator* _vala1__mailbox_it;
	ApplicationContact* _tmp50_;
	GeeCollection* _tmp51_;
	GeeCollection* _tmp52_;
	GeeIterator* _tmp53_;
	GeeIterator* _tmp54_;
	GearyRFC822MailboxAddress* _vala1_mailbox;
	GeeIterator* _tmp55_;
	gpointer _tmp56_;
	GeeSet* _tmp57_;
	GearyRFC822MailboxAddress* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GeeCollection* _tmp63_;
	ApplicationContact* _tmp64_;
	FolksSearchView* _tmp65_;
	GError* err;
	GError* _tmp66_;
	const gchar* _tmp67_;
	GeeCollection* engine_results;
	GearyAccount* _tmp68_;
	GearyContactStore* _tmp69_;
	GearyContactStore* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GeeCollection* _tmp73_;
	GeeCollection* _tmp74_;
	GeeIterator* _contact_it;
	GeeCollection* _tmp75_;
	GeeIterator* _tmp76_;
	GeeIterator* _tmp77_;
	GearyContact* contact;
	GeeIterator* _tmp78_;
	gpointer _tmp79_;
	gchar* email_key;
	GearyContact* _tmp80_;
	const gchar* _tmp81_;
	const gchar* _tmp82_;
	gchar* _tmp83_;
	GeeSet* _tmp84_;
	const gchar* _tmp85_;
	ApplicationContact* _vala2__result_;
	GearyContact* _tmp86_;
	GearyRFC822MailboxAddress* _tmp87_;
	GearyRFC822MailboxAddress* _tmp88_;
	ApplicationContact* _tmp89_;
	ApplicationContact* _tmp90_;
	GeeIterator* _vala2__mailbox_it;
	ApplicationContact* _tmp91_;
	GeeCollection* _tmp92_;
	GeeCollection* _tmp93_;
	GeeIterator* _tmp94_;
	GeeIterator* _tmp95_;
	GearyRFC822MailboxAddress* _vala2_mailbox;
	GeeIterator* _tmp96_;
	gpointer _tmp97_;
	GeeSet* _tmp98_;
	GearyRFC822MailboxAddress* _tmp99_;
	const gchar* _tmp100_;
	const gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	GeeCollection* _tmp104_;
	ApplicationContact* _tmp105_;
	GError* _inner_error0_;
};

struct _ApplicationContactStoreLookupEngineContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContactStore* self;
	GearyRFC822MailboxAddress* mailbox;
	GCancellable* cancellable;
	GearyContact* result;
	gchar* email_key;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GearyContact* contact;
	UtilCacheLru* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_;
	GearyContact* _tmp6_;
	GearyContact* _tmp7_;
	GearyAccount* _tmp8_;
	GearyContactStore* _tmp9_;
	GearyContactStore* _tmp10_;
	GearyContact* _tmp11_;
	GearyContact* _tmp12_;
	GearyContact* _tmp13_;
	GearyContact* _tmp14_;
	GearyAccount* _tmp15_;
	GearyContactStore* _tmp16_;
	GearyContactStore* _tmp17_;
	GearyContact* _tmp18_;
	GeeCollection* _tmp19_;
	GeeCollection* _tmp20_;
	UtilCacheLru* _tmp21_;
	const gchar* _tmp22_;
	GearyContact* _tmp23_;
	GError* _inner_error0_;
};

struct _ApplicationContactStoreGetContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContactStore* self;
	FolksIndividual* individual;
	GearyRFC822MailboxAddress* mailbox;
	GCancellable* cancellable;
	ApplicationContact* result;
	ApplicationContact* contact;
	UtilCacheLru* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	ApplicationContact* _tmp4_;
	ApplicationContact* _tmp5_;
	UtilCacheLru* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ApplicationContact* _tmp9_;
	GearyContact* engine;
	GearyContact* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* name;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GearyContact* _tmp21_;
	ApplicationContact* _tmp22_;
	GError* _tmp23_;
	GError* _inner_error0_;
};

struct _ApplicationContactStoreSearchFolksByEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContactStore* self;
	gchar* address;
	GCancellable* cancellable;
	FolksIndividual* result;
	FolksSearchView* view;
	FolksIndividualAggregator* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	FolksSimpleQuery* _tmp2_;
	FolksSimpleQuery* _tmp3_;
	FolksSearchView* _tmp4_;
	FolksSearchView* _tmp5_;
	FolksSearchView* _tmp6_;
	FolksIndividual* match;
	FolksSearchView* _tmp7_;
	GeeSortedSet* _tmp8_;
	GeeSortedSet* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gchar* normalised_address;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GeeIterator* _poss_it;
	FolksSearchView* _tmp16_;
	GeeSortedSet* _tmp17_;
	GeeSortedSet* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _tmp20_;
	FolksIndividual* poss;
	GeeIterator* _tmp21_;
	gpointer _tmp22_;
	GeeIterator* _email_it;
	FolksIndividual* _tmp23_;
	GeeSet* _tmp24_;
	GeeSet* _tmp25_;
	GeeIterator* _tmp26_;
	GeeIterator* _tmp27_;
	FolksEmailFieldDetails* email;
	GeeIterator* _tmp28_;
	gpointer _tmp29_;
	FolksEmailFieldDetails* _tmp30_;
	gconstpointer _tmp31_;
	gconstpointer _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gboolean _tmp38_;
	FolksIndividual* _tmp39_;
	FolksIndividual* _tmp40_;
	FolksIndividual* _tmp41_;
	FolksSearchView* _tmp42_;
	GError* err;
	GError* _tmp43_;
	const gchar* _tmp44_;
	GError* _tmp45_;
	GError* _inner_error0_;
};

static gint ApplicationContactStore_private_offset;
static gpointer application_contact_store_parent_class = NULL;
static gchar** application_contact_store_FOLKS_GENERAL_MATCH_FIELDS;
static gint application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_length1;
static gchar** application_contact_store_FOLKS_GENERAL_MATCH_FIELDS = NULL;
static gint application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_length1 = 0;
static gint _application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_size_ = 0;
static gchar** application_contact_store_FOLKS_EMAIL_MATCH_FIELDS;
static gint application_contact_store_FOLKS_EMAIL_MATCH_FIELDS_length1;
static gchar** application_contact_store_FOLKS_EMAIL_MATCH_FIELDS = NULL;
static gint application_contact_store_FOLKS_EMAIL_MATCH_FIELDS_length1 = 0;
static gint _application_contact_store_FOLKS_EMAIL_MATCH_FIELDS_size_ = 0;

static void application_contact_store_on_individuals_changed (ApplicationContactStore* self,
                                                       GeeMultiMap* changes);
static void _application_contact_store_on_individuals_changed_folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender,
                                                                                                                 GeeMultiMap* changes,
                                                                                                                 gpointer self);
static inline gchar* application_contact_store_to_cache_key (const gchar* value);
static void application_contact_store_set_account (ApplicationContactStore* self,
                                            GearyAccount* value);
VALA_EXTERN ApplicationContactStore* application_contact_store_new (GearyAccount* account,
                                                        FolksIndividualAggregator* individuals);
VALA_EXTERN ApplicationContactStore* application_contact_store_construct (GType object_type,
                                                              GearyAccount* account,
                                                              FolksIndividualAggregator* individuals);
static void application_contact_store_load_data_free (gpointer _data);
static gboolean application_contact_store_load_co (ApplicationContactStoreLoadData* _data_);
static void application_contact_store_search_folks_by_email (ApplicationContactStore* self,
                                                      const gchar* address,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static FolksIndividual* application_contact_store_search_folks_by_email_finish (ApplicationContactStore* self,
                                                                         GAsyncResult* _res_,
                                                                         GError** error);
static void application_contact_store_load_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void application_contact_store_get_contact (ApplicationContactStore* self,
                                            FolksIndividual* individual,
                                            GearyRFC822MailboxAddress* mailbox,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static ApplicationContact* application_contact_store_get_contact_finish (ApplicationContactStore* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static void application_contact_store_search_data_free (gpointer _data);
static gboolean application_contact_store_search_co (ApplicationContactStoreSearchData* _data_);
static void application_contact_store_search_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN void application_contact_store_close (ApplicationContactStore* self);
static void application_contact_store_lookup_engine_contact_data_free (gpointer _data);
VALA_EXTERN void application_contact_store_lookup_engine_contact (ApplicationContactStore* self,
                                                      GearyRFC822MailboxAddress* mailbox,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
VALA_EXTERN GearyContact* application_contact_store_lookup_engine_contact_finish (ApplicationContactStore* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static gboolean application_contact_store_lookup_engine_contact_co (ApplicationContactStoreLookupEngineContactData* _data_);
static void application_contact_store_lookup_engine_contact_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void application_contact_store_get_contact_data_free (gpointer _data);
static gboolean application_contact_store_get_contact_co (ApplicationContactStoreGetContactData* _data_);
VALA_EXTERN ApplicationContact* application_contact_new_for_folks (ApplicationContactStore* store,
                                                       FolksIndividual* source);
VALA_EXTERN ApplicationContact* application_contact_construct_for_folks (GType object_type,
                                                             ApplicationContactStore* store,
                                                             FolksIndividual* source);
static void application_contact_store_get_contact_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
VALA_EXTERN ApplicationContact* application_contact_new_for_engine (ApplicationContactStore* store,
                                                        const gchar* display_name,
                                                        GearyContact* source);
VALA_EXTERN ApplicationContact* application_contact_construct_for_engine (GType object_type,
                                                              ApplicationContactStore* store,
                                                              const gchar* display_name,
                                                              GearyContact* source);
static void application_contact_store_search_folks_by_email_data_free (gpointer _data);
static gboolean application_contact_store_search_folks_by_email_co (ApplicationContactStoreSearchFolksByEmailData* _data_);
static void application_contact_store_search_folks_by_email_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void application_contact_store_finalize (GObject * obj);
static GType application_contact_store_get_type_once (void);
static void _vala_application_contact_store_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_application_contact_store_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
application_contact_store_get_instance_private (ApplicationContactStore* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationContactStore_private_offset);
}

static void
_application_contact_store_on_individuals_changed_folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender,
                                                                                                            GeeMultiMap* changes,
                                                                                                            gpointer self)
{
	application_contact_store_on_individuals_changed ((ApplicationContactStore*) self, changes);
}

static inline gchar*
application_contact_store_to_cache_key (const gchar* value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_utf8_normalize (value, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GearyAccount*
application_contact_store_get_account (ApplicationContactStore* self)
{
	GearyAccount* result;
	GearyAccount* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONTACT_STORE (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_contact_store_set_account (ApplicationContactStore* self,
                                       GearyAccount* value)
{
	GearyAccount* old_value;
	g_return_if_fail (APPLICATION_IS_CONTACT_STORE (self));
	old_value = application_contact_store_get_account (self);
	if (old_value != value) {
		GearyAccount* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_account);
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_contact_store_properties[APPLICATION_CONTACT_STORE_ACCOUNT_PROPERTY]);
	}
}

/** Constructs a new contact store for an account. */
ApplicationContactStore*
application_contact_store_construct (GType object_type,
                                     GearyAccount* account,
                                     FolksIndividualAggregator* individuals)
{
	ApplicationContactStore * self = NULL;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (individuals, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR), NULL);
	self = (ApplicationContactStore*) geary_base_object_construct (object_type);
	application_contact_store_set_account (self, account);
	_tmp0_ = _g_object_ref0 (individuals);
	_g_object_unref0 (self->individuals);
	self->individuals = _tmp0_;
	_tmp1_ = self->individuals;
	g_signal_connect_object (_tmp1_, "individuals-changed-detailed", (GCallback) _application_contact_store_on_individuals_changed_folks_individual_aggregator_individuals_changed_detailed, self, 0);
	return self;
}

ApplicationContactStore*
application_contact_store_new (GearyAccount* account,
                               FolksIndividualAggregator* individuals)
{
	return application_contact_store_construct (APPLICATION_TYPE_CONTACT_STORE, account, individuals);
}

static void
application_contact_store_load_data_free (gpointer _data)
{
	ApplicationContactStoreLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mailbox);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactStoreLoadData, _data_);
}

void
application_contact_store_load (ApplicationContactStore* self,
                                GearyRFC822MailboxAddress* mailbox,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	ApplicationContactStoreLoadData* _data_;
	ApplicationContactStore* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_CONTACT_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (mailbox, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationContactStoreLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_store_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (mailbox);
	_g_object_unref0 (_data_->mailbox);
	_data_->mailbox = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_contact_store_load_co (_data_);
}

ApplicationContact*
application_contact_store_load_finish (ApplicationContactStore* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	ApplicationContact* result;
	ApplicationContactStoreLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns a contact for a specific mailbox.
     *
     * Returns a contact that has the given mailbox address listed as
     * a primary or secondary email. A contact will always be
     * returned, so if no matching contact already exists a new,
     * non-persistent contact will be returned.
     */
static void
application_contact_store_load_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	ApplicationContactStoreLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_store_load_co (_data_);
}

static gboolean
application_contact_store_load_co (ApplicationContactStoreLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->individual = NULL;
	_data_->_tmp0_ = geary_rf_c822_mailbox_address_get_address (_data_->mailbox);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = application_contact_store_to_cache_key (_data_->_tmp1_);
	_data_->email_key = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->folks_address_cache;
	_data_->_tmp4_ = _data_->email_key;
	if (util_cache_lru_has_key (_data_->_tmp3_, _data_->_tmp4_)) {
		_data_->_tmp5_ = _data_->self->priv->folks_address_cache;
		_data_->_tmp6_ = _data_->email_key;
		_data_->_tmp7_ = util_cache_lru_get_entry (_data_->_tmp5_, _data_->_tmp6_);
		_g_object_unref0 (_data_->individual);
		_data_->individual = (FolksIndividual*) _data_->_tmp7_;
	} else {
		_data_->_tmp9_ = geary_rf_c822_mailbox_address_get_address (_data_->mailbox);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_state_ = 1;
		application_contact_store_search_folks_by_email (_data_->self, _data_->_tmp10_, _data_->cancellable, application_contact_store_load_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = application_contact_store_search_folks_by_email_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp8_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->email_key);
			_g_object_unref0 (_data_->individual);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp12_ = _data_->_tmp8_;
		_data_->_tmp8_ = NULL;
		_g_object_unref0 (_data_->individual);
		_data_->individual = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->self->priv->folks_address_cache;
		_data_->_tmp14_ = _data_->email_key;
		_data_->_tmp15_ = _data_->individual;
		util_cache_lru_set_entry (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_);
		_g_object_unref0 (_data_->_tmp8_);
	}
	_data_->_tmp17_ = _data_->individual;
	_data_->_state_ = 2;
	application_contact_store_get_contact (_data_->self, _data_->_tmp17_, _data_->mailbox, _data_->cancellable, application_contact_store_load_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp18_ = application_contact_store_get_contact_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp16_ = _data_->_tmp18_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->email_key);
		_g_object_unref0 (_data_->individual);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->_tmp16_;
	_data_->_tmp16_ = NULL;
	_data_->result = _data_->_tmp19_;
	_g_object_unref0 (_data_->_tmp16_);
	_g_free0 (_data_->email_key);
	_g_object_unref0 (_data_->individual);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_contact_store_search_data_free (gpointer _data)
{
	ApplicationContactStoreSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactStoreSearchData, _data_);
}

void
application_contact_store_search (ApplicationContactStore* self,
                                  const gchar* query,
                                  guint min_importance,
                                  guint limit,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	ApplicationContactStoreSearchData* _data_;
	ApplicationContactStore* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_CONTACT_STORE (self));
	g_return_if_fail (query != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationContactStoreSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_store_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query);
	_g_free0 (_data_->query);
	_data_->query = _tmp1_;
	_data_->min_importance = min_importance;
	_data_->limit = limit;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_contact_store_search_co (_data_);
}

GeeCollection*
application_contact_store_search_finish (ApplicationContactStore* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GeeCollection* result;
	ApplicationContactStoreSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/** Searches for contacts based on a specific string */
static void
application_contact_store_search_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	ApplicationContactStoreSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_store_search_co (_data_);
}

static gboolean
application_contact_store_search_co (ApplicationContactStoreSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_linked_list_new (APPLICATION_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->results = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	_data_->_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->seen = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_SET, GeeSet);
	_data_->_tmp2_ = _data_->self->individuals;
	_data_->_tmp3_ = g_strconcat ("%", _data_->query, "%", NULL);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = application_contact_store_FOLKS_GENERAL_MATCH_FIELDS;
	_data_->_tmp5__length1 = application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_length1;
	_data_->_tmp6_ = folks_simple_query_new (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp5__length1);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = folks_search_view_new (_data_->_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, FOLKS_TYPE_QUERY, FolksQuery));
	_data_->_tmp9_ = _data_->_tmp8_;
	_g_object_unref0 (_data_->_tmp7_);
	_g_free0 (_data_->_tmp4_);
	_data_->view = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->view;
	_data_->_state_ = 1;
	folks_search_view_prepare (_data_->_tmp10_, application_contact_store_search_ready, _data_);
	return FALSE;
	_state_1:
	folks_search_view_prepare_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->view);
		_g_object_unref0 (_data_->seen);
		_g_object_unref0 (_data_->results);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp11_ = _data_->view;
		_data_->_tmp12_ = folks_search_view_get_individuals (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->_individual_it = _data_->_tmp14_;
		while (TRUE) {
			_data_->_tmp15_ = _data_->_individual_it;
			if (!gee_iterator_next (_data_->_tmp15_)) {
				break;
			}
			_data_->_tmp16_ = _data_->_individual_it;
			_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
			_data_->individual = (FolksIndividual*) _data_->_tmp17_;
			_data_->_tmp18_ = _data_->individual;
			_data_->_tmp19_ = folks_favourite_details_get_is_favourite (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetails));
			_data_->_tmp20_ = _data_->_tmp19_;
			if (_data_->_tmp20_) {
				_data_->_tmp21_ = _data_->individual;
				_data_->_state_ = 2;
				application_contact_store_get_contact (_data_->self, _data_->_tmp21_, NULL, _data_->cancellable, application_contact_store_search_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp22_ = application_contact_store_get_contact_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				_data_->_result_ = _data_->_tmp22_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->individual);
					_g_object_unref0 (_data_->_individual_it);
					_g_object_unref0 (_data_->view);
					_g_object_unref0 (_data_->seen);
					_g_object_unref0 (_data_->results);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				{
					_data_->_tmp23_ = _data_->_result_;
					_data_->_tmp24_ = application_contact_get_email_addresses (_data_->_tmp23_);
					_data_->_tmp25_ = _data_->_tmp24_;
					_data_->_tmp26_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, GEE_TYPE_ITERABLE, GeeIterable));
					_data_->_mailbox_it = _data_->_tmp26_;
					while (TRUE) {
						_data_->_tmp27_ = _data_->_mailbox_it;
						if (!gee_iterator_next (_data_->_tmp27_)) {
							break;
						}
						_data_->_tmp28_ = _data_->_mailbox_it;
						_data_->_tmp29_ = gee_iterator_get (_data_->_tmp28_);
						_data_->mailbox = (GearyRFC822MailboxAddress*) _data_->_tmp29_;
						_data_->_tmp30_ = _data_->seen;
						_data_->_tmp31_ = _data_->mailbox;
						_data_->_tmp32_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp31_);
						_data_->_tmp33_ = _data_->_tmp32_;
						_data_->_tmp34_ = application_contact_store_to_cache_key (_data_->_tmp33_);
						_data_->_tmp35_ = _data_->_tmp34_;
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp35_);
						_g_free0 (_data_->_tmp35_);
						_g_object_unref0 (_data_->mailbox);
					}
					_g_object_unref0 (_data_->_mailbox_it);
				}
				_data_->_tmp36_ = _data_->results;
				_data_->_tmp37_ = _data_->_result_;
				gee_collection_add (_data_->_tmp36_, _data_->_tmp37_);
				_g_object_unref0 (_data_->_result_);
			}
			_g_object_unref0 (_data_->individual);
		}
		_g_object_unref0 (_data_->_individual_it);
	}
	{
		_data_->_tmp38_ = _data_->view;
		_data_->_tmp39_ = folks_search_view_get_individuals (_data_->_tmp38_);
		_data_->_tmp40_ = _data_->_tmp39_;
		_data_->_tmp41_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->_vala1__individual_it = _data_->_tmp41_;
		while (TRUE) {
			_data_->_tmp42_ = _data_->_vala1__individual_it;
			if (!gee_iterator_next (_data_->_tmp42_)) {
				break;
			}
			_data_->_tmp43_ = _data_->_vala1__individual_it;
			_data_->_tmp44_ = gee_iterator_get (_data_->_tmp43_);
			_data_->_vala1_individual = (FolksIndividual*) _data_->_tmp44_;
			_data_->_tmp45_ = _data_->_vala1_individual;
			_data_->_tmp46_ = folks_favourite_details_get_is_favourite (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp45_, FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetails));
			_data_->_tmp47_ = _data_->_tmp46_;
			if (!_data_->_tmp47_) {
				_data_->_tmp48_ = _data_->_vala1_individual;
				_data_->_state_ = 3;
				application_contact_store_get_contact (_data_->self, _data_->_tmp48_, NULL, _data_->cancellable, application_contact_store_search_ready, _data_);
				return FALSE;
				_state_3:
				_data_->_tmp49_ = application_contact_store_get_contact_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				_data_->_vala1__result_ = _data_->_tmp49_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->_vala1_individual);
					_g_object_unref0 (_data_->_vala1__individual_it);
					_g_object_unref0 (_data_->view);
					_g_object_unref0 (_data_->seen);
					_g_object_unref0 (_data_->results);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				{
					_data_->_tmp50_ = _data_->_vala1__result_;
					_data_->_tmp51_ = application_contact_get_email_addresses (_data_->_tmp50_);
					_data_->_tmp52_ = _data_->_tmp51_;
					_data_->_tmp53_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp52_, GEE_TYPE_ITERABLE, GeeIterable));
					_data_->_vala1__mailbox_it = _data_->_tmp53_;
					while (TRUE) {
						_data_->_tmp54_ = _data_->_vala1__mailbox_it;
						if (!gee_iterator_next (_data_->_tmp54_)) {
							break;
						}
						_data_->_tmp55_ = _data_->_vala1__mailbox_it;
						_data_->_tmp56_ = gee_iterator_get (_data_->_tmp55_);
						_data_->_vala1_mailbox = (GearyRFC822MailboxAddress*) _data_->_tmp56_;
						_data_->_tmp57_ = _data_->seen;
						_data_->_tmp58_ = _data_->_vala1_mailbox;
						_data_->_tmp59_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp58_);
						_data_->_tmp60_ = _data_->_tmp59_;
						_data_->_tmp61_ = application_contact_store_to_cache_key (_data_->_tmp60_);
						_data_->_tmp62_ = _data_->_tmp61_;
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp57_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp62_);
						_g_free0 (_data_->_tmp62_);
						_g_object_unref0 (_data_->_vala1_mailbox);
					}
					_g_object_unref0 (_data_->_vala1__mailbox_it);
				}
				_data_->_tmp63_ = _data_->results;
				_data_->_tmp64_ = _data_->_vala1__result_;
				gee_collection_add (_data_->_tmp63_, _data_->_tmp64_);
				_g_object_unref0 (_data_->_vala1__result_);
			}
			_g_object_unref0 (_data_->_vala1_individual);
		}
		_g_object_unref0 (_data_->_vala1__individual_it);
	}
	{
		_data_->_tmp65_ = _data_->view;
		_data_->_state_ = 4;
		folks_search_view_unprepare (_data_->_tmp65_, application_contact_store_search_ready, _data_);
		return FALSE;
		_state_4:
		folks_search_view_unprepare_finish (_data_->_tmp65_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp66_ = _data_->err;
		_data_->_tmp67_ = _data_->_tmp66_->message;
		g_warning ("application-contact-store.vala:154: Error unpreparing Folks search: %s", _data_->_tmp67_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->view);
		_g_object_unref0 (_data_->seen);
		_g_object_unref0 (_data_->results);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp68_ = _data_->self->priv->_account;
	_data_->_tmp69_ = geary_account_get_contact_store (_data_->_tmp68_);
	_data_->_tmp70_ = _data_->_tmp69_;
	_data_->_tmp71_ = g_strconcat ("%", _data_->query, "%", NULL);
	_data_->_tmp72_ = _data_->_tmp71_;
	_data_->_state_ = 5;
	geary_contact_store_search (_data_->_tmp70_, _data_->_tmp72_, _data_->min_importance, _data_->limit, _data_->cancellable, application_contact_store_search_ready, _data_);
	return FALSE;
	_state_5:
	_data_->_tmp73_ = geary_contact_store_search_finish (_data_->_tmp70_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp74_ = _data_->_tmp73_;
	_g_free0 (_data_->_tmp72_);
	_data_->engine_results = _data_->_tmp74_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->view);
		_g_object_unref0 (_data_->seen);
		_g_object_unref0 (_data_->results);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp75_ = _data_->engine_results;
		_data_->_tmp76_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp75_, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->_contact_it = _data_->_tmp76_;
		while (TRUE) {
			_data_->_tmp77_ = _data_->_contact_it;
			if (!gee_iterator_next (_data_->_tmp77_)) {
				break;
			}
			_data_->_tmp78_ = _data_->_contact_it;
			_data_->_tmp79_ = gee_iterator_get (_data_->_tmp78_);
			_data_->contact = (GearyContact*) _data_->_tmp79_;
			_data_->_tmp80_ = _data_->contact;
			_data_->_tmp81_ = geary_contact_get_email (_data_->_tmp80_);
			_data_->_tmp82_ = _data_->_tmp81_;
			_data_->_tmp83_ = application_contact_store_to_cache_key (_data_->_tmp82_);
			_data_->email_key = _data_->_tmp83_;
			_data_->_tmp84_ = _data_->seen;
			_data_->_tmp85_ = _data_->email_key;
			if (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp84_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp85_)) {
				_data_->_tmp86_ = _data_->contact;
				_data_->_tmp87_ = geary_contact_get_rfc822_address (_data_->_tmp86_);
				_data_->_tmp88_ = _data_->_tmp87_;
				_data_->_state_ = 6;
				application_contact_store_load (_data_->self, _data_->_tmp88_, _data_->cancellable, application_contact_store_search_ready, _data_);
				return FALSE;
				_state_6:
				_data_->_tmp89_ = application_contact_store_load_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp90_ = _data_->_tmp89_;
				_g_object_unref0 (_data_->_tmp88_);
				_data_->_vala2__result_ = _data_->_tmp90_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_free0 (_data_->email_key);
					_g_object_unref0 (_data_->contact);
					_g_object_unref0 (_data_->_contact_it);
					_g_object_unref0 (_data_->engine_results);
					_g_object_unref0 (_data_->view);
					_g_object_unref0 (_data_->seen);
					_g_object_unref0 (_data_->results);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				{
					_data_->_tmp91_ = _data_->_vala2__result_;
					_data_->_tmp92_ = application_contact_get_email_addresses (_data_->_tmp91_);
					_data_->_tmp93_ = _data_->_tmp92_;
					_data_->_tmp94_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp93_, GEE_TYPE_ITERABLE, GeeIterable));
					_data_->_vala2__mailbox_it = _data_->_tmp94_;
					while (TRUE) {
						_data_->_tmp95_ = _data_->_vala2__mailbox_it;
						if (!gee_iterator_next (_data_->_tmp95_)) {
							break;
						}
						_data_->_tmp96_ = _data_->_vala2__mailbox_it;
						_data_->_tmp97_ = gee_iterator_get (_data_->_tmp96_);
						_data_->_vala2_mailbox = (GearyRFC822MailboxAddress*) _data_->_tmp97_;
						_data_->_tmp98_ = _data_->seen;
						_data_->_tmp99_ = _data_->_vala2_mailbox;
						_data_->_tmp100_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp99_);
						_data_->_tmp101_ = _data_->_tmp100_;
						_data_->_tmp102_ = application_contact_store_to_cache_key (_data_->_tmp101_);
						_data_->_tmp103_ = _data_->_tmp102_;
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp98_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp103_);
						_g_free0 (_data_->_tmp103_);
						_g_object_unref0 (_data_->_vala2_mailbox);
					}
					_g_object_unref0 (_data_->_vala2__mailbox_it);
				}
				_data_->_tmp104_ = _data_->results;
				_data_->_tmp105_ = _data_->_vala2__result_;
				gee_collection_add (_data_->_tmp104_, _data_->_tmp105_);
				_g_object_unref0 (_data_->_vala2__result_);
			}
			_g_free0 (_data_->email_key);
			_g_object_unref0 (_data_->contact);
		}
		_g_object_unref0 (_data_->_contact_it);
	}
	_data_->result = _data_->results;
	_g_object_unref0 (_data_->engine_results);
	_g_object_unref0 (_data_->view);
	_g_object_unref0 (_data_->seen);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** Closes the store, flushing all caches. */
void
application_contact_store_close (ApplicationContactStore* self)
{
	UtilCacheLru* _tmp0_;
	UtilCacheLru* _tmp1_;
	UtilCacheLru* _tmp2_;
	g_return_if_fail (APPLICATION_IS_CONTACT_STORE (self));
	_tmp0_ = self->priv->folks_address_cache;
	util_cache_lru_clear (_tmp0_);
	_tmp1_ = self->priv->contact_id_cache;
	util_cache_lru_clear (_tmp1_);
	_tmp2_ = self->priv->engine_address_cache;
	util_cache_lru_clear (_tmp2_);
}

static void
application_contact_store_lookup_engine_contact_data_free (gpointer _data)
{
	ApplicationContactStoreLookupEngineContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mailbox);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactStoreLookupEngineContactData, _data_);
}

void
application_contact_store_lookup_engine_contact (ApplicationContactStore* self,
                                                 GearyRFC822MailboxAddress* mailbox,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	ApplicationContactStoreLookupEngineContactData* _data_;
	ApplicationContactStore* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_CONTACT_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (mailbox, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationContactStoreLookupEngineContactData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_store_lookup_engine_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (mailbox);
	_g_object_unref0 (_data_->mailbox);
	_data_->mailbox = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_contact_store_lookup_engine_contact_co (_data_);
}

GearyContact*
application_contact_store_lookup_engine_contact_finish (ApplicationContactStore* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	GearyContact* result;
	ApplicationContactStoreLookupEngineContactData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_contact_store_lookup_engine_contact_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	ApplicationContactStoreLookupEngineContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_store_lookup_engine_contact_co (_data_);
}

static gboolean
application_contact_store_lookup_engine_contact_co (ApplicationContactStoreLookupEngineContactData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_rf_c822_mailbox_address_get_address (_data_->mailbox);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = application_contact_store_to_cache_key (_data_->_tmp1_);
	_data_->email_key = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->engine_address_cache;
	_data_->_tmp4_ = _data_->email_key;
	_data_->_tmp5_ = util_cache_lru_get_entry (_data_->_tmp3_, _data_->_tmp4_);
	_data_->contact = (GearyContact*) _data_->_tmp5_;
	_data_->_tmp6_ = _data_->contact;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp8_ = _data_->self->priv->_account;
		_data_->_tmp9_ = geary_account_get_contact_store (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_state_ = 1;
		geary_contact_store_get_by_rfc822 (_data_->_tmp10_, _data_->mailbox, _data_->cancellable, application_contact_store_lookup_engine_contact_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = geary_contact_store_get_by_rfc822_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp7_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->contact);
			_g_free0 (_data_->email_key);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp12_ = _data_->_tmp7_;
		_data_->_tmp7_ = NULL;
		_g_object_unref0 (_data_->contact);
		_data_->contact = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->contact;
		if (_data_->_tmp13_ == NULL) {
			_data_->_tmp14_ = geary_contact_new_from_rfc822_address (_data_->mailbox, 0);
			_g_object_unref0 (_data_->contact);
			_data_->contact = _data_->_tmp14_;
			_data_->_tmp15_ = _data_->self->priv->_account;
			_data_->_tmp16_ = geary_account_get_contact_store (_data_->_tmp15_);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_tmp18_ = _data_->contact;
			_data_->_tmp19_ = geary_collection_single (GEARY_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp18_);
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_state_ = 2;
			geary_contact_store_update_contacts (_data_->_tmp17_, _data_->_tmp20_, _data_->cancellable, application_contact_store_lookup_engine_contact_ready, _data_);
			return FALSE;
			_state_2:
			geary_contact_store_update_contacts_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
			_g_object_unref0 (_data_->_tmp20_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->_tmp7_);
				_g_object_unref0 (_data_->contact);
				_g_free0 (_data_->email_key);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp21_ = _data_->self->priv->engine_address_cache;
		_data_->_tmp22_ = _data_->email_key;
		_data_->_tmp23_ = _data_->contact;
		util_cache_lru_set_entry (_data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_);
		_g_object_unref0 (_data_->_tmp7_);
	}
	_data_->result = _data_->contact;
	_g_free0 (_data_->email_key);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_contact_store_get_contact_data_free (gpointer _data)
{
	ApplicationContactStoreGetContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->mailbox);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactStoreGetContactData, _data_);
}

static void
application_contact_store_get_contact (ApplicationContactStore* self,
                                       FolksIndividual* individual,
                                       GearyRFC822MailboxAddress* mailbox,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	ApplicationContactStoreGetContactData* _data_;
	ApplicationContactStore* _tmp0_;
	FolksIndividual* _tmp1_;
	GearyRFC822MailboxAddress* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (APPLICATION_IS_CONTACT_STORE (self));
	g_return_if_fail ((individual == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (individual, FOLKS_TYPE_INDIVIDUAL));
	g_return_if_fail ((mailbox == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (mailbox, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationContactStoreGetContactData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_store_get_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (individual);
	_g_object_unref0 (_data_->individual);
	_data_->individual = _tmp1_;
	_tmp2_ = _g_object_ref0 (mailbox);
	_g_object_unref0 (_data_->mailbox);
	_data_->mailbox = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_contact_store_get_contact_co (_data_);
}

static ApplicationContact*
application_contact_store_get_contact_finish (ApplicationContactStore* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	ApplicationContact* result;
	ApplicationContactStoreGetContactData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_contact_store_get_contact_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	ApplicationContactStoreGetContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_store_get_contact_co (_data_);
}

static gboolean
application_contact_store_get_contact_co (ApplicationContactStoreGetContactData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->contact = NULL;
	if (_data_->individual != NULL) {
		_data_->_tmp0_ = _data_->self->priv->contact_id_cache;
		_data_->_tmp1_ = folks_individual_get_id (_data_->individual);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = util_cache_lru_get_entry (_data_->_tmp0_, _data_->_tmp2_);
		_g_object_unref0 (_data_->contact);
		_data_->contact = (ApplicationContact*) _data_->_tmp3_;
		_data_->_tmp4_ = _data_->contact;
		if (_data_->_tmp4_ == NULL) {
			_data_->_tmp5_ = application_contact_new_for_folks (_data_->self, _data_->individual);
			_g_object_unref0 (_data_->contact);
			_data_->contact = _data_->_tmp5_;
			_data_->_tmp6_ = _data_->self->priv->contact_id_cache;
			_data_->_tmp7_ = folks_individual_get_id (_data_->individual);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = _data_->contact;
			util_cache_lru_set_entry (_data_->_tmp6_, _data_->_tmp8_, _data_->_tmp9_);
		}
	} else {
		if (_data_->mailbox != NULL) {
			_data_->_state_ = 1;
			application_contact_store_lookup_engine_contact (_data_->self, _data_->mailbox, _data_->cancellable, application_contact_store_get_contact_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp10_ = application_contact_store_lookup_engine_contact_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->engine = _data_->_tmp10_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->contact);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp13_ = geary_rf_c822_mailbox_address_get_name (_data_->mailbox);
			_data_->_tmp14_ = _data_->_tmp13_;
			if (!geary_string_is_empty_or_whitespace (_data_->_tmp14_)) {
				_data_->_tmp12_ = !geary_rf_c822_mailbox_address_is_spoofed (_data_->mailbox);
			} else {
				_data_->_tmp12_ = FALSE;
			}
			if (_data_->_tmp12_) {
				_data_->_tmp15_ = geary_rf_c822_mailbox_address_get_name (_data_->mailbox);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp11_ = _data_->_tmp16_;
			} else {
				_data_->_tmp17_ = geary_rf_c822_mailbox_address_get_mailbox (_data_->mailbox);
				_data_->_tmp18_ = _data_->_tmp17_;
				_data_->_tmp11_ = _data_->_tmp18_;
			}
			_data_->_tmp19_ = g_strdup (_data_->_tmp11_);
			_data_->name = _data_->_tmp19_;
			_data_->_tmp20_ = _data_->name;
			_data_->_tmp21_ = _data_->engine;
			_data_->_tmp22_ = application_contact_new_for_engine (_data_->self, _data_->_tmp20_, _data_->_tmp21_);
			_g_object_unref0 (_data_->contact);
			_data_->contact = _data_->_tmp22_;
			_g_free0 (_data_->name);
			_g_object_unref0 (_data_->engine);
		} else {
			_data_->_tmp23_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_BAD_PARAMETERS, "Requires either an individual or a mailbox");
			_data_->_inner_error0_ = _data_->_tmp23_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->contact);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->contact;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_contact_store_search_folks_by_email_data_free (gpointer _data)
{
	ApplicationContactStoreSearchFolksByEmailData* _data_;
	_data_ = _data;
	_g_free0 (_data_->address);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactStoreSearchFolksByEmailData, _data_);
}

static void
application_contact_store_search_folks_by_email (ApplicationContactStore* self,
                                                 const gchar* address,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	ApplicationContactStoreSearchFolksByEmailData* _data_;
	ApplicationContactStore* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_CONTACT_STORE (self));
	g_return_if_fail (address != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationContactStoreSearchFolksByEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_store_search_folks_by_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (address);
	_g_free0 (_data_->address);
	_data_->address = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_contact_store_search_folks_by_email_co (_data_);
}

static FolksIndividual*
application_contact_store_search_folks_by_email_finish (ApplicationContactStore* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	FolksIndividual* result;
	ApplicationContactStoreSearchFolksByEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_contact_store_search_folks_by_email_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	ApplicationContactStoreSearchFolksByEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_store_search_folks_by_email_co (_data_);
}

static gboolean
application_contact_store_search_folks_by_email_co (ApplicationContactStoreSearchFolksByEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->individuals;
	_data_->_tmp1_ = application_contact_store_FOLKS_EMAIL_MATCH_FIELDS;
	_data_->_tmp1__length1 = application_contact_store_FOLKS_EMAIL_MATCH_FIELDS_length1;
	_data_->_tmp2_ = folks_simple_query_new (_data_->address, _data_->_tmp1_, _data_->_tmp1__length1);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = folks_search_view_new (_data_->_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, FOLKS_TYPE_QUERY, FolksQuery));
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp3_);
	_data_->view = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->view;
	_data_->_state_ = 1;
	folks_search_view_prepare (_data_->_tmp6_, application_contact_store_search_folks_by_email_ready, _data_);
	return FALSE;
	_state_1:
	folks_search_view_prepare_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->view);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->match = NULL;
	_data_->_tmp7_ = _data_->view;
	_data_->_tmp8_ = folks_search_view_get_individuals (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp11_ = _data_->_tmp10_;
	if (!_data_->_tmp11_) {
		_data_->_tmp12_ = g_utf8_normalize (_data_->address, (gssize) -1, G_NORMALIZE_DEFAULT);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = g_utf8_casefold (_data_->_tmp13_, (gssize) -1);
		_data_->_tmp15_ = _data_->_tmp14_;
		_g_free0 (_data_->_tmp13_);
		_data_->normalised_address = _data_->_tmp15_;
		{
			_data_->_tmp16_ = _data_->view;
			_data_->_tmp17_ = folks_search_view_get_individuals (_data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_poss_it = _data_->_tmp19_;
			while (TRUE) {
				_data_->_tmp20_ = _data_->_poss_it;
				if (!gee_iterator_next (_data_->_tmp20_)) {
					break;
				}
				_data_->_tmp21_ = _data_->_poss_it;
				_data_->_tmp22_ = gee_iterator_get (_data_->_tmp21_);
				_data_->poss = (FolksIndividual*) _data_->_tmp22_;
				{
					_data_->_tmp23_ = _data_->poss;
					_data_->_tmp24_ = folks_email_details_get_email_addresses (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp23_, FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetails));
					_data_->_tmp25_ = _data_->_tmp24_;
					_data_->_tmp26_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, GEE_TYPE_ITERABLE, GeeIterable));
					_data_->_email_it = _data_->_tmp26_;
					while (TRUE) {
						_data_->_tmp27_ = _data_->_email_it;
						if (!gee_iterator_next (_data_->_tmp27_)) {
							break;
						}
						_data_->_tmp28_ = _data_->_email_it;
						_data_->_tmp29_ = gee_iterator_get (_data_->_tmp28_);
						_data_->email = (FolksEmailFieldDetails*) _data_->_tmp29_;
						_data_->_tmp30_ = _data_->email;
						_data_->_tmp31_ = folks_abstract_field_details_get_value (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp30_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
						_data_->_tmp32_ = _data_->_tmp31_;
						_data_->_tmp33_ = g_utf8_normalize ((const gchar*) _data_->_tmp32_, (gssize) -1, G_NORMALIZE_DEFAULT);
						_data_->_tmp34_ = _data_->_tmp33_;
						_data_->_tmp35_ = g_utf8_casefold (_data_->_tmp34_, (gssize) -1);
						_data_->_tmp36_ = _data_->_tmp35_;
						_data_->_tmp37_ = _data_->normalised_address;
						_data_->_tmp38_ = g_strcmp0 (_data_->_tmp36_, _data_->_tmp37_) == 0;
						_g_free0 (_data_->_tmp36_);
						_g_free0 (_data_->_tmp34_);
						if (_data_->_tmp38_) {
							_data_->_tmp39_ = _data_->poss;
							_data_->_tmp40_ = _g_object_ref0 (_data_->_tmp39_);
							_g_object_unref0 (_data_->match);
							_data_->match = _data_->_tmp40_;
							_g_object_unref0 (_data_->email);
							break;
						}
						_g_object_unref0 (_data_->email);
					}
					_g_object_unref0 (_data_->_email_it);
				}
				_data_->_tmp41_ = _data_->match;
				if (_data_->_tmp41_ != NULL) {
					_g_object_unref0 (_data_->poss);
					break;
				}
				_g_object_unref0 (_data_->poss);
			}
			_g_object_unref0 (_data_->_poss_it);
		}
		_g_free0 (_data_->normalised_address);
	}
	{
		_data_->_tmp42_ = _data_->view;
		_data_->_state_ = 2;
		folks_search_view_unprepare (_data_->_tmp42_, application_contact_store_search_folks_by_email_ready, _data_);
		return FALSE;
		_state_2:
		folks_search_view_unprepare_finish (_data_->_tmp42_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp43_ = _data_->err;
		_data_->_tmp44_ = _data_->_tmp43_->message;
		g_warning ("application-contact-store.vala:275: Error unpreparing Folks search: %s", _data_->_tmp44_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->match);
		_g_object_unref0 (_data_->view);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
		_data_->_tmp45_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Contact load was cancelled");
		_data_->_inner_error0_ = _data_->_tmp45_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->match);
		_g_object_unref0 (_data_->view);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->match;
	_g_object_unref0 (_data_->view);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_contact_store_on_individuals_changed (ApplicationContactStore* self,
                                                  GeeMultiMap* changes)
{
	g_return_if_fail (APPLICATION_IS_CONTACT_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (changes, GEE_TYPE_MULTI_MAP));
	{
		GeeIterator* _individual_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = gee_multi_map_get_keys (changes);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_individual_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksIndividual* individual = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			FolksIndividual* _tmp7_;
			_tmp4_ = _individual_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _individual_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			individual = (FolksIndividual*) _tmp6_;
			_tmp7_ = individual;
			if (_tmp7_ != NULL) {
				UtilCacheLru* _tmp8_;
				FolksIndividual* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gpointer _tmp12_;
				ApplicationContact* _tmp13_;
				_tmp8_ = self->priv->contact_id_cache;
				_tmp9_ = individual;
				_tmp10_ = folks_individual_get_id (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = util_cache_lru_remove_entry (_tmp8_, _tmp11_);
				_tmp13_ = (ApplicationContact*) _tmp12_;
				_g_object_unref0 (_tmp13_);
				{
					GeeIterator* _email_it = NULL;
					FolksIndividual* _tmp14_;
					GeeSet* _tmp15_;
					GeeSet* _tmp16_;
					GeeIterator* _tmp17_;
					_tmp14_ = individual;
					_tmp15_ = folks_email_details_get_email_addresses (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetails));
					_tmp16_ = _tmp15_;
					_tmp17_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ITERABLE, GeeIterable));
					_email_it = _tmp17_;
					while (TRUE) {
						GeeIterator* _tmp18_;
						FolksEmailFieldDetails* email = NULL;
						GeeIterator* _tmp19_;
						gpointer _tmp20_;
						UtilCacheLru* _tmp21_;
						FolksEmailFieldDetails* _tmp22_;
						gconstpointer _tmp23_;
						gconstpointer _tmp24_;
						gpointer _tmp25_;
						FolksIndividual* _tmp26_;
						_tmp18_ = _email_it;
						if (!gee_iterator_next (_tmp18_)) {
							break;
						}
						_tmp19_ = _email_it;
						_tmp20_ = gee_iterator_get (_tmp19_);
						email = (FolksEmailFieldDetails*) _tmp20_;
						_tmp21_ = self->priv->folks_address_cache;
						_tmp22_ = email;
						_tmp23_ = folks_abstract_field_details_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
						_tmp24_ = _tmp23_;
						_tmp25_ = util_cache_lru_remove_entry (_tmp21_, (const gchar*) _tmp24_);
						_tmp26_ = (FolksIndividual*) _tmp25_;
						_g_object_unref0 (_tmp26_);
						_g_object_unref0 (email);
					}
					_g_object_unref0 (_email_it);
				}
			}
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
application_contact_store_class_init (ApplicationContactStoreClass * klass,
                                      gpointer klass_data)
{
	gchar** general_fields = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint general_fields_length1;
	gint _general_fields_size_;
	gchar* email_field = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	application_contact_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationContactStore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_application_contact_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_contact_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_contact_store_finalize;
	/** The account this store aggregates data for. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_STORE_ACCOUNT_PROPERTY, application_contact_store_properties[APPLICATION_CONTACT_STORE_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = _vala_array_dup3 (FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES));
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES);
	general_fields = _tmp0_;
	general_fields_length1 = _tmp0__length1;
	_general_fields_size_ = general_fields_length1;
	_tmp1_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
	_tmp2_ = g_strdup (_tmp1_);
	email_field = _tmp2_;
	_tmp3_ = general_fields;
	_tmp3__length1 = general_fields_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup4 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	application_contact_store_FOLKS_GENERAL_MATCH_FIELDS = (_vala_array_free (application_contact_store_FOLKS_GENERAL_MATCH_FIELDS, application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_length1, (GDestroyNotify) g_free), NULL);
	application_contact_store_FOLKS_GENERAL_MATCH_FIELDS = _tmp4_;
	application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_length1 = _tmp4__length1;
	_application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_size_ = application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_length1;
	_tmp5_ = email_field;
	_tmp6_ = g_strdup (_tmp5_);
	_vala_array_add7 (&application_contact_store_FOLKS_GENERAL_MATCH_FIELDS, &application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_length1, &_application_contact_store_FOLKS_GENERAL_MATCH_FIELDS_size_, _tmp6_);
	_tmp7_ = email_field;
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = g_new0 (gchar*, 1 + 1);
	_tmp9_[0] = _tmp8_;
	application_contact_store_FOLKS_EMAIL_MATCH_FIELDS = (_vala_array_free (application_contact_store_FOLKS_EMAIL_MATCH_FIELDS, application_contact_store_FOLKS_EMAIL_MATCH_FIELDS_length1, (GDestroyNotify) g_free), NULL);
	application_contact_store_FOLKS_EMAIL_MATCH_FIELDS = _tmp9_;
	application_contact_store_FOLKS_EMAIL_MATCH_FIELDS_length1 = 1;
	_application_contact_store_FOLKS_EMAIL_MATCH_FIELDS_size_ = application_contact_store_FOLKS_EMAIL_MATCH_FIELDS_length1;
	_g_free0 (email_field);
	general_fields = (_vala_array_free (general_fields, general_fields_length1, (GDestroyNotify) g_free), NULL);
}

static void
application_contact_store_instance_init (ApplicationContactStore * self,
                                         gpointer klass)
{
	UtilCacheLru* _tmp0_;
	UtilCacheLru* _tmp1_;
	UtilCacheLru* _tmp2_;
	self->priv = application_contact_store_get_instance_private (self);
	_tmp0_ = util_cache_lru_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, APPLICATION_CONTACT_STORE_LRU_CACHE_MAX);
	self->priv->folks_address_cache = _tmp0_;
	_tmp1_ = util_cache_lru_new (APPLICATION_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, APPLICATION_CONTACT_STORE_LRU_CACHE_MAX);
	self->priv->contact_id_cache = _tmp1_;
	_tmp2_ = util_cache_lru_new (GEARY_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, APPLICATION_CONTACT_STORE_LRU_CACHE_MAX);
	self->priv->engine_address_cache = _tmp2_;
}

static void
application_contact_store_finalize (GObject * obj)
{
	ApplicationContactStore * self;
	FolksIndividualAggregator* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_CONTACT_STORE, ApplicationContactStore);
	_tmp0_ = self->individuals;
	g_signal_parse_name ("individuals-changed-detailed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _application_contact_store_on_individuals_changed_folks_individual_aggregator_individuals_changed_detailed, self);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->individuals);
	_g_object_unref0 (self->priv->folks_address_cache);
	_g_object_unref0 (self->priv->contact_id_cache);
	_g_object_unref0 (self->priv->engine_address_cache);
	G_OBJECT_CLASS (application_contact_store_parent_class)->finalize (obj);
}

/**
 * Contacts loader and cache for an account.
 *
 * This class aggregates contact information from Folks, the Engine,
 * and the source mailbox. It allows contacts for a specific account
 * to be obtained, and uses caches to minimise performance impact of
 * re-using recently used contacts.
 */
static GType
application_contact_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationContactStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_contact_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationContactStore), 0, (GInstanceInitFunc) application_contact_store_instance_init, NULL };
	GType application_contact_store_type_id;
	application_contact_store_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationContactStore", &g_define_type_info, 0);
	ApplicationContactStore_private_offset = g_type_add_instance_private (application_contact_store_type_id, sizeof (ApplicationContactStorePrivate));
	return application_contact_store_type_id;
}

GType
application_contact_store_get_type (void)
{
	static volatile gsize application_contact_store_type_id__once = 0;
	if (g_once_init_enter (&application_contact_store_type_id__once)) {
		GType application_contact_store_type_id;
		application_contact_store_type_id = application_contact_store_get_type_once ();
		g_once_init_leave (&application_contact_store_type_id__once, application_contact_store_type_id);
	}
	return application_contact_store_type_id__once;
}

static void
_vala_application_contact_store_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ApplicationContactStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_CONTACT_STORE, ApplicationContactStore);
	switch (property_id) {
		case APPLICATION_CONTACT_STORE_ACCOUNT_PROPERTY:
		g_value_set_object (value, application_contact_store_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_contact_store_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	ApplicationContactStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_CONTACT_STORE, ApplicationContactStore);
	switch (property_id) {
		case APPLICATION_CONTACT_STORE_ACCOUNT_PROPERTY:
		application_contact_store_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

