/* folder-list-search-branch.c generated by valac 0.56.3, the Vala compiler
 * generated from folder-list-search-branch.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

enum  {
	FOLDER_LIST_SEARCH_BRANCH_0_PROPERTY,
	FOLDER_LIST_SEARCH_BRANCH_NUM_PROPERTIES
};
static GParamSpec* folder_list_search_branch_properties[FOLDER_LIST_SEARCH_BRANCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	FOLDER_LIST_SEARCH_ENTRY_0_PROPERTY,
	FOLDER_LIST_SEARCH_ENTRY_NUM_PROPERTIES
};
static GParamSpec* folder_list_search_entry_properties[FOLDER_LIST_SEARCH_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FolderListSearchEntryPrivate {
	GearyEngine* engine;
	gint account_count;
};

static gpointer folder_list_search_branch_parent_class = NULL;
static gint FolderListSearchEntry_private_offset;
static gpointer folder_list_search_entry_parent_class = NULL;

static GType folder_list_search_branch_get_type_once (void);
static void folder_list_search_entry_on_accounts_changed (FolderListSearchEntry* self,
                                                   GearyEngine* engine,
                                                   GearyAccountInformation* config);
static void _folder_list_search_entry_on_accounts_changed_geary_engine_account_available (GearyEngine* _sender,
                                                                                   GearyAccountInformation* account,
                                                                                   gpointer self);
static void _folder_list_search_entry_on_accounts_changed_geary_engine_account_unavailable (GearyEngine* _sender,
                                                                                     GearyAccountInformation* account,
                                                                                     gpointer self);
static void folder_list_search_entry_on_email_total_changed (FolderListSearchEntry* self);
static void _folder_list_search_entry_on_email_total_changed_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self);
static gchar* folder_list_search_entry_real_get_sidebar_name (FolderListAbstractFolderEntry* base);
static gchar* folder_list_search_entry_real_get_sidebar_tooltip (FolderListAbstractFolderEntry* base);
static gchar* folder_list_search_entry_real_get_sidebar_icon (FolderListAbstractFolderEntry* base);
static gchar* folder_list_search_entry_real_to_string (FolderListAbstractFolderEntry* base);
static gint folder_list_search_entry_real_get_count (FolderListAbstractFolderEntry* base);
static void folder_list_search_entry_finalize (GObject * obj);
static GType folder_list_search_entry_get_type_once (void);

FolderListSearchBranch*
folder_list_search_branch_construct (GType object_type,
                                     GearyAppSearchFolder* folder,
                                     GearyEngine* engine)
{
	FolderListSearchBranch * self = NULL;
	FolderListSearchEntry* _tmp0_;
	FolderListSearchEntry* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_APP_TYPE_SEARCH_FOLDER), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (engine, GEARY_TYPE_ENGINE), NULL);
	_tmp0_ = folder_list_search_entry_new (folder, engine);
	_tmp1_ = _tmp0_;
	self = (FolderListSearchBranch*) sidebar_root_only_branch_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SIDEBAR_TYPE_ENTRY, SidebarEntry));
	_g_object_unref0 (_tmp1_);
	return self;
}

FolderListSearchBranch*
folder_list_search_branch_new (GearyAppSearchFolder* folder,
                               GearyEngine* engine)
{
	return folder_list_search_branch_construct (FOLDER_LIST_TYPE_SEARCH_BRANCH, folder, engine);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyAppSearchFolder*
folder_list_search_branch_get_search_folder (FolderListSearchBranch* self)
{
	SidebarEntry* _tmp0_;
	FolderListSearchEntry* _tmp1_;
	GearyFolder* _tmp2_;
	GearyFolder* _tmp3_;
	GearyAppSearchFolder* _tmp4_;
	GearyAppSearchFolder* _tmp5_;
	GearyAppSearchFolder* result;
	g_return_val_if_fail (FOLDER_LIST_IS_SEARCH_BRANCH (self), NULL);
	_tmp0_ = sidebar_branch_get_root (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch));
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FOLDER_LIST_TYPE_SEARCH_ENTRY, FolderListSearchEntry);
	_tmp2_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder));
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static void
folder_list_search_branch_class_init (FolderListSearchBranchClass * klass,
                                      gpointer klass_data)
{
	folder_list_search_branch_parent_class = g_type_class_peek_parent (klass);
}

static void
folder_list_search_branch_instance_init (FolderListSearchBranch * self,
                                         gpointer klass)
{
}

/**
 * This branch is a top-level container for a search entry.
 */
static GType
folder_list_search_branch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolderListSearchBranchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folder_list_search_branch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolderListSearchBranch), 0, (GInstanceInitFunc) folder_list_search_branch_instance_init, NULL };
	GType folder_list_search_branch_type_id;
	folder_list_search_branch_type_id = g_type_register_static (SIDEBAR_TYPE_ROOT_ONLY_BRANCH, "FolderListSearchBranch", &g_define_type_info, 0);
	return folder_list_search_branch_type_id;
}

GType
folder_list_search_branch_get_type (void)
{
	static volatile gsize folder_list_search_branch_type_id__once = 0;
	if (g_once_init_enter (&folder_list_search_branch_type_id__once)) {
		GType folder_list_search_branch_type_id;
		folder_list_search_branch_type_id = folder_list_search_branch_get_type_once ();
		g_once_init_leave (&folder_list_search_branch_type_id__once, folder_list_search_branch_type_id);
	}
	return folder_list_search_branch_type_id__once;
}

static inline gpointer
folder_list_search_entry_get_instance_private (FolderListSearchEntry* self)
{
	return G_STRUCT_MEMBER_P (self, FolderListSearchEntry_private_offset);
}

static void
_folder_list_search_entry_on_accounts_changed_geary_engine_account_available (GearyEngine* _sender,
                                                                              GearyAccountInformation* account,
                                                                              gpointer self)
{
	folder_list_search_entry_on_accounts_changed ((FolderListSearchEntry*) self, _sender, account);
}

static void
_folder_list_search_entry_on_accounts_changed_geary_engine_account_unavailable (GearyEngine* _sender,
                                                                                GearyAccountInformation* account,
                                                                                gpointer self)
{
	folder_list_search_entry_on_accounts_changed ((FolderListSearchEntry*) self, _sender, account);
}

static void
_folder_list_search_entry_on_email_total_changed_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self)
{
	folder_list_search_entry_on_email_total_changed ((FolderListSearchEntry*) self);
}

FolderListSearchEntry*
folder_list_search_entry_construct (GType object_type,
                                    GearyAppSearchFolder* folder,
                                    GearyEngine* engine)
{
	FolderListSearchEntry * self = NULL;
	GearyEngine* _tmp0_;
	GearyEngine* _tmp7_;
	GearyEngine* _tmp8_;
	GearyFolderProperties* _tmp9_;
	GearyFolderProperties* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_APP_TYPE_SEARCH_FOLDER), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (engine, GEARY_TYPE_ENGINE), NULL);
	self = (FolderListSearchEntry*) folder_list_abstract_folder_entry_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (folder, GEARY_TYPE_FOLDER, GearyFolder));
	_tmp0_ = _g_object_ref0 (engine);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp0_;
	{
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = geary_engine_get_accounts (engine, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = gee_collection_get_size (_tmp1_);
		_tmp4_ = _tmp3_;
		self->priv->account_count = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_debug ("folder-list-search-branch.vala:33: Failed to get account count: %s", _tmp6_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp7_ = self->priv->engine;
	g_signal_connect_object (_tmp7_, "account-available", (GCallback) _folder_list_search_entry_on_accounts_changed_geary_engine_account_available, self, 0);
	_tmp8_ = self->priv->engine;
	g_signal_connect_object (_tmp8_, "account-unavailable", (GCallback) _folder_list_search_entry_on_accounts_changed_geary_engine_account_unavailable, self, 0);
	_tmp9_ = geary_folder_get_properties (G_TYPE_CHECK_INSTANCE_CAST (folder, GEARY_TYPE_FOLDER, GearyFolder));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("notify::", GEARY_FOLDER_PROPERTIES_PROP_NAME_EMAIL_TOTAL, NULL);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject), _tmp11_, (GCallback) _folder_list_search_entry_on_email_total_changed_g_object_notify, self, 0);
	_g_free0 (_tmp11_);
	return self;
}

FolderListSearchEntry*
folder_list_search_entry_new (GearyAppSearchFolder* folder,
                              GearyEngine* engine)
{
	return folder_list_search_entry_construct (FOLDER_LIST_TYPE_SEARCH_ENTRY, folder, engine);
}

static gchar*
folder_list_search_entry_real_get_sidebar_name (FolderListAbstractFolderEntry* base)
{
	FolderListSearchEntry * self;
	gchar* _tmp0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FOLDER_LIST_TYPE_SEARCH_ENTRY, FolderListSearchEntry);
	if (self->priv->account_count == 1) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (_ ("Search"));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		GearyFolder* _tmp2_;
		GearyFolder* _tmp3_;
		GearyAccount* _tmp4_;
		GearyAccount* _tmp5_;
		GearyAccountInformation* _tmp6_;
		GearyAccountInformation* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp2_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (self, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_folder_get_account (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_account_get_information (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_account_information_get_display_name (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf (_ ("Search %s account"), _tmp9_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp10_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
folder_list_search_entry_real_get_sidebar_tooltip (FolderListAbstractFolderEntry* base)
{
	FolderListSearchEntry * self;
	gint total = 0;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolderProperties* _tmp2_;
	GearyFolderProperties* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FOLDER_LIST_TYPE_SEARCH_ENTRY, FolderListSearchEntry);
	_tmp0_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (self, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_folder_get_properties (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_folder_properties_get_email_total (_tmp3_);
	_tmp5_ = _tmp4_;
	total = _tmp5_;
	_tmp6_ = g_strdup_printf (ngettext ("%d result", "%d results", (gulong) total), total);
	result = _tmp6_;
	return result;
}

static gchar*
folder_list_search_entry_real_get_sidebar_icon (FolderListAbstractFolderEntry* base)
{
	FolderListSearchEntry * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FOLDER_LIST_TYPE_SEARCH_ENTRY, FolderListSearchEntry);
	_tmp0_ = g_strdup ("edit-find-symbolic");
	result = _tmp0_;
	return result;
}

static gchar*
folder_list_search_entry_real_to_string (FolderListAbstractFolderEntry* base)
{
	FolderListSearchEntry * self;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FOLDER_LIST_TYPE_SEARCH_ENTRY, FolderListSearchEntry);
	_tmp0_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (self, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("SearchEntry: ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static void
folder_list_search_entry_on_accounts_changed (FolderListSearchEntry* self,
                                              GearyEngine* engine,
                                              GearyAccountInformation* config)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (FOLDER_LIST_IS_SEARCH_ENTRY (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (engine, GEARY_TYPE_ENGINE));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_ENTRY, SidebarEntry), "entry-changed");
	{
		GeeCollection* _tmp0_ = NULL;
		GeeCollection* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = geary_engine_get_accounts (engine, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = gee_collection_get_size (_tmp0_);
		_tmp3_ = _tmp2_;
		self->priv->account_count = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_debug ("folder-list-search-branch.vala:76: Failed to get account count: %s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
folder_list_search_entry_on_email_total_changed (FolderListSearchEntry* self)
{
	g_return_if_fail (FOLDER_LIST_IS_SEARCH_ENTRY (self));
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_ENTRY, SidebarEntry), "entry-changed");
}

static gint
folder_list_search_entry_real_get_count (FolderListAbstractFolderEntry* base)
{
	FolderListSearchEntry * self;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FOLDER_LIST_TYPE_SEARCH_ENTRY, FolderListSearchEntry);
	result = 0;
	return result;
}

static void
folder_list_search_entry_class_init (FolderListSearchEntryClass * klass,
                                     gpointer klass_data)
{
	folder_list_search_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolderListSearchEntry_private_offset);
	((FolderListAbstractFolderEntryClass *) klass)->get_sidebar_name = (gchar* (*) (FolderListAbstractFolderEntry*)) folder_list_search_entry_real_get_sidebar_name;
	((FolderListAbstractFolderEntryClass *) klass)->get_sidebar_tooltip = (gchar* (*) (FolderListAbstractFolderEntry*)) folder_list_search_entry_real_get_sidebar_tooltip;
	((FolderListAbstractFolderEntryClass *) klass)->get_sidebar_icon = (gchar* (*) (FolderListAbstractFolderEntry*)) folder_list_search_entry_real_get_sidebar_icon;
	((FolderListAbstractFolderEntryClass *) klass)->to_string = (gchar* (*) (FolderListAbstractFolderEntry*)) folder_list_search_entry_real_to_string;
	((FolderListAbstractFolderEntryClass *) klass)->get_count = (gint (*) (FolderListAbstractFolderEntry*)) folder_list_search_entry_real_get_count;
	G_OBJECT_CLASS (klass)->finalize = folder_list_search_entry_finalize;
}

static void
folder_list_search_entry_instance_init (FolderListSearchEntry * self,
                                        gpointer klass)
{
	self->priv = folder_list_search_entry_get_instance_private (self);
	self->priv->account_count = 0;
}

static void
folder_list_search_entry_finalize (GObject * obj)
{
	FolderListSearchEntry * self;
	GearyEngine* _tmp0_;
	guint _tmp1_;
	GearyEngine* _tmp2_;
	guint _tmp3_;
	GearyFolder* _tmp4_;
	GearyFolder* _tmp5_;
	GearyFolderProperties* _tmp6_;
	GearyFolderProperties* _tmp7_;
	gchar* _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLDER_LIST_TYPE_SEARCH_ENTRY, FolderListSearchEntry);
	_tmp0_ = self->priv->engine;
	g_signal_parse_name ("account-available", GEARY_TYPE_ENGINE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _folder_list_search_entry_on_accounts_changed_geary_engine_account_available, self);
	_tmp2_ = self->priv->engine;
	g_signal_parse_name ("account-unavailable", GEARY_TYPE_ENGINE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _folder_list_search_entry_on_accounts_changed_geary_engine_account_unavailable, self);
	_tmp4_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (self, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_folder_get_properties (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("notify::", GEARY_FOLDER_PROPERTIES_PROP_NAME_EMAIL_TOTAL, NULL);
	g_signal_parse_name (_tmp8_, G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _folder_list_search_entry_on_email_total_changed_g_object_notify, self);
	_g_free0 (_tmp8_);
	_g_object_unref0 (self->priv->engine);
	G_OBJECT_CLASS (folder_list_search_entry_parent_class)->finalize (obj);
}

static GType
folder_list_search_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolderListSearchEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folder_list_search_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolderListSearchEntry), 0, (GInstanceInitFunc) folder_list_search_entry_instance_init, NULL };
	GType folder_list_search_entry_type_id;
	folder_list_search_entry_type_id = g_type_register_static (FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, "FolderListSearchEntry", &g_define_type_info, 0);
	FolderListSearchEntry_private_offset = g_type_add_instance_private (folder_list_search_entry_type_id, sizeof (FolderListSearchEntryPrivate));
	return folder_list_search_entry_type_id;
}

GType
folder_list_search_entry_get_type (void)
{
	static volatile gsize folder_list_search_entry_type_id__once = 0;
	if (g_once_init_enter (&folder_list_search_entry_type_id__once)) {
		GType folder_list_search_entry_type_id;
		folder_list_search_entry_type_id = folder_list_search_entry_get_type_once ();
		g_once_init_leave (&folder_list_search_entry_type_id__once, folder_list_search_entry_type_id);
	}
	return folder_list_search_entry_type_id__once;
}

