/* plugin-email.c generated by valac 0.56.3, the Vala compiler
 * generated from plugin-email.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <glib.h>
#include "geary-engine.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

static GType plugin_email_get_type_once (void);
static GType plugin_email_identifier_get_type_once (void);

/** Defines the formats that email body text can be loaded as. */
static GType
plugin_email_body_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PLUGIN_EMAIL_BODY_TYPE_PLAIN, "PLUGIN_EMAIL_BODY_TYPE_PLAIN", "plain"}, {PLUGIN_EMAIL_BODY_TYPE_HTML, "PLUGIN_EMAIL_BODY_TYPE_HTML", "html"}, {0, NULL, NULL}};
	GType plugin_email_body_type_type_id;
	plugin_email_body_type_type_id = g_enum_register_static ("PluginEmailBodyType", values);
	return plugin_email_body_type_type_id;
}

GType
plugin_email_body_type_get_type (void)
{
	static volatile gsize plugin_email_body_type_type_id__once = 0;
	if (g_once_init_enter (&plugin_email_body_type_type_id__once)) {
		GType plugin_email_body_type_type_id;
		plugin_email_body_type_type_id = plugin_email_body_type_get_type_once ();
		g_once_init_leave (&plugin_email_body_type_type_id__once, plugin_email_body_type_type_id);
	}
	return plugin_email_body_type_type_id__once;
}

PluginEmailIdentifier*
plugin_email_get_identifier (PluginEmail* self)
{
	PluginEmailIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_EMAIL (self), NULL);
	_iface_ = PLUGIN_EMAIL_GET_INTERFACE (self);
	if (_iface_->get_identifier) {
		return _iface_->get_identifier (self);
	}
	return NULL;
}

GearyEmailFlags*
plugin_email_get_flags (PluginEmail* self)
{
	PluginEmailIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_EMAIL (self), NULL);
	_iface_ = PLUGIN_EMAIL_GET_INTERFACE (self);
	if (_iface_->get_flags) {
		return _iface_->get_flags (self);
	}
	return NULL;
}

/**
     * Returns the email's primary originator.
     *
     * This method returns the mailbox of the best originator of the
     * email, if any.
     *
     * @see Util.Email.get_primary_originator
     */
GearyRFC822MailboxAddress*
plugin_email_get_primary_originator (PluginEmail* self)
{
	PluginEmailIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_EMAIL (self), NULL);
	_iface_ = PLUGIN_EMAIL_GET_INTERFACE (self);
	if (_iface_->get_primary_originator) {
		return _iface_->get_primary_originator (self);
	}
	return NULL;
}

void
plugin_email_load_body_as (PluginEmail* self,
                           PluginEmailBodyType type,
                           gboolean convert,
                           GCancellable* cancellable,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	PluginEmailIface* _iface_;
	_iface_ = PLUGIN_EMAIL_GET_INTERFACE (self);
	if (_iface_->load_body_as) {
		_iface_->load_body_as (self, type, convert, cancellable, _callback_, _user_data_);
	}
}

gchar*
plugin_email_load_body_as_finish (PluginEmail* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	PluginEmailIface* _iface_;
	_iface_ = PLUGIN_EMAIL_GET_INTERFACE (self);
	if (_iface_->load_body_as_finish) {
		return _iface_->load_body_as_finish (self, _res_, error);
	}
	return NULL;
}

static void
plugin_email_default_init (PluginEmailIface * iface,
                           gpointer iface_data)
{
	/** Returns a unique identifier for this email. */
	g_object_interface_install_property (iface, g_param_spec_object ("identifier", "identifier", "identifier", PLUGIN_TYPE_EMAIL_IDENTIFIER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the set of mutable flags for the email. */
	g_object_interface_install_property (iface, g_param_spec_object ("flags", "flags", "flags", GEARY_TYPE_EMAIL_FLAGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

/**
 * An object representing an email for use by plugins.
 *
 * Instances of these may be obtained from {@link EmailStore}.
 */
static GType
plugin_email_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginEmailIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_email_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_email_type_id;
	plugin_email_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginEmail", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_email_type_id, GEARY_TYPE_BASE_OBJECT);
	g_type_interface_add_prerequisite (plugin_email_type_id, GEARY_TYPE_EMAIL_HEADER_SET);
	return plugin_email_type_id;
}

GType
plugin_email_get_type (void)
{
	static volatile gsize plugin_email_type_id__once = 0;
	if (g_once_init_enter (&plugin_email_type_id__once)) {
		GType plugin_email_type_id;
		plugin_email_type_id = plugin_email_get_type_once ();
		g_once_init_leave (&plugin_email_type_id__once, plugin_email_type_id);
	}
	return plugin_email_type_id__once;
}

PluginAccount*
plugin_email_identifier_get_account (PluginEmailIdentifier* self)
{
	PluginEmailIdentifierIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_EMAIL_IDENTIFIER (self), NULL);
	_iface_ = PLUGIN_EMAIL_IDENTIFIER_GET_INTERFACE (self);
	if (_iface_->get_account) {
		return _iface_->get_account (self);
	}
	return NULL;
}

/**
     * Returns a variant version of this identifier.
     *
     * This value is suitable to be used as the `show-email`
     * application action parameter.
     *
     * @see EmailStore.get_email_identifier_for_variant
     * @see EmailStore.email_identifier_variant_type
     */
GVariant*
plugin_email_identifier_to_variant (PluginEmailIdentifier* self)
{
	PluginEmailIdentifierIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_EMAIL_IDENTIFIER (self), NULL);
	_iface_ = PLUGIN_EMAIL_IDENTIFIER_GET_INTERFACE (self);
	if (_iface_->to_variant) {
		return _iface_->to_variant (self);
	}
	return NULL;
}

static void
plugin_email_identifier_default_init (PluginEmailIdentifierIface * iface,
                                      gpointer iface_data)
{
	/** Returns the account that the email belongs to. */
	g_object_interface_install_property (iface, g_param_spec_object ("account", "account", "account", PLUGIN_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

/**
 * An object representing an email's identifier.
 */
static GType
plugin_email_identifier_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginEmailIdentifierIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_email_identifier_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_email_identifier_type_id;
	plugin_email_identifier_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginEmailIdentifier", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_email_identifier_type_id, GEARY_TYPE_BASE_OBJECT);
	g_type_interface_add_prerequisite (plugin_email_identifier_type_id, GEE_TYPE_HASHABLE);
	return plugin_email_identifier_type_id;
}

GType
plugin_email_identifier_get_type (void)
{
	static volatile gsize plugin_email_identifier_type_id__once = 0;
	if (g_once_init_enter (&plugin_email_identifier_type_id__once)) {
		GType plugin_email_identifier_type_id;
		plugin_email_identifier_type_id = plugin_email_identifier_get_type_once ();
		g_once_init_leave (&plugin_email_identifier_type_id__once, plugin_email_identifier_type_id);
	}
	return plugin_email_identifier_type_id__once;
}

